@extends('layouts.factor-master')

@section('content')
<?php
$report = customeReport('item_expense');
$_number = in_array('number', $report);
$_type_number = in_array('type_number', $report);
$_date = in_array('date', $report);
$_vendor = in_array('vendor', $report);
$_amount = in_array('amount', $report);
$_currency = in_array('currency', $report);
$_rate = in_array('rate', $report);
$_description = in_array('description', $report);
$_type = in_array('type', $report);
$_expense_type = in_array('expense_type', $report);
?>

<h3 class="table-caption" style="text-align: center;">@lang('layout.PriceListReport')</h3>
<br>
@if(count($data) > 0)
<table class="main-table">
  <thead>
    <tr class="bg">
      <th> @lang('layout.Record') </th>
      <th>@lang('layout.Date')</th>
      <th>@lang('layout.Description')</th>
      <th>@lang('layout.Source')</th>
      <th>@lang('layout.Item')</th>
      <th>@lang('layout.Currency')</th>
      <th>@lang('layout.Status')</th>
      
    </tr>
  </thead>
  <?php
  $count = 0;
  ?>
  @foreach($data AS $record)
  <tr>
    <td class="center">{{++$count}}</td>
    <td class="center">{{convertDate($record->date)}}</td>
    <td class="center">{{$record->description}}</td>
    <td class="center">{{$record->source}}</td>
    <td class="center">{{$record->item}}</td>
    <td class="center">{{$record->currency}}</td>
    <td class="center">
      @if($record->status == 1) 
      @lang('layout.Active')
      @else
      @lang('layout.Deactive')
      @endif
    </td>
    
  </tr>
  @endforeach
</table>
@endif

@if(count($detail) > 0)
<table class="main-table">
  <thead>
    <tr class="bg">
      <th> @lang('layout.Record') </th>
      <th>@lang('layout.Source')</th>
      <th>@lang('layout.Destination')</th>
      <th>@lang('layout.Item')</th>
      <th>@lang('layout.Currency')</th>
      <th>@lang('layout.Status')</th>
      @foreach($priceListA as $row1)
      <th style="min-width: 100px">
          <center>
          {{ $row1->name}}
          </center>
      </th>
      @endforeach
    </tr>
  </thead>
  <?php
  $count = 0;
  ?>
  @foreach($detail AS $row)
  <tr>
    <td class="center">{{++$count}}</td>
    <td class="center">{{$row['source']}}</td>
    <td class="center">{{$row['destination']}}</td>
    <td class="center">{{$row['item']}}</td>
    <td class="center">{{$row['currency']}}</td>
    <td class="center">
      @if($row['status'] == 1) 
      @lang('layout.Active')
      @else
      @lang('layout.Deactive')
      @endif
    </td>
    @foreach($row['cat'] as $row2)
    <td class=""> {{ $row2['amount']}}  </td>
    @endforeach
  </tr>
  @endforeach
</table>
@endif

<!--  signature -->
<table style="width: 100%" class="signtable">
  <tr>
    @foreach(getCompanyInfo('sign','reports') AS $info)
    <td style="text-align: left; width:40%">
      <table>

        <tr>
          <td align="right" class="signsize">{{$info['name']}}</td>
        </tr>

      </table>
    </td>
    @endforeach
  </tr>
</table>
<!-- End signature -->
@endsection