@extends('layouts.app')
@section('content')
@include('member_classes.modal')
<!-- END PAGE HEADER-->
<!-- BEGIN TAB PORTLET--> 
<div class="row"> 
    <div class="portlet light bordered">
        <div class="portlet-title">
            <div class="caption font-dark">
                <i class="icon-settings font-dark"></i>&nbsp;
                <span class="caption-subject bold uppercase">@lang('layout.PriceListAmount') </span>
            </div>
             <div class="btn-group pull-right">
                    <!-- <a href="{{route('priceListAmount.create')}}">
                        <button class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                    </button></a> -->
                    <div id="priceListAmount" v-cloak>
                        
                         <button class="btn btn-success" id="show-modal" @click="showModal =true">@lang('layout.AddNew')</button>

                         <modal v-if="showModal" @close="showModal = false">
                            <div slot="header">
                                <div class="col-md-12 col-sm-12 col-xs-12">
                                    <h3>
                                        @lang('layout.PriceListAmountCreate')
                                    </h3>
                                </div>
                                <div class="col-md-4">
                                    <div v-if="fieldErrors.length > 0">
                                        <p class="text-danger" fieldErrors>
                                            <spna v-text="fieldErrors"></spna>
                                        </p>
                                    </div>
                                </div>
                            </div>
                            <div slot="body">
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label>@lang("layout.Number") <span class="required"> * </span></label>
                                            <input type="number" class="form-control" name="number" v-model="number">
                                        </div>
                                    </div>

                                </div>
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label>@lang("layout.Quantity") <span class="required"> * </span></label>
                                            <input type="number" class="form-control" name="quantity" v-model="quantity">
                                        </div>
                                    </div>

                                </div>
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label>@lang("layout.SelectU/M") <span class="required"> * </span></label>
                                            <select name="um_id" v-model="measure" class="form-control">
                                                <option value="">@lang('layout.SelectU/M')</option>
                                                @foreach($measures as $measure)
                                                <option value="{{$measure->id}}">{{$measure->name}}</option>
                                                @endforeach
                                            </select>
                                        </div>

                                    </div>
                                    
                                </div>
                            </div>

                            <div slot="footer">
                                <button type=button class="btn btn-success" @click="addClass" >
                                    @lang('layout.OK')
                                </button>
                                <button type=button class="btn btn-danger"
                                       @click="showModal =false" >
                                    @lang('layout.Cancel')
                                </button>
                            </div>
                        </modal>
                        
                    </div>
            </div>
        </div>
        <div class="portlet-body">

            <template v-cloak id="company_ll">
                <company @company="setCompany"></company>
            </template>

            <table class="table table-striped table-bordered table-hover" cellspacing="1" id="priceListAmounts" width="100%">
                <thead>
                <tr> 
                    <th>@lang('layout.Number')</th>
                    <th>@lang('layout.Quantity')</th>
                    <th>@lang('layout.Measure') </th>
                    <th>@lang('layout.Date') </th>
                    <th>@lang('layout.Action') </th>
                </tr>
                </thead> 
            </table>
        </div>
    </div>
</div> 
@stop
@include('groupCompanyFilter.select')
@push('scripts')
<script>
    let data_table;
     $(document).ready(function() { 
        $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
        data_table = $('#priceListAmounts').DataTable( {
            ajax: '{{route("priceListAmount.index")}}',
            pageLength:'{{getPageRows()}}',
            responsive:'{{responsiveDataTable()}}',
            pagingType:'{{paginationType()}}',
            serverSide: true,
            paging:     true,
            buttons: [{
                extend: 'excel',
                text: '',
                key: {
                    key: 'x',
                    altkey: true
                }
            }],
            columns: [
            { data: 'number', name: 'price_list_amounts.number' },
            { data: 'quantity', name: 'price_list_amounts.quantity' },
            { data: 'name', name: 'measure_units.name' },
            { data: 'created_at', name: 'price_list_amounts.created_at' },
            { data: 'action', name: 'action', orderable:false, searchable: false },
            ] 
    }); 
    });
        Vue.component('modal',{
            template: '#modal-template'
        });

     let vu = new Vue({
        el: '#priceListAmount',
        data:{
            showModal:false,
            fieldErrors:[],
            number: {{$number}},
            old_number: {{$number}},
            quantity: null,
            measure: null,
        },
        methods:{
            addClass(){
                axios.post("{{route('priceListAmount.store')}}",{
                    number:this.number,
                    quantity:this.quantity,
                    measure:this.measure
                })
                .then(function(response){
                    vu.showModal = false;
                    var number = vu.old_number + 1;
                    vu.old_number = number;
                    vu.number = number;
                    vu.quantity = null;
                    vu.measure = null;
                    $('#priceListAmounts').DataTable().ajax.reload();
                })
            }
        }
     });

     new Vue({
         el: '#company_ll',
         methods: {
             setCompany: function (event) {
                 if (typeof data_table == 'object'){
                     data_table.clear();
                     data_table.ajax.reload();
                 }
             }
         }
     });

</script>

@endpush
