@extends('layouts.app')
@section('content')
    <div class="row">

        <div class="portlet light bg-inverse">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.PriceListAmountEdit') </span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools">
                    <a href="" class="collapse" data-original-title="" title=""> </a>
                    <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
                    <a href="" class="reload" data-original-title="" title=""> </a>
                    <a href="" class="remove" data-original-title="" title=""> </a>
                </div>
            </div>
            <div class="portlet-body form" style="margin-bottom: 50%;" >
                <!-- BEGIN FORM-->
                {!! Form::model($priceListAmount,['method' => 'PATCH','route' => ['priceListAmount.update',$priceListAmount->id],'class'=>'form-horizontal']) !!}
                    <div class="form-body">
                        <div class="col-md-9"> 
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.Number'):</label>
                                <div class="col-md-9">
                                    {{Form::number('number',null,['class' => 'form-control'])}}
                                </div>
                            </div> 
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.Quantity'):</label>
                                <div class="col-md-9">
                                    {{Form::number('quantity',null,['class' => 'form-control'])}}
                                </div>
                            </div> 
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang("layout.SelectU/M"):</label>
                                <div class="col-md-9">
                                    <select name="um_id"  class="form-control">
                                        <option value="">@lang('layout.SelectU/M')</option>
                                        @foreach($measures as $measure)
                                        <option value="{{$measure->id}}" @if($measure->id == $priceListAmount->um_id) selected @endif >{{$measure->name}}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div> 
                        </div>  
                    </div>
                    <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                        <button type="button" class="btn green" onclick="regForm(this)"> @lang('layout.Submit') </button>
                        <button href="{{url('priceListAmount.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel') </button>
                     </div>  
                {!! Form::close() !!}
            </div>                  
            <!-- END FORM-->
        </div>
    </div> 
@endsection