@extends('layouts.app')


@section('content')

    <div class="portlet">
        <div class="portlet-title" id="backbtn">
            <div class="caption">
                <i class=""></i>@lang('layout.PriceLevelShow')
            </div>
            <div class="tools">
            </div>
        </div>
        <div class="portlet-body">
            <div class="table-scrollable">
                <table class="table table-striped table-bordered table-advance table-hover">
                    <thead>
                    <tr>
                        
                        <th class="hidden-xs">
                            <i class="fa fa-text-width"></i> @lang('layout.Name')
                        </th>
                         <th>
                            <i class="fa fa-clock-o"></i> @lang('layout.Date')
                        </th>
                         <th class="hidden-xs">
                            <i class="fa fa-text-width"></i> @lang('layout.Description')
                        </th>
          
                        
                    </tr>
                    </thead>
                    <tbody>
                    <tr>  
                        <td class="hidden-xs"> {{ $priceLevel->name}}  </td>
                        <td class="hidden-xs"> {{convertDate($priceLevel->date) }}  </td>
                        <td class="hidden-xs"> {{ $priceLevel->description}}  </td>
                    </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
        
 <div class="tabbable tabbable-tabdrop">
    <div class="row">
        <!-- app -->

        <!-- BEGIN EXAMPLE TABLE PORTLET-->
            <div class="portlet light bordered">
                <div class="portlet-title">
                    <div class="caption font-dark">
                        <i class="icon-settings font-dark"></i>
                        <span class="caption-subject bold uppercase">@lang('layout.PriceLevelShow')</span>
                    </div>
                    <div class="tools"></div>
                     <div class="actions">
                         {{Form::open(['route' => 'export.exportCsv','method' => 'DELETE','class' => 'inline'])}}
                           <input type="hidden" name="type" value="price_level_details"/>
                           <input type="hidden" name="id" value="{{$priceLevel->id}}"/> 
                           <button type="submit" class="btn btn-success"> <i class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>
                        {{Form::close()}} 

                         {{Form::open(['route' => 'export.PDFAny','method' => 'DELETE','class' => 'inline'])}}
                           <input type="hidden" name="type" value="price_level_details"/>
                           <input type="hidden" name="id" value="{{$priceLevel->id}}"/> 
                           <button type="submit" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                        {{Form::close()}}  
                    </div>
                </div>
                <div class="portlet-body">
                    <table class="table table-striped table-bordered table-hover" id="sales">
                        <thead>
                        <tr>  
                        <th>@lang('layout.Name')</th>
                        <th>@lang('layout.Unit')</th>
                        <th>@lang('layout.CustomeRatePriceLevel')</th>
                        </tr>
                        </thead>
                    </table>
                </div>
            </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>
</div>

@endsection
@push('scripts')

<script>
        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
        $('#sales').DataTable({
            ajax:{
                url:'{{route("priceLevelList.show",$priceLevel->id)}}',
            },
            
            scrollCollapse: true,
            serverSide: true,
            responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
            paging: true,
            columns: [

                { data: 'name', name: 'name' },
                { data: 'measure', name: 'measure' },
                { data: 'custome_rate', name: 'custome_rate',orderable:false,searchable:false },

        ]
        });       


    });
</script>


@endpush 
