@extends('layouts.app')
@section('style')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">
<style>

</style>
@stop
@section('content')

<div class="row" id="app" v-cloak>

    <div class="portlet light bg-inverse" style="min-height: 100%;">
        <div class="portlet-title">
            <div class="caption">
                <i class="icon-equalizer font-green-haze"></i>&nbsp;
                <span class="caption-subject font-green-haze bold uppercase">@lang('layout.PriceLevelCreate') </span>
                <!-- <span class="caption-helper">some info...</span> -->
            </div>
            <div class="tools">

            </div>
        </div>
        <div class="portlet-body form" style="margin-bottom:50%;">
            <!-- BEGIN FORM-->
            {!! Form::open(array('route' => 'priceLevelGeneral.store','method'=>'POST','class'=>'form-horizontal','id'=>'price-form')) !!}
            {{ csrf_field() }}

            <div class="form-body">
                <div class="row">
                    <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                        <div class="form-group">

                            <div class="col-md-12">
                                <label class="control-label">@lang('layout.Name')</label>
                                <input type="text" name="level_name" class=" list-style form-control">

                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                        <div class="form-group">

                            <div class="col-md-12">
                                <label class="control-label">@lang('layout.Date')</label>

                                <input type="text" name="date" class="form-control date" autocomplete="off">
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                        <div class="form-group">

                            <div class="col-md-12">
                                <label class="control-label">@lang('layout.Description')</label>
                                {!! Form::textarea('description', null, array('placeholder' => __('layout.Description'),'class' => 'form-control','rows' => 2, 'cols' => 30)) !!}
                            </div>
                        </div>
                    </div>

                </div>
                <div class="row">

                    <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                        <div class="form-group">
                            <div class="col-md-12">
                                <label class="control-label">@lang('layout.Type')</label>
                                <select class="list-style form-control" name="price_type">
                                    <option value="">@lang('layout.Select')</option>
                                    <option value="up">@lang('type.up')</option>
                                    <option value="down">@lang('type.down')</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                        <div class="form-group">
                            <div class="col-md-12">
                                <label class="control-label">@lang('layout.Percentage') %</label>
                                <input type="number" name="percent" class=" list-style form-control">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                <button type="button" onclick="regForm(this)" class="btn green">@lang('layout.Submit')</button>
                <button type="button" class="btn blue" @click="saveAndNew($event)">@lang('layout.SaveAndNew')</button>
                <a href="{{route('priceLevelList.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
            </div>
            {!! Form::close() !!}
        </div>
        <!-- END FORM-->
    </div>
</div>

@endsection
@push('scripts')


<script type="text/javascript">

    @if(App::getLocale())
        Vue.use(VeeValidate, {
            locale: '{{App::getLocale()}}',
        });
        @else
        Vue.use(VeeValidate, {
            locale: 'en',
        });
        @endif

    Vue.component("v-select", VueSelect.VueSelect);
    var vm = new Vue({
        el: '#app',
        data: {
            amount: 0,
            selected_type: 'percent',
            selectedAll: false,
            selected_advance_pricing_type: 'up',
            selected_pricing_type: 'add_new_price',
            selectedItem: null,
            itemlist: [],
            item_id: [],
            searched_items: []
        },
        methods: {
            
            saveAndNew() {
                this.$validator.validate()
                    .then(valid => {
                        if (valid) {
                            var url = "{{route('priceLevelGeneral.store')}}";
                            form_id = 'price-form';
                            var data = $('#' + form_id).serialize();
                            // console.log(444, data);
                            toggleBlock(true);
                            axios.post(url, data)
                                .then(function(response) {
                                    toggleBlock(0);
                                    if (response.data.result == 1) {
                                        $('#' + form_id).trigger('reset');

                                        toastr.success('', response.data.message);
                                        location.reload();

                                    } else {
                                        var message = "{{__('message.Warning')}}";
                                        //$('#error-sound')[0].play();
                                        toastr.warning('', message);
                                    }
                                })
                                .catch(function(error) {
                                    toggleBlock(0);
                                    console.log(error);
                                    var message = "{{__('message.Warning')}}";
                                    //$('#error-sound')[0].play();
                                    toastr.warning('', message);
                                });

                        }
                    })
            },
        }

    });
</script>


@endpush