@extends('layouts.app')
@section('style')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">
<style>

</style>
@stop
@section('content')

<div class="row" id="app" v-cloak>

    <div class="portlet light bg-inverse" style="min-height: 100%;">
        <div class="portlet-title">
            <div class="caption">
                <i class="icon-equalizer font-green-haze"></i>&nbsp;
                <span class="caption-subject font-green-haze bold uppercase">@lang('layout.PriceLevelCreate') </span>
                <!-- <span class="caption-helper">some info...</span> -->
            </div>
            <div class="tools">

            </div>
        </div>
        <div class="portlet-body form" style="margin-bottom:50%;">
            <!-- BEGIN FORM-->
            {!! Form::open(array('route' => 'priceLevelList.store','method'=>'POST','class'=>'form-horizontal','id'=>'price-form')) !!}
            {{ csrf_field() }}

            <div class="form-body">
                <div class="row">
                    <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                        <div class="form-group">

                            <div class="col-md-12">
                                <label class="control-label">@lang('layout.Name')</label>
                                <input type="text" name="level_name" class=" list-style form-control">

                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                        <div class="form-group">

                            <div class="col-md-12">
                                <label class="control-label">@lang('layout.Date')</label>

                                <input type="text" name="date" class="form-control date" autocomplete="off">
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                        <div class="form-group">

                            <div class="col-md-12">
                                <label class="control-label">@lang('layout.Description')</label>
                                {!! Form::textarea('description', null, array('placeholder' => __('layout.Description'),'class' => 'form-control','rows' => 2, 'cols' => 30)) !!}
                            </div>
                        </div>
                    </div>

                </div>
                <div class="row">

                    <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                        <div class="form-group">

                            <div class="col-md-12">
                                <label class="control-label">@lang('menu.InventoryCategory')</label>
                                <select class="list-style form-control" @change="changeCategory(this)" v-model="inventory_category_id">
                                    <option value="">@lang('layout.Select')</option>
                                    <option v-for="cat in category" :value="cat.id">@{{cat.name}}</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                        <div class="form-group">

                            <div class="col-md-12">
                                <label class="control-label">@lang('layout.SelectItem')</label>
                                <v-select class="vue-select2" v-model="selectedItem" label="name" @search="onItemSearch" :options="itemlist">
                                </v-select>
                                <input type="hidden" name="item_id" :value="item_id.length > 0 ? item_id:null">
                            </div>
                        </div>
                    </div>
                    <div class="col-md-1">
                        <br>
                        <button type="button" @click="searchType" class="btn btn-info" style="background-color: rgb(80, 129, 141) !important;border: 1px solid rgb(80, 129, 141) !important;"><i class="fa fa-search"></i>@lang('layout.Search')</button>

                    </div>
                </div>

                <!-- begin items -->
                <div class="row" v-if="searched_items.length>0" style="overflow-x: scroll;">
                    <table id="table_content" class="table table-bordered table-advance">
                        <thead>
                            <tr>
                                <th> <i class="fa fa-check" style="font-size: 25px;color: green"></i> </th>

                                <th>@lang('layout.Number')</th>
                                <th>@lang('layout.Name') </th>
                                <th>@lang('layout.Unit') </th>
                                <th>@lang('layout.LastCost') </th>
                                <th>@lang('layout.StandardPrice') </th>
                                <th>@lang('layout.CustomeRatePriceLevel') </th>


                            </tr>
                        </thead>
                        <tbody>
                            <tr v-for="(item,index) in searched_items">
                                <td><input type="checkbox" :name="'selected_item['+index+']'" class="form-control"></td>



                                <td>@{{(!item)?null:item.number}}</td>
                                <td>@{{(!item)?null:item.name}}</td>
                                <td>@{{(!item)?null:item.measure}}</td>
                                <td>@{{(!item)?null:item.cost}}</td>
                                <td>@{{(!item)?null:item.rate}}</td>
                                <td><input type="number" :name="'custome_rate['+index+']'" class="form-control"></td>
                                <input type="hidden" :name="'items_id['+index+']'" class="form-control" :value="(!item)?null:item.id">



                            </tr>
                        </tbody>
                    </table>

                </div>
                <!-- end items -->



            </div>
            <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                <button type="button" onclick="regForm(this)" class="btn green">@lang('layout.Submit')</button>
                <button type="button" class="btn blue" @click="saveAndNew($event)">@lang('layout.SaveAndNew')</button>
                <a href="{{route('priceLevelList.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
            </div>
            {!! Form::close() !!}
        </div>
        <!-- END FORM-->
    </div>
</div>

@endsection
@push('scripts')


<script type="text/javascript">

    @if(App::getLocale())
        Vue.use(VeeValidate, {
            locale: '{{App::getLocale()}}',
        });
        @else
        Vue.use(VeeValidate, {
            locale: 'en',
        });
        @endif

    Vue.component("v-select", VueSelect.VueSelect);
    var inventory_category = {!! $inventory_category !!}
    var vm = new Vue({
        el: '#app',
        data: {
            category: inventory_category,
            amount: 0,
            selected_type: 'percent',
            selectedAll: false,
            selected_advance_pricing_type: 'up',
            selected_pricing_type: 'add_new_price',

            selectedItem: null,
            itemlist: [],
            item_id: [],
            searched_items: [],

            inventory_category_id: null

        },
        methods: {
            onItemSearch(search, loading) {
                loading(true);
                this.searchItem(search, loading, this);
            },
            //ajax call to get items
            searchItem(search, loading, vm) {
                axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'anyTable',
                            'search_column': 'name',
                            'table_name': 'items',
                            keyword: search,
                        }
                    })
                    .then(function(response) {
                        this.itemlist = [];
                        if (response.data.length > 0) {
                            vm.itemlist = response.data;
                            console.log('data', vm.itemlist);
                        }
                        loading(false);
                    })
                    .catch(function(error) {
                        console.log(error);
                    })
            },


            searchType() {
                vm.searched_items = [];
                axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'priceLevelItems',
                            category: vm.inventory_category_id,
                            item: (!vm.selectedItem) ? null : vm.selectedItem.id
                        }
                    })
                    .then(function(response) {
                        if (response.data.length > 0) {

                            for (var i = 0; i < response.data.length; i++) {

                                vm.searched_items.push({
                                    id: response.data[i].id,
                                    number: response.data[i].number,
                                    name: response.data[i].name,
                                    cost: response.data[i].cost,
                                    rate: response.data[i].rate,
                                    measure: response.data[i].measure,

                                });

                            }
                        }

                    })
                    .catch(function(error) {
                        console.log(error);
                    });
                // }

            },
            changeCategory(e) {
                var value = e.event.target.value;
                for (var i = 0; i < this.items.length; i++) {
                    this.items[i].selected = null;
                    if (this.items[i].inventory_category_id == value) {
                        this.items[i].selected = true;
                    }
                }
            },
            toggleCheck(index) {
                this.items[index].selected = !this.items[index].selected;
            },
            changeType() {
                console.log('test 22', this.selected_type);
            },
            amountChange() {
                console.log('ssss');
            },
            selectAll(e) {

                for (var i = 0; i < this.items.length; i++) {
                    if (this.selectedAll == true) {
                        this.items[i].selected = true;
                    } else {
                        this.items[i].selected = false;
                    }

                }
            },
            saveAndNew() {
                this.$validator.validate()
                    .then(valid => {
                        if (valid) {
                            var url = "{{route('priceLevelList.store')}}";
                            form_id = 'price-form';
                            var data = $('#' + form_id).serialize();
                            // console.log(444, data);
                            toggleBlock(true);
                            axios.post(url, data)
                                .then(function(response) {
                                    toggleBlock(0);
                                    if (response.data.result == 1) {
                                        $('#' + form_id).trigger('reset');

                                        toastr.success('', response.data.message);
                                        location.reload();

                                    } else {
                                        var message = "{{__('message.Warning')}}";
                                        //$('#error-sound')[0].play();
                                        toastr.warning('', message);
                                    }
                                })
                                .catch(function(error) {
                                    toggleBlock(0);
                                    console.log(error);
                                    var message = "{{__('message.Warning')}}";
                                    //$('#error-sound')[0].play();
                                    toastr.warning('', message);
                                });

                        }
                    })
            },
        },
        created: function() {
            console.log('test 22', this.record);
        }

    });
</script>


@endpush