@extends('layouts.app')

@section('style')
 <style>
    input:checked + .slider {
        background-color: #4CAF50 !important;
    }
</style>
@endsection

@section('content')
    <div class="row">

        <div class="portlet light bg-inverse">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.PositionCreate') </span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
            </div>
            <div class="portlet-body form" style="margin-bottom: 50%;" >
                <!-- BEGIN FORM-->
                {!! Form::open(array('route' => 'position.store','method'=>'POST','class'=>'form-horizontal')) !!}
                {{ csrf_field() }} 
                    <div class="form-body">
                        <div class="col-md-12" style="padding: 5px;" > 
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="control-label col-md-3">@lang('layout.PositionName'):</label>
                                    <div class="col-md-9">
                                        {{Form::text('name',null,['class' => 'form-control'])}}
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group"> 
                                    <label class="control-label col-md-3">@lang('layout.Level')</label>
                                    <div class="col-md-9">
                                        <select class="form-control" name="level" >
                                            <option value="1" selected>1 @lang('layout.Level')</option>
                                            <option value="2">2 @lang('layout.Level')</option>
                                            <option value="3">3 @lang('layout.Level')</option>
                                            <option value="4">4 @lang('layout.Level')</option>
                                            <option value="5">5 @lang('layout.Level')</option>
                                            <option value="6">6 @lang('layout.Level')</option>
                                            <option value="7">7 @lang('layout.Level')</option>
                                            <option value="8">8 @lang('layout.Level')</option>
                                            <option value="9">9 @lang('layout.Level')</option>
                                            <option value="10">10 @lang('layout.Level')</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-12" style="padding: 5px;"> 
                                <div class="mt-checkbox-inline col-lg-3 col-md-3" style="padding: 0px;">
                                    <!-- <div class="form-group"> -->
                                        <table class="table table-striped table-bordered table-advance table-hover">
                                            <tbody>
                                                <tr>
                                                    <td style="text-align: center;">@lang('layout.RegisterForm')</td>
                                                </tr> 
                                                <tr>
                                                    <td style="text-align: center;">
                                                        <label class="switch">
                                                            <input type="checkbox" name="register_form" value="yes" >
                                                            <span class="slider round"></span>
                                                        </label>
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    <!-- </div> -->
                                </div> 
                                <div class="mt-checkbox-inline col-lg-3 col-md-3" style="padding: 0px;">
                                    <!-- <div class="form-group"> -->
                                        <table class="table table-striped table-bordered table-advance table-hover">
                                            <tbody>
                                                <tr>
                                                    <td style="text-align: center;">@lang('layout.AcceptForm')</td>
                                                </tr>
                                                <tr>
                                                    <td style="text-align: center;">
                                                        <label class="switch">
                                                            <input type="checkbox" name="accept_form" value="yes" >
                                                            <span class="slider round"></span>
                                                        </label>
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    <!-- </div> -->
                                </div> 
                                <div class="mt-checkbox-inline col-lg-3 col-md-3" style="padding: 0px;">
                                    <!-- <div class="form-group"> -->
                                        <table class="table table-striped table-bordered table-advance table-hover">
                                            <tbody>
                                                <tr>
                                                    <td style="text-align: center;">@lang('layout.EditForm')</td>
                                                </tr>
                                                <tr>
                                                    <td style="text-align: center;">
                                                        <label class="switch">
                                                            <input type="checkbox" name="edit_form" value="yes" >
                                                            <span class="slider round"></span>
                                                        </label>
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    <!-- </div> -->
                                </div> 
                                <div class="mt-checkbox-inline col-lg-3 col-md-3" style="padding: 0px;">
                                    <!-- <div class="form-group"> -->
                                        <table class="table table-striped table-bordered table-advance table-hover">
                                            <tbody>
                                                <tr>
                                                    <td style="text-align: center;">@lang('layout.CancelForm')</td>
                                                </tr>
                                                <tr>
                                                    <td style="text-align: center;">
                                                        <label class="switch">
                                                            <input type="checkbox" name="cancel_form" value="yes" >
                                                            <span class="slider round"></span>
                                                        </label>
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    <!-- </div> -->
                                </div> 
                        </div>
                        <div class="col-md-12" style="padding: 5px;"> 
                            <div class="col-md-12"> 
                                <div class="form-group">
                                    <label class="control-label col-md-3">@lang('layout.Description'):</label>
                                    <div class="col-md-9">
                                    {!! Form::textarea('description', null, array('placeholder' => __('layout.Description'),'class' => 'form-control','rows' => 6, 'cols' => 30)) !!}
                                    </div>
                                </div>
                            </div>  
                        </div>  
                        <div class="col-md-12"> 
                            <table id="table_content"  class="table table-striped table-bordered table-advance table-hover">                         
                                <thead>
                                    <tr>
                                        <th >@lang('layout.Currency')</th>
                                        <th >@lang('layout.Amount')</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td class="hilight">
                                            <div class="input-group">
                                                <label>{{getHomeCurrency()['code']}}</label>
                                                <input type="hidden" name="currency_code" value="{{getHomeCurrency()['code']}}" />
                                            </div>
                                        </td>
                                        <td class="hilight">
                                            <input type="number" name="amount" class="form-control" />
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>  
                        {{-- <div class="col-md-12"> 
                            <table id="table_content"  class="table table-striped table-bordered table-advance table-hover">                         
                                <thead>
                                    <tr>
                                        <th >#</th>
                                        <th >@lang('layout.Currency')</th>
                                        <th >@lang('layout.Amount')</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $count = 1; ?>
                                    @foreach ($currency as $item)
                                    <tr>
                                        <td class="hilight">
                                            <div class="input-group">
                                                <span>{{$count++}}</span>
                                            </div>
                                        </td>
                                        <td class="hilight">
                                            <div class="input-group">
                                                <label>{{$item['code']}}</label>
                                                <input type="hidden" name="currency_code[]" value="{{$item['code']}}" />
                                            </div>
                                        </td>
                                        <td class="hilight">
                                            <input type="number" name="amount[]" class="form-control" />
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>   --}}
                    </div>
                    <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                        <button type="button" class="btn green" onclick="regForm(this)"> @lang('layout.Submit') </button>
                        <button href="{{url('position.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel') </button>
                    </div>  
                {!! Form::close() !!}
            </div>                  
            <!-- END FORM-->
        </div>
    </div> 
@endsection
 