@extends('layouts.app')
@section('style')
    <style>
    .modal-container{
        width: 50% !important;
    }
    </style>
@endsection
@section('content')

<div id="print-modal">
    <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute"
                  v-if="is_show"
                  :value-type="'platts_rate_details'"
                  @closed="closeModal">
        
        <div slot="body">
            <input type="hidden" name="id" value="{{$plattsRate->id}}">
            <div class="row">
                <div class="form-group">

                </div>
            </div>

              <div class="row">
                <div class="form-group">
                </div>
            </div>
        </div>
    </report-modal>
</div>


    <div class="portlet">
        <div class="portlet-title" id="backbtn">
            <div class="caption">
                <i class=""></i>@lang('layout.PlattsRateShow')
            </div>
            <div class="tools">
            </div> 
        </div>
        <div class="portlet-body">
            <div class="table-scrollable">
                <table class="table table-striped table-bordered table-advance table-hover">
                    <thead>
                    <tr>
                        <th>@lang('menu.PlattsCategory')</th>
                        <th>@lang('layout.Currency')</th>
                        <th>@lang('layout.Rate')</th>
                        <th>@lang('layout.Date')</th>
                        <th>@lang('layout.Description')</th>
                        <th>@lang('layout.User')</th>
                    </tr>
                    </thead>
                    <tbody>
                    <tr>
                        <td>{{$plattsRate->platts_category_name}}</td>
                        <td>{{$plattsRate->currency}}</td>
                        <td>{{$plattsRate->rate}}</td>
                        <td>{{$plattsRate->date}}</td>
                        <td>{{$plattsRate->description}}</td>
                        <td>{{$plattsRate->user}}</td>
                    </tr>
            
                    </tbody>
                </table>
            </div>

          

        </div>
    </div>
    <div class="row">


        <div class="tabbable tabbable-tabdrop">
                    <div class="">

                        <div class="col-md-12">
                            <!-- BEGIN EXAMPLE TABLE PORTLET-->
                            <div class="portlet light bordered">
                                <div class="portlet-title">
                                    <div class="caption font-dark">
                                        <i class="icon-settings font-dark"></i>&nbsp;
                                        <span class="caption-subject bold uppercase">@lang('layout.Items') </span>
                                    </div>
                                    <div class="tools"></div>
                                    <div class="actions">
                                        <span id="anchore-modal">
                                            <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                                               <i class="fa fa-print"></i>
                                            </a>
                                        </span>
                                    </div>
                                </div>
                                <div class="portlet-body">
                                    <table class="table table-striped table-bordered table-hover" id="platts_rate_details_table">
                                        <thead>
                                        <tr>
                                            <th>@lang('layout.ItemName')</th>
                                            <th>@lang('layout.Unit/M')</th>
                                            <th>@lang('layout.Amount')</th>
                                        </tr>
                                        </thead>
                                    </table>
                                </div>
                            </div>
                            <!-- END EXAMPLE TABLE PORTLET-->
                        </div>
                    </div>
        </div>

    </div>


@endsection
@include('print.modal')
@push('scripts')

    <script>
        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            $('#platts_rate_details_table').DataTable({
                ajax: {
                    url: '{{route("plattsRate.show",$plattsRate->id)}}',
                },
                pageLength:'{{getPageRows()}}',

                scrollCollapse: true,
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                serverSide: true,
                paging: true,
                columns: [
                    {data: 'name', name: 'items.name'},
                    {data: 'symbol', name: 'symbol', orderable: false, searchable: false},
                    {data: 'amount', name: 'platts_rates.amount', orderable: false, searchable: false}
                ]
            });
        });

        var vm = new Vue({
            el: '#print-modal',
            data: {
                is_show: false,
                pdfRoute: '{!!route('plattsRate.report') !!}',
                excelRoute: '{!! route('plattsRate.report') !!}'
            },
            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show;
                }
            }
        });

        var anchor = new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    console.log('trr')
                    vm.$data.is_show = true;
                }
            }
        });
    </script>


@endpush
