@extends('layouts.app')
@section('style')
    <style>
    .modal-container{
        width: 50% !important;
    }
    </style>
@endsection
@section('content')
    <!-- BEGIN CONTENT -->
    <div id="print-modal">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute"
                      v-if="is_show"
                      :value-type="'platts_rate'"
                      @closed="closeModal">

            <div slot="body">
                <div class="row">
                    <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
                        <div class="form-group">
                            <label class="control-label ">@lang('menu.PlattsCategory')</label>
                            <v-select 
                                class="vue-select2" 
                                label="name" 
                                :options="plattsCategory" 
                                v-model="selected_platts_category"
                                >
                            </v-select>
                            <input type="hidden" name="platts_category_id" :value="(!selected_platts_category)?null:selected_platts_category.id">
                        </div>
                    </div>
                    <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
                        <div class="form-group">
                                <label class="control-label ">@lang('layout.SelectType') </label>
                                <select name="platts_report_type" id="" class="form-control">
                                    <option value="" >@lang('layout.SelectType')</option>
                                    <option value="1">@lang('layout.WithDetail')</option>
                                </select>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="form-group">
                            <div class="col-md-4">
                                <label class="control-label ">@lang('layout.Date')</label>
                                    <select name="period" v-model="period" @input="getDates()" class="form-control">
                                    <option value="CustomDates">@lang('type.CustomDates')</option>
                                    <option value="Today">@lang('type.Today')</option>
                                    <option value="Yesterday">@lang('type.Yesterday')</option>
                                    <option value="ThisWeek">@lang('type.ThisWeek')</option>
                                    <option value="LastWeek">@lang('type.LastWeek')</option>
                                    <option value="WeekToDate">@lang('type.WeekToDate')</option>
                                    <option value="ThisMonth">@lang('type.ThisMonth')</option>
                                    <option value="MonthToDate">@lang('type.MonthToDate')</option>
                                    <option value="ThisQuarter">@lang('type.ThisQuarter')</option>
                                    <option value="QuarterToDate">@lang('type.QuarterToDate')</option>
                                    <option value="ThisYear">@lang('type.ThisYear')</option>
                                    <option value="YearToDate">@lang('type.YearToDate')</option>
                                </select>
                            </div>
                            <div class="col-md-8" v-show="period == 'CustomDates'">
                                <div class="form-group">
                                    <label class="control-label"> @lang('layout.Date')</label>
                                    <div class="input-group">
                                        <input class="form-control date" id="range-from-example" v-model="from_date" name="from_date" autocomplete="off">
                                        <span class="input-group-addon"> @lang('layout.To') </span>
                                        <input class="form-control date" id="range-to-example" v-model="to_date" name="to_date" autocomplete="off">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
            </div>
        </report-modal>
    </div>

    <!-- BEGIN TAB PORTLET-->
    <div class="row">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>&nbsp;
                    <span class="caption-subject bold uppercase">  @lang('layout.PlattsRateList')  </span>
                </div>
                <div class="tools"></div>
                
                <div class="pull-right">
                    @permission('PlattsRate-export')
                        <span id="anchore-modal">
                         <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                            <i class="fa fa-print"></i>
                         </a>
                     </span>
                    @endpermission
                    
                    @permission('PlattsCategory-list')
                    <a href="{{route('plattsCategory.index')}}">
                        <button id="sample_editable_1_new" class="btn btn-success">
                            <i class="fa fa-reorder "></i> @lang('menu.PlattsCategory')
                        </button>
                    </a>
                    @endpermission

                    @permission('PlattsRate-create')
                    <a href="{{route('plattsRate.create')}}">
                        <button id="sample_editable_1_new" class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                        </button>
                    </a>
                    @endpermission
                </div>
            </div>
            <div class="portlet-body">
                <template v-cloak id="company_ll">
                    <company @company="setCompany"></company>
                </template>
                <table class="table table-striped table-bordered table-hover" id="plattsRateTable">
                    <thead>
                    <tr>
                        <th>#</th>
                        <th>@lang('menu.PlattsCategory')</th>
                        <th>@lang('layout.Currency')</th>
                        <th>@lang('layout.Rate')</th>
                        <th>@lang('layout.Date')</th>
                        <th>@lang('layout.Description')</th>
                        <th>@lang('layout.User')</th>
                        <th>@lang('layout.Actions')</th>
                    </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>


    <!-- END TAB PORTLET-->
    <iframe id="payframe" style="display: none;"></iframe>
    <!-- END CONTENT BODY -->
@stop
@include('print.modal')
@include('groupCompanyFilter.select')
@push('scripts')

    <script>
        Vue.component("v-select", VueSelect.VueSelect);

        let data_table;
        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            data_table = $('#plattsRateTable').DataTable({
                ajax: '{{route("plattsRate.index")}}',
                pageLength: '{{getPageRows()}}',
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                scrollCollapse: true,
                paging: true,
                serverSide: true,
                columns: [
                    {data: 'id', name: 'platts_rates.id'},
                    {data: 'platts_category_name', name: 'platts_categories.name'},
                    {data: 'currency', name: 'platts_rates.currency'},
                    {data: 'rate', name: 'platts_rates.rate'},
                    {data: 'date', name: 'platts_rates.date'},
                    {data: 'description', name: 'platts_rates.description'},
                    {data: 'user', name: 'users.name'},
                    {data: 'actions', name: 'actions', orderable: false, searchable: false},
                ]
            });
        });

        new Vue({
            el: '#company_ll',
            methods: {
                setCompany: function (event) {
                    if(typeof data_table =='object'){
                        data_table.clear();
                        data_table.ajax.reload();
                    }

                }
            }
        });


        $('#excell_all').on('click', function (e) {
            $('#show-modal2').click();
            e.preventDefault();
        })

        var plattsCategory = {!! $plattsCategory !!}
        var vm = new Vue({
            el: '#print-modal',
            data: {
                period: 'CustomDates',
                from_date: null,
                to_date: null,
                is_show: false,
                pdfRoute: '{!!route('plattsRate.report') !!}',
                excelRoute: '{!! route('plattsRate.report') !!}',
                plattsCategory:plattsCategory,
                selected_platts_category:null
            },
            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show;
                },
                //ajax call to get dates
                getDates() {
                    setTimeout((function () {
                    vm.getDate(vm.period);
                        // console.log(12);
                    }), 2e2);
                },
                getDate(period) {
                    if (period) {
                    // console.log(3232, period);
                    if (period != 'CustomDates') {
                        axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'getDatesByPeriod',
                            period: period,
                        }
                        })
                        .then(function(response) {
                        vm.from_date = null;
                        vm.to_date = null;
                        if (response.data) {
                            vm.from_date = response.data.start;
                            vm.to_date = response.data.end;
                            // console.log('data', response.data);
                        }
                        })
                        .catch(function(error) {
                        vm.period = 'CustomDates';
                        vm.from_date = null;
                        vm.to_date = null;
                        })
                    } else {
                        vm.from_date = null;
                        vm.to_date = null;
                    }
                    }
                },
            }
        });

        var anchor = new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    console.log('trr')
                    vm.$data.is_show = true;
                }
            }
        });

    </script>
@endpush
