@extends('layouts.factor-master')

@section('content')

	{{-- <h4 class="table-caption" style="text-align: center;">@lang('menu.PlattsRate') {{$platts_category_name}}</h4> --}}
  @if($from_date || $to_date)
  <table class="main-table">
      <tr class="bg">
          @if($from_date)
              <td>
                  <span>@lang('layout.FromDate')</span>:
                  <BDO DIR="LTR">{{convertDate($from_date)}}</BDO>
              </td>
          @endif
          @if($to_date)
              <td>
                  <span>@lang('layout.ToDate')</span>:
                  <BDO DIR="LTR">{{convertDate($to_date)}}</BDO>
              </td>
          @endif
      </tr>
  </table>
  <br>
  @endif

  @if(count($data))

<table class="main-table">
    <thead>

    <tr style="background-color: yellow">
      <th colspan="{{count($item_names)+4}}">@lang('menu.PlattsRate') {{$platts_category_name}}</th>
    </tr>    
    <tr style="background-color: yellow">
      <th>@lang('layout.Record')</th>
      <th>@lang('layout.Date') @lang('layout.Gregorian')</th>
      <th>@lang('layout.Date') @lang('layout.Jalali')</th>
      <th>@lang('layout.Day')</th>
      @foreach($item_names AS $item)
      <th width="7%">{{$item['name']}}</th>
      @endforeach
    </tr>
    </thead>

    
    <tbody>
      <?php
      $count = 0;
      $totals = [];
    ?>  
      @foreach($data AS $record)
      <?php
        $details = $record['details'];
        
      ?>
    <tr>
      <td class="center">{{++$count}}</td>
      <td class="center">{{$record['date']}}</td>
      <td class="center">{{convertDate($record['date'])}}</td>
      <td class="center">{{__('layout.'.substr($record['dayOfWeek'],0,3))}}</td>
      @foreach($details AS $row)
      <?php
      if(array_key_exists($row['item_id'], $totals))
      {
          $totals[$row['item_id']]=$totals[$row['item_id']]+$row['amount'];
      } else {
          $totals[$row['item_id']]=$row['amount'];
      }
      ?>
      <td class="center" >
        {{myRound($row['amount'])}}
      </td>
      @endforeach
    </tr>
    @endforeach
  
    <tr style="background-color: rgb(175, 195, 221);">
      <td class="center" colspan="4" style="font-weight:bold">@lang('layout.Total')</td>
      @foreach($totals AS $t)
      <td class="center" style="font-weight:bold">{{myRound($t)}}</td>
      @endforeach
    </tr>    
    <tr style="background-color: rgb(175, 195, 221);">
      <td class="center" colspan="4" style="font-weight:bold">@lang('layout.Qty1')</td>
      @foreach($item_names AS $item)
      <td class="center" style="font-weight:bold">{{count($data)}}</td>
      @endforeach
    </tr>    
    
    <tr style="background-color: rgb(175, 195, 221);">
      <td class="center" colspan="4" style="font-weight:bold">@lang('layout.Average')</td>
      @foreach($totals AS $a)
      <td class="center" style="font-weight:bold">{{myRound($a/count($data))}}</td>
      @endforeach
    </tr>
  </tbody>
</table> 
@endif

 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection