@extends('layouts.app')
@section('style')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">
<style>

</style>
@stop
@section('content')


<div class="row" id="app" v-cloak>

        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.PlattsRateCreate') </span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools">
                    
                </div>
            </div>
            <div class="portlet-body form" style="margin-bottom:50%;">
                <!-- BEGIN FORM-->
                {!! Form::open(array('route' => 'plattsRate.store','method'=>'POST','class'=>'form-horizontal','id'=>'platts_rate_form')) !!}
                {{ csrf_field() }}

                    <div class="form-body">
                      <div class="row">
                          <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                            <div class="form-group">
                                
                                 <div class="col-md-12">
                                  <label class="control-label">@lang('menu.PlattsCategory')</label>
                                     <v-select label="name" v-model="selected_platts_category" :options="plattsCategory">
                                    </v-select>
                                    <input type="hidden" name="platts_category_id" :value="(selected_platts_category==null)?null:selected_platts_category.id" v-validate="'required'" data-vv-as="@lang('menu.PlattsCategory')">
                                    <span class="required">@{{ errors.first('platts_category_id') }}</span>

                                </div>
                            </div> 
                        </div> 
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                            <div class="form-group">
                                
                                 <div class="col-md-12">
                                  <label class="control-label">@lang('layout.Currency')</label>
                                     <v-select label="code" v-model="selected_currency" :options="currency">
                                    </v-select>
                                    <input type="hidden" name="currency" :value="(selected_currency==null)?null:selected_currency.code" v-validate="'required'" data-vv-as="@lang('layout.Currency')">
                                    <span class="required">@{{ errors.first('currency') }}</span>
                                </div>
                            </div> 
                        </div>  
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                            <div class="form-group">
                                
                                 <div class="col-md-12">
                                  <label class="control-label">@lang('layout.Rate')</label>
                                    <input type="number" name="rate" v-model="!selected_currency?null:selected_currency.rate" class="form-control" v-validate="'required'" data-vv-as="@lang('layout.Rate')">
                                    <span class="required">@{{ errors.first('rate') }}</span>
                                </div>
                            </div> 
                        </div>   
                      </div>
                      <div class="row">
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                          <div class="form-group">
                               <div class="col-md-12">
                                <label class="control-label">@lang('layout.Date')</label>
                                  <input type="text" name="date" class="form-control date" autocomplete="off">

                              </div>
                          </div> 
                      </div> 
                          <div class="col-lg-8 col-md-8 col-sm-12 col-xs-12">
                            <div class="form-group">
                                <div class="col-md-12">
                                  <label class="control-label">@lang('layout.Description')</label>
                                  {!! Form::textarea('description', null, array('class' => 'form-control','rows' => 2, 'cols' => 30)) !!}
                                </div>
                            </div>
                        </div> 
                      </div>
                    <div class="row" v-if="inventories.length>0" style="overflow-x: scroll;">
                      <table id="table_content" class="table table-bordered table-advance">
                        <thead>
                          <tr>
                            <th style="text-align:center">#</th>
                            <th style="min-width: 130px;text-align:center">@lang('layout.ItemName') </th>
                            <th style="min-width: 100px;text-align:center">@lang('layout.Measure') </th>
                            <th style="min-width: 100px;text-align:center">@lang('layout.Amount') </th>
                            <th></th>
                          </tr>
                        </thead>
                        <tbody>
                          <tr v-for="(item,index) in inventories">
                            <td>@{{index+1}}</td>
                            <td class="highlight">
                              <v-select label="name" v-model="item.item" :options="temp_items" @search="onItemSearch" @click.native="addNew(100)"></v-select>
                              <input type="hidden" :name="'item_id['+index+']'" :value="(!item.item)?null:item.item.id">
                            </td>
                            <td class="highlight">
                              <select v-model="(item.item == null)?null:item.item.measure" class="form-control" >
                                <option value="null">@lang('layout.Select')</option>
                                <span v-if="(item.item ==null)?false:true">
                                  <option v-for="measure in (item.item==null)?null:item.item.measure_list" :value="measure">
                                    @{{measure.measure_name}}
                                  </option>
                                </span>


                              </select>

                              <input type="hidden" name="item_measure[]" :value="(item.item==null)?null:item.item.measure.measure_id">
                            </td>
                            <td class="highlight">
                              <input type="number" name="amount[]" class="form-control">
                            </td>
                            <td>
                              <span v-if="index >= 0" v-on:click="deleteItem(index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>
                            </td>
                          </tr>
                          <tr style="background-color: #ffffff;">
                            <td></td>
                            <td>
                              <center>
                                <button type="button" @click="addNew(100)" class="btn btn-success"><i class="fa fa-plus"></i></button>
                              </center>
                            </td>
                            <td></td>
                          </tr>
                        </tbody>
                      </table>

                    </div>
                                        
                                   
                     
                    </div>
                    <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                        <button type="button" onclick="regForm(this)" class="btn green">@lang('layout.Submit')</button>
                        <button type="button" class="btn blue" :disabled="disabled"  @click="saveAndNew($event)">@lang('layout.SaveAndNew')</button>
                        <a href="{{route('plattsRate.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                    </div>  
                {!! Form::close() !!}
            </div>                  
            <!-- END FORM-->
        </div>
    </div> 

@endsection
@push('scripts')
<script type="text/javascript">

  @if(App::getLocale())
  Vue.use(VeeValidate, {
      locale: '{{App::getLocale()}}',
  });
  @else
  Vue.use(VeeValidate, {
      locale: 'en',
  });
  @endif

  Vue.component('v-select', VueSelect.VueSelect);

  var plattsCategory      = {!! $plattsCategory !!}
  var currency            = {!! $currency !!}
  var v =  new Vue({
    el: '#app',
    data: {
      disabled:false,
      plattsCategory:plattsCategory,
      selected_platts_category:null,
      currency:currency,
      selected_currency:null,
      inventories: [{
        item: null
      }],
      temp_items: []

    },
    methods:
    {
        //ajax call to get items
        onItemSearch: _.debounce((search, loading) => {
          loading(true);
          axios.get("{{route('callMethod.search')}}", {

              params: {
                method_name: 'itemSearchSale',
                keyword: search,
              },
            })
            .then(function(response) {
              v.temp_items = [];
              // console.log('ddddddd',response)
              if (response.data.length > 0) {
                v.temp_items = response.data;
                
              }
              loading(false);
            })
            .catch(function(error) {
              console.log(error);
            });

        }, getDebounceTime()),
        // generic function for adding item to list
        addNew(index) {
          this.temp_items = [];
          if (index != null) {
              if (this.inventories[index + 1] == undefined) {
                this.temp_items = [];
                this.inventories.push({
                  item: null
                });
              }
          }

        },
        // delete item from list
        deleteItem(index) {
          if (index != null) {
            this.inventories.splice(index, 1);
          }

      },
      saveAndNew() {
        this.$validator.validate()
            
        .then(valid => {
          if (valid) {
            v.disabled = true;
            var url = "{{route('plattsRate.store')}}";
            form_id = 'platts_rate_form';
            var data = $('#' + form_id).serialize();
                    console.log('data',data)
            toggleBlock(true);
            axios.post(url, data)
              .then(function (response) {
                toggleBlock(0);
                if (response.data.result == 1) {
                  $('#' + form_id).trigger('reset');
                  //$('#success-sound')[0].play();
                  toastr.success('', response.data.message);
                  location.reload();
                  
                }
                else {
                  var message = "{{__('message.Warning')}}";
                  v.disabled = false;
                  //$('#error-sound')[0].play();
                  toastr.warning('', message);
                }
              })
              .catch(function (error) {
                            toggleBlock(0);
                v.disabled = false;
                console.log(error);
                var message = "{{__('message.Warning')}}";
                //$('#error-sound')[0].play();
                toastr.warning('', message);
              });

          }
        })
      }
    }

  });

</script>


@endpush