@extends('layouts.app')
@section('style')
<style type="text/css">
   table.td{
        border-top:0px;
    }
    .header{
    }
</style>
@stop
@section('content')
    <div class="portlet">
        <div class="portlet-title" id="backbtn">
            <div class="caption">
                <i class=""></i>@lang('layout.PayDetails')
            </div>
            <div class="tools">
                <a href="javascript:;" class="collapse" data-original-title="" title=""> </a>
                <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
            </div>
        </div>
        <div class="portlet-body">
            <div class="table-scrollable">
                <table class="table table-striped table-bordered table-advance table-hover">
                    <thead>
                    <tr>
                        <th class="text-center">
                            <i class="fa  fa"></i> @lang('layout.ReferenceNumber') 
                        </th> 
                        <th class="text-center">
                            <i class="fa  fa-user"></i> @lang('layout.Name') 
                        </th>
                         <th class="text-center">
                            <i class="fa fa-clock-o"></i> @lang('layout.Date')
                        </th> 
                        <th class="text-center">
                            <i class="fa fa-clock-o"></i> @lang('layout.OverdueDate')
                        </th>
                        <th class="text-center">
                            <i class="fa fa-clock-o"></i> @lang('layout.Hour')
                        </th>
                        <th class="text-center">
                            <i class="fa fa-file-excel-o"></i> @lang('layout.Account')
                        </th>
                        <th class="text-center">
                            <i class="fa "></i> @lang('layout.Currency')
                        </th> 
                        <th class="text-center">
                            <i class="fa  "></i> @lang('layout.Rate')
                        </th>
                        <th class="text-center">  
                            <i class="fa  "></i> @lang('layout.Amount') 
                        </th>
                        <th class="text-center">
                            <i class="fa  "></i> @lang('layout.Discount') 
                        </th>
                        @if(getcommission() =="true")
                        <th class="text-center">
                            <i class="fa  "></i> @lang('layout.Commission') 
                        </th>
                        @endif
                        <th class="text-center">
                            <i class="fa"></i> @lang('layout.Type')
                        </th>  
                        @if($pay->type == 'branchTransfer')  
                        <th class="text-center">
                            <i class="fa fa-bars"></i> @lang('layout.Send')
                        </th>
                        @endif 
                        @if(systemConfig()[20] == 1)
                        <th class="text-center">
                            <i class="fa fa"></i> @lang('layout.Contract')
                        </th>
                        @endif
                    </tr>
                    </thead>
                    <tbody>
                    <tr>  
                        <td class="text-center"> {{ $pay->ref_Number}}  </td>
                        <td class="text-center"> {{ $pay->name}}  </td>
                        <td class="text-center"> {{ convertDate($pay->Date) }} </td>
                        <td class="text-center"> {{ convertDate($pay->overdue_date) }} </td>
                        <td class="text-center"> {{ $pay->hour }} </td>
                        <td class="text-center"> {{ $pay->account }}  </td> 
                        <td class="text-center"> {{ $pay->currency }}  </td>
                        <td class="text-center"> {{ $pay->brate}}  </td>
                        <td class="text-center"> {{ myRound($pay->amount)}}  </td>
                        <td class="text-center"> {{ $pay->discount }}  </td>
                        @if(getcommission() =="true")
                            <td class="text-center"> {{ myRound($pay->commAmount)}}  </td>
                        @endif
                        <td class="text-center"> {{ $pay->type }}  </td>
                        @if($pay->type == 'branchTransfer') 
                            <td class="text-center"> @if($pay->alert_status == 'On') @lang('layout.Not') @else @lang('layout.yes') @endif </td>
                        @endif
                        @if(systemConfig()[20] == 1)
                            <td class="text-center">{{$pay->contractname}}</td>
                        @endif
                    </tr>
                    </tbody>
                </table>
                <table class="table table-striped table-bordered table-advance table-hover">
                    <thead>
                    <tr>
                        <th width="" class="text-center">
                            <i class=" fa fa-text-width"></i> @lang('layout.Description')
                        </th>
                        <th width="" class="text-center">
                            <i class=" fa fa-text-width"></i> @lang('layout.Memo')
                        </th>
                    </tr>
                    </thead>
                    <tbody>
                    <tr>
                        <td class="text-center"> {{ $pay->description}}  </td>
                        <td class="text-center"> {{ $pay->memo}}  </td>
                    </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
         <div class="row">
         <div class="tabbable tabbable-tabdrop">
            <ul class="nav nav-tabs">
                <li class="active">
                    <a href="#tab2" data-toggle="tab" id="tab_payment">@lang('layout.Attachments')</a>
                </li>
            </ul>
            <div class="tab-content">
             <div class="tab-pane active" id="tab2"> 
                    <div class="tab-pane" id="tab2"> 
                    <div class="portlet light bordered">
                <div class="portlet-title">
                    <div class="caption font-dark">
                        <i class="icon-settings font-dark"></i>
                        <span class="caption-subject bold uppercase">@lang('layout.Attachments')</span>
                    </div>
                </div>
                <div class="portlet-body">
                       <div class="portlet light bordered">
                            <div class="portlet-body">
                                <form role="form" action="{{route('attachment.store')}}" method="post" enctype="multipart/form-data">
                                    @csrf
                                    <input type="hidden" name="redirect_route" value="pay.show">
                                    <input type="hidden" name="foreign_data_id" value="{{$pay->id}}">
                                    <input type="hidden" name="path" value="uploads/Payment">
                                    <input type="hidden" name="table_name" value="payments">
                                    <div class="row">
                                        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                            <div class="form-group">
                                                <label class="control-label">@lang('layout.AttachmentTitle')</label>
                                                <input type="text" name="title" class="form-control">
                                            </div>
                                        </div>
                                        <div class="col-md-6" style="margin-top: 5px">
                                            <div class="form-group">
                                                <label class="control-label">@lang('layout.Description')</label>
                                                <textarea name="description" rows="7" style="resize: none" class="form-control"></textarea>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                              <div class="form-group">
                                                <div class="fileinput fileinput-new" data-provides="fileinput" style="width: 100%;">
                                                    <div style="margin-top: 5px">
                                                        <span class="btn default btn-file">
                                                            <span class="fileinput-new">@lang('layout.SelectFile')</span>
                                                            <span class="fileinput-exists">@lang('layout.Change')</span>
                                                            <input type="hidden" value="" name=""><input type="file" name="photo"> </span>        
                                                        <a href="javascript:;" class="btn default fileinput-exists" data-dismiss="fileinput"> @lang('layout.Remove') </a>
                                                    </div>
                                                    <div class="fileinput-new thumbnail" style="width: 100%; height: 145px;">
                                                        <img src="" alt=""> </div>
                                                    <div class="fileinput-preview fileinput-exists thumbnail" style="max-width: 100%; max-height: 150px; line-height: 10px;"> </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>                 
                                    <div class="margin-top-10 text-center">
                                        <button type="button" onclick="regForm(this)" class="btn green"> @lang('layout.Submit') </button>
                                        <a href="{{route('pay.index')}}" class="btn default">@lang('layout.Cancel')</a>
                                    </div>
                            </form>
                            </div>
                    </div>
                    <table class="table table-striped table-bordered table-hover" id="attachment">
                        <thead>
                        <tr>  
                        <th>@lang('layout.AttachmentTitle')</th>
                        <th>@lang('layout.Description')</th>
                        <th>@lang('layout.Action')</th>
                        </tr>
                        </thead>
                    </table>
                </div>
            </div>
    </div>
            </div>
        </div>
    </div>
</div>
@endsection
@push('scripts')
<script>
    $(document).ready(function () {
        $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
          $('#attachment').DataTable({
                ajax:{
                    url:'{{route("pay.show",$pay->id)}}',
                    data:{type:'attachment'}
                  },
                scrollCollapse: true,
                serverSide: true,
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                paging: true,
                columns: [
                    { data: 'title', name: 'attachments.title'},
                    { data: 'description', name: 'attachments.description'},
                    { data: 'actions',         name: 'actions', orderable:false,searchable:false},
            ]
        });
    });
</script>
@endpush