@extends('layouts.factor-master')
@section('style')

<style>
  .st {
    font-size: 16px;
    font-weight: bold;
  }
</style>
@stop
@section('content')

<h4 class="bold uppercase" style="text-align: center; font-size: 20px;">@lang('layout.PaymentVouchar')(PV)</h4>

<table class="main-table" style="width: 100%;" cellpadding="8px">
  <tr class="bg">
    <td style="width: 20%;">
      <span class="st"> @lang('layout.PaymentNumber'): </span>
      <span class="st">{{$payments->pNumber}}</span>
    </td>
    <td colspan="2" style="width: 20%;">
      <span class="st">@lang('layout.Code'):</span>
      <span class="st">{{$payments->code}}</span>
    </td>
  </tr>
  <tr class="bg">

    <td style="width: 30%;">
      <span class="st">@lang('layout.Date'): </span>
      <BDO DIR="LTR"> <span class="st">{{convertDate($payments->Date)}}</span> </BDO>
    </td>
    <td style="width: 20%;">
      <span class="st">@lang('layout.Hour'): </span>
      <BDO DIR="LTR"> <span class="st">
          <?php echo Date('h:i A' , strtotime($payments->DateTime)); ?>
        </span> </BDO>
    </td>
    <td rowspan="2" style="width: 50%;">
      <span class="st">@lang('layout.Description'):</span>
      <span class="st">
         {{$payments->description}}
        </span>
    </td>
  </tr>
  <tr class="bg">
    <td>
      <span class="st" >@lang('layout.Payer'):</span>
      <span class="st" >{{$user}}</span>
    </td>
    <td>
      <span class="st">@lang('layout.ReceivedBy'):</span>
      <span class="st">{{$payments->member}}</span>
    </td>
    
  </tr>
  <tr>

</table>
<table class="main-table" style="width: 100%; " cellpadding="8px">

  <tr>
    <td>
      <span class="st">@lang('layout.Amount') @lang('currency.'.($payments->currency ))</span>
    </td>    
    <td>
      <span class="st">@lang('layout.Rate')</span>
    </td> 
    <td>
      <span class="st">@lang('currency.'.(getHomeCurrency()['code']))</span>
    </td>    
    <td>
      <span class="st">@lang('layout.Remained')
        
      </span>
    </td>
  </tr>  
  <tr>
    <td>
      <span class="st">{{myRound($payments->Amount)}} {{$payments->currency}}</span>
    </td>    
    <td>
      <span class="st">{{$payments->rate}}</span>
    </td>
    <td>
      <span class="st">{{myRound($payments->Amount/$payments->rate)}} {{getHomeCurrency()['code']}}</span>
    </td>

    @if(getHesabSabeqa() =='true')
   <td>
     <span class="st">{{myRound(ABS($balance))}} {{getHomeCurrency()['code']}}
      @if($balance<0)
          (@lang('layout.Payable'))
        @else
          (@lang('layout.Receivable'))
        @endif
    </span>
    </td>
   @endif

  </tr>
</table>





@if(company()['pay_message'])
<table width="100%">
  <tr>
    <td style="font-size: 14px;">{!!company()['pay_message']!!}</td>
  </tr>

  <tr>
    <td></td>
    <td></td>
  </tr>


</table>
@endif
<br>
<table width="100%">
  <tr>
    <td style="width: 70%;font-size: 14px;"></td>
    <td style="width: 40%;" class="st">@lang('layout.MohrAndSignature')</td>
  </tr>

  <tr>
    <td></td>
    <td></td>
  </tr>


</table>


@endsection