@extends('layouts.app')

@section('content')
    <div class="row">

        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.EditPay')</span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools">

                </div>
            </div>
            <div class="portlet-body form" style="margin-bottom:50%;" id="app">
                <!-- BEGIN FORM-->
                {!! Form::model($payment, ['method' => 'PATCH','class'=>'form-horizontal','route' => ['pay.updateBankCheckPayment',$payment->id]]) !!}
                <div class="form-body" v-cloak>
                    <div class="row">
                        <div class="col-md-8">
                            <div class="row">
                                <div class="col-md-4">
                                    <label class="control-label">@lang('layout.SelectMember')</label>
                                    <v-select @input="getSummary" class="vue-select2" v-model="selectedMember"
                                              label="name"
                                              :options="member" disabled>
                                    </v-select>
                                    <input type="hidden" name="member_id" v-model="selectedMember.id"
                                           v-validate="'required'" data-vv-as="@lang('layout.Member')">
                                    <span class="required">@{{errors.first('member_id')}}</span>
                                </div>
                                <div class="col-md-2">
                                    <label class="control-label">@lang('layout.Number')</label>
                                    <input type="number" name="number" class="form-control"
                                           value="{{$payment->payment_number}}" readonly>
                                </div>
                                <div class="col-md-3">
                                    <label class="control-label">@lang('layout.ReferenceNumber')</label>
                                    <input type="text" name="ref_no" class="form-control" @input="checkRefNo()"
                                           v-model='ref_no' readonly>
                                    <span v-if="isError ==true" class="input-has-error"
                                          style="color: red">@{{msg}}</span>
                                </div>

                                <div class="col-md-3">
                                    <label class="control-label">@lang('layout.Type')</label>
                                    <select class="form-control" name="type" v-model="selectedType">
                                        <option value="invoice">@lang('layout.Invoice')</option>
                                        <option value="bill">@lang('layout.Bill')</option>
                                        <option value="salary">@lang('layout.Salary')</option>
                                        <option value="loan">@lang('layout.Loan')</option>
                                        <option value="prepaid">@lang('layout.Prepaid')</option>
                                        <option value="bankCheck">@lang('layout.BankCheck')</option>
                                    </select>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6" style="padding: 0px;">
                                    <div :class="currency_len">
                                        <label class="control-label">@lang('layout.PaymentCurrency')</label>
                                        <select class="form-control" v-model="selectedCurrency" disabled 
                                                v-on:change="setSize(selectedCurrency.code)" :readonly="(old_payment_type=='bank_check' && payment_type=='')">
                                            <option v-for="curre in currency" :value="curre">@{{ curre.code }}</option>
                                        </select>
                                        <input type="hidden" name="currency" v-bind:value="selectedCurrency.code"/>
                                    </div>
                                    <div :class="rate_len" v-if="selectedCurrency.code != '{{getHomeCurrency()["code"]}}'">
                                        <label class="control-label">@lang('layout.Rate') </label>
                                        <div :class="{'has-error':selectedCurrency.rate < 0}">
                                            <div class="input-group">
                                                <input v-model="selected_rate" class="form-control"
                                                       type="number" step="any" min="0"
                                                       @keyup="check_code(paymentCurrency.code)" readonly>
                                                <span class="input-group-addon">@{{selectedCurrency.symbol}}</span>
                                            </div>
                                            <input type="hidden" name="currency_rate" :value="selected_rate">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <label class="control-label">@lang('layout.Account')</label>

                                    <div class="input-group">
                                        <select class="form-control" name="account_id" v-model="defaultAccount"
                                                v-on:change="test(defaultAccount)">
                                            <option v-for="Account in accountUpdate" :value="Account.id">@{{
                                                Account.name }}
                                            </option>
                                        </select>
                                        <!-- <span class="input-group-addon">@{{ Number(selectedBank.balance)-(Number(amount)-Number(defaultAmount)) }}</span> -->
                                        <span v-if="selectedBank" class="input-group-addon">@{{ format_number( Number(selectedBank.balance)-(Number(amount)-Number(defaultAmount))) }}</span>

                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6" style="padding: 0px;">
                                    <div :class="pcurrency_len">
                                        <label class="control-label">@lang('layout.Currency')</label>
                                        <select class="form-control" v-model="paymentCurrency"
                                                v-on:change="setPaymentSize(paymentCurrency.code)" disabled>
                                            <option v-for="curre in currency1" :value="curre">@{{ curre.code }}</option>
                                        </select>
                                        <input type="hidden" name="paymentCurrency"
                                               v-bind:value="paymentCurrency.code"/>
                                    </div>
                                    <div :class="prate_len" v-if="paymentCurrency.code != '{{getHomeCurrency()["code"]}}'">
                                        <label class="control-label">@lang('layout.Rate') </label>
                                        <div :class="{'has-error':paymentCurrency.exchange_rate < 0}">
                                            <div class="input-group">
                                                <input v-model="selected_rate1" class="form-control"
                                                       type="number" min="0" step="any"
                                                        readonly>
                                                <span class="input-group-addon">@{{paymentCurrency.symbol}}</span>
                                            </div>
                                            <input type="hidden" name="rate" :value="selected_rate1">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <label class="control-label">@lang('layout.Amount')</label>
                                    <div class="input-group">

                                        <input type="hidden" name="amount" v-model="amount" step="any" min="0"  v-validate="'required'" data-vv-as="@lang('layout.Amount')" class="form-control">
                                        <br>
                                        @{{amount}}
                                        <span class="input-group-addon">@{{selectedCurrency.symbol}}</span>
                                    </div>
                                    <span class="required">@{{errors.first('amount')}}</span>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-3">
                                    <label class="control-label">@lang('layout.ExchangedAmount')</label>
                                    <div class="input-group">
                                        <input type="number"
                                               :value="checkExchagePayment"
                                               class="form-control" min="0" step="any" readonly>
                                        <span class="input-group-addon">@{{paymentCurrency.symbol}}</span> 
                                    </div> 
                                </div>
                                <div class="col-md-3">
                                    <label class="control-label">@lang('layout.Discount')</label>
                                    <input type="number" name="discount" v-model="discount" step="any" min="0"
                                           class="form-control" disabled>

                                </div>
                                <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
                                    <label class="control-label">@lang('layout.Date') </label>
                                    <div>
                                        <input class="form-control date" id="range-from-example" name="date"
                                               autocomplete="off" value="{{$payment->Date}}" disabled>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-3">
                                    <label class="control-label">@lang('layout.PaymentType')</label>
                                    <select class="form-control" name="payment_type" v-model="payment_type" disabled>
                                        <option value="">@lang('layout.SelectType')</option>
                                        <option value="bank_check">@lang('layout.BankCheck')</option>
                                    </select>
                                </div>
                                <div class="col-md-3" v-show="payment_type !=''">
                                    <label class="control-label">@lang('layout.CheckNumber')</label>
                                    <input type="text" name="check_number" value="{{$payment->check_number}}"
                                           class="form-control" placeholder="00020" readonly>
                                </div>
                                <div class="col-md-6" v-show="payment_type !=''">
                                    <label class="control-label">@lang('layout.CheckDate')</label>
                                    <input type="text" name="check_date" value="{{$payment->check_date}}"
                                           class="form-control date" autocomplete="off"
                                           placeholder="@lang('layout.CheckDate')" disabled>
                                </div>
                                <?php
                                $r_description = $payment->description;
                                $d_discription = '(مبلغ ' . $payment->discount . 'تخفیف)';
                                // dd($r_description);
                                // dd(strlen($d_discription));
                                //dd(substr($r_description,0, -strlen($d_discription)));
                                // dd(substr($r_description, strpos($r_description,$d_discription )));

                                if (substr($r_description, strpos($r_description, $d_discription)) == $d_discription) {
                                    $description = (substr($r_description, 0, -strlen($d_discription)));
                                } else {
                                    $description = $r_description;
                                }
                                ?>
                                <div class="col-md-6">
                                    <label class="control-label">@lang('layout.Description')</label>
                                    {{Form::textarea('description',$description,['class'=>'form-control','rows'=>'3'])}}
                                </div>
                            </div>

                        </div>
                        <div class="col-md-4">
                            <div class="panel panel-default"
                                 style="background-color:rgb(204, 216, 228);position: relative;top: 24px;">
                                <div class="panel-body">
                                    <table class="table table-bordered">
                                        <thead>
                                        <tr>
                                            <th>@lang('layout.Currency') </th>
                                            <th>@lang('layout.Payable')</th>
                                            <th>@lang('layout.Receivable')</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                  <span v-if="selectedMember">
                   <tr v-for="summ in summary">
                      <td class="highlight">
                         @{{ summ.currency }}
                      </td>
                      <td class="hidden-xs"> @{{ format_number(Number(summ.payment)) }}</td>
                      <td>
                          @{{ format_number(Number(summ.invoice)) }}
                      </td>
                    </tr>
                </span>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-10">
                    <div class="row">
                        <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                            <button v-if="isError ==false" type="button" class="btn green"
                                    @click="handleSubmit($event)">@lang('layout.Submit')</button>
                            <a href="{{route('pay.index')}}" class="btn default"><i
                                        class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                        </div>
                    </div>
                </div>
                {!! Form::close() !!}
            </div>
            <!-- END FORM-->
        </div>
    </div>
@endsection
@push('scripts')

    <script>
        @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
        Vue.use(VeeValidate, {
            locale: 'en',
        });
        @endif

        Vue.component('v-select', VueSelect.VueSelect)
        var Banks ={!! $bank!!}
        var Currency ={!! $currency!!}
        var Currency1 ={!! $currency!!}
        var member ={!! $member !!};
        var one ={!! json_encode(Currency()->getCurrency()) !!}
        var two ={!! json_encode(Currency()->getCurrency()) !!}
        var code = "{!! getHomeCurrency()["code"] !!}";
        let vu = new Vue({
            el: '#app',
            data: {
                selectedCurrency: one,
                selectedCurrencyTemp: null,
                paymentCurrency: two,
                summary: [],
                member: member,
                selectedCurrency2: null,
                currency:{!! json_encode(getCurrencies()) !!},
                currency1:{!! json_encode(getCurrencies()) !!},

                bankes: {!! $banks !!},
                selectedBank: null,
                defaultValue: 0,
                defaultAmount:{!! $payment->amount * $payment->brate!!},
                defaultAccount: 0,
                selected_rate:{!!$payment->brate!!},
                selected_rate1:{!!$payment->exchange_rate!!},
                listAccounts: [],
                selectedMember:null,
                newAmount: null,
                amount:{!!$payment->amount!!},
                discount:{!!$payment->discount!!},
                defaultAccountId: "{{ $payment->paid_account_id }}",
                recordRate: "{{ $payment->rate }}",
                currencyList: Currency,
                type: 'bank',
                account: {},
                currency_len: 'col-md-12',
                rate_len: 'col-md-0',
                pcurrency_len: 'col-md-12',
                selectedType: "{!! $payment->type !!}",
                prate_len: 'col-md-0',
                code: code,
                first_currency: 0,
                second_currency: 0,
                // selectedType: "{!!$payment->type!!}",
                firstAccount: "{{ $payment->paid_account_id }}",
                allBankAccounts: null,
                defautlgetAmount: {!! $payment->amount * $payment->brate !!},
                ref_no: "{{$payment->ref_Number}}",
                msg: '',
                isError: false,
                payment_type: "{{$payment->payment_type}}",
                payment:{!! $payment !!},
                old_payment_type:"{{$payment->payment_type}}",
                checkExchagePayment: ''
            },
            computed: {
                accountUpdate() {
                    var b = _.clone(Banks)
                    var test = this.accounts = b.filter((account) => {
                        return (new RegExp(this.selectedCurrency.code.toLowerCase())).test(account.code.toLowerCase())
                    })
                    if (test) {
                        if (test[0]) {
                            this.defaultValue = test[0].id;
                        }
                    }
                    for (var x in this.bankes) {
                        for (z in this.bankes[x]) {
                            if (this.firstAccount != -1) {
                                if (this.bankes[x][z] == this.firstAccount && z == 'id') {
                                    this.selectedBank = this.bankes[x];
                                    this.defaultAccount = this.firstAccount;
                                    this.firstAccount = -1;
                                    break;
                                }
                            }
                            else if (this.bankes[x][z] == this.defaultValue && z == 'id') {
                                this.selectedBank = this.bankes[x];
                                this.defaultAccount = this.defaultValue;
                                break;
                            }
                        }

                    }
                    return test;
                },
            },
            mounted :function() {
                // this.checkExchagePayment = 333322;
                @if(systemConfig()[30] == 1)
                // this.checkExchagePayment = ((this.amount-this.discount)*this.selected_rate1/(this.selected_rate)).toFixed(3);
                this.checkExchagePayment = myRound(((this.amount / this.selectedCurrency.static_rate * this.selected_rate) * this.paymentCurrency.static_rate) / this.selected_rate1);
                @else 
                this.checkExchagePayment = ((this.amount-this.discount)*this.selected_rate1/(this.selected_rate)).toFixed(3);
                @endif
            },
            created() {

                if(this.payment)
                {

                    this.selectedMember=_.find(this.member,(v)=>v.id==this.payment.member_id);
                }
                var b = _.clone(Banks);
                for (var m of b) {
                    if (m.id == this.defaultAccountId) {

                        this.defaultAccount = m;

                    }
                }

                this.checkSelected();
            },
            methods: {
                checkRefNo() {

                    //console.log(vm.ref_no)

                    var chack = 'false';
                    var ref_no = vu.ref_no;
                    if (ref_no != null) {


                        axios.get("{{route('callMethod.search')}}",
                            {

                                params: {
                                    ref_no: vu.ref_no,
                                    method_name: 'Search_ref_no',
                                    table_name: 'payments'
                                },
                            })
                            .then(function (response) {
                                // console.log(response.data.result);
                                if (response.data.result != null) {
                                    console.log(response.data.result);
                                    // v.temp_items=response.data;
                                    vu.msg = "@lang('layout.DuplicateData')";
                                    vu.isError = true;
                                }
                                else {
                                    vu.msg = 'no';
                                    vu.isError = false;

                                }


                            })
                            .catch(function (error) {
                                console.log(error);
                            });

                    }

                },
                handleSubmit(e) {
                    this.$validator.validate().then(valid => {
                        if (valid) {
                            // console.log(e);
                            // alert(e.target);
                            regForm(e.target);
                        }
                    });
                },
                getSummary() {
                    if (this.selectedMember) {

                        this.getSummaryRecor(this.selectedMember.id, this);

                    }

                },
                getSummaryRecor(id, vm) {
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'memberStatment',
                            member_id: id,
                        }
                    })
                        .then(function (response) {

                            if (response.data.length > 0) {
                                vm.summary = response.data;
                            }
                        })
                        .catch(function (error) {
                            console.log(error);
                        });
                },

                check_code(code) {
                    if (this.paymentCurrency.code == this.selectedCurrency.code) {
                        this.selected_rate1 = this.selected_rate;
                    }

                },
                checkSelected() {
                    var allCarrencies = {!! json_encode(getCurrencies()) !!};
                    for (var x in allCarrencies) {
                        for (z in allCarrencies[x]) {
                            if (allCarrencies[x][z] == "{!! $payment->bcurrency !!}") {
                                if (allCarrencies[x][z] != "{!!getHomeCurrency()["code"]!!}") {
                                    this.currency_len = 'col-md-6';
                                    this.rate_len = 'col-md-6';
                                }
                                this.selectedCurrency = allCarrencies[x];
                            }

                            if (allCarrencies[x][z] == "{!! $payment->currency !!}") {
                                if (allCarrencies[x][z] != "{!!getHomeCurrency()["code"]!!}") {
                                    this.pcurrency_len = 'col-md-6';
                                    this.prate_len = 'col-md-6';
                                }
                                this.paymentCurrency = allCarrencies[x];

                            }


                        }

                    }

                },
                setSize(selected_code) {
                    this.paymentCurrency = this.selectedCurrency;
                    this.selected_rate = this.selectedCurrency.exchange_rate;
                    this.selected_rate1 = this.selectedCurrency.exchange_rate;
                    if (selected_code == this.code) {
                        this.currency_len = 'col-md-12';
                        this.rate_len = 'col-md-0';
                        this.selected_rate = selectedCurrency.exchange_rate;
                    }
                    else {
                        this.currency_len = 'col-md-6';
                        this.rate_len = 'col-md-6';
                    }
                    this.pcurrency_len = this.currency_len;
                    this.prate_len = this.rate_len;
                },
                setPaymentSize(selected_code) {
                    // this.selected_rate = this.paymentCurrency.exchange_rate;
                    this.selected_rate1 = this.paymentCurrency.exchange_rate;

                    if (selected_code == this.code) {
                        this.pcurrency_len = 'col-md-12';
                        this.prate_len = 'col-md-0';
                    }
                    else {
                        this.pcurrency_len = 'col-md-6';
                        this.prate_len = 'col-md-6';
                    }
                },

                test(defaultAccount) {
                    for (var x in this.bankes) {
                        for (z in this.bankes[x]) {
                            if (this.bankes[x][z] == defaultAccount && z == 'id') {
                                this.selectedBank = this.bankes[x];
                                break;
                            }
                        }

                    }
                },
                amounts() {

                    this.amount = this.amount - this.discount;

                },
            }

        });

        // vu.setData();
    </script>


@endpush
   