@extends('layouts.app')
@section('content')
    <!-- END PAGE HEADER-->
    <div id="print-modal">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show" :value-type="'all_pay'" @closed="closeModal">
            <div slot=body>
            <!----------------------------------------------
            ----Begin Report Body And Custome Report------- 
            ----------------------------------------------->
            <div class="row" v-cloak>
                <div class="tabbable tabbable-tabdrop">
                    <ul class="nav nav-tabs">
                        <li class="active">
                            <a href="#tab1" data-toggle="tab" id="tab_main">@lang('menu.Report')</a>
                        </li>
                        @if(systemConfig()[2] != 0 )
                        @permission(['customreport-list'])
                        <li class="">
                            <a href="#tab2" data-toggle="tab" id="tab_custome">@lang('layout.CustomReportM')</a>
                        </li>
                        @endpermission
                        @endif
                    </ul>
                    <div class="tab-content">
                        <div class="tab-pane active" id="tab1"> 
                            <div class="portlet light bordered">
                                <div class="row">
                                    <div class="form-group">
                                        <div class="col-md-4">
                                            <label class="control-label ">@lang('layout.SelectMember') </label>
                                            <v-select class="vue-select2" v-model="selectedMember" label="name" @search="onMemberSearch" :options="memberlist">
                                            </v-select>
                                            <input type="hidden" name="member_id" v-model.number="(!selectedMember)?null:selectedMember.id">
                                        </div>
                                        <div class="col-md-4">
                                            <label class="control-label ">@lang('layout.SelectType') </label>
                                            <select name="type_name" id="" class="form-control">
                                                <option value="">@lang('layout.SelectType')</option>
                                                @foreach($paymentTypes as  $type)
                                                    <option value="{{$type->type}}">{{$type->type}}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        <div class="col-md-4">
                                            <label class="control-label ">@lang('layout.MemberClass') </label>
                                            <v-select class="vue-select2" v-model="selectedClass" label="name" @search="onClassSearch"
                                                        :options="classlist">
                                            </v-select>
                                            <input type="hidden" name="class_id" v-model.number="(!selectedClass)?null:selectedClass.id">
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="form-group">
                                        @if(getFinancialClass() =='true') 
                                            @permission('financialClass-list')
                                            <div class="col-md-4">
                                                <label class="control-label"> @lang('menu.FinancialClass')</label>
                                                <select name="financial_class_id" class="form-control" >
                                                    <option value="">@lang('layout.SelectClass')</option>
                                                    <option value="Unclassified">Unclassified</option>
                                                    <option v-for="cla in financial_classes" :value="cla.id" :key="cla.id" >@{{cla.name}}</option>
                                                </select>
                                            </div>
                                            @endpermission
                                        @endif
                                        <div class="col-md-4">
                                            <label class="control-label">@lang('layout.Currency') </label>
                                            <select class="form-control" v-model="selected_currency" >
                                                <option v-for="curre in currencies" :value="curre">@{{ curre.code }}</option>
                                            </select>
                                            <input type="hidden" name="currency" v-bind:value="(selected_currency)?selected_currency.code:null"/>
                                        </div>
                                        <div class="col-md-4">
                                            <span v-if="selected_currency">
                                                <span v-if="selected_currency.code != code">
                                                <label class="control-label">@lang('layout.Rate') </label>
                                                        <div class="input-group">
                                                            <input v-model="selected_currency.rate" class="form-control" name="currency_rate"
                                                                type="number" step="any" min="0"  >
                                                            <span class="input-group-addon">@{{selected_currency.symbol}}</span>
                                                        </div>
                                                </span>
                                            </span>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-4">
                                        <label class="control-label ">@lang('layout.Bank') </label>
                                        <v-select class="vue-select2"
                                                v-model="selected_bank"
                                                label="name"
                                                :options="bank"
                                                @search="searchAccount"
                                                >
                                        </v-select>
                                        <input type="hidden" name="bank_id" :value="(!selected_bank)?null:selected_bank.id">
                                    </div>
                                    @if(systemConfig()[20] == 1)
                                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                            <label class="control-label">@lang('layout.Contract')</label>
                                            <v-select class="vue-select2" placeholder="@lang('layout.Select')" v-model="selectedContract" label="company_name" :options="contract">
                                            </v-select>
                                            <input type="hidden" name="contract_id" v-model.number="(!selectedContract)?null:selectedContract.id" />
                                        </div>
                                    @endif
                                    
                                    <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                        <label class="control-label">@lang('layout.filterMoneyCurrency')</label>
                                        <select class="form-control" v-model="selected_filter_currencies" >
                                            <option v-for="curre in filtercurrencies" :value="curre">@{{ curre.code }}</option>
                                        </select>
                                        <input type="hidden" name="currency" v-bind:value="(selected_filter_currencies)?selected_filter_currencies.code:null"/>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="form-group">
                                        <div class="col-md-4">
                                            <label class="control-label ">@lang('layout.Date')</label>
                                                <select name="period" v-model="period" @input="getDates()" class="form-control">
                                                <option value="CustomDates">@lang('type.CustomDates')</option>
                                                <option value="Today">@lang('type.Today')</option>
                                                <option value="Yesterday">@lang('type.Yesterday')</option>
                                                <option value="ThisWeek">@lang('type.ThisWeek')</option>
                                                <option value="LastWeek">@lang('type.LastWeek')</option>
                                                <option value="WeekToDate">@lang('type.WeekToDate')</option>
                                                <option value="ThisMonth">@lang('type.ThisMonth')</option>
                                                <option value="MonthToDate">@lang('type.MonthToDate')</option>
                                                <option value="ThisQuarter">@lang('type.ThisQuarter')</option>
                                                <option value="QuarterToDate">@lang('type.QuarterToDate')</option>
                                                <option value="ThisYear">@lang('type.ThisYear')</option>
                                                <option value="YearToDate">@lang('type.YearToDate')</option>
                                            </select>
                                        </div>
                                        <div class="col-md-8" v-show="period == 'CustomDates'">
                                            <div class="form-group">
                                                <label class="control-label"> @lang('layout.Date')</label>
                                                <div class="input-group">
                                                    <input class="form-control date" id="range-from-example" v-model="from_date" name="from_date" autocomplete="off">
                                                    <span class="input-group-addon"> @lang('layout.To') </span>
                                                    <input class="form-control date" id="range-to-example" v-model="to_date" name="to_date" autocomplete="off">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div> 
                        <div class="tab-pane" id="tab2"> 
                            <div class="portlet light bordered">
                                <div class="portlet-body">
                                    <form  id="saveCustomeReport" role="form" action="{{route('customeReport.storeCustomeReport')}}" method="post" >
                                        @csrf
                                        <input type="hidden" name="part_name" value="pay_index">
                                        <div class="col-md-12 col-sm-12 col-xs-12">
                                            <div class="mt-checkbox-inline col-md-2" style="padding: 0px;" v-for="(row,itemIndex) in customReportData">
                                                <div class="form-group">
                                                    <table class="table table-striped table-bordered table-advance table-hover">
                                                        <tr>
                                                            <td style="text-align: center;">@{{ row.Name }}</td>
                                                        </tr>
                                                        <tr>
                                                            <td style="text-align: center;">
                                                                <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">
                                                                <label class="switch">
                                                                    <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                    :checked="row.checkedColumn" >
                                                                    <span class="slider round"></span>
                                                                </label>
                                                                <select :name="'column_percentage['+itemIndex+']'" v-model="row.column_percentage" class="form-control" style="width: 90%;">
                                                                    <option value="">@lang('layout.Select')</option>
                                                                    <option value="2">2 %</option>
                                                                    <option value="6">6 %</option>
                                                                    <option value="10">10 %</option>
                                                                    <option value="15">15 %</option>
                                                                    <option value="20">20 %</option>
                                                                    <option value="25">25 %</option>
                                                                    <option value="30">30 %</option>
                                                                    <option value="40">40 %</option>
                                                                    <option value="50">50 %</option>
                                                                    <option value="60">60 %</option>
                                                                </select>
                                                            </td>
                                                        </tr>
                                                    </table>
                                                    <!-- <label> @{{ row.Name }}</label>
                                                    <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">
                                                    <label class="switch">
                                                            <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                            :checked="row.checkedColumn" >
                                                            <span class="slider round"></span>
                                                    </label> -->
                                                </div>
                                            </div>
                                        </div>
                                        <div class="margiv-top-10">
                                            <!-- <button type="button" onclick="regForm(this)" class="btn green"> <i class="fa fa-save"></i> </button> -->
                                            <button type="button" onclick="saveCustomeReport(this)" class="btn blue"> <i class="fa fa-save"></i> </button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!----------------------------------------------
            ----Begin Report Body And Custome Report-------
            ----------------------------------------------->


            </div>
        </report-modal>
    </div>
    <!-- BEGIN TAB PORTLET-->
    <div class="row">
        <!-- app -->
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bortdered">
            <div class="portlet-title">
                <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                    <div class="caption font-dark">
                        <i class="icon-settings font-dark"></i>
                        <span class="caption-subject bold uppercase">@lang('layout.PaymentList')</span>
                    </div>
                </div>
                <div class="col-lg-7 col-md-7 col-sm-12 col-xs-12" style="display: flex; justify-content: center;" id="date_part">
                    <div class="form-group">
                        <div class="input-group">
                            <input name="from_date" class="form-control date" ref="from_date" placeholder="@lang('layout.FromDate')" autocomplete="off" />
                            <span class="input-group-addon"> @lang('layout.To') </span>
                            <input name="to_date" class="form-control date" ref="to_date" placeholder="@lang('layout.ToDate')" autocomplete="off" />
                            <span class="input-group-addon btn" style="background: #36c6d3;color: white;"  @Click="getData()"> @lang('layout.Search') </span>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                    <div class="pull-right">
                        @permission('pay-list')
                        <span id="anchore-modal">
                         <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                            <i class="fa fa-print"></i>
                         </a>
                        </span>
    
                        @endpermission
                        @permission('pay-create')
                        <a href="{{route('pay.create')}}">
                            <!-- <button id="sample_editable_1_new" class="btn green btn-sm btn-outline"> -->
                            <button id="sample_editable_1_new" class="btn btn-success">
                                <i class="fa fa-plus"></i> @lang('layout.AddNew')
                            </button>
                        </a>
                        @endpermission
                    </div>
                </div>
            </div>
            <div class="portlet-body">
                <template v-cloak id="company_ll">
                    <company @company="setCompany"></company>
                </template>
                <table class="table table-striped table-bordered table-hover" id="pay">
                    <thead>
                        <tr>
                            <th>@lang('layout.Number')</th>
                            <th>@lang('layout.ReferenceNumber')</th>
                            <th>@lang('layout.Name')</th>
                            <th>@lang('layout.Account')</th>
                            <th>@lang('layout.Currency')</th>
                            <th>@lang('layout.Rate')</th>
                            <th>@lang('layout.Amount')</th>
                            <th>@lang('layout.Type')</th>
                            @if(systemConfig()[20] != 0 )
                                <th>@lang('layout.Contract')</th>
                            @endif
                            <th>@lang('layout.Date')</th>
                            <th>@lang('layout.OverdueDate')</th>
                            <th>@lang('layout.Hour')</th>
                            <th>@lang('layout.User')</th>
                            <th>@lang('layout.Description')</th>
                            <th>@lang('layout.Status')</th>
                            <th>@lang('layout.Actions')</th>
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>
    <!-- END TAB PORTLET-->
    <iframe id="payframe" style="display: none;"></iframe>
    <!-- END CONTENT BODY -->
@stop
@include('print.modal')
@include('groupCompanyFilter.select')
@push('scripts')
    <script>
        var cust_rep = {!!customeReportNewData('pay_index')!!};
        Vue.component("v-select", VueSelect.VueSelect);
        @if (Session('payment_id'))
        printVoucher("{{Session('payment_id')}}", "{{Session('whatsapp')}}")
        @endif
        function printVoucher(id,sendWhatsapp = null) {
            var a = document.createElement('a');
            a.href = "{{url('printPayment')}}/" + id + "/" + sendWhatsapp;
            a.target = "_blank";
            document.body.appendChild(a);
            a.click();
            document.body.removeChild(a);
        }
        function sendVoucherToWhatsapp(id,sendWhatsapp) {
            if (id && sendWhatsapp) {
                axios.get("{{url('printPayment')}}/" + id + "/1", {
                    // params: {
                        // method_name: 'SearchMember',
                        // class_id: class_id
                    // }
                })
                .then(function(response) {
                    // console.log(response);
                    if (response.data) {
                        if (sendWhatsapp == 1) {
                            var a = document.createElement('a');
                            a.href = "https://wa.me/?text=" + response.data;
                            a.target = "_blank";
                            document.body.appendChild(a);
                            a.click();
                            document.body.removeChild(a);
                        }
                        if (sendWhatsapp == 2) {
                            var a = document.createElement('a');
                            a.href = "https://telegram.me/share/url?url=Hi&text=" + response.data;
                            a.target = "_blank";
                            document.body.appendChild(a);
                            a.click();
                            document.body.removeChild(a);
                        }
                    }
                })
                .catch(function(error) {
                    console.log(error);
                })
            }
        }
        var data_table =0;
        $(document).ready(function () {
            getRecord(); 
        });
        function getRecord() {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            if (data_table != 0) {
                data_table.destroy();
            }
            data_table = $('#pay').DataTable({
                ajax: {
                    ajax: '{{route("pay.index")}}',
                    data: {
                        from_date: vtr.from_date,
                        to_date: vtr.to_date
                    }
                },      
                pageLength: '{{getPageRows()}}',
                order: [["{{orderByColumn()=='number'?0:8}}", "{{getRowOrder()}}"]],
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                scrollCollapse: true,
                paging: true,
                serverSide: true,
                buttons: [{
                    extend: 'excel',
                    text: '',
                    key: {
                        key: 'x',
                        altkey: true
                    }
                }],
                columns: [
                    {data: 'payment_number', name: 'payments.number'},
                    {data: 'ref_no', name: 'payments.ref_no'},
                    {data: 'member_name', name: 'members.name'},
                    {data: 'Account', name: 'accounts.name'},
                    {data: 'currency', name: 'transactions.unit'},
                    {data: 'Rate', name: 'transactions.rate', searchable: false},
                    {data: 'amount', name: 'transactions.amount' @if(getGeneralSearch()) , searchable: false @endif},
                    {data: 'Payment_type', name: 'payments.type', searchable: false},
                    @if(systemConfig()[20] != 0 )
                    {data: 'contractname', name: 'contracts.company_name'},
                    @endif
                    {data: 'Date', name: 'payments.date' @if(getGeneralSearch()) , searchable: false @endif},
                    {data: 'overdue_date', name: 'payments.overdue_date'},
                    {data: 'hour', name: 'payments.hour', searchable: false},
                    {data: 'username', name: 'users.name'},
                    {data: 'Description', name: 'payments.description' @if(getGeneralSearch()) , searchable: false @endif},
                    {data: 'payment_status', name: 'payment_status', orderable: false, searchable: false},
                    {data: 'actions', name: 'actions', orderable: false, searchable: false}
                ]
            });
        }
        var vtr = new Vue({
            el: '#date_part',
            data: {
                from_date: null,
                to_date: null,
            },
            methods: {
                getData() {
                    this.from_date = this.$refs.from_date.value;
                    this.to_date = this.$refs.to_date.value;
                    // console.log(234, this.from_date, this.to_date,this.$refs.from_date.value);
                    getRecord();
                }
            }
        });
        new Vue({
            el: '#company_ll',
            methods: {
                setCompany: function (event) {
                    window.location.reload();
                }
            }
        });
        // function printVoucher(id){
        //     document.getElementById("payframe").src ="{{url('printPayment')}}/"+id;
        // }
        // for new modal
        var currencies = {!! $currencies !!};
        var filtercurrencies = {!! $currencies !!};
        var contract = {!! json_encode($contract) !!};
        var code = '{!! getHomeCurrency()['code'] !!}';
        var vm = new Vue({
            el: '#print-modal',
            data: {
                contract: contract,
                selectedContract: null,
                period: 'CustomDates',
                from_date: null,
                to_date: null,
                is_show: false,
                pdfRoute: '{!!route('export.PDFAll') !!}',
                excelRoute: '{!! route('export.ExcelAll') !!}',
                selectedMember: null,
                filtercurrencies: filtercurrencies,
                selected_filter_currencies: null,
                currencies: currencies,
                selected_currency: null,
                code: code,
                memberlist: [],
                selected_bank:null,
                bank:[],
                classlist: [],
                selectedClass: null,
                financial_classes: {!!getFinancialClassList()!!},
                customReportData:
                [
                 {Name: '@lang("layout.Number")', column_name: 'number',checkedColumn:(cust_rep.number)?'checked':'',column_percentage:(cust_rep.number___percent)?cust_rep.number___percent:''},
                 {Name: '@lang("layout.ReferenceNumber")', column_name: 'reference_number',checkedColumn:(cust_rep.reference_number)?'checked':'',column_percentage:(cust_rep.reference_number___percent)?cust_rep.reference_number___percent:''},
                 {Name: '@lang("layout.Type")', column_name: 'type',checkedColumn:(cust_rep.type)?'checked':'',column_percentage:(cust_rep.type___percent)?cust_rep.type___percent:''},
                 {Name: '@lang("layout.Contract")', column_name: 'contract_id',checkedColumn:(cust_rep.contract_id)?'checked':'',column_percentage:(cust_rep.contract_id___percent)?cust_rep.contract_id___percent:''},
                 {Name: '@lang("layout.Description")', column_name: 'description',checkedColumn:(cust_rep.description)?'checked':'',column_percentage:(cust_rep.description___percent)?cust_rep.description___percent:''},
                 {Name: '@lang("layout.Date")', column_name: 'date',checkedColumn:(cust_rep.date)?'checked':'',column_percentage:(cust_rep.date___percent)?cust_rep.date___percent:''},
                 {Name: '@lang("layout.Hour")', column_name: 'hour',checkedColumn:(cust_rep.hour)?'checked':'',column_percentage:(cust_rep.hour___percent)?cust_rep.hour___percent:''},
                 {Name: '@lang("layout.OverdueDate")', column_name: 'overdue_date',checkedColumn:(cust_rep.overdue_date)?'checked':'',column_percentage:(cust_rep.overdue_date___percent)?cust_rep.overdue_date___percent:''},
                 {Name: '@lang("layout.Name")', column_name: 'name',checkedColumn:(cust_rep.name)?'checked':'',column_percentage:(cust_rep.name___percent)?cust_rep.name___percent:''},
                 {Name: '@lang("layout.Code")', column_name: 'code',checkedColumn:(cust_rep.code)?'checked':'',column_percentage:(cust_rep.code___percent)?cust_rep.code___percent:''},
                 {Name: '@lang("layout.MemberClass")', column_name: 'class',checkedColumn:(cust_rep.class)?'checked':'',column_percentage:(cust_rep.class___percent)?cust_rep.class___percent:''},
                 {Name: '@lang("layout.Amount")', column_name: 'amount',checkedColumn:(cust_rep.amount)?'checked':'',column_percentage:(cust_rep.amount___percent)?cust_rep.amount___percent:''},
                 {Name: '@lang("layout.Currency")', column_name: 'currency',checkedColumn:(cust_rep.currency)?'checked':'',column_percentage:(cust_rep.currency___percent)?cust_rep.currency___percent:''},
                 {Name: '@lang("layout.Rate")', column_name: 'rate',checkedColumn:(cust_rep.rate)?'checked':'',column_percentage:(cust_rep.rate___percent)?cust_rep.rate___percent:''},
                 {Name: '@lang("layout.ExchangedAmount")', column_name: 'exchanged_amount',checkedColumn:(cust_rep.exchanged_amount)?'checked':'',column_percentage:(cust_rep.exchanged_amount___percent)?cust_rep.exchanged_amount___percent:''},
                 {Name: '@lang("layout.Account")', column_name: 'account',checkedColumn:(cust_rep.account)?'checked':'',column_percentage:(cust_rep.account___percent)?cust_rep.account___percent:''},
                 {Name: '@lang("layout.Total")', column_name: 'total',checkedColumn:(cust_rep.total)?'checked':'',column_percentage:(cust_rep.total___percent)?cust_rep.total___percent:''},
                 {Name: '@lang("layout.User")', column_name: 'user',checkedColumn:(cust_rep.user)?'checked':'',column_percentage:(cust_rep.user___percent)?cust_rep.user___percent:''},
                 {Name: '@lang("layout.ExchangeAmount")', column_name: 'exchange_amount',checkedColumn:(cust_rep.exchange_amount)?'checked':'',column_percentage:(cust_rep.exchange_amount___percent)?cust_rep.exchange_amount___percent:''},
                 {Name: '@lang("layout.ExchangedCurrency")', column_name: 'exchanged_currency',checkedColumn:(cust_rep.exchanged_currency)?'checked':'',column_percentage:(cust_rep.exchanged_currency___percent)?cust_rep.exchanged_currency___percent:''},
                 {Name: '@lang("layout.ExchangedRate")', column_name: 'exchange_rate',checkedColumn:(cust_rep.exchange_rate)?'checked':'',column_percentage:(cust_rep.exchange_rate___percent)?cust_rep.exchange_rate___percent:''},
                ],
                cust_rep:cust_rep
            },
            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show
                },
                onClassSearch(search, loading) {
                    loading(true);
                    this.searchClass(search, loading, this);
                },
                  //ajax call to get class
                searchClass(search, loading, vm) {
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'anyTable',
                            keyword: search,
                            table_name: 'member_classes',
                        }
                    })
                    .then(function (response) {
                        this.classlist = [];
                        if (response.data.length > 0) {
                            vm.classlist = response.data;
                        }
                        loading(false);
                    })
                    .catch(function (error) {
                        console.log(error);
                    })
                },
                searchAccount(search, loading) {
                    loading(true);
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'anyTable',
                            keyword: search,
                            table_name: 'accounts',
                            filterColumn: 'type',
                            filterValue: 'bank',
                        }
                    })
                    .then(function (response) {
                        this.bank = [];
                        if (response.data.length > 0) {
                            vm.bank = response.data;
                        }
                        loading(false);
                    })
                    .catch(function (error) {
                        console.log(error);
                    })
                },
                onMemberSearch(search, loading) {
                    loading(true);
                    this.searchMember(search, loading, this);
                },
                //ajax call to get items
                searchMember(search, loading, vm) {
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'anyTable',
                            'search_column': 'name',
                            'table_name': 'members',
                            keyword: search,
                        }
                    })
                    .then(function (response) {
                        this.memberlist = [];
                        if (response.data.length > 0) {
                            vm.memberlist = response.data;
                            console.log('data', vm.memberlist);
                        }
                        loading(false);
                    })
                    .catch(function (error) {
                        console.log(error);
                    })
                },
                //ajax call to get dates
                getDates() {
                    setTimeout((function () {
                        vm.getDate(vm.period);
                        // console.log(12);
                    }), 2e2);
                },
                getDate(period) {
                    if (period) {
                        // console.log(3232, period);
                        if (period != 'CustomDates') {
                            axios.get("{{route('callMethod.search')}}", {
                                params: {
                                    method_name: 'getDatesByPeriod',
                                    period: period,
                                }
                            })
                            .then(function(response) {
                                vm.from_date = null;
                                vm.to_date = null;
                                if (response.data) {
                                    vm.from_date = response.data.start;
                                    vm.to_date = response.data.end;
                                    // console.log('data', response.data);
                                }
                            })
                            .catch(function(error) {
                                vm.period = 'CustomDates';
                                vm.from_date = null;
                                vm.to_date = null;
                            })
                        } else {
                            vm.from_date = null;
                            vm.to_date = null;
                        }
                    }
                },
            }
        });
        new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    console.log('trr')
                    vm.$data.is_show = true;
                }
            }
        });
        // /for new modal
    </script>
@endpush
