@extends('layouts.app')
<link href="{{URL::asset('assets/global/plugins/bootstrap-timepicker/css/bootstrap-timepicker.min.css')}}" rel="stylesheet" type="text/css" />
@section('content')
@include("layouts.Cmodal")
    <div class="row">
        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    @if($duplicate)
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.CreateNewPay')</span>
                    @else
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.EditPay')</span>
                    @endif
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools">
                </div>
            </div>
            <div class="portlet-body form" style="margin-bottom:50%;" id="app">
                <!-- BEGIN FORM-->
                @if($duplicate)
                {!! Form::model($payment, ['method' => 'post','class'=>'form-horizontal','route' => ['pay.storeNew',$payment->id]]) !!}
                @else 
                {!! Form::model($payment, ['method' => 'PATCH','class'=>'form-horizontal','route' => ['pay.update',$payment->id]]) !!}
                @endif
                <div class="form-body" v-cloak>
                    <div class="row" style="margin-bottom: 20px; padding: 10px;">
                        <div class="col-lg-9 col-md-9 col-sm-12 col-xs-12" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px; margin-bottom: 10px; padding: 15px 50px;">
                            <div class="row" style="padding: 0px 10px;">
                                <div v-show="showWhat('member_class')=='yes'" class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="">
                                        <label class="control-label">@lang('layout.MemberClass') </label>
                                        <v-select label="name" :options="memberClass" v-model="selected_class" @input="memberClassChange()"></v-select>
                                        <input type="hidden" name="class_id" :value="!selected_class?null:selected_class.id">
                                    </div> 
                                </div>
                                <div class="col-lg-5">
                                    <div class="form-group">
                                        <label class="control-label">@lang('layout.SelectMember')</label>
                                        <div class="input-group">
                                            <v-select @input="getSummary" class="vue-select2" v-model="selectedMember"
                                                @search="MemberSearch" label="name" :options="member">
                                            </v-select>
                                            <input type="hidden" name="member_id" v-model="(!selectedMember)?null:selectedMember.id" v-validate="'required'" data-vv-as="@lang('layout.Member')">
                                            <span class="btn btn-success input-group-addon " title="@lang('button.AddNewCustomer')" @click="showModal = true" style="background-color:  rgb(84, 199, 211)">
                                                <i class="fa fa-plus" style="color: white"></i>
                                            </span>
                                            <span class="required">@{{errors.first('member_id')}}</span>
                                        </div>
                                    </div>
                                </div>
                                @if($duplicate)
                                <div class="col-lg-3">
                                    <label class="control-label">@lang('layout.Number')</label>
                                    <input type="number" name="number" class="form-control" value="{{$numberDuplicate}}">
                                </div>
                                @else
                                <div class="col-lg-3">
                                    <label class="control-label">@lang('layout.Number')</label>
                                    <input type="number" name="number" class="form-control" value="{{$payment->payment_number}}">
                                </div>
                                @endif
                            </div>
                            <div class="row" style="padding: 0px 10px;">
                                <div class="col-lg-4">
                                    <label class="control-label">@lang('layout.ReferenceNumber')</label>
                                    <input type="text" name="ref_no" class="form-control" @input="checkRefNo()" v-model='ref_no'>
                                    <span v-if="isError ==true" class="input-has-error" style="color: red">@{{msg}}</span>
                                </div>
                                <div class="col-lg-4">
                                    <label class="control-label">@lang('layout.Type')</label>
                                    <select class="form-control" name="type" v-model="selectedType">
                                        <option value="invoice">@lang('layout.Invoice')</option>
                                        <option value="bill">@lang('layout.Bill')</option>
                                        <option value="salary">@lang('layout.Salary')</option>
                                        <option value="loan">@lang('layout.Loan')</option>
                                        <option value="prepaid">@lang('layout.Prepaid')</option>
                                        <option value="bankCheck">@lang('layout.BankCheck')</option>
                                        <option value="branchTransfer">@lang('layout.BranchTransfer')</option>
                                        <option value="BillPayment">@lang('layout.BillPayment')</option>
                                        <option value="ExpensePayment">@lang('type.ExpensePayment')</option>
                                        <option value="CarpetContract">@lang('type.CarpetContract')</option>
                                        @if(systemConfig()[20] == 1)
                                            <option value="contract">@lang('type.Contract')</option>
                                        @endif
                                    </select>
                                </div>
                                @if(systemConfig()[16] != 0)
                                    <div v-if="farmer_contract_list.length > 0" class="col-lg-4">
                                        <label class="control-label">@lang('layout.FarmerContract')</label>
                                        <v-select class="vue-select2" label="name" :options="farmer_contract_list" v-model="selectedFarmerContract">
                                        </v-select>
                                        <input type="hidden" name="contract_farmer_id" v-model.number="(!selectedFarmerContract)?null:selectedFarmerContract.id">
                                    </div>
                                @endif 
                                @if(systemConfig()[21] != 0)
                                    <div v-if="carpet_contract_list.length > 0" class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                        <label class="control-label">@lang('layout.CarpetContract')</label>
                                        <v-select class="vue-select2" label="name" :options="carpet_contract_list" v-model="selectedCarpetContract">
                                        </v-select>
                                        <input type="hidden" name="carpet_contract_id" v-model.number="(!selectedCarpetContract)?null:selectedCarpetContract.id">
                                    </div>
                                @endif 
                                <div class="col-lg-12" style="padding: 0px !important;">
                                    <div :class="currency_len">
                                        <label class="control-label">@lang('layout.PaymentCurrency')</label>
                                        <select class="form-control" v-model="selectedCurrency"
                                                v-on:change="setSize(selectedCurrency.code), get_exchange()" :readonly="(old_payment_type=='bank_check' && payment_type=='')">
                                            <option v-for="curre in currency" :value="curre">@{{ curre.code }}</option>
                                        </select>
                                        <input type="hidden" name="currency" v-bind:value="selectedCurrency.code"/>
                                    </div>
                                    <div :class="rate_len" v-if="selectedCurrency.code != '{{getHomeCurrency()["code"]}}'">
                                        <label class="control-label">@lang('layout.Rate') </label>
                                        <div :class="{'has-error':selectedCurrency.rate < 0}">
                                            <div class="input-group">
                                                <input v-model="selected_rate" class="form-control"
                                                       type="number" step="any" min="0" :readonly="averageRate"
                                                       @keyup="check_code(paymentCurrency.code), get_exchange()" @click="check_code(paymentCurrency.code), get_exchange()">
                                                <span class="input-group-addon">@{{selectedCurrency.symbol}}</span>
                                            </div>
                                            <input type="hidden" name="currency_rate" :value="selected_rate">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-8" style="padding: 0px !important;">
                                    <div :class="pcurrency_len">
                                        <label class="control-label">@lang('layout.Currency')</label>
                                        <select class="form-control" v-model="paymentCurrency"
                                                v-on:change="setPaymentSize(paymentCurrency.code), get_exchange()" :readonly="(old_payment_type=='bank_check' && payment_type=='')">
                                            <option v-for="curre in currency1" :value="curre">@{{ curre.code }}</option>
                                        </select>
                                        <input type="hidden" name="paymentCurrency"
                                               v-bind:value="paymentCurrency.code"/>
                                    </div>
                                    <div :class="prate_len" v-if="paymentCurrency.code != '{{getHomeCurrency()["code"]}}'">
                                        <label class="control-label">@lang('layout.Rate') </label>
                                        <div :class="{'has-error':paymentCurrency.exchange_rate < 0}">
                                            <div class="input-group">
                                                <input v-model="selected_rate1" class="form-control"
                                                       type="number" min="0" step="any"  @input="get_exchange()" 
                                                       :readonly="selectedCurrency.code==paymentCurrency.code">
                                                <span class="input-group-addon">@{{paymentCurrency.symbol}}</span>
                                            </div>
                                            <input type="hidden" name="rate" :value="selected_rate1">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-4">
                                    <label class="control-label">@lang('layout.Amount')</label>
                                    <div class="input-group">
                                        <vue-numeric
                                            :readonly="(old_payment_type=='bank_check' && payment_type=='')"
                                            class="form-control"
                                            v-model="amount"
                                            :max="99999999999999"
                                            :currency="selectedCurrency.code"
                                            :precision="precision()"
                                            @input="get_exchange()"
                                            >
                                        </vue-numeric>
                                        <input type="hidden" name="amount" v-model="amount" step="any" min="0" v-validate="'required'" data-vv-as="@lang('layout.Amount')" class="form-control">
                                        <span class="input-group-addon">@{{selectedCurrency.symbol}}</span>
                                    </div>
                                    <span class="required">@{{errors.first('amount')}}</span>
                                </div>
                                <div class="col-lg-4">
                                    <label class="control-label">@lang('layout.Account')</label>
                                    <div class="input-group">
                                        <select class="form-control" name="account_id" v-model="defaultAccount" v-on:change="test(defaultAccount)">
                                            <option v-for="Account in accountUpdate" :value="Account.id">@{{ Account.name }}
                                            </option>
                                        </select>
                                        <span v-if="selectedBank" class="input-group-addon" :style="(((selectedBank)? Number(selectedBank.balance)-(Number(amount)-Number(defaultAmount))-Number(first_discount)+Number(discount):0 ) < 0)?'background-color: #ff0000; color: #ffffff;':''" >@{{ (selectedBank)?format_number( Number(selectedBank.balance)-(Number(amount)-Number(defaultAmount))-Number(first_discount)+Number(discount)):0 }}</span>
                                    </div>
                                </div>
                                <div class="col-lg-4">
                                    <label class="control-label">@lang('layout.ExchangedAmount')</label>
                                    <div class="input-group">
                                        <vue-numeric
                                            class="form-control"
                                            v-model="exchange_amount"
                                            :max="99999999999999"
                                            currency=""
                                            :precision="precision()"
                                            @input="set_rate()"
                                            >
                                        </vue-numeric>
										<input type="hidden" :value="((amount-discount)*selected_rate1/(selected_rate)).toFixed(4)" >
											
                                        <span class="input-group-addon">@{{paymentCurrency.symbol}}</span>

                                    </div>

                                </div>
                                <div class="col-lg-4">
                                    <label class="control-label">@lang('layout.Discount')</label>
                                    <input type="number" name="discount" v-model="discount" step="any" min="0" class="form-control">
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <label class="control-label">@lang('layout.Date') </label>
                                    <div>
                                        <input class="form-control date" id="range-from-example" name="date" autocomplete="off" value="{{$payment->Date}}"
                                        @if(getDateRequired() == 'true') v-validate='"required"' data-vv-as="@lang('layout.Date')" @endif>
                                        <span class="required">@{{ errors.first('date') }}</span>
                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.OverdueDate')</label>
                                            {{Form::text('overdue_date',$payment->overdue_date,['class' => 'form-control date','id'=>'date','autocomplete'=>'off'])}}
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Hour')</label>
                                            <div class="input-group">
                                                @if(getHourType() == 24)
                                                <input type="text" class="form-control timepicker timepicker-24" name="hour" value="{{$payment->hour}}">
                                                @else
                                                <input type="text" class="form-control timepicker timepicker-no-seconds" name="hour" value="{{$payment->hour}}" >
                                                @endif
                                                <span class="input-group-btn">
                                                    <button class="btn default" type="button">
                                                        <i class="fa fa-clock-o"></i>
                                                    </button>
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row" style="padding: 0px 10px;">
                                <div class="col-lg-4">
                                    <label class="control-label">@lang('layout.PaymentType')</label>
                                    <select class="form-control" name="payment_type" v-model="payment_type">
                                        <option value="">@lang('layout.SelectType')</option>
                                        <option value="bank_check">@lang('layout.BankCheck')</option>
                                    </select>
                                </div>
                                <div class="col-lg-4" v-show="payment_type !=''">
                                    <label class="control-label">@lang('layout.CheckNumber')</label>
                                    <input type="text" name="check_number" value="{{$payment->check_number}}" class="form-control" placeholder="00020">
                                </div>
                                <div class="col-lg-4" v-show="payment_type !=''">
                                    <label class="control-label">@lang('layout.CheckDate')</label>
                                    <input type="text" name="check_date" value="{{$payment->check_date}}" class="form-control date" autocomplete="off"  placeholder="@lang('layout.CheckDate')">
                                </div>
                                <?php
                                    $r_description = $payment->description;
                                    $d_discription = '(مبلغ ' . $payment->discount . 'تخفیف)';
                                    // dd($r_description);
                                    // dd(strlen($d_discription));
                                    //dd(substr($r_description,0, -strlen($d_discription)));
                                    // dd(substr($r_description, strpos($r_description,$d_discription )));
                                    if (substr($r_description, strpos($r_description, $d_discription)) == $d_discription) {
                                        $description = (substr($r_description, 0, -strlen($d_discription)));
                                    } else {
                                        $description = $r_description;
                                    }
                                ?>
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <label class="control-label">@lang('layout.Contract')</label>
                                    <v-select class="vue-select2" placeholder="@lang('layout.Select')" v-model="selectedContract" label="company_name" :options="{{$contract}}">
                                    </v-select>
                                    <input type="hidden" name="contract_id" v-model.number="(!selectedContract)?null:selectedContract.id" />
                                </div>
                                <div class="col-lg-8 col-md-8 col-sm-12 col-xs-12">
                                    <label class="control-label">@lang('layout.Description')</label>
                                    {{Form::textarea('description',$description,['class'=>'form-control','rows'=>'1'])}}
                                </div>
                            </div>
                            @if(getcommission() =="true")
                            <div class="row" style="padding: 0px 10px;">
                                <div class="col-md-4">
                                    <label class="control-label">@lang('layout.Expense') </label>
                                    <v-select label="name" :options="expense" v-model="selectedExpense" ></v-select>
                                    <input type="hidden" name="expense_id" v-bind:value="(!selectedExpense)?null:selectedExpense.id" />
                                </div> 
                                <div class="col-md-4">
                                    <label class="control-label">@lang('layout.Commission')</label>
                                    {{Form::number('commission_amount',$payment->commAmount,['class' => 'form-control',"placeholder"=>__('layout.Amount')])}}
                                </div>
                                <div class="col-md-4">
                                    <label class="control-label">@lang('layout.Description')</label>
                                    {{Form::textarea('commission_description',$payment->comm_description,['class'=>'form-control','rows'=>'1'])}}
                                </div>
                            </div>
                            @endif
                            @if(isGroupCompany())
                            <div class="row" style="padding: 0px 10px;">
                                <div v-if="selectedType=='branchTransfer'" class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Company')</label>
                                            <v-select label="name"  :options="company" v-model="selected_company" placeholder="@lang('layout.Company')" :select-on-tab="true"></v-select>
                                            <input type="hidden" name="to_company_id" :value="(!selected_company)?null:selected_company.id">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            @endif
                            <div class="row" style="padding: 0px 10px;">
                                <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Memo')</label>
                                            <textarea name="memo" class="form-control" rows="2">{{$payment->memo}}</textarea>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                            <div class="col-lg-12 col-md-12 col-sm-12" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px;margin-bottom: 1em; padding-top: 20px;">
                                <div class="panel panel-default">
                                    <div class="panel-body" style="margin-top: 20px;background: transparent;">
                                        <table class="table table-bordered">
                                            <thead>
                                                <tr>
                                                    <th>@lang('layout.Currency') </th>
                                                    <th>@lang('layout.Payable')</th>
                                                    <th>@lang('layout.Receivable')</th>
                                                    <th>@lang('layout.AverageRate')</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <span v-if="selectedMember">
                                                    <tr v-for="summ in summary">
                                                        <td class="highlight text-center">
                                                            @{{ summ.currency }}
                                                        </td>
                                                        <td class="text-center"> 
                                                            @{{ format_number(Number(summ.payment)) }}
                                                        </td>
                                                        <td class="text-center">
                                                            @{{ format_number(Number(summ.invoice)) }}
                                                        </td>
                                                        <td class="text-center">
                                                            @{{format_number(Number(summ.rate))}}
                                                        </td>
                                                    </tr>
                                                </span>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-12">
                    <div class="row">
                        <div class="col-lg-12 col-xs-12 col-sm-12 col-md-12 text-center">
                            <button v-if="isError ==false" type="button" class="btn green"
                                    @click="handleSubmit($event)">@lang('layout.Submit')</button>
                            <a href="{{route('pay.index')}}" class="btn default"><i
                                        class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                        </div>
                        <cmodal :show='showModal' @close="showModal=false">

                        </cmodal>
                    </div>
                </div>
                {!! Form::close() !!}
            </div>
            <!-- END FORM-->
        </div>
    </div>
@endsection
@push('scripts')
<script src="{{URL::asset('assets/global/plugins/bootstrap-timepicker/js/bootstrap-timepicker.min.js')}}" type="text/javascript"></script>
<script src="{{URL::asset('assets/pages/scripts/components-date-time-pickers.min.js')}}" type="text/javascript"></script>
    <script>
        @if(App::getLocale())
        Vue.use(VeeValidate, {
            locale: '{{App::getLocale()}}',
        });
        @else
        Vue.use(VeeValidate, {
            locale: 'en',
        });
        @endif

        Vue.component('v-select', VueSelect.VueSelect);
        Vue.use(VueNumeric.default);
        //begin new member
        Vue.component("cmodal", {
            template: '#cmodal-template',

            props: ['show'],
            data() {
                return {
                    types: [],
                    classes: [],
                    receivables: [],
                    payables: [],
                    code: null,
                    selectType: null,
                    selectPay: null,
                    selectedClass: null,
                    selectReceive: null,
                }
            },
            mounted() {
                setTimeout(() => {
                    this.getMemberCode();
                }, 500);
            },
            methods: {
                onSubmit() {
                    vu.showModal = false;
                    var datas = $("#modalForm").serializeArray();
                    let vmc = this;
                    $.ajax({
                        headers: {
                            'X-CSRF-TOKEN': "{{csrf_token()}}"
                        },
                        url: '{{route("customer.store")}}',
                        method: 'post',
                        data: {
                            "name": datas[0]['value'],
                            "code": datas[1]['value'],
                            'email': datas[2]['value'],
                            'phone': datas[3]['value'],
                            'address1': datas[4]['value'],
                            'type': this.selectType.id,
                            'receivable': this.selectReceive.id,
                            'payable': this.selectPay.id,
                            'class': (this.selectedClass) ? this.selectedClass.id : null
                        },
                        dataType: 'json',

                    }).done(function(response) {
                        if (response) {
                            vu.selectedMember = response.customer;
                            vmc.getMemberCode();
                        }

                    }).fail(function(error) {
                        console.log('error', error);
                    });
                },
                getMemberCode() {
                    let vmc = this;
                    axios.get('{{route("customer.create")}}').then(
                    response => {
                        vmc.types = response.data.types;
                        if (vmc.types) {
                            for (var i = 0; i < vmc.types.length; i++) {
                                if (vmc.types[i].type == "Vendor") {
                                    vmc.selectType = vmc.types[i];
                                }
                            }
                        }
                        vmc.receivables = response.data.receivable;
                        vmc.payables = response.data.payable;
                        vmc.code = response.data.code;
                        vmc.classes = response.data.member_class;
                        if(vmc.receivables.length>0)
                        {
                            vmc.selectReceive=vmc.receivables[0];
                        }
                        if(vmc.payables.length>0)
                        {
                            vmc.selectPay=vmc.payables[0];
                        }

                    }).catch(error => console.log(error));
                }
            }
        });
        
        var Banks ={!! $banks!!}
        var Currency ={!! $currency!!}
        var Currency1 ={!! $currency!!}
        var one ={!! json_encode(Currency()->getCurrency()) !!}
        var two ={!! json_encode(Currency()->getCurrency()) !!}
        var code = "{!! getHomeCurrency()["code"] !!}";
        var memberClass = {!! $memberClass !!};
        var expense = {!! $expense !!};
        var contract_farmer_id = {!!$payment->contract_farmer_id!!};
        var company = {!! $company !!};
        var payment = {!! $payment !!}

        let vu = new Vue({
            el: '#app',
            data: {
                showModal: false,
                selectedContract: null,
                selectedCurrency: one,
                selectedCurrencyTemp: null,
                paymentCurrency: two,
                summary: [],
                member: [],
                selectedCurrency2: null,
                currency:{!! json_encode(getCurrencies()) !!},
                currency1:{!! json_encode(getCurrencies()) !!},
                bankes: {!! $banks !!},
                selectedBank: null,
                expense: expense,
                selectedExpense: null,
                averageRate: false,
                defaultValue: 0,
                defaultAmount:{!! $payment->amount!!},
                defaultAccount: 0,
                selected_rate:{!!$payment->brate!!},
                selected_rate1:{!!$payment->exchange_rate!!},
                listAccounts: [],
                selectedMember:{!!$selectedMember!!},
                newAmount: null,
                exchange_amount: null,
                amount:{!!$payment->amount!!},
                discount:{!!$payment->discount!!},
                first_discount:{!!$payment->discount!!},
                defaultAccountId: "{{ $payment->paid_account_id }}",
                recordRate: "{{ $payment->rate }}",
                currencyList: Currency,
                type: 'bank',
                company:company,
                selected_company:null,
                account: {},
                currency_len: 'col-md-12',
                rate_len: 'col-md-0',
                pcurrency_len: 'col-md-12',
                selectedType: "{!! $payment->type !!}",
                prate_len: 'col-md-0',
                code: code,
                first_currency: 0,
                second_currency: 0,
                // selectedType: "{!!$payment->type!!}",
                firstAccount: "{{ $payment->paid_account_id }}",
                allBankAccounts: null,
                defautlgetAmount: {!! $payment->amount * $payment->brate !!},
                ref_no: "@if($duplicate) {{$refNum}} @else {{$payment->ref_Number}} @endif",
                msg: '',
                isError: false,
                payment_type: "{{$payment->payment_type}}",
                payment:{!! $payment !!},
                old_payment_type:"{{$payment->payment_type}}",
                memberClass: memberClass,
                selected_class: null,
                farmer_contract_list:[],
                selectedFarmerContract:null,
                contract_farmer_id: contract_farmer_id,
                carpet_contract_list:[],
                selectedCarpetContract:null

            },
            computed: {
                accountUpdate() {
                    var b = _.clone(Banks)
                    var test = this.accounts = b.filter((account) => {
                        return (new RegExp(this.selectedCurrency.code.toLowerCase())).test(account.code.toLowerCase())
                    })
                    if (test.length > 0) {
                        this.defaultValue = test[0].id;
                    
                        for (var x in this.bankes) {
                            for (z in this.bankes[x]) {
                                if (this.firstAccount != -1) {
                                    if (this.bankes[x][z] == this.firstAccount && z == 'id') {
                                        this.selectedBank = this.bankes[x];
                                        this.defaultAccount = this.firstAccount;
                                        this.firstAccount = -1;
                                        break;
                                    }
                                }
                                else if (this.bankes[x][z] == this.defaultValue && z == 'id') {
                                    this.selectedBank = this.bankes[x];
                                    this.defaultAccount = this.defaultValue;
                                    break;
                                }
                            }
                        }
                    }else{
                        // this.selectedBank = null;
                    }
                    return test;
                },
            },
            created() {

                if(this.payment)
                {

                    // this.selectedMember=_.find(this.member,(v)=>v.id==this.payment.member_id);
                    this.selected_class = _.find(this.memberClass, (c) => c.id == this.payment.class_id);
                }
                if(this.payment.to_company_id)
                {
                    this.selected_company = _.find(this.company, (c) => c.id == this.payment.to_company_id);
                }
                if(this.payment.expense_id)
                {
                    this.selectedExpense = _.find(this.expense, (c) => c.id == this.payment.expense_id);
                }
                var b = _.clone(Banks);
                for (var m of b) {
                    if (m.id == this.defaultAccountId) {

                        this.defaultAccount = m;

                    }
                }

                this.checkSelected();
				
				if(this.selected_rate > 0){
                    @if(systemConfig()[30] == 1)
                        this.exchange_amount = myRound(((this.amount / this.selectedCurrency.static_rate * this.selected_rate) * this.paymentCurrency.static_rate) / this.selected_rate1);
                    @else 
						this.exchange_amount = myRound((this.amount* this.selected_rate1)/this.selected_rate);
                    @endif
					}
            },
            mounted:function(){
            // initialize the selected item
            if(payment.contract_id !='' && payment.contract_id !=null) {
                this.selectedContract = _.find({!! $contract !!}, (a) => a.id == this.payment.contract_id);
            }
        },
            methods: {
                      //  Contract Wagon Started ...........................................................

            // contractWagon() {
            //     this.wagon = this.wagonAll;
            //     if (this.selectedContract) {
            //         // contract_id = this.inventories[index]['contract'].id;s
            //         this.wagon = this.wagonAll.filter((wagon) => {
            //             return this.selectedContract.id == wagon.contract_id;
            //         });

            //     }
            //     },

      // Contract Wagon Finished .................................................................
                
                memberClassChange() {
                        if (vu.selected_class) {
                            vu.member = [];
                            // vu.selectedMember = null;
                            let class_id = vu.selected_class.id;
                        
                            axios.get("{{route('callMethod.search')}}", {
                                params: {
                                    method_name: 'SearchMember',
                                    class_id: class_id
                                }
                            })
                            .then(function(response) {
                                if (response.data.length > 0) {
                                    // console.log(response.data);
                                    vu.member = [];
                                    vu.member = response.data;
                                }
                            })
                            .catch(function(error) {
                                console.log(error);
                            })
                        }
                    },
                    MemberSearch: _.debounce((search, loading) => {
                        loading(true);
                        let class_id = (vu.selected_class != undefined) ? vu.selected_class.id : null;
                        
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'SearchMember', 
                                keyword: search,
                                class_id: class_id
                            }
                        })
                        .then(function(response) {
                            if (response.data.length > 0) {
                                // console.log(response.data);
                                vu.member = [];
                                vu.member = response.data;
                            }
                            loading(false);
                        })
                        .catch(function(error) {
                            loading(false);
                            console.log(error);
                        })
                    }, getDebounceTime()),

                checkRefNo() {

                    //console.log(vu.ref_no)

                    var chack = 'false';
                    var ref_no = vu.ref_no;
                    if (ref_no != null) {


                        axios.get("{{route('callMethod.search')}}",
                            {

                                params: {
                                    ref_no: vu.ref_no,
                                    method_name: 'Search_ref_no',
                                    table_name: 'payments'
                                },
                            })
                            .then(function (response) {
                                // console.log(response.data.result);
                                if (response.data.result != null) {
                                    console.log(response.data.result);
                                    // v.temp_items=response.data;
                                    vu.msg = "@lang('layout.DuplicateData')";
                                    vu.isError = true;
                                }
                                else {
                                    vu.msg = 'no';
                                    vu.isError = false;

                                }


                            })
                            .catch(function (error) {
                                console.log(error);
                            });

                    }

                },
                handleSubmit(e) {
                    this.$validator.validate().then(valid => {
                        if (valid) {
                            // console.log(e);
                            // alert(e.target);
                            regForm(e.target);
                        }
                    });
                },
                getSummary() {
                    if (this.selectedMember) {
                        this.farmer_contract_list = [];
                        this.selectedFarmerContract = null;
                        this.getSummaryRecor(this.selectedMember.id, this);
                        this.take_farmer_contract_data(this);
                        this.take_carpet_contract_data(this);

                    }

                },
				get_exchange() {
                    let vu = this;
					if(vu.selected_rate > 0){ 
                        @if(systemConfig()[30] == 1)
                        if (vu.paymentCurrency && vu.selectedCurrency) { 
                            vu.exchange_amount = myRound(((vu.amount / vu.selectedCurrency.static_rate * vu.selected_rate) * vu.paymentCurrency.static_rate) / vu.selected_rate1);
                        }
                        @else 
                            vu.exchange_amount = myRound((vu.amount * vu.selected_rate1) / vu.selected_rate);
                        @endif 
                    }
				},
				set_rate() {
                    let vu = this;
					if(vu.exchange_amount > 0){
                        @if(systemConfig()[30] == 1)
                        vu.selected_rate1 = Number.parseFloat(((vu.amount / vu.selectedCurrency.static_rate * vu.selected_rate) / vu.exchange_amount) * vu.paymentCurrency.static_rate).toFixed(7);
                        @else 
						vu.selected_rate1 = Number.parseFloat((vu.exchange_amount)/ (vu.amount / vu.selected_rate)).toFixed(10);
                        @endif					
                    }
				},
                getSummaryRecor(id, vm) {
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'memberStatment',
                            member_id: id,
                        }
                    })
                        .then(function (response) {

                            if (response.data.length > 0) {
                                vm.summary = response.data;
                            }
                            else{
                                    vm.summary=[];
                                }
                        })
                        .catch(function (error) {
                            console.log(error);
                        });
                },
                take_farmer_contract_data(vm) {

                    axios.get("{{route('member.farmerContract')}}", {
                        params: {
                            member_id: this.selectedMember.id
                        },
                    }).then(function (response) {
                        vm.farmer_contract_list = response.data;

                        for (var j = 0; j < vm.farmer_contract_list.length; j++) {
                            if (vm.contract_farmer_id != null && vm.farmer_contract_list[j].id == vm.contract_farmer_id) {
                                vm.selectedFarmerContract = vm.farmer_contract_list[j];
                            }
                        }

                    })
                        .catch(function (error) {
                            console.log(error);
                        });
                }, 
                take_carpet_contract_data(vm) {
                    vm.carpet_contract_list = [];
                    vm.selectedCarpetContract = null;

                    axios.get("{{route('carpetContract.member')}}", {
                        params: {
                            member_id: vm.selectedMember.id
                        },
                    }).then(function (response) {
                        vm.carpet_contract_list = response.data;
                        for (var j = 0; j < vm.carpet_contract_list.length; j++) {
                            if (vm.payment.carpet_contract_id != null && vm.carpet_contract_list[j].id == vm.payment.carpet_contract_id) {
                                vm.selectedCarpetContract = vm.carpet_contract_list[j];
                            }
                        }
                    })
                    .catch(function (error) {
                        console.log(error);
                    });
                }, 

                check_code(code) {
                    if (this.paymentCurrency.code == this.selectedCurrency.code) {
                        this.selected_rate1 = this.selected_rate;
                    }

                },
                checkSelected() {
                    var allCarrencies = {!! json_encode(getCurrencies()) !!};
                    for (var x in allCarrencies) {
                        for (z in allCarrencies[x]) {
                            if (allCarrencies[x][z] == "{!! $payment->bcurrency !!}") {
                                if (allCarrencies[x][z] != "{!!getHomeCurrency()["code"]!!}") {
                                    this.currency_len = 'col-md-6';
                                    this.rate_len = 'col-md-6';
                                }
                                this.selectedCurrency = allCarrencies[x];
                            }

                            if (allCarrencies[x][z] == "{!! $payment->currency !!}") {
                                if (allCarrencies[x][z] != "{!!getHomeCurrency()["code"]!!}") {
                                    this.pcurrency_len = 'col-md-6';
                                    this.prate_len = 'col-md-6';
                                }
                                this.paymentCurrency = allCarrencies[x];

                            }


                        }

                    }

                },
                setSize(selected_code) {
                    this.averageRate = false;
                    this.paymentCurrency = this.selectedCurrency;
                    this.selected_rate = this.selectedCurrency.exchange_rate;
                    this.selected_rate1 = this.selectedCurrency.exchange_rate;
                    if (selected_code == this.code) {
                        this.currency_len = 'col-md-12';
                        this.rate_len = 'col-md-0';
                        this.selected_rate = this.selectedCurrency.exchange_rate;
                    }
                    else {
                        this.currency_len = 'col-md-6';
                        this.rate_len = 'col-md-6';
                    }
                    this.pcurrency_len = this.currency_len;
                    this.prate_len = this.rate_len;

                    @if(getAverageRate() =="true")
                    setTimeout(() => {
                        if (this.selectedBank.avg_rate) {
                            this.averageRate = true;
                            this.selected_rate = this.selectedBank.avg_rate;
                            this.selected_rate1 = this.selectedBank.avg_rate;
                        }
                    }, 200);
                    @endif
                },
                setPaymentSize(selected_code) {
                    this.averageRate = false;
                    // this.selected_rate = this.paymentCurrency.exchange_rate;
                    this.selected_rate1 = this.paymentCurrency.exchange_rate;

                    if (selected_code == this.code) {
                        this.pcurrency_len = 'col-md-12';
                        this.prate_len = 'col-md-0';
                    }
                    else {
                        this.pcurrency_len = 'col-md-6';
                        this.prate_len = 'col-md-6';
                    }
                    @if(getAverageRate() =="true")
                    if (this.selectedBank.avg_rate) {
                        this.averageRate = true;
                        this.selected_rate = this.selectedBank.avg_rate;
                        if (this.paymentCurrency.code == this.selectedCurrency.code) {
                            this.selected_rate1 = this.selectedBank.avg_rate;
                        }
                    }
                    @endif
                },
                test(defaultAccount) {
                    this.averageRate = false;
                    for (var x in this.bankes) {
                        for (z in this.bankes[x]) {
                            if (this.bankes[x][z] == defaultAccount && z == 'id') {
                                this.selectedBank = this.bankes[x];
                                @if(getAverageRate() =="true")
                                if (this.bankes[x].avg_rate) {
                                    this.selected_rate = this.bankes[x].avg_rate;
                                    this.averageRate = true;
                                    if (this.paymentCurrency.code == this.selectedCurrency.code) {
                                        this.selected_rate1 = this.bankes[x].avg_rate;
                                    }
                                }
                                @endif
                                break;
                            }
                        }
                    }
                },
                amounts() {

                    this.amount = this.amount - this.discount;

                },
            }

        });

        // vu.setData();
    </script>


@endpush
   