{{-- @extends('layouts.app')
@section('style')

    <link rel="stylesheet" href="{{url('/select2/css/select2-bootstrap.min.css')}}">
    <link rel="stylesheet" href="{{url('/select2/css/select2.min.css')}}">
@stop
@section('content')
    <div class="row">

        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.CreateNewPay') </span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools">

                </div>
            </div>
            <div class="portlet-body form" style="margin-bottom:50%;" id="app" v-cloak>
                <!-- BEGIN FORM-->
                {{Form::open(['route' => 'pay.store','method' => 'POST','class' => 'form-horizontal','id'=>'pay-submit'])}}
                <div class="form-body">
                    <div class="row">
                        <div class="col-md-8">

                          <div class="row">
                                      <div v-show="showWhat('member_class')=='yes'"
                                     class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                            <label class="control-label">@lang('layout.MemberClass') </label>

                                            <v-select label="name" :options="memberClass"
                                                      v-model="selected_class"
                                                      @input="memberClassChange()"></v-select>
                                            <input type="hidden" name="class_id"
                                                   :value="!selected_class?null:selected_class.id">
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-4">
                                    <label class="control-label">@lang('layout.SelectMember')</label>
                                    <v-select @input="getSummary" class="vue-select2" v-model="selectedMember"
                                              label="name"
                                              :options="member">
                                    </v-select>

                                    <input type="hidden" name="member_id"
                                           v-model.number="(!selectedMember)?null:selectedMember.id"
                                           v-validate="'required'" data-vv-as="@lang('layout.Member')">
                                    <span class="required">@{{errors.first('member_id')}}</span>
                                </div>
                                <div class="col-md-2">
                                    <label class="control-label">@lang('layout.Number')</label>
                                    <input type="number" name="number" class="form-control" v-model="number" @input="checkNo()"
                                           v-validate="'required'" data-vv-as="@lang('layout.Number')">
                                    <span class="required">@{{errors.first('number')}}</span>
                                    <span v-if="number_Error ==true" class="input-has-error" style="color: red">@{{number_msg}}</span>
                                </div>
 
                                <div class="col-md-3">
                                    <label class="control-label">@lang('layout.ReferenceNumber')</label>
                                    <input type="text" name="ref_no" class="form-control" @input="checkRefNo()"
                                           v-model='ref_no'>
                                    <span v-if="isError ==true" class="input-has-error"
                                          style="color: red">@{{msg}}</span>
                                </div>
                                <div class="col-md-3">
                                    <label class="control-label">@lang('layout.Type')</label>
                                    <select class="form-control" name="type">
                                        <option disabled>@lang('layout.SelectType')</option>
                                        <option value="bill">@lang('layout.Bill')</option>
                                        <option value="invoice">@lang('layout.Invoice')</option>
                                        <option value="salary">@lang('layout.Salary')</option>
                                        <option value="loan">@lang('layout.Loan')</option>
                                        <option value="prepaid">@lang('layout.Prepaid')</option>
                                        <option value="bankCheck">@lang('layout.BankCheck')</option>
                                    </select>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6" style="padding: 0px;">
                                    <div :class="currency_len">
                                        <label class="control-label">@lang('layout.PaymentCurrency')</label>
                                        <select class="form-control" v-model="selectedCurrency"
                                                v-on:change="setSize(selectedCurrency.code), get_exchange()">
                                            <option v-for="curre in currency" :value="curre">@{{ curre.code }}</option>
                                        </select>
                                        <input type="hidden" name="currency" v-bind:value="selectedCurrency.code"/>
                                    </div>
                                    <div :class="rate_len" v-if="selectedCurrency.code != code">
                                        <label class="control-label">@lang('layout.Rate') </label>
                                        <div :class="{'has-error':selectedCurrency.rate < 0}">
                                            <div class="input-group">
                                                <input v-model="selected_rate" class="form-control"
                                                       type="number" step="any" min="0"
                                                       @keyup="check_code(paymentCurrency.code), get_exchange()">
                                                <span class="input-group-addon">@{{selectedCurrency.symbol}}</span>
                                            </div>
                                            <input type="hidden" name="currency_rate" :value="selected_rate">
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <label class="control-label">@lang('layout.Account')</label>
                                    <div class="input-group">
                                        <select class="form-control" name="account_id" v-model="defaultAccount"
                                                v-on:change="test(defaultAccount)">
                                            <option v-for="Account in accountUpdate" :value="Account.id">@{{
                                                Account.name }}
                                            </option>
                                        </select>
                                        <!--  <span class="input-group-addon">@{{ Number(selectedBank.balance)-(Number(amount)-Number(defaultAmount)) }}</span> -->

                                        <span class="input-group-addon">@{{ format_number( Number(selectedBank.balance)-(Number(amount)-Number(defaultAmount))+Number(discount)) }}</span>

                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6" style="padding: 0px;">
                                    <div :class="pcurrency_len">
                                        <label class="control-label">@lang('layout.Currency')</label>
                                        <select class="form-control" v-model="paymentCurrency" 
                                                v-on:change="setPaymentSize(paymentCurrency.code), get_exchange()">
                                            <option v-for="curre in currency1" :value="curre">@{{ curre.code }}</option>
                                        </select>
                                        <input type="hidden" name="paymentCurrency"
                                               v-bind:value="paymentCurrency.code"/>
                                    </div>
                                    <div :class="prate_len" v-if="paymentCurrency.code != code">
                                        <label class="control-label">@lang('layout.Rate') </label>
                                        <div :class="{'has-error':paymentCurrency.exchange_rate < 0}">
                                            <div class="input-group">
                                                <input v-model="selected_rate1" class="form-control" @input="get_exchange()"
                                                       type="number" min="0" step="any"
                                                       :readonly="selectedCurrency.code==paymentCurrency.code">
                                                <span class="input-group-addon">@{{paymentCurrency.symbol}}</span>
                                            </div>
                                            <input type="hidden" name="rate" :value="selected_rate1">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <label class="control-label">@lang('layout.Amount')</label>
                                    <div class="input-group">
                                        <input type="number" name="amount" class="form-control" v-model="amount"
                                               step="any" min="0" v-validate="'required'" @input="get_exchange()"
                                               data-vv-as="@lang('layout.Amount')">
                                        <span class="input-group-addon">@{{selectedCurrency.symbol}}</span>

                                    </div>
                                    <span class="required">@{{errors.first('amount')}}</span>
                                </div>
                                <input type="hidden" name="hq_rate" :value="selectedCurrency.hq_rate">
                            </div>
                            <div class="row">
                                <div class="col-md-3">
                                    <label class="control-label">@lang('layout.ExchangedAmount')</label>
                                    <div class="input-group">
                                        <input type="number" v-model="exchange_amount" @input="set_rate()"
                                               class="form-control" min="0" step="any">
                                        <input type="hidden" :value="(amount*selected_rate1/(selected_rate)).toFixed(4)" >
                                        <span class="input-group-addon">@{{paymentCurrency.symbol}}</span>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <label class="control-label">@lang('layout.Discount')</label>
                                    <input type="number" name="discount" v-model="discount" step="any" min="0"
                                           class="form-control">
                                </div>
                                <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
                                    <label class="control-label">@lang('layout.Date') </label>
                                    <div>
                                        <input class="form-control date" id="range-from-example" name="date"
                                               autocomplete="off">
                                    </div>
                                </div>

                            </div>
                            <div class="row">

                                <div class="col-md-3">
                                    <label class="control-label">@lang('layout.PaymentType')</label>
                                    <select class="form-control" name="payment_type" v-model="payment_type">
                                        <option value="">@lang('layout.SelectType')</option>
                                        <option value="bank_check">@lang('layout.BankCheck')</option>
                                    </select>
                                </div>
                                <div class="col-md-3" v-show="payment_type !=''">
                                    <label class="control-label">@lang('layout.CheckNumber')</label>
                                    <input type="text" name="check_number" class="form-control" placeholder="00020">
                                </div>
                                <div class="col-md-6" v-show="payment_type !=''">
                                    <label class="control-label">@lang('layout.CheckDate')</label>
                                    <input type="text" name="check_date" class="form-control date" autocomplete="off"
                                           placeholder="@lang('layout.CheckDate')">
                                </div>
                                <div class="col-md-6">
                                    <label class="control-label">@lang('layout.Description')</label>
                                    {{Form::textarea('description',null,['class'=>'form-control','rows'=>'1'])}}
                                </div>
                            </div>
                            @if(getcommission() =="true")
                            <div class="row">
                                <div class="col-md-4">
                                    <label class="control-label">@lang('layout.Expense') </label>
                                    <v-select label="name" :options="expense"
                                                v-model="selectedExpense" ></v-select>
                                    <input type="hidden" name="expense_id" v-bind:value="(!selectedExpense)?null:selectedExpense.id" />
                                </div> 
                                <div class="col-md-4">
                                    <label class="control-label">@lang('layout.Commission')</label>
                                    {{Form::number('commission_amount',null,['class' => 'form-control',"placeholder"=>__('layout.Amount')])}}
                                </div>
                                <div class="col-md-4">
                                    <label class="control-label">@lang('layout.Description')</label>
                                    {{Form::textarea('commission_description',null,['class'=>'form-control','rows'=>'1'])}}
                                </div>
                            </div>
                            @endif
                            <div class="row">
                            @if(getWhatsApp() =='true')                    
                                <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label"> <span class="fa fa-whatsapp" style="color:green;"></span> @lang('layout.Whatsapp')</label>
                                            <label class="mt-checkbox mt-checkbox-outline">
                                                <input type="checkbox"  name="whatsapp" value="2" />
                                                <span></span>
                                            </label>
                                        </div>
                                    </div>
                                </div>
                            @endif
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="panel panel-default"
                                 style="background-color:rgb(204, 216, 228);position: relative;top: 24px;">
                                <div class="panel-body">
                                    <table class="table table-bordered">
                                        <thead>
                                        <tr>
                                            <th>@lang('layout.Currency') </th>
                                            <th>@lang('layout.Payable')</th>
                                            <th>@lang('layout.Receivable')</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                                 <span v-if="selectedMember">
                                                   <tr v-for="summ in summary">
                                                      <td class="highlight">
                                                         @{{ summ.currency }}
                                                      </td>
                                                      <td class="hidden-xs"> @{{ format_number(Number(summ.payment)) }}</td>
                                                      <td>
                                                          @{{ format_number(Number(summ.invoice)) }}
                                                      </td>
                                                    </tr>
                                                </span>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-10">
                    <div class="row">
                        <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                            <button v-if="((isError == false) && (number_Error == false))" type="button" class="btn green"
                                    @click="handleSubmit($event)">@lang('layout.Submit')</button>
                            <button v-if="((isError == false) && (number_Error == false))" type="button" class="btn blue"
                            :disabled="disabled" @click="saveAndNew($event)">@lang('layout.SaveAndNew')</button>
                            <a href="{{route('pay.index')}}" class="btn default"><i
                                        class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                        </div>
                    </div>
                </div>
                {!! Form::close() !!}
            </div>
            <!-- END FORM--> 
        </div>
    </div>
@endsection
@push('scripts')

    <script src="{{url('/select2/js/select2.full.min.js')}}"></script>

    <script>

        @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
        Vue.use(VeeValidate, {
            locale: 'en',
        });
        @endif


        Vue.component("v-select", VueSelect.VueSelect);
        var Member =
                {!!$member!!}
        var Banks =
                {!! $bank !!}
        var Currency =
                {!! $currency !!}
        var Currency1 =
                {!! $currency!!}
        var one = {!! json_encode(getHomeCurrency()) !!};
        var two = {!! json_encode(getHomeCurrency()) !!};
        var code = '{!! getHomeCurrency()['code'] !!}';
        var memberClass = {!! $memberClass !!};
        var expense = {!! $expense !!};
 
        let rates =
                {!! $rates !!}

        var vm = new Vue({
                el: '#app',
                data: {
                    selectedCurrency: one,
                    selectedCurrencyTemp: null,
                    paymentCurrency: two,
                    selectedCurrency2: null,
                    currency: [],
                    currency1: [],
                    expense: expense,
                    selectedExpense: null,
                    bankes: {!! $banks !!},
                    number: "{{$number}}",
                    old_number: "{{$number}}",
                    number_msg: '',
                    number_Error: false,
                    disabled: false,
                    selectedBank: null,
                    defuilt_banks: null,
                    defaultValue: 0,
                    summary: [],
                    defaultAmount: 0,
                    defaultAccount: 0,
                    selected_rate: 0,
                    selected_rate1: 0,
                    listAccounts: [],
                    selectedMember: null,
                    newAmount: null,
                    amount: null,
                    exchange_amount: null,
                    discount: null,
                    currencyList: Currency,
                    type: 'bank',
                    account: {},
                    currency_len: 'col-md-12',
                    rate_len: 'col-md-0',
                    pcurrency_len: 'col-md-12',
                    prate_len: 'col-md-0',
                    code: code,
                    first_currency: 0,
                    second_currency: 0,
                    ref_no: '',
                    msg: '',
                    isError: false,
                    payment_type: '',

                    memberClass: memberClass,
                    selected_class: null,
                    member: Member,
                    all_member: Member


                },
                computed: {
                    accountUpdate() {
                        var b = _.clone(Banks)
                        var test = this.accounts = b.filter((account) => {
                            return (new RegExp(this.selectedCurrency.code.toLowerCase())).test(account.code.toLowerCase())
                        })
                        if (test) {
                            if (this.defuilt_banks) {
                                this.defaultValue = this.defuilt_banks.id;
                                this.defuilt_banks = null;
                            }else{
                                if (test.length > 0) {
                                    this.defaultValue = test[0].id;
                                }
                            }
                        }


                        for (var x in this.bankes) {
                            for (z in this.bankes[x]) {
                                if (this.bankes[x][z] == this.defaultValue) {
                                    this.selectedBank = this.bankes[x];
                                    this.defaultAccount = this.defaultValue;
                                    break;
                                }
                            }

                        }
                        return test;
                    },

                },
                mounted: function () {
                    var selected_banks=_.find(this.bankes,(v)=>v.id=={!! getDropdown('pay', 'bank') !!});
                    if(selected_banks){
                        this.defaultAccount = selected_banks.id;
                        var selected_currency=_.find(this.currency,(v)=>v.code==selected_banks.code);
                        // currency
                        this.selectedCurrency = selected_currency;
                        this.defuilt_banks = selected_banks;
                        this.setSize(selected_currency.code)
                    }

                    // console.log(123, selected_banks, selected_currency);
                },
                created() {
                    this.setRates();
                },
                methods: {

                 memberClassChange() {
                        vm.member = vm.all_member;
                        console.log(vm.all_member);
                        if (vm.selected_class) {
                            // console.log('test22', vm.selected_class);
                            vm.member = vm.all_member.filter((m) => {
                                return vm.selected_class.id == m.class_id;
                            });

                        }
                    },
                    setRates() {

                        let c = _.clone(Currency);
                        let c1 = _.clone(Currency1);

                        Currency = [];
                        Currency1 = [];

                        c.forEach((a) => {

                            rates.forEach((rate) => {

                                if (a.code == rate.code)
                                    Currency.push({
                                        name: a.name,
                                        code: a.code,
                                        symbol: a.symbol,
                                        exchange_rate: rate.rate,
                                        rate: rate.rate,
                                        hq_rate: rate.hq_rate
                                    });
                            });
                        });

                        c1.forEach((a) => {
                            rates.forEach((rate) => {

                                if (a.code == rate.code)
                                    Currency1.push({
                                        name: a.name,
                                        code: a.code,
                                        symbol: a.symbol,
                                        exchange_rate: rate.rate,
                                        rate: rate.rate,
                                        hq_rate: rate.hq_rate
                                    });


                            });
                        });

                        // for ensuring for each currency rate is defined

                        c.forEach((a) => {

                            let found = false;
                            Currency.forEach((cur) => {
                                if (a.code == cur.code) {
                                    found = true;
                                    return;
                                }
                            });

                            if (!found) {
                                Currency.push({
                                    name: a.name,
                                    code: a.code,
                                    symbol: a.symbol,
                                    exchange_rate: 1,
                                    rate: 1,
                                    hq_rate: 1
                                });
                            }
                        });

                        c1.forEach((a) => {

                            let found = false;

                            Currency1.forEach((cur) => {
                                if(a.code == cur.code){
                                    found = true;
                                    return;
                                }

                            });

                            if (!found) {
                                Currency1.push({
                                    name: a.name,
                                    code: a.code,
                                    symbol: a.symbol,
                                    exchange_rate: 1,
                                    rate: 1,
                                    hq_rate: 1
                                });
                            }
                        });

                        this.currency = Currency;
                        this.currency1 = Currency1;


                    },
                    checkNo() {
                        var chack = 'false';
                        var number = vm.number;
                        if (number != null) {
                            axios.get("{{route('callMethod.search')}}", {

                                    params: {
                                        number: vm.number,
                                        method_name: 'Search_number',
                                        table_name: 'payments'
                                    },
                                })
                                .then(function(response) {
                                    // console.log(response.data.result);
                                    if (response.data.result != null) {
                                        // console.log(response.data.result);
                                        // vm.temp_items=response.data;
                                        vm.number_msg = "@lang('layout.DuplicateData')";
                                        vm.number_Error = true;
                                    } else {
                                        vm.number_msg = 'no';
                                        vm.number_Error = false;

                                    }
                                })
                                .catch(function(error) {
                                    console.log(error);
                                });

                        }
                    },
                    checkRefNo() {

                        //console.log(vm.ref_no)

                        var chack = 'false';
                        var ref_no = vm.ref_no;
                        if (ref_no != null) {


                            axios.get("{{route('callMethod.search')}}",
                                {

                                    params: {
                                        ref_no: vm.ref_no,
                                        method_name: 'Search_ref_no',
                                        table_name: 'payments'
                                    },
                                })
                                .then(function (response) {
                                    // console.log(response.data.result);
                                    if (response.data.result != null) {
                                        console.log(response.data.result);
                                        // v.temp_items=response.data;
                                        vm.msg = "@lang('layout.DuplicateData')";
                                        vm.isError = true;
                                    }
                                    else {
                                        vm.msg = 'no';
                                        vm.isError = false;

                                    }
                                })
                                .catch(function (error) {
                                    console.log(error);
                                });

                        }
                    },
                    handleSubmit(e) {
                        this.$validator.validate().then(valid => {
                            if (valid) {
                                // console.log(e);
                                // alert(e.target);
                                regForm(e.target);
                            }
                        });
                    },
                    get_exchange() {
						if(vm.selected_rate > 0){
							vm.exchange_amount = myRound((vm.amount* vm.selected_rate1)/vm.selected_rate);
						}
                    },
                    set_rate() {
						if(vm.exchange_amount > 0){
							vm.selected_rate1 = myRound((vm.exchange_amount)/ (vm.amount / vm.selected_rate));
						}
                    },
                    saveAndNew() {
                        this.$validator.validate()
                            .then(valid => {
                                if (valid) {
                                    vm.disabled = true;
                                    var url = "{{route('pay.store')}}";
                                    form_id = 'pay-submit';
                                    var data = $('#' + form_id).serialize();

                                    axios.post(url, data)
                                        .then(function (response) {
                                            if (response.data.result == 1) {
                                                $('#' + form_id).trigger('reset');
                                                toastr.success('', response.data.message);
                                                vm.number = Number(vm.old_number) + 1;
                                                vm.old_number = Number(vm.old_number) + 1;
                                                vm.amount = null;
                                                vm.ref_no = null;

                                                // vm.selectedMember = null;
                                                location.reload();
                                            }
                                            else {
                                                var message = "{{__('message.Warning')}}";
                                                vm.disabled = false;
                                                //$('#error-sound')[0].play();
                                                toastr.warning('', message);
                                            }
                                        })
                                        .catch(function (error) {
                                            vm.disabled = false;
                                            console.log(error);
                                            var message = "{{__('message.Warning')}}";
                                            //$('#error-sound')[0].play();
                                            toastr.warning('', message);
                                        });

                                }
                            })
                    },


                    getSummary() {
                        if (this.selectedMember) {

                            this.getSummaryRecor(this.selectedMember.id, this);

                        }

                    },
                    getSummaryRecor(id, vm) {
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'memberStatment',
                                member_id: id,
                            }
                        })
                            .then(function (response) {

                                if (response.data.length > 0) {
                                    vm.summary = response.data;
                                }
                                else{
                                        vm.summary=[];
                                    }
                            })
                            .catch(function (error) {
                                console.log(error);
                            });
                    },
                    setSize(selected_code) {
                        this.paymentCurrency = this.selectedCurrency;
                        this.selected_rate = this.selectedCurrency.exchange_rate;
                        this.selected_rate1 = this.selectedCurrency.exchange_rate;
                        if (selected_code == this.code) {
                            this.currency_len = 'col-md-12';
                            this.rate_len = 'col-md-0';
                        }
                        else {
                            this.currency_len = 'col-md-6';
                            this.rate_len = 'col-md-6';
                        }
                        this.pcurrency_len = this.currency_len;
                        this.prate_len = this.rate_len;
                    },
                    setPaymentSize(selected_code) {
                        // this.selected_rate = this.paymentCurrency.exchange_rate;
                        this.selected_rate1 = this.paymentCurrency.exchange_rate;

                        if (selected_code == this.code) {
                            this.pcurrency_len = 'col-md-12';
                            this.prate_len = 'col-md-0';
                        }
                        else {
                            this.pcurrency_len = 'col-md-6';
                            this.prate_len = 'col-md-6';
                        }
                    },
                    check_code(code) {
                        if (this.paymentCurrency.code == this.selectedCurrency.code) {
                            this.selected_rate1 = this.selected_rate;
                        }

                    },
                    test(defaultAccount) {
                        for (var x in this.bankes) {
                            for (z in this.bankes[x]) {
                                if (this.bankes[x][z] == defaultAccount) {
                                    this.selectedBank = this.bankes[x];
                                    break;
                                }
                            }

                        }
                    
                        // if (this.selectedBank.balance<=0 ) {

                        //     this.isError = true;
                        // }
                    
                        // else{
                        //     this.isError = false;
                        // }
                    

                    },

                }
            });
    </script>


@endpush
  --}}

























































  @extends('layouts.app')
@section('style')
    <link rel="stylesheet" href="{{url('/select2/css/select2-bootstrap.min.css')}}">
    <link rel="stylesheet" href="{{url('/select2/css/select2.min.css')}}">
    <link href="{{URL::asset('assets/global/plugins/bootstrap-timepicker/css/bootstrap-timepicker.min.css')}}" rel="stylesheet" type="text/css" />
    <style type="text/css">
        .bg{
            background: #bddadc !important;
        }
    </style>
@stop
@section('content')
@include("layouts.Cmodal")
    <div class="row">
        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.CreateNewPay') </span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools">
                </div>
            </div>
            <div class="portlet-body form" style="margin-bottom:50%;" id="app" v-cloak>
                <!-- BEGIN FORM-->
                {{Form::open(['route' => 'pay.store','method' => 'POST','class' => 'form-horizontal','id'=>'pay-submit'])}}
                <div class="form-body">
                    <div class="row" style="margin-bottom: 20px; padding: 10px;">
                        <div class="col-lg-9 col-md-9 col-sm-12 col-xs-12" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px; margin-bottom: 10px; padding: 15px 50px;">
                            <div class="row" style="padding: 0px 10px;">
                                <div v-show="showWhat('member_class')=='yes'" class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="">
                                        <label class="control-label">@lang('layout.MemberClass') </label>
                                        <v-select label="name" :options="memberClass" v-model="selected_class" @input="memberClassChange()"></v-select>
                                        <input type="hidden" name="class_id" :value="!selected_class?null:selected_class.id">
                                    </div>
                                </div>
                                <div class="col-lg-5">
                                    <div class="form-group">
                                        <label class="control-label">@lang('layout.SelectMember')</label>
                                        <div class="input-group">
                                            <v-select @input="getSummary" :class="selectMem + ' vue-select2 '" v-model="selectedMember"
                                                @search="MemberSearch" label="name" :options="member">
                                            </v-select>
                                            <span class="input-group-addon">
                                                @if (fingerprint() == 'true')
                                                <input type="checkbox" name="finger" @click="clearFinger('finger')" v-model="finger" placeholder="@lang('layout.Fingerprint')" >
                                                <span></span>
                                                @endif
                                            </span>

                                            <input type="hidden" name="member_id" v-model.number="(!selectedMember)?null:selectedMember.id" v-validate="'required'" data-vv-as="@lang('layout.Member')">
                                            <span class="btn btn-success input-group-addon " title="@lang('button.AddNewCustomer')" @click="showModal = true" style="background-color:  rgb(84, 199, 211)">
                                                <i class="fa fa-plus" style="color: white"></i>
                                            </span> 
                                        </div>
                                        {{-- <input type="hidden" name="member_id" v-model.number="(!selectedMember)?null:selectedMember.id" v-validate="'required'" data-vv-as="@lang('layout.Member')"> --}}
                                        <span class="required">@{{errors.first('member_id')}}</span>
                                    </div>
                                </div>
                                <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                    <label class="control-label">@lang('layout.Date') </label>
                                    <div>
                                        <input class="form-control date" id="range-from-example" name="date"  autocomplete="off"
                                        @if(getDateRequired() == 'true') v-validate='"required"' data-vv-as="@lang('layout.Date')" @endif>
                                        <span class="required">@{{ errors.first('date') }}</span>
                                    </div>
                                </div>
                            </div>
                            <div class="row" style="padding: 0px 10px;">
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <label class="control-label">@lang('layout.Hour')</label>
                                    <div class="input-group" @click="stopDynamicTime" @mousemove="changeTime"> 
                                        @if(getHourType() == 24)
                                        <input type="text" class="form-control timepicker timepicker-24" v-model="dynamic_time" ref="time_input" name="hour" @keyup="changeTime">
                                        @else
                                        <input type="text" class="form-control timepicker timepicker-no-seconds" v-model="dynamic_time" ref="time_input" name="hour" @keyup="changeTime">
                                        @endif
                                        <span class="input-group-btn">
                                            <button class="btn default" type="button">
                                                <i class="fa fa-clock-o"></i>
                                            </button>
                                        </span>
                                    </div>
                                </div>                            
                                <div class="col-lg-4">
                                    <label class="control-label">@lang('layout.Type')</label>
                                    <select class="form-control" name="type" v-model="pay_type" >
                                        <option disabled>@lang('layout.SelectType')</option>
                                        <option value="bill">@lang('layout.Bill')</option>
                                        <option value="invoice">@lang('layout.Invoice')</option>
                                        <option value="salary">@lang('layout.Salary')</option>
                                        <option value="loan">@lang('layout.Loan')</option>
                                        <option value="prepaid">@lang('layout.Prepaid')</option>
                                        <option value="bankCheck">@lang('layout.BankCheck')</option>
                                        <option value="branchTransfer">@lang('layout.BranchTransfer')</option>
                                        <option value="BillPayment">@lang('layout.BillPayment')</option>
                                        <option value="ExpensePayment">@lang('type.ExpensePayment')</option>
                                        <option value="CarpetContract">@lang('type.CarpetContract')</option>
                                        @if(systemConfig()[20] == 1)
                                            <option value="contract">@lang('type.Contract')</option>
                                        @endif
                                    </select>
                                </div>
                                <div class="col-lg-4">
                                    <label class="control-label">@lang('layout.PaymentType')</label>
                                    <select class="form-control" name="payment_type" v-model="payment_type">
                                        <option value="">@lang('layout.SelectType')</option>
                                        <option value="bank_check">@lang('layout.BankCheck')</option>
                                    </select>
                                </div>
                            </div>
                            <div class="row" style="padding: 0px 10px;">
                                <div class="col-lg-4" v-show="payment_type !=''">
                                    <label class="control-label">@lang('layout.CheckNumber')</label>
                                    <input type="text" name="check_number" class="form-control" placeholder="00020">
                                </div>
                                <div class="col-lg-4" v-show="payment_type !=''">
                                    <label class="control-label">@lang('layout.CheckDate')</label>
                                    <input type="text" name="check_date" class="form-control date" autocomplete="off"
                                           placeholder="@lang('layout.CheckDate')">
                                </div>
                            </div>
                            @if(getcommission() =="true")
                                <div class="row" style="padding: 0px 10px;">
                                    <div class="col-lg-4">
                                        <label class="control-label">@lang('layout.Expense') </label>
                                        <v-select label="name" :options="expense"
                                                    v-model="selectedExpense" ></v-select>
                                        <input type="hidden" name="expense_id" v-bind:value="(!selectedExpense)?null:selectedExpense.id" />
                                    </div> 
                                    <div class="col-lg-4">
                                        <label class="control-label">@lang('layout.Commission')</label>
                                        {{Form::number('commission_amount',null,['class' => 'form-control',"placeholder"=>__('layout.Amount')])}}
                                    </div>
                                    <div class="col-lg-4">
                                        <label class="control-label">@lang('layout.Description')</label>
                                        {{Form::textarea('commission_description',null,['class'=>'form-control','rows'=>'1'])}}
                                    </div>
                                </div>
                            @endif
                            @if(isGroupCompany())
                                <div class="row" style="padding: 0px 10px;">
                                    <div v-if="pay_type=='branchTransfer'" class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                        <div class="form-group">
                                            <div class="col-md-12">
                                                <label class="control-label">@lang('layout.Company')</label>
                                                <v-select label="name"  :options="company" v-model="selected_company" placeholder="@lang('layout.Company')" :select-on-tab="true"></v-select>
                                                <input type="hidden" name="to_company_id" :value="(!selected_company)?null:selected_company.id">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endif
                            @if(systemConfig()[20] == 1)
                                <div v-if="pay_type=='contract'" class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <label class="control-label">@lang('layout.Contract')</label>
                                    <v-select class="vue-select2" placeholder="@lang('layout.Select')" v-model="selectedContract" label="company_name"  @input="contractWagon()" :options="{{$contract}}">
                                    </v-select>
                                    <input type="hidden" name="contract_id" v-model.number="(!selectedContract)?null:selectedContract.id" />
                                </div>
                            @endif
                            <div class="row">
                            @if(systemConfig()[16] != 0)
                                <div v-if="farmer_contract_list.length > 0" class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <label class="control-label">@lang('layout.FarmerContract')</label>
                                    <v-select class="vue-select2" label="name" :options="farmer_contract_list" v-model="selectedFarmerContract">
                                    </v-select>
                                    <input type="hidden" name="contract_farmer_id" v-model.number="(!selectedFarmerContract)?null:selectedFarmerContract.id">
                                </div>
                            @endif 
                            @if(systemConfig()[21] != 0)
                                <div v-if="carpet_contract_list.length > 0" class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <label class="control-label">@lang('layout.CarpetContract')</label>
                                    <v-select class="vue-select2" label="name" :options="carpet_contract_list" v-model="selectedCarpetContract">
                                    </v-select>
                                    <input type="hidden" name="carpet_contract_id" v-model.number="(!selectedCarpetContract)?null:selectedCarpetContract.id">
                                </div>
                            @endif 
                            @if(getWhatsApp() =='true')                    
                                <!-- <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group" >
                                        <div class="col-md-12">
                                            <label class="control-label"> <span class="fa fa-whatsapp" style="color:green;"></span> @lang('layout.Whatsapp')</label>
                                            <label class="mt-checkbox mt-checkbox-outline">
                                                <input type="checkbox"  name="whatsapp" value="2" />
                                                <span></span>
                                            </label>
                                        </div>
                                    </div>
                                </div> -->
                            @endif
                            </div>
                            <div class="row" style="padding: 0px 10px;">
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.OverdueDate')</label>
                                            {{Form::text('overdue_date',null,['class' => 'form-control date','id'=>'date','autocomplete'=>'off'])}}
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Memo')</label>
                                            <textarea name="memo" class="form-control" rows="1"></textarea>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                    <table class="table table-striped table-bordered table-advance ">
                                        <tr>
                                            <td class="t_body">
                                                <label class=" control-label">@lang('layout.SelectAmountByExchangedAmount')</label>
                                                <label class="mt-checkbox mt-checkbox-outline">
                                                    <input type="checkbox" name="change_amount" v-model="change_amount" value="on">
                                                    <span></span>
                                                </label>
                                            </td>
                                        </tr>
                                    </table>
                                </div>
                                @if(getTelegramBot()=="true")
                                    <div class="col-lg-1 col-md-1 col-sm-12 col-xs-12">
                                        <table class="table table-striped table-bordered table-advance ">
                                            <tr>
                                                <td class="t_body">
                                                    <div>
                                                        <label class="mt-checkbox mt-checkbox-outline"><i class="fa fa-telegram" style="color:rgb(14 177 177); font-size:20px"></i>
                                                            <input type="checkbox" name="telegram" value="ok">
                                                            <span></span>
                                                        </label>
                                                    </div>
                                                </td>
                                            </tr>
                                        </table>
                                    </div>
                                @endif
                            </div>
                        </div>
                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                            <div class="col-lg-12 col-md-12 col-sm-12" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px;margin-bottom: 1em;">
                                <div class="panel panel-default" style="margin-top: 20px;">
                                    <div class="panel-body">
                                        <table class="table table-bordered">
                                            <thead>
                                                <tr>
                                                    <th class="text-center">@lang('layout.Currency') </th>
                                                    <th class="text-center">@lang('layout.Payable')</th>
                                                    <th class="text-center">@lang('layout.Receivable')</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <span v-if="selectedMember">
                                                    <tr v-for="summ in summary">
                                                        <td class="highlight text-center">
                                                            @{{ summ.currency }}
                                                        </td>
                                                        <td class="hidden-xs text-center"> @{{ format_number(Number(summ.payment)) }}</td>
                                                        <td class="text-center">
                                                            @{{ format_number(Number(summ.invoice)) }}
                                                        </td>
                                                    </tr>
                                                </span>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <hr>
                        <!-- begin receiveablePayment -->
                        <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                        <thead>
                                <tr>
                                    <th> #</th>
                                    <th class="text-center" style="width: 120px;">@lang('layout.Number')</th>
                                    <th class="text-center" style="min-width: 100px;">@lang('layout.PaymentCurrency')</th>
                                    <th class="text-center" style="min-width: 250px;">@lang('layout.Account')</th>
                                    <th class="text-center" style="min-width: 100px;">@lang('layout.Currency')</th>
                                    <th class="text-center" style="min-width: 100px;">@lang('layout.Discount')</th>
                                    <th class="text-center" style="min-width: 140px;">@lang('layout.Description')</th>
                                    <th></th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr v-for="(row,index) in receiveablePayment" :class="(index%2==0)?' ':'bg'">
                                    <td>@{{index+1}}</td>
                                    <td>
                                        <input type="number" :name="'number['+index+']'" class="form-control" :value="Number.parseFloat(row.number) + Number.parseFloat(index)" ref="number" @input="checkNo(row.number, index)"
                                            v-validate="'required'" data-vv-as="@lang('layout.Number')">
                                        <span class="required">@{{errors.first('number['+index+']')}}</span>
                                        <span v-if="number_Error ==true" class="input-has-error" style="color: red">@{{number_msg}}</span>
                                        
                                        <center> <label class="control-label">@lang('layout.ReferenceNumber')</label> </center>
                                        <input type="text" :name="'ref_no['+index+']'" class="form-control" @input="checkRefNo(row.ref_no)"
                                            v-model='row.ref_no'>
                                        <span v-if="isError ==true" class="input-has-error" style="color: red">@{{msg}}</span>
                                    </td>
                                    <td class="highlight">
                                        <select class="form-control" v-model="row.selectedCurrency"
                                                v-on:change="setSizeRow(row.selectedCurrency.code,index), get_exchange_row(index)">
                                            <option v-for="curre in currency" :value="curre">@{{ curre.code }}</option>
                                        </select>
                                        <input type="hidden" :name="'currency['+index+']'" v-bind:value="row.selectedCurrency.code"/>
                                        
                                        <span v-if="row.selectedCurrency.code != code">
                                        <center> <label class="control-label">@lang('layout.Rate') </label> </center>
                                            <div :class="{'has-error':selectedCurrency.rate < 0}">
                                                <div class="input-group">
                                                    <input v-model="row.selected_rate" class="form-control" :name="'currency_rate['+index+']'" :readonly="averageRate"
                                                        type="number" step="any" min="0"  @click="check_code(row.paymentCurrency.code, index), get_exchange_row(index)" @keyup="check_code(row.paymentCurrency.code, index), get_exchange_row(index)">
                                                    <span class="input-group-addon">@{{row.selectedCurrency.symbol}}</span>
                                                </div>
                                            </div>
                                        </span>
                                    </td>
                                    <td class="highlight">
                                        <div class="input-group">
                                            <select class="form-control" :name="'account_id['+index+']'" v-model="row.defaultAccount"
                                                    v-on:change="getDefaultAccount(row.defaultAccount,index)">
                                                <option v-for="Account in row.accounts" :value="Account.id">
                                                    @{{ Account.name }}
                                                </option>
                                            </select>
                                            <span class="input-group-addon" :style="(((row.selectedBank)? Number(row.selectedBank.balance)-(Number((row.amount)?row.amount:0))+Number((row.discount)?row.discount:0):0 ) < 0)?'background-color: #ff0000; color: #ffffff;':''" >@{{ (row.selectedBank)?format_number( Number(row.selectedBank.balance)-(Number((row.amount)?row.amount:0))+Number((row.discount)?row.discount:0)):0 }}</span>

                                        </div>
                                        <center><label class="control-label">@lang('layout.Amount')</label></center>
                                        <vue-numeric
                                            class="form-control"
                                            v-model="row.amount"
                                            :max="99999999999999"
                                            :currency="row.selectedCurrency.code"
                                            :precision="precision()"
                                            @input="get_exchange_row(index)"
                                            >
                                        </vue-numeric>
                                        <input type="hidden" :name="'amount['+index+']'" class="form-control" v-model="row.amount" step="any" min="0" v-validate="'required'" data-vv-as="@lang('layout.Amount')">
                                        <span class="required">@{{errors.first('amount['+index+']')}}</span>
                                    </td>
                                    <td>
                                            <select class="form-control" v-model="row.paymentCurrency" 
                                                    v-on:change="setPaymentSizeRow(row.paymentCurrency.code,index), get_exchange_row(index)">
                                                <option v-for="curre in currency1" :value="curre">@{{ curre.code }}</option>
                                            </select>
                                            <input type="hidden" :name="'paymentCurrency['+index+']'" v-bind:value="row.paymentCurrency.code"/>

                                        <span  v-if="row.paymentCurrency.code != code">
                                        <center> <label class="control-label">@lang('layout.Rate') </label> </center>
                                            <div :class="{'has-error':row.paymentCurrency.exchange_rate < 0}">
                                                <div class="input-group">
                                                    <input v-model="row.selected_rate1" class="form-control" @input="get_exchange_row(index)"
                                                        type="number" min="0" step="any" :name="'rate['+index+']'"
                                                        :readonly="row.selectedCurrency.code==row.paymentCurrency.code">
                                                    <span class="input-group-addon">@{{row.paymentCurrency.symbol}}</span>
                                                </div>
                                            </div>
                                        </span>
                                    </td>
                                    <td class="highlight">
                                        <input type="number" :name="'discount['+index+']'" v-model="row.discount" step="any" min="0" class="form-control">
                                        <center> <label class="control-label">@lang('layout.ExchangedAmount')</label> </center>
                                        <vue-numeric
                                            class="form-control"
                                            v-model="row.exchange_amount"
                                            :max="99999999999999"
                                            :currency="row.paymentCurrency.code"
                                            :precision="precision()"
                                            @Click.native="set_rate_row(index)"
                                            @keyup.native="set_rate_row(index)"
                                            >
                                        </vue-numeric>
                                    </td>
                                    <td>
                                        <textarea :name="'description['+index+']'" class="form-control" rows="3" > </textarea>
                                    </td>
                                    <td>
                                        <span v-on:click="deleteItem('pay',index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>
                                    </td>
                                </tr>
                                <tr style="background-color: #ffffff;">
                                    <td colspan="3">
                                        <center>
                                            <button type="button" @click="addNew('pay',1000)" class="btn btn-success"> <i class="fa fa-plus"></i></button>
                                        </center>
                                    </td>
                                </tr>

                            </tbody>
                        </table>
                        <!-- end receiveablePayment -->
                    </div>
                </div>
                <div class="col-md-12">
                    <div class="row">
                        <div class="col-xs-12 col-sm-12 col-md-12 text-center">
                            <button v-if="((isError == false) && (number_Error == false))" type="button" class="btn green"
                                    @click="handleSubmit($event)">@lang('layout.Submit')</button>
                            <button v-if="((isError == false) && (number_Error == false))" type="button" class="btn blue"
                            :disabled="disabled" @click="saveAndNew($event)">@lang('layout.SaveAndNew')</button>
                            <a href="{{route('pay.index')}}" class="btn default"><i
                                        class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                        </div>
                        <cmodal :show='showModal' @close="showModal=false">

                        </cmodal>
                    </div>
                </div>
                {!! Form::close() !!}
            </div>
            <!-- END FORM--> 
        </div>
    </div>
@endsection
@push('scripts')
<script src="{{URL::asset('assets/global/plugins/bootstrap-timepicker/js/bootstrap-timepicker.min.js')}}" type="text/javascript"></script>
<script src="{{URL::asset('assets/pages/scripts/components-date-time-pickers.min.js')}}" type="text/javascript"></script>
    <script src="{{url('/select2/js/select2.full.min.js')}}"></script>

    <script>

        @if(App::getLocale())
        Vue.use(VeeValidate, {
            locale: '{{App::getLocale()}}',
        });
        @else
        Vue.use(VeeValidate, {
            locale: 'en',
        });
        @endif

        Vue.component("v-select", VueSelect.VueSelect);
        Vue.use(VueNumeric.default);

        //begin new member
        Vue.component("cmodal", {
            template: '#cmodal-template',

            props: ['show'],
            data() {
                return {
                    classes: [],
                    selectedClass: null,
                    types: [],
                    receivables: [],
                    payables: [],
                    code: null,
                    selectType: null,
                    selectPay: null,
                    selectReceive: null,
                }
            },
            created() {

                axios.get('{{route("customer.create")}}').then(
                    response => {
                        this.types = response.data.types;
                        if (this.types) {
                            for (var i = 0; i < this.types.length; i++) {
                                if (this.types[i].type == "Vendor") {
                                    this.selectType = this.types[i];
                                }
                            }
                        }
                        this.receivables = response.data.receivable;
                        this.payables = response.data.payable;
                        this.code = response.data.code;
                        this.classes = response.data.member_class;
                        if(this.receivables.length>0)
                        {
                            this.selectReceive=this.receivables[0];
                        }
                        if(this.payables.length>0)
                        {
                            this.selectPay=this.payables[0];
                        }

                    }).catch(error => console.log(error));
            },
            methods: {
                onSubmit() {

                    vm.showModal = false;
                    //this.member.type = this.member.type.id;
                    var datas = $("#modalForm").serializeArray();
                    $.ajax({
                        headers: {'X-CSRF-TOKEN': "{{csrf_token()}}"},
                        url: '{{route("customer.store")}}',
                        method: 'post',
                        data: {
                            "name": datas[0]['value'],
                            'code': datas[1]['value'],
                            'email': datas[2]['value'],
                            'phone': datas[3]['value'],
                            'address1': datas[4]['value'],
                            'type': this.selectType.id,
                            'receivable': this.selectReceive.id,
                            'payable': this.selectPay.id,
                            'class': (this.selectedClass) ? this.selectedClass.id : null
                        },
                        dataType: 'json',

                    }).done(function (response) {
                        if (response) {
                            vm.selectedMember = response.customer;
                        }
                    }).fail(function (error) {
                        console.log('error', error);
                    });

                }
            }
        });

        var Banks = {!! $banks !!};
        var Currency = {!! $currency !!};
        var Currency1 = {!! $currency!!};
        var one = {!!json_encode(getHomeCurrency()) !!};
        var two = {!!json_encode(getHomeCurrency()) !!};
        var code = '{!! getHomeCurrency()['code'] !!}';
        var memberClass = {!! $memberClass !!};
        var expense = {!! $expense !!};
        var company = {!! $company !!};
        var contract = {!! $contract !!};
 
        let rates = {!! $rates !!};

        var vm = new Vue({
                el: '#app',
                data: {
                    dynamic_time:'',
                    selectedCurrency: one,
                    selectedCurrencyTemp: null,
                    paymentCurrency: two,
                    selectedCurrency2: null,
                    currency: [],
                    currency1: [],
                    showModal: false,
                    expense: expense,
                    selectedExpense: null,
                    selectedContract: null,
                    bankes: {!! $banks !!},
                    number: "{{$number}}",
                    old_number: "{{$number}}",
                    number_msg: '',
                    number_Error: false,
                    disabled: false,
                    averageRate: false,
                    change_amount: false,
                    selectedBank: null,
                    defuilt_banks: null,
                    defaultValue: 0,
                    summary: [],
                    defaultAccount: 0,
                    selected_rate: 0,
                    selected_rate1: 0,
                    company:company,
                    selected_company:null,
                    listAccounts: [],
                    selectedMember: null,
                    newAmount: null,
                    amount: null,
                    exchange_amount: null,
                    discount: null,
                    currencyList: Currency,
                    type: 'bank',
                    pay_type: 'bill',
                    account: {},
                    currency_len: 'col-md-12',
                    rate_len: 'col-md-0',
                    pcurrency_len: 'col-md-12',
                    prate_len: 'col-md-0',
                    code: code,
                    first_currency: 0,
                    second_currency: 0,
                    ref_no: '',
                    msg: '',
                    isError: false,
                    payment_type: '',
                    receiveablePayment: [],
                    memberClass: memberClass,
                    selected_class: null,
                    member: [],
                    farmer_contract_list:[],
                    selectedFarmerContract:null,
                    carpet_contract_list:[],
                    selectedCarpetContract:null,
                    finger: null,
                    fingerCounter: 0,
                    selectMem:''
                },
                computed: {
                    // accountUpdate() {
                    //     var b = _.clone(Banks)
                    //     var test = this.accounts = b.filter((account) => {
                    //         return (new RegExp(this.selectedCurrency.code.toLowerCase())).test(account.code.toLowerCase())
                    //     })
                    //     if (test) {
                    //         if (this.defuilt_banks) {
                    //             this.defaultValue = this.defuilt_banks.id;
                    //             this.defuilt_banks = null;
                    //         }else{
                    //             if (test.length > 0) {
                    //                 this.defaultValue = test[0].id;
                    //             }
                    //         }
                    //     }


                    //     for (var x in this.bankes) {
                    //         for (z in this.bankes[x]) {
                    //             if (this.bankes[x][z] == this.defaultValue && z == 'id') {
                    //                 this.selectedBank = this.bankes[x];
                    //                 this.defaultAccount = this.defaultValue;
                    //                 break;
                    //             }
                    //         }

                    //     }
                    //     return test;
                    // },

                },
                mounted: function () {
                    var selected_banks=_.find(this.bankes,(v)=>v.id=={!! getDropdown('pay', 'bank') !!});
                    if(selected_banks){
                        this.defaultAccount = selected_banks.id;
                        var selected_currency=_.find(this.currency,(v)=>v.code==selected_banks.code);
                        var rate = selected_currency.exchange_rate;
                        @if(getAverageRate() =="true")
                        if (selected_banks.avg_rate) {
                            this.averageRate = true;
                            rate = selected_banks.avg_rate;
                        }
                        @endif

                        // currency
                        // this.selectedCurrency = selected_currency;
                        // this.defuilt_banks = selected_banks;

                        var b = _.clone(Banks)
                        var accounts = this.accounts = b.filter((account) => {
                            return (new RegExp(selected_currency.code.toLowerCase())).test(account.code.toLowerCase())
                        })

                        this.receiveablePayment.push({
                            accounts: accounts,
                            defaultAccount: selected_banks.id,
                            selectedBank: selected_banks,
                            selectedCurrency: selected_currency,
                            paymentCurrency: selected_currency,
                            selected_rate: rate,
                            selected_rate1: rate,
                            exchange_amount: 0,
                            exchange_amount: 0,
                            number: this.number,
                            ref_no: null
                        });
                        // console.log(12, this.receiveablePayment);
                        // this.setSize(selected_currency.code)
                    } else{
                        var selected_currency=_.find(this.currency,(v)=>v.code==code);
                        var b = _.clone(Banks)
                        var accounts = this.accounts = b.filter((account) => {
                            return (new RegExp(selected_currency.code.toLowerCase())).test(account.code.toLowerCase())
                        })

                        this.receiveablePayment.push({
                            accounts: accounts,
                            defaultAccount: null,
                            selectedBank: null,
                            selectedCurrency: selected_currency,
                            paymentCurrency: selected_currency,
                            selected_rate: selected_currency.exchange_rate,
                            selected_rate1: selected_currency.exchange_rate,
                            static_rate: selected_currency.static_rate,
                            exchange_amount: 0,
                            exchange_amount: 0,
                            number: this.number,
                            ref_no: null
                        });

                    }

                    this.dynamicTime()
                    // console.log(123, selected_banks, selected_currency);
                },
                created() {
                    this.setRates();
                },
                methods: {
                    onSubmit() {
                        v.showModal = false;
                    },
                    contractWagon() {
                        this.wagon = this.wagonAll;
                        if (this.selectedContract) {
                            this.inventories = [
                                {item: null,inventory:null},
                                {item: null,inventory:null},
                                {item: null,inventory:null}
                            ];
                            this.wagon = this.wagonAll.filter((wagon) => {
                                return this.selectedContract.id == wagon.contract_id;
                            });

                        }
                    },
                    //BEGIN - Used for dynamic input time
                    dynamicTime()
                        {
                            this.time_interval = setInterval(() => {
                                const now = new Date()
                                @if(getHourType() == 24)
                                    const hours = now.getHours().toString().padStart(2,'0')
                                    const minutes = now.getMinutes().toString().padStart(2,'0') 
                                    // const seconds = now.getSeconds().toString().padStart(2,'0')
                                    this.dynamic_time = `${hours}:${minutes}`
                                @else
                                    const timeString = now.toLocaleTimeString('en-US',{hour:'numeric',minute:'numeric',hour12:true});
                                    this.dynamic_time = `${timeString}`
                                @endif
                                
                            },1000);
                        },
                        stopDynamicTime()
                        {
                            clearInterval(vm.time_interval)
                        },
                        changeTime()
                        {
                            vm.dynamic_time = vm.$refs.time_input.value
                        },
                    //END - Used for dynamic input time
                    
                    setRates() {

                        let c = _.clone(Currency);
                        let c1 = _.clone(Currency1);

                        Currency = [];
                        Currency1 = [];

                        c.forEach((a) => {

                            rates.forEach((rate) => {

                                if (a.code == rate.code)
                                    Currency.push({
                                        name: a.name,
                                        code: a.code,
                                        symbol: a.symbol,
                                        exchange_rate: rate.rate,
                                        rate: rate.rate,
                                        hq_rate: rate.hq_rate
                                    });
                            });
                        });

                        c1.forEach((a) => {
                            rates.forEach((rate) => {

                                if (a.code == rate.code)
                                    Currency1.push({
                                        name: a.name,
                                        code: a.code,
                                        symbol: a.symbol,
                                        exchange_rate: rate.rate,
                                        rate: rate.rate,
                                        hq_rate: rate.hq_rate
                                    });


                            });
                        });

                        // for ensuring for each currency rate is defined

                        c.forEach((a) => {

                            let found = false;
                            Currency.forEach((cur) => {
                                if (a.code == cur.code) {
                                    found = true;
                                    return;
                                }
                            });

                            if (!found) {
                                Currency.push({
                                    name: a.name,
                                    code: a.code,
                                    symbol: a.symbol,
                                    exchange_rate: 1,
                                    rate: 1,
                                    hq_rate: 1
                                });
                            }
                        });

                        c1.forEach((a) => {

                            let found = false;

                            Currency1.forEach((cur) => {
                                if(a.code == cur.code){
                                    found = true;
                                    return;
                                }

                            });

                            if (!found) {
                                Currency1.push({
                                    name: a.name,
                                    code: a.code,
                                    symbol: a.symbol,
                                    exchange_rate: 1,
                                    rate: 1,
                                    hq_rate: 1
                                });
                            }
                        });

                        this.currency = Currency;
                        this.currency1 = Currency1;

                    },
                    checkNo(number,index) {
                        vm.receiveablePayment[index].number = this.$refs.number[index].value;
                        var chack = 'false';
                        let contract_id = (v.selectedContract != undefined) ? v.selectedContract.id : '';
                        // var number = vm.number;
                        if (number != null) {
                            axios.get("{{route('callMethod.search')}}", {

                                    params: {
                                        number: number,
                                        method_name: 'Search_number',
                                        table_name: 'payments'
                                    },
                                })
                                .then(function(response) {
                                    // console.log(response.data.result);
                                    if (response.data.result != null) {
                                        // console.log(response.data.result);
                                        // vm.temp_items=response.data;
                                        vm.number_msg = "@lang('layout.DuplicateData')";
                                        vm.number_Error = true;
                                    } else {
                                        vm.number_msg = 'no';
                                        vm.number_Error = false;

                                    }
                                })
                                .catch(function(error) {
                                    console.log(error);
                                });

                        }
                    },
                    checkRefNo(ref_no) {

                        // console.log(12312,ref_no)
                        var chack = 'false';
                        // var ref_no = vm.ref_no;
                        if (ref_no != null) {
                            axios.get("{{route('callMethod.search')}}",
                                {
                                    params: {
                                        ref_no: ref_no,
                                        method_name: 'Search_ref_no',
                                        table_name: 'payments'
                                    },
                                })
                                .then(function (response) {
                                    // console.log(response.data.result);
                                    if (response.data.result != null) {
                                        console.log(response.data.result);
                                        // v.temp_items=response.data;
                                        vm.msg = "@lang('layout.DuplicateData')";
                                        vm.isError = true;
                                    }
                                    else {
                                        vm.msg = 'no';
                                        vm.isError = false;

                                    }
                                })
                                .catch(function (error) {
                                    console.log(error);
                                });

                        }
                    },

                    memberClassChange() {
                        if (vm.selected_class) {
                            vm.member = [];
                            vm.selectedMember = null;
                            let class_id = vm.selected_class.id;
                        
                            axios.get("{{route('callMethod.search')}}", {
                                params: {
                                    method_name: 'SearchMember',
                                    class_id: class_id
                                }
                            })
                            .then(function(response) {
                                if (response.data.length > 0) {
                                    // console.log(response.data);
                                    vm.member = [];
                                    vm.member = response.data;
                                }
                            })
                            .catch(function(error) {
                                console.log(error);
                            })
                        }
                    },
                    MemberSearch: _.debounce((search, loading) => {
                        loading(true);
                        let class_id = (vm.selected_class != undefined) ? vm.selected_class.id : null;
                        
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'SearchMember', 
                                keyword: search,
                                class_id: class_id
                            }
                        })
                        .then(function(response) {
                            if (response.data.length > 0) {
                                // console.log(response.data);
                                vm.member = [];
                                vm.member = response.data;
                            }
                            loading(false);
                        })
                        .catch(function(error) {
                            loading(false);
                            console.log(error);
                        })
                    }, getDebounceTime()),

                    handleSubmit(e) {
                        this.$validator.validate().then(valid => {
                            if (valid) {
                                // console.log(e);
                                // alert(e.target);
                                regForm(e.target);
                            }
                        });
                    },

                    clearFinger(fing) {
                        setTimeout((function () {
                            vm.fingerCounter = 0;
                            var finger = vm.finger;
                            if (finger) {
                                if (finger && fing == 'finger') {
                                    vm.selectedMember = null;
                                }
                                axios.get("{{route('callCheque.search')}}", {
                                        params: {
                                            method_name: 'clearFinger',
                                        }
                                    })
                                    .then(function(response) {
                                        if (response.data) {
                                            vm.getFinger(fing)
                                        } else {
                                            swal({ title:"{{__('message.FDeviceNotConn')}}", dangerMode: true});
                                        }
                                    })
                                    .catch(function(error) {
                                        swal({ title:"{{__('message.FDeviceNotConn')}}", dangerMode: true});
                                    });
                            }
                        }), 2e2);
                    },
                    getFinger(fing) {
                        var finger = vm.finger;
                        if (vm.fingerCounter < 20) {
                            vm.fingerCounter++; 
                            setTimeout((function () {
                                if (finger) {
                                    axios.get("{{route('callCheque.search')}}", {
                                            params: {
                                                method_name: 'getFinger',
                                            }
                                        })
                                        .then(function(response) {
                                            // console.log(12, response.data);
                                            if (response.data) {
                                                axios.get("{{route('callMethod.search')}}", {
                                                    params: {
                                                        method_name: 'SearchMember', 
                                                        id: response.data,
                                                    }
                                                })
                                                .then(function(response1) {
                                                    if (response1.data) {
                                                        if (finger && fing == 'finger') {
                                                            vm.selectedMember = response1.data;
                                                            vm.selectMem = 'v_select_success';
                                                        }
                                                    }
                                                })
                                            } else {
                                                vm.getFinger(fing);
                                            }
                                        })
                                        .catch(function(error) {
                                            vm.getFinger(fing);
                                            console.log(error);
                                        });
                                }
                            }), 3e3);
                        } else {
                            if (finger && fing == 'finger') {
                                vm.selectMem = 'v_select_danger';
                            }
                            
                            swal({ title:"{{__('message.FDeviceNotConn')}}", dangerMode: true});
                        }
                    },

                    get_exchange() {
                        let vm = this;
						if(vm.selected_rate > 0){
                            @if(systemConfig()[30] == 1)
							// vm.exchange_amount = myRound((vm.amount* vm.selected_rate1)/vm.selected_rate);  
                            vm.exchange_amount = myRound(((vm.amount / vm.selectedCurrency.static_rate * vm.selected_rate) * vm.paymentCurrency.static_rate) / vm.selected_rate1);
                            @else 
							vm.exchange_amount = myRound((vm.amount* vm.selected_rate1)/vm.selected_rate);
                            @endif
						
                        }
                    },
                    get_exchange_row(index) {
                        let vm = this;
						if(vm.receiveablePayment[index].selected_rate > 0){
                            @if(systemConfig()[30] == 1)
                            // vm.receiveablePayment[index].exchange_amount = myRound((vm.receiveablePayment[index].amount* vm.receiveablePayment[index].selected_rate1)/vm.receiveablePayment[index].selected_rate);
                            vm.receiveablePayment[index].exchange_amount = myRound(((vm.receiveablePayment[index].amount / vm.receiveablePayment[index].selectedCurrency.static_rate * vm.receiveablePayment[index].selected_rate) * vm.receiveablePayment[index].paymentCurrency.static_rate) / vm.receiveablePayment[index].selected_rate1);
                            @else 
                            vm.receiveablePayment[index].exchange_amount = myRound((vm.receiveablePayment[index].amount* vm.receiveablePayment[index].selected_rate1)/vm.receiveablePayment[index].selected_rate);
                            @endif
                        }
                    },
                    set_rate_row(index) {
                        let vm = this;
                        if (vm.receiveablePayment[index].paymentCurrency.code == vm.receiveablePayment[index].selectedCurrency.code) {
                            if (vm.receiveablePayment[index].exchange_amount > 0 && vm.receiveablePayment[index].amount > 0) {
                                vm.receiveablePayment[index].amount = myRound(vm.receiveablePayment[index].exchange_amount);
                            }
                        } else if (vm.receiveablePayment[index].paymentCurrency.code == vm.code && !vm.change_amount) {
                            if (vm.receiveablePayment[index].exchange_amount > 0 && vm.receiveablePayment[index].amount > 0) {
                                @if(systemConfig()[30] == 1)
                                vm.receiveablePayment[index].selected_rate = Number.parseFloat((vm.receiveablePayment[index].exchange_amount / vm.receiveablePayment[index].amount) * vm.receiveablePayment[index].selectedCurrency.static_rate).toFixed(7);
                                @else 
                                vm.receiveablePayment[index].selected_rate = Number.parseFloat((vm.receiveablePayment[index].amount) / (vm.receiveablePayment[index].exchange_amount)).toFixed(10);
                                @endif
                            }
                        } else {
                            if (vm.receiveablePayment[index].exchange_amount > 0) {
                                // console.log(vm.change_amount, vm.receiveablePayment[index].selected_rate1 , vm.receiveablePayment[index].selected_rate);
                                if (vm.change_amount && vm.receiveablePayment[index].selected_rate1 > 0 && vm.receiveablePayment[index].selected_rate > 0) {
                                    @if(systemConfig()[30] == 1)
                                    vm.receiveablePayment[index].amount = myRound(((vm.receiveablePayment[index].exchange_amount / vm.receiveablePayment[index].paymentCurrency.static_rate * vm.receiveablePayment[index].selected_rate1) * vm.receiveablePayment[index].selectedCurrency.static_rate) / vm.receiveablePayment[index].selected_rate);
                                    @else 
                                    vm.receiveablePayment[index].amount = myRound((vm.receiveablePayment[index].exchange_amount / vm.receiveablePayment[index].selected_rate1) * (vm.receiveablePayment[index].selected_rate));
                                    // vm.receiveablePayment[index].amount = myRound((vm.receiveablePayment[index].exchange_amount / vm.receiveablePayment[index].selected_rate1) * (vm.receiveablePayment[index].selected_rate));
                                    @endif
                                } else {
                                    
                                    @if(systemConfig()[30] == 1)
                                    // vm.receiveablePayment[index].selected_rate1 = Number.parseFloat((vm.receiveablePayment[index].exchange_amount) / (vm.receiveablePayment[index].amount / vm.receiveablePayment[index].selected_rate)).toFixed(10);
                                    vm.receiveablePayment[index].selected_rate1 = Number.parseFloat(((vm.receiveablePayment[index].amount / vm.receiveablePayment[index].selectedCurrency.static_rate * vm.receiveablePayment[index].selected_rate) / vm.receiveablePayment[index].exchange_amount) * vm.receiveablePayment[index].paymentCurrency.static_rate).toFixed(7);
                                    @else 
                                    vm.receiveablePayment[index].selected_rate1 = Number.parseFloat((vm.receiveablePayment[index].exchange_amount) / (vm.receiveablePayment[index].amount / vm.receiveablePayment[index].selected_rate)).toFixed(10);
                                    @endif
                                }
                            }
                        }
                    },
                    set_rate() {
						if(vm.exchange_amount > 0){
							vm.selected_rate1 = Number.parseFloat((vm.exchange_amount)/ (vm.amount / vm.selected_rate)).toFixed(10);
						}
                    },
                    saveAndNew() {
                        this.$validator.validate()
                            .then(valid => {
                                if (valid) {
                                    vm.disabled = true;
                                    var url = "{{route('pay.store')}}";
                                    form_id = 'pay-submit';
                                    var data = $('#' + form_id).serialize();

                                    axios.post(url, data)
                                        .then(function (response) {
                                            if (response.data.result == 1) {
                                                $('#' + form_id).trigger('reset');
                                                toastr.success('', response.data.message);
                                                vm.number = Number(vm.old_number) + 1;
                                                vm.old_number = Number(vm.old_number) + 1;
                                                vm.amount = null;
                                                vm.ref_no = null; 
                                                // vm.selectedMember = null;
                                                location.reload();
                                            }
                                            else {
                                                var message = "{{__('message.Warning')}}";
                                                vm.disabled = false;
                                                //$('#error-sound')[0].play();
                                                toastr.warning('', message);
                                            }
                                        })
                                        .catch(function (error) {
                                            vm.disabled = false;
                                            console.log(error);
                                            var message = "{{__('message.Warning')}}";
                                            //$('#error-sound')[0].play();
                                            toastr.warning('', message);
                                        });

                                }
                            })
                    },


                    getSummary() {
                        if (this.selectedMember) {
                            this.farmer_contract_list = [];
                            this.selectedFarmerContract = null;

                            this.getSummaryRecor(this.selectedMember.id, this);
                            this.take_farmer_contract_data(this);
                            this.take_carpet_contract_data(this);

                        }

                    },
                    getSummaryRecor(id, vm) {
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'memberStatment',
                                member_id: id,
                            }
                        })
                            .then(function (response) {

                                if (response.data.length > 0) {
                                    vm.summary = response.data;
                                }
                                else{
                                        vm.summary=[];
                                    }
                            })
                            .catch(function (error) {
                                console.log(error);
                            });
                    },
                    take_farmer_contract_data(vm) {
                        axios.get("{{route('member.farmerContract')}}", {
                            params: {
                                member_id: this.selectedMember.id
                            },
                        }).then(function (response) {
                            vm.farmer_contract_list = response.data;
                        })
                        .catch(function (error) {
                            console.log(error);
                        });
                    }, 
                    take_carpet_contract_data(vm) {
                        vm.carpet_contract_list = [];
                        vm.selectedCarpetContract = null;

                        axios.get("{{route('carpetContract.member')}}", {
                            params: {
                                member_id: vm.selectedMember.id
                            },
                        }).then(function (response) {
                            vm.carpet_contract_list = response.data;
                        })
                        .catch(function (error) {
                            console.log(error);
                        });
                    }, 
                    setSize(selected_code) {
                        this.paymentCurrency = this.selectedCurrency;
                        this.selected_rate = this.selectedCurrency.exchange_rate;
                        this.selected_rate1 = this.selectedCurrency.exchange_rate;
                        if (selected_code == this.code) {
                            this.currency_len = 'col-md-12';
                            this.rate_len = 'col-md-0';
                        }
                        else {
                            this.currency_len = 'col-md-6';
                            this.rate_len = 'col-md-6';
                        }
                        this.pcurrency_len = this.currency_len;
                        this.prate_len = this.rate_len;
                    },
                    setSizeRow(selected_code,index) {
                        vm.averageRate = false;
                        
                        var b = _.clone(Banks)
                        var accounts = this.accounts = b.filter((account) => {
                            return (new RegExp(selected_code.toLowerCase())).test(account.code.toLowerCase())
                        })
                        vm.receiveablePayment[index].accounts = accounts;
                        vm.receiveablePayment[index].defaultAccount = null;
                        vm.receiveablePayment[index].selectedBank = null;
                        vm.receiveablePayment[index].paymentCurrency = vm.receiveablePayment[index].selectedCurrency;
                        vm.receiveablePayment[index].selected_rate = vm.receiveablePayment[index].selectedCurrency.exchange_rate;
                        vm.receiveablePayment[index].selected_rate1 = vm.receiveablePayment[index].selectedCurrency.exchange_rate;
                        // console.log(999,vm.receiveablePayment[index]);
                    },
                    setPaymentSizeRow(selected_code,index) {
                        if (vm.receiveablePayment[index].selectedCurrency.code == vm.receiveablePayment[index].paymentCurrency.code) {
                            vm.receiveablePayment[index].selected_rate1 = vm.receiveablePayment[index].selected_rate;
                        } else {
                            vm.receiveablePayment[index].selected_rate1 = vm.receiveablePayment[index].paymentCurrency.exchange_rate;
                        }
                    },
                    setPaymentSize(selected_code) {
                        // this.selected_rate = this.paymentCurrency.exchange_rate;
                        this.selected_rate1 = this.paymentCurrency.exchange_rate;

                        if (selected_code == this.code) {
                            this.pcurrency_len = 'col-md-12';
                            this.prate_len = 'col-md-0';
                        }
                        else {
                            this.pcurrency_len = 'col-md-6';
                            this.prate_len = 'col-md-6';
                        }
                    },
                    check_code(code, index) {
                        if (vm.receiveablePayment[index].paymentCurrency.code == vm.receiveablePayment[index].selectedCurrency.code) {
                            vm.receiveablePayment[index].selected_rate1 = vm.receiveablePayment[index].selected_rate;
                        }

                    },
                    test(defaultAccount) {
                        for (var x in this.bankes) {
                            for (z in this.bankes[x]) {
                                if (this.bankes[x][z] == defaultAccount && z == 'id') {
                                    this.selectedBank = this.bankes[x];
                                    break;
                                }
                            }

                        }
                    
                        // if (this.selectedBank.balance<=0 ) {

                        //     this.isError = true;
                        // }
                    
                        // else{
                        //     this.isError = false;
                        // }
                    

                    },
                    getDefaultAccount(defaultAccount,index) {
                        this.averageRate = false;
                        for (var x in this.bankes) {
                            for (z in this.bankes[x]) {
                                if (this.bankes[x][z] && defaultAccount) {
                                    if (this.bankes[x][z] == defaultAccount && z == 'id') {
                                        vm.receiveablePayment[index].selectedBank = this.bankes[x];

                                        @if(getAverageRate() =="true")
                                        if (this.bankes[x].avg_rate) {
                                            this.averageRate = true;
                                            vm.receiveablePayment[index].selected_rate = this.bankes[x].avg_rate;
                                            vm.receiveablePayment[index].selected_rate1 = this.bankes[x].avg_rate;
                                        }
                                        @endif

                                        break;
                                    }
                                }
                            }

                        }
                    },

                    // generic function for adding item to list
                    addNew(type = null, index) {
                        if (type != null) {
                            if (type == 'pay') {
                                if (this.receiveablePayment[index + 1] == undefined) {
                                    var selected_currency=_.find(this.currency,(v)=>v.code==code);
                                    
                                    var b = _.clone(Banks)
                                    var accounts = this.accounts = b.filter((account) => {
                                        return (new RegExp(selected_currency.code.toLowerCase())).test(account.code.toLowerCase())
                                    })

                                    this.receiveablePayment.push({
                                        accounts: accounts,
                                        defaultAccount: null,
                                        selectedBank: null,
                                        selectedCurrency: selected_currency,
                                        paymentCurrency: selected_currency,
                                        selected_rate: selected_currency.exchange_rate,
                                        selected_rate1: selected_currency.exchange_rate,
                                        exchange_amount: 0,
                                        exchange_amount: 0,
                                        number: this.number,
                                        ref_no: null
                                    });

                                }
                            }
                        }

                    },

                    // delete item from list
                    deleteItem(type = null, index) {
                        if (type != null) {
                            if (type == 'pay') {
                                this.receiveablePayment.splice(index, 1);
                            }
                        }

                    },

                }
            });
    </script>


@endpush
 