@extends('layouts.app')
@section('content')
@section('style')
<style type="text/css">
    .pay{
        margin-top: 12%;
    }
</style>
@stop
    <div class="row">
        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.EditPayroll') </span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools">
                </div>
            </div>
            <div class="portlet-body form" id="item-service" style="margin-bottom: 30%;">
                 {!! Form::model($payroll,['method' => 'PATCH','route' => ['payrollFromAttendance.update',$payroll->id]]) !!}
                <div class="form-body">
                    <div id="app" v-cloak>
                        <div class="row"> 
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="control-label"> @lang('layout.EmployeeName')</label>
                                   <v-select @input="getSalary"  placeholder="@lang('layout.SelectEmployee')" label="name"
                                            v-model="selectedEmployee"
                                            disabled>       
                                    </v-select>
                                    <input type="hidden" name="sal_id" v-model.salnumer="(!selectedEmployee)?null:selectedEmployee.sal_id">
                                    <input type="hidden" name="member_id" v-model.number="(!selectedEmployee)?null:selectedEmployee.id">
									<input type="hidden" name="employee" v-model.number="(!selectedEmployee)?null:selectedEmployee.id"  v-validate="'required'" data-vv-as="@lang('layout.Employee')">
                                    
                                </div>
                            </div>
                           <div class="col-md-5">
                                <div class="form-group">
                                    <label class="control-label"> @lang('layout.Date')</label>
                                    <div class="input-group">
                                        {{Form::text('From_Date',null,['class' => 'form-control ','id'=>'range-from-example','readonly'])}}
                                        <span class="input-group-addon">@lang('layout.To') </span>
                                        {{Form::text('To_Date',null,['class' => 'form-control ','id'=>'range-to-example','readonly'])}}
                                        <!-- <input type="hidden" id="to_date" name="to_date"> -->
                                    </div>
                                </div>
                            </div>
							<div class="col-md-1">
								<div class="form-group">
								<label class="control-label">@lang('layout.Hourly')   
								<input type="checkbox" name="hourly"  v-model="hourly" class="form-control">
								</label>
								</div>
                            </div>
                            <div class="col-lg-3 col-md-3 col-sm-3 col-xs-12">
							    <div class="form-group">
									<label class="control-label">@lang('layout.Date')</label>
									{{Form::text('date',$payroll->Date,['class' => 'form-control date','id'=>'date','autocomplete'=>'off'])}}
								</div>
						    </div> 
                        </div>
                        <div class="row" v-if="selectedEmployee && selectedEmployee.attendance_type =='daily'">
                            <div class="col-md-6" > 
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="control-label">@lang('layout.BasicSalary')</label>
                                            <div class="input-group">
                                                <input type="number" class="form-control" name="basicSalary" :value="(!selectedEmployee)?null:selectedEmployee.amount" >
                                                <input type="hidden" name="sal_id" v-model.salnumer="(!selectedEmployee)?null:selectedEmployee.sal_id">            
                                                <input type="hidden" name="sal_currency" v-model.salnumer="(!selectedEmployee)?null:selectedEmployee.currency">
                                                <span class="input-group-addon">@{{(selectedEmployee)?selectedEmployee.currency:null}}</span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6" >
                                        <span v-if="(selectedEmployee && selectedEmployee.currency != '{{getHomeCurrency()["code"]}}')?selectedEmployee.currency:null">
                                            <div class="form-group">
                                                <label class="control-label">@lang('layout.SalaryRate') </label>
                                                <div :class="{'has-error':selectedCurrency.rate < 0}">
                                                    <div class="input-group">
                                                        <input v-model="selectedEmployee.rate" class="form-control" name="salaryRate"
                                                               type="number" min="0" step="any">
                                                        <span class="input-group-addon">@{{(selectedEmployee)?selectedEmployee.currency:null}}</span>
                                                    </div>
                                                </div>
                                            </div>
                                        </span>
                                    </div>
                                    <div class="col-md-6" >
                                        <div class="form-group">
                                            <label class="control-label">@lang('layout.Currency')</label>
                                            <v-select  label="code" :options="currency" v-model="selectedCurrency"></v-select>
                                        </div>
                                    </div>
                                    <input type="hidden" name="payroll_currency" v-bind:value="selectedCurrency.code"/>
                                    <div class="col-md-6" v-if="selectedCurrency.code != '{{getHomeCurrency()["code"]}}'">
                                        <div class="form-group">
                                            <label class="control-label">@lang('layout.PaymentRate') </label>
                                                <div :class="{'has-error':selectedCurrency.rate < 0}">
                                                    <div class="input-group">
                                                    <input  v-model="selectedCurrency.exchange_rate" class="form-control"
                                                           type="number" min="0" step="any">
                                                    <span class="input-group-addon">@{{selectedCurrency.code}}</span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <input type="hidden" name="currency_rate" :value="selectedCurrency.exchange_rate">
                                </div>
                            </div> 
                            <div class="col-md-6" > 
                                <div class="row">
                               
                                    <div class="col-md-6">
                                         <div class="form-group">
                                             <label class="control-label">@lang('layout.PaidLeave')</label>
                                             {{Form::number('paidLeave',null,['class' => 'form-control','step' => 'any','min' =>'0','v-model'=>'paidLeave'])}}
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                         <div class="form-group">
                                            <label class="control-label"> @lang('layout.WorkedDay')</label>
                                             {{Form::number('workedDay',null,['class' => 'form-control','step' => 'any','min' =>'0','v-model'=>'workdays'])}}
                                        </div>
                                    </div>
									
									
									<div class="col-md-6" v-if="hourly">
                                         <div class="form-group">
                                             <label class="control-label">@lang('layout.HourNo')</label>
                                             {{Form::number('hourlyStatick',null,['class' => 'form-control','step' => 'any','min' =>'0','v-model'=>'hourlyStatick','v-validate' =>'"required"','data-vv-as' => __('layout.HourNo')])}}

                                             <span class="required">@{{ errors.first('hourlyStatick') }}</span>
                                        </div>
                                    </div>
                                    <div class="col-md-6" v-if="hourly">
                                         <div class="form-group">
                                            <label class="control-label"> @lang('layout.WorkedHour')</label>
                                             {{Form::number('hourlyAtt',null,['class' => 'form-control','step' => 'any','min' =>'0','v-model'=>'hourlyAtt','v-validate' =>'"required"','data-vv-as' => __('layout.WorkedHour'),'readonly'])}}
                                             <span class="required">@{{ errors.first('hourlyAtt') }}</span>

                                        </div>
                                    </div>
									
                                </div> 
                            </div> 
                        </div>

                        <div class="row" v-if="selectedEmployee && (overtime_amount||delay_amount)">
                            <div class="col-md-6">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                                <label class="control-label">@lang('layout.OvertimeAmount')</label>
                                            <input type="number" class="form-control" name="overtime_amount"  :value="overtime_amount" readonly>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                                <label class="control-label">@lang('layout.DelayAmount')</label>
                                            <input type="number" class="form-control" name="delay_amount" :value="delay_amount" readonly>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="row" v-if="selectedEmployee && selectedEmployee.attendance_type =='daily'">
                            <div class="col-md-6">
                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="form-group">
                                             <label class="control-label">@lang('layout.Rent')</label>
                                            <input type="number" class="form-control" :value="rent" readonly>
                                            <input type="hidden" class="form-control" name="rent" :value="rents" readonly>
                                        </div>
                                    </div>
									<div class="col-md-4">
                                        <div class="form-group">
                                             <label class="control-label">@lang('layout.TotalOverTime')</label>
                                            <input type="number" class="form-control" name="overtime" :value="overtime" readonly>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                         <div class="form-group">
                                             <label class="control-label">@lang('layout.NetPayable')</label>
                                             {{Form::number('Net_Payable',null,['class' => 'form-control','step' => 'any','min' =>'0',':value'=>'netPayable','readonly'])}}
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="row">
								
                                    <div class="col-md-6">
                                         <div class="form-group">
                                            <label class="control-label">@lang('layout.ExpenseAccount')</label>
                                            {{Form::select('expense_id',$expense,null,['class' => 'form-control'])}}
                                        </div>
                                    </div> 
                                    <div class="col-md-6">
                                         <div class="form-group">
                                            <label class="control-label"> @lang('layout.Description')</label>
                                            {!! Form::textarea('description', null, array('placeholder' => __('layout.Description'),'class' => 'form-control','rows' => 2, 'cols' => 30)) !!}
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

						<div class="row" v-if="selectedEmployee && selectedEmployee.attendance_type!='daily'">
                           
                                
                          
                            <div class="col-md-12" > 
                                <div class="row">
                                      <div class="col-md-3">
                                        <div class="form-group">
                                            <label class="control-label">@lang('layout.BasicSalary')</label>
                                            <div class="input-group">
                                                <input type="number" class="form-control" name="basicSalary" v-model="(!salary)?null:salary.amount" >

                                                 <input type="hidden" name="sal_id" v-model.salnumer="(!selectedEmployee)?null:selectedEmployee.sal_id">

                                                 <input type="hidden" name="sal_currency" v-model.salnumer="(!selectedEmployee)?null:selectedEmployee.currency">
                                                  <span class="input-group-addon">@{{(selectedEmployee)?selectedEmployee.currency:null}}</span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-3" >
                                        <span v-if="(selectedEmployee && selectedEmployee.currency != '{{getHomeCurrency()["code"]}}')?selectedEmployee.currency:null">
                                            <div class="form-group">
                                                <label class="control-label">@lang('layout.SalaryRate') </label>
                                                <div :class="{'has-error':selectedCurrency.rate < 0}">
                                                    <div class="input-group">
                                                        <input v-model="selectedEmployee.rate" class="form-control" name="salaryRate"
                                                               type="number" min="0" step="any">
                                                        <span class="input-group-addon">@{{(selectedEmployee)?selectedEmployee.currency:null}}</span>
                                                    </div>
                                                </div>
                                            </div>
                                        </span>
                                    </div>

                                    <div class="col-md-3" >
                                        <div class="form-group">
                                            <label class="control-label">@lang('layout.Currency')</label>
                                           

                                               <v-select  label="code" :options="currency" v-model="selectedCurrency"></v-select>
                                             
                                           

                                        </div>
                                    </div>      

                                    <input type="hidden" name="payroll_currency" v-bind:value="selectedCurrency.code"/>
                                    <div class="col-md-3" v-if="selectedCurrency.code != '{{getHomeCurrency()["code"]}}'">
                                        <div class="form-group">
                                            <label class="control-label">@lang('layout.PaymentRate') </label>
                                                <div :class="{'has-error':selectedCurrency.rate < 0}">
                                                    <div class="input-group">
                                                    <input  v-model="selectedCurrency.exchange_rate" class="form-control"
                                                           type="number" min="0" step="any">
                                                    <span class="input-group-addon">@{{selectedCurrency.exchange_rate}}</span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <input type="hidden" name="currency_rate" :value="selectedCurrency.exchange_rate">

                                </div>
                            </div> 
                            <div class="col-md-6" > 
                                <div class="row">
                              
                                    

                                    <div class="col-md-6">
                                         <div class="form-group">
                                             <label class="control-label">@lang('layout.Fee')</label>
                                             {{Form::number('PresentsHS',null,['class' => 'form-control','step' => 'any','min' =>'0','v-model'=>'PresentsHS ','v-validate' =>'"required"','data-vv-as' => __('layout.PaidLeave'),'readonly'])}}

                                             <span class="required">@{{ errors.first('paidLeave') }}</span>
                                        </div>
                                    </div>
                                </div> 
                            </div> 
                        </div>

						<div class="row" v-if="selectedEmployee && selectedEmployee.attendance_type !='daily'">
                            <div class="col-md-6">
                                <div class="row">
									<div class="col-md-6">
                                        <div class="form-group">
                                             <label class="control-label">@lang('layout.TotalOverTime')</label>
                                            <input type="number" class="form-control" name="overtime" :value="overtime" readonly>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                         <div class="form-group">
                                             <label class="control-label">@lang('layout.NetPayable')</label>
                                            <input type="number" class="form-control"  name="netPayableNotDaily" :value="netPayableNotDaily.toFixed(3)" step="any" readonly="readonly">
                                        </div>
                                    </div>
                                    
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="row">
								    <div class="col-md-6">
                                         <div class="form-group">
                                            <label class="control-label">@lang('layout.ExpenseAccount')</label>
                                            {{Form::select('expense_id',$expense,null,['class' => 'form-control','v-validate' =>'"required"','data-vv-as' => __('layout.ExpenseAccount')])}}
                                             <span class="required">@{{ errors.first('expense_id') }}</span>

                                        </div>
                                    </div> 
                                    <div class="col-md-6">
                                         <div class="form-group">
                                            <label class="control-label"> @lang('layout.Description')</label>
                                            {!! Form::textarea('description', null, array('placeholder' => __('layout.Description'),'class' => 'form-control','rows' => 2, 'cols' => 30)) !!}
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
						<div class="row">
                            @if(systemConfig()[5] != 0 )
                                <div class="col-md-3"> 
                                    <label class="control-label">@lang('layout.Project')</label>
                                    <v-select class="vue-select2" label="name" @search="ProjectSearch"
                                            :options="project_list" v-model="selectedProject">
                                    </v-select>
                                    <input type="hidden" name="project_id" v-model.number="(!selectedProject)?null:selectedProject.project_id">
                                </div>
                            @endif
                            @if(systemConfig()[19] == 1)
                                <div class="col-md-3"> 
                                    <label class="control-label">@lang('layout.NGOProject')</label>
                                    <v-select class="vue-select2" label="name" @search="searchNgoProjects" :options="NgoProject_list" v-model="selectedNgoProject">
                                    </v-select>
                                    <input type="hidden" name="ngo_project_id" v-model.number="(!selectedNgoProject)?null:selectedNgoProject.id">
                                </div>
                            @endif
                            @if(systemConfig()[20] == 1)
                            <div class="col-md-2" v-if="!contract_percentage" > 
                                <label class="control-label">@lang('menu.Contract')</label>
                                <v-select class="vue-select2" 
                                        @search="searchContracts"
                                        v-model="selectedContract" label="company_name"
                                        :options="contract_list">
                                </v-select>
                                <input type="hidden" name="contract_id" v-model.number="(!selectedContract)?null:selectedContract.id" />
                            </div>
                            @endif
                            <div class="col-lg-2 col-md-12 col-sm-12 col-xs-12">
                                <div class="form-group">
                                    <div style="display: flex; flex-direction: column; justify-content: center; align-items: center;">
                                        <label class="control-label">@lang('layout.BuildExpense')</label>
                                        <input type="checkbox" name="build_expense_confirm" @checked($payroll->build_expense_confirm) id="" value="On">
                                    </div>
                                </div>
                            </div>
                            @if(systemConfig()[20] == 1)
                            <div class="col-md-2">
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <div style="display: flex; flex-direction: column; justify-content: center; align-items: center;">
                                                <label class="control-label">@lang('layout.MultiContract')</label>
                                                <input type="checkbox" name="contract_percentage" v-model="contract_percentage" @checked($payroll->contract_percentage) value="on">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            @endif

                        </div>



                        <hr>
                        <!-- begin tax -->
                        <div class="row">
                             <input type="checkbox" name="tax" v-model="tax">
                                        @lang('layout.Tax')
                            <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12" v-if="tax">
                                <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                    <div class="col-md-12">
                                        <label class="control-label ">@lang('layout.TaxCurrency')</label>
                                        <v-select  label="code" :options="taxCurrency" v-model="selectedTaxCurrency"></v-select>
                                        <input type="hidden" name="tax_currency" class="form-control" v-validate="'required'"
                                                       data-vv-as="@lang('layout.TaxCurrency')" :value=(!selectedTaxCurrency)?null:selectedTaxCurrency.code>
                                        <span class="required">@{{ errors.first('tax_currency') }}</span>
                                    </div>
                                </div>

                                <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                    <div class="col-md-12">
                                        <label class="control-label ">@lang('layout.Rate')</label>
                                       
                                        <input type="number" name="tax_rate" class="form-control" v-validate="'required'"
                                                       data-vv-as="@lang('layout.Rate')" v-model=(!selectedTaxCurrency)?null:selectedTaxCurrency.rate>
                                        <span class="required">@{{ errors.first('tax_currency') }}</span>
                                    </div>
                                </div>

                                <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                    <div class="col-md-12">
                                        <label class="control-label ">@lang('layout.PaymentType')</label>
                                        <br>
                                        <input type="checkbox" readonly name="by_employee" v-model="paymentType">
                                        @lang('layout.ByEmployee')
                                        
                                    </div>
                                </div>
                                <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <label class="control-label"> @lang('layout.AgencyTax')</label>
                                       <v-select   placeholder="@lang('layout.SelectEmployee')" label="name"
                                                v-model="selectedMember"
                                                {{-- @search="MemberSearch"  --}}
                                                @search="onAgencySearch"
                                             :options="members"
                                             >       
                                        </v-select>
                                        <input type="hidden" name="tax_member" v-model.number="(!selectedMember)?null:selectedMember.id" >
                                    </div>
                                </div>
                                  <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                         <div class="form-group">
                                             <label class="control-label"> @lang('layout.ExpenseAccount')</label>
                                            <v-select   placeholder="@lang('layout.ExpenseAccount')" label="name"
                                                v-model="selected_tax_expense"
                                             :options="{{$expense_tax}}">       
                                            </v-select>
                                            <input type="hidden" name="selected_tax_expense" v-model="(!selected_tax_expense)?null:selected_tax_expense.id" >



                                        </div>
                                </div>

                            </div>
                        </div>
                        <!-- end tax -->


                        <br/>
                        <br/>
                        @if(systemConfig()[20] == 1)
                        <!-- begin multiContract -->
                        <table v-if="contract_percentage" id="table_content" class="table table-striped table-bordered table-advance table-hover">
                            <thead>
                                <tr>
                                    <th class="text-center" style="min-width: 8px;"> #</th>
                                    <th class="text-center" style="min-width: 160px;">@lang('layout.ContractName')</th>
                                    <th class="text-center" style="min-width: 160px;">@lang('layout.Percentage')</th>
                                    <th></th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr v-for="(record,index) in multiContractData">
                                    <td class="text-center">@{{index+1}}</td>
                                    <td class="highlight">
                                        <v-select class="vue-select2" placeholder="@lang('layout.Select')"
                                                v-model="record.selected" 
                                                label="company_name"
                                                @search="searchContracts"
                                                :options="contract_list" @click.native="addNew('multiContract',index)" >
                                        </v-select>
                                        <input type="hidden" name="multiContract_id[]" :value="(record.selected==null)?null:record.selected.id">
                                    </td>

                                    <td>
                                        <input class="form-control" type="number" name="percentage[]"
                                            v-model.number="record.percentage" placeholder="@lang('layout.Percentage')">
                                    </td>

                                    <td class="text-center" style="vertical-align: middle;">
                                        <span v-on:click="deleteItem('multiContract',index)"><i class="paddint-both glyphicon glyphicon-trash text-danger" style="cursor: pointer;"></i></span>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                        <!-- end multiContract -->
                        @endif



                    </div>
                    <!--/row-->
                </div>
                <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                     <button type="button" onclick="regForm(this)" class="btn green">@lang('layout.Submit')</button>
                    
                     <a href="{{route('payroll.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
               </div> 
             {{Form::close()}}
            </div>               
            <!-- END FORM-->
        </div>
    </div> 
@endsection
@push('scripts')
 
<script>

      @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
    Vue.use(VeeValidate, {
        locale: 'en',
    });
    @endif 
      ////
      var employeePayrollTax= {!! $employeePayrollTax !!};
     Vue.component("v-select", VueSelect.VueSelect);
        var Currency ={!! $currency!!}
        var selectedCurrency ={!! $selectedCurrency!!}
        var multiContractData ={!! $multiContractData!!}
        var app = new Vue({
            el: '#app',
            data: {
            selectedCurrency:selectedCurrency,
            currency:Currency,
            currencyList: Currency,
            contract_percentage:null,
            multiContractData: [],
            members:[],
            selectedMember: {!! $selectedMember !!},
            taxCurrency:[{!! $taxCurrency !!}],
            selectedTaxCurrency:{!! $taxCurrency !!},
            paymentType:1,
            tax:0,
            selected_tax_expense:{!!$selected_tax_expense!!},
            workdays:{!!$payroll->Worked_Days!!},
            selectedProject:{!!$project!!},
            project_list: [],
            selectedNgoProject:{!!$ngo_project!!},
            NgoProject_list: [],
            selectedBank:null,
            salary:null,
            employee:{!! $payroll->member_id !!},
            payroll:{!! $payroll !!},
            selectedEmployee:{!! json_encode($selected_employee) !!},
            paidLeave:{!!$payroll->Paid_Leave!!},
            type:'{!!$payroll->type!!}',
            salaryType:'{!!$payroll->salaryType!!}',
            amount:0,
            fee:0,
            advancePaid:0,
            hourlyAtt:{!! $payroll->worked_hour !!},
            hourlyStatick:{!! $payroll->static_time !!},
            overtime:{!! $payroll->overtime_addition !!},
            overtimes:{!! $payroll->overtime_addition !!},
            hourly:"{!! $payroll->hourly !!}",
			Presents  :null,
            PresentsHS:{!!$payroll->Worked_Days!!},
            Absent    :null,
            AbsentHS :null,
            total_justified_absent:null,
            num_days:{!! $num_days !!},
			rent  :0,
            rents  :0,
            overtime_amount:0,
            delay_amount:0,
            total_overtime_amount:0,
            total_delay_amount:0,
            employeePayrollTax:employeePayrollTax, 
            employeess: [],
            employees: {!! $employee !!},
            selectedContract:{!! $selectedContract !!},
            contract_list:[]
            },
            watch: {

            },
            computed:{ 
				netPayable()
                        { 
                            var total=0;
                            var workdays   = parseFloat((this.workdays)?this.workdays:0) 
                            var paidLeave  = parseFloat((this.paidLeave)?this.paidLeave:0)
                            var num_days  = parseFloat((this.num_days)?this.num_days:1)
                            var amount     = parseFloat((this.amount)?this.amount:0);
                            var fee        = parseFloat((this.fee)?this.fee:0);
                            var hourlyStatick = parseFloat((this.hourlyStatick)?this.hourlyStatick:0);
                            var hourlyAtt = parseFloat((this.hourlyAtt)?this.hourlyAtt:0);
                            @if(systemConfig()[30] == 1)
                            var overtime  = (this.overtimes * this.selectedCurrency.static_rate / this.selectedCurrency.exchange_rate);
							this.overtime  = (this.overtimes * this.selectedCurrency.static_rate / this.selectedCurrency.exchange_rate);
                            @else 
                            var overtime  = (this.overtimes * this.selectedCurrency.exchange_rate);
							this.overtime  = (this.overtimes * this.selectedCurrency.exchange_rate);
                            @endif

                            @if(systemConfig()[30] == 1)
                            var rent  = (((this.rents / this.selectedEmployee.static_rate * this.selectedEmployee.rate) * this.selectedCurrency.static_rate / this.selectedCurrency.exchange_rate) / this.selectedEmployee.rate);
                            @else 
							var rent  = ((this.rents * this.selectedCurrency.exchange_rate) / this.selectedEmployee.rate);
                            @endif

							this.rent  = rent;

                            @if(systemConfig()[30] == 1)
                            var overtime_amount = (((this.overtime_amount / this.selectedEmployee.static_rate * this.selectedEmployee.rate) * this.selectedCurrency.static_rate / this.selectedCurrency.exchange_rate) / this.selectedEmployee.rate);
                            @else 
                            var overtime_amount = (this.overtime_amount * this.selectedCurrency.exchange_rate)/ this.selectedEmployee.rate;
                            @endif

                            @if(systemConfig()[30] == 1)
                            var delay_amount    = (((this.delay_amount / this.selectedEmployee.static_rate * this.selectedEmployee.rate) * this.selectedCurrency.static_rate / this.selectedCurrency.exchange_rate) / this.selectedEmployee.rate);
                            @else 
                            var delay_amount    = (this.delay_amount* this.selectedCurrency.exchange_rate)/ this.selectedEmployee.rate;
                            @endif

                            var static_rate = Number.parseFloat(this.selectedEmployee.static_rate);
                            this.overtime_amount = overtime_amount;
                            this.delay_amount    = delay_amount;
							
                            let temp_s_e=this.selectedEmployee;
                            
                            if(this.selectedEmployee) {
                                if(workdays && !this.hourly)
                                {
                                    if(this.salaryType =="TwiceAMonth"){
                                        num_days = 15;
                                    }else if(this.salaryType =="TwoWeek"){
                                        num_days = 14;
                                    }else if(this.salaryType =="Weekly"){
                                        num_days = 7;
                                    }else if(this.salaryType =="Daily"){
                                        num_days = 1;
                                    }else{ 
                                        num_days = 30;
                                    }
                                  //   var day = ((this.salaryAmount * this.selectedCurrency.exchange_rate / this.selectedEmployee['rate']) / num_days);
                                     // var ff=fee*this.selectedCurrency.exchange_rate;
                                     @if(systemConfig()[30] == 1)
                                    //  console.log('okk' , this.selectedEmployee.static_rate);
                                     var day = ((((this.salaryAmount / this.selectedEmployee.static_rate * this.selectedEmployee.rate) * this.selectedCurrency.static_rate) / this.selectedCurrency.exchange_rate) / num_days);
                                     @else 
                                     var day = ((this.salaryAmount * this.selectedCurrency.exchange_rate / this.selectedEmployee.rate) / num_days);
                                     @endif
                                      
                                     // console.log('ffff',ff);
                                     total = (day * (workdays + paidLeave)) + (overtime) + Number.parseFloat(rent) + Number.parseFloat(overtime_amount) - Number.parseFloat(delay_amount);
                                     //  console.log('ffffccpp',day,workdays,paidLeave,overtime,total);
                                }
								else if(hourlyAtt && this.hourly)
                                {
                                    @if(systemConfig()[30] == 1)
                                    var day = (((this.salaryAmount / this.selectedEmployee.static_rate * this.selectedEmployee.rate) * this.selectedCurrency.static_rate / this.selectedCurrency.exchange_rate) / (num_days * hourlyStatick));
                                    @else 
                                     var day = ((this.salaryAmount * this.selectedCurrency.exchange_rate / this.selectedEmployee['rate']) / (num_days * hourlyStatick));
                                    @endif 
                                     // var ff=fee*this.selectedCurrency.exchange_rate;
                                    //  console.log('ffffcc',day,hourlyAtt,paidLeave,hourlyStatick);
                                     total = (day * (hourlyAtt + (paidLeave * hourlyStatick))) + (overtime) + Number.parseFloat(rent) + Number.parseFloat(overtime_amount) - Number.parseFloat(delay_amount);
							// console.log('kkkkkk',total);
                                }
                                else
                                {
                                    @if(systemConfig()[30] == 1)
                                    var ff=fee* this.selectedCurrency.static_rate / this.selectedCurrency.exchange_rate;
                                    @else 
                                    var ff=fee*this.selectedCurrency.exchange_rate;
                                    @endif

                                    @if(systemConfig()[30] == 1)
                                    total=(((this.salaryAmount / this.selectedEmployee.static_rate * this.selectedEmployee.rate) * this.selectedCurrency.static_rate / this.selectedCurrency.exchange_rate))+(overtime)+ Number.parseFloat(rent) + Number.parseFloat(overtime_amount) - Number.parseFloat(delay_amount);
                                    @else 
                                    total=(this.salaryAmount * this.selectedCurrency.exchange_rate/this.selectedEmployee['rate'])+(overtime)+ Number.parseFloat(rent) + Number.parseFloat(overtime_amount) - Number.parseFloat(delay_amount);
                                    @endif 
                                }
                            }
							// console.log('ffffpppp',total);
                             return total;
                        },  
						
						
						netPayableNotDaily()
                        {
                         
                            var total=0;
                            var workdays    = parseFloat((this.PresentsHS )?this.PresentsHS :0)
                            var amount     = parseFloat((this.amount)?this.amount:0);
                            var fee        = parseFloat((this.fee)?this.fee:0);
                            let temp_s_e=this.selectedEmployee;

                            @if(systemConfig()[30] == 1)
							var overtime  = (this.overtimes * this.selectedCurrency.static_rate / this.selectedCurrency.exchange_rate);
							this.overtime  = (this.overtimes * this.selectedCurrency.static_rate / this.selectedCurrency.exchange_rate);
                            @else 
							var overtime  = (this.overtimes * this.selectedCurrency.exchange_rate);
							this.overtime  = (this.overtimes * this.selectedCurrency.exchange_rate);
                            @endif
 
                            @if(systemConfig()[30] == 1)
							var rent  = (((this.rents / this.selectedEmployee.static_rate * this.selectedEmployee.rate) * this.selectedCurrency.static_rate / this.selectedCurrency.exchange_rate) / this.selectedEmployee.rate);
							@else 
							var rent  = ((this.rents * this.selectedCurrency.exchange_rate) / this.selectedEmployee.rate);
                            @endif
  
							this.rent  = rent;

                            @if(systemConfig()[30] == 1)
                            var overtime_amount = (this.overtime_amount * this.selectedCurrency.static_rate / this.selectedCurrency.exchange_rate);
                            @else 
                            var overtime_amount = (this.overtime_amount * this.selectedCurrency.exchange_rate);
                            @endif

                            @if(systemConfig()[30] == 1)
                            var delay_amount    = (this.delay_amount * this.selectedCurrency.static_rate / this.selectedCurrency.exchange_rate);
                            @else 
                            var delay_amount    = (this.delay_amount * this.selectedCurrency.exchange_rate);
                            @endif



                            this.overtime_amount = overtime_amount;
                            this.delay_amount    = delay_amount;
                           
                            if(this.selectedEmployee) {
                                if(workdays)
                                {
                                    @if(systemConfig()[30] == 1)
                                    var day = ((((this.salaryAmount / this.selectedEmployee.static_rate * this.selectedEmployee.rate) * this.selectedCurrency.static_rate / this.selectedCurrency.exchange_rate)));
                                    @else 
                                    var day = ((this.salaryAmount * this.selectedCurrency.exchange_rate / this.selectedEmployee['rate']));
                                    @endif


                                    @if(systemConfig()[30] == 1)
                                     var ff=fee*this.selectedCurrency.static_rate / this.selectedCurrency.exchange_rate;
                                    @else
                                     var ff=fee*this.selectedCurrency.exchange_rate;
                                    @endif 
                                    //  console.log('ffff',this.salaryAmount,workdays,day);
                                     total = (day * workdays) + (overtime) + Number.parseFloat(rent) + Number.parseFloat(overtime_amount) - Number.parseFloat(delay_amount);
                                    //  console.log('total',total);
                                }
                                else
                                {
                                    @if(systemConfig()[30] == 1)
                                    var ff=fee* this.selectedCurrency.static_rate/ this.selectedCurrency.exchange_rate;
                                    @else 
                                    var ff=fee*this.selectedCurrency.exchange_rate;
                                    @endif
                                    
                                    @if(systemConfig()[30] == 1)
                                     total=(((this.salaryAmount / this.selectedEmployee.static_rate * this.selectedEmployee.rate) * this.selectedCurrency.static_rate / this.selectedCurrency.exchange_rate))+(overtime)+ Number.parseFloat(rent) + Number.parseFloat(overtime_amount) - Number.parseFloat(delay_amount);
                                    @else 
                                     total=(this.salaryAmount * this.selectedCurrency.exchange_rate/this.selectedEmployee['rate'])+(overtime)+ Number.parseFloat(rent) + Number.parseFloat(overtime_amount) - Number.parseFloat(delay_amount);
                                    @endif 
                                }
                            }
                             return total;
                        },   



						
            },
            mounted() {
                @if($payroll->rent)
                    this.rent = {!! $payroll->rent !!};
                    this.rents = {!! $payroll->rent !!};
                @endif
                @if($payroll->overtime_amount)
                    this.overtime_amount = {!! $payroll->overtime_amount !!};
                @endif
                @if($payroll->delay_amount)
                    this.delay_amount = {!! $payroll->delay_amount !!};
                @endif

                @if($payroll->contract_percentage)
                    this.contract_percentage = true;
                @endif

                if(multiContractData){
                    for (var i = 0; i < multiContractData.length; i++) {
                        var percent = multiContractData[i].percentage;
                        this.multiContractData.push({percentage: percent, selected: multiContractData[i]});
                    }
                } 

                this.multiContractData.push({percentage: 0, selected: null}); 

                if(this.employeePayrollTax)
                {
                    this.paymentType=1;
                    if(this.employeePayrollTax.id)
                    {
                        this.tax=1;
                        this.selectedTaxCurrency = _.find(this.taxCurrency, (v) => v.code == this.employeePayrollTax.tax_currency);
                        if (this.selectedTaxCurrenc) {
                            this.selectedTaxCurrency.rate=this.employeePayrollTax.tax_rate;
                        }
                    }
                    else
                    {
                        this.tax=0;
                    }
                }

            },
            created:function(){
                // this.selectedEmployee=this.employee;
                // console.log(32, this.selectedEmployee.id);
                // for(var a = 0; a<this.employees.length; a++){
                    if(this.selectedEmployee){
                       this.getSalaryRecord(this.selectedEmployee.id);
                        // this.selectedEmployee = this.selectedEmployee;
                         this.salaryAmount=this.payroll.amount;
                        this.selectedEmployee['amount']=this.payroll.amount;
                        this.selectedEmployee['currency']=this.payroll.currency;
                        this.selectedEmployee['sal_id']=this.payroll.sal_id;
                        this.selectedEmployee['rate']=this.payroll.salary_rate;
                        this.selectedEmployee['static_rate']=this.payroll.static_rate;
                        // break;
                    }
                // }
            },
            methods: {  
                MemberSearch: _.debounce((search, loading) => {
                    loading(true);
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'SearchMember', 
                            keyword: search,
                            type: 'Employee'
                        }
                    })
                    .then(function(response) {
                        if (response.data.length > 0) {
                            // console.log(response.data);
                            this.members = [];
                            this.members = response.data;
                        }
                        loading(false);
                    })
                    .catch(function(error) {
                        loading(false);
                        console.log(error);
                    })
                }, getDebounceTime()),
                

                onAgencySearch(search, loading) {
                    loading(true);
                    this.searchAgencyMember(search, loading, this);
                },
                searchAgencyMember(search, loading, vm) {
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'member',
                            type: '',
                            search: search,
                        }
                    })
                    .then(function (response) {
                        this.members = [];
                        if (response.data.length > 0) {
                            vm.members = response.data;
                            console.log(222, vm.members);
                        }
                        loading(false);
                    })
                    .catch(function (error) {
                        console.log(error);
                    })
                },


                getSalary(){
                    if(this.selectedEmployee)
                    {   
                        // console.log('se',this.selectedEmployee);
                     if(this.selectedEmployee.id !=this.employee)
                     {  
                        this.getSalaryRecord(this.selectedEmployee.member_id);
                     }
                    } 
                },
                
            // Search Project
				ProjectSearch:_.debounce((search,loading)=>{
                    this.project_list=[];
				   loading(true);
				   axios.get("{{route('callMethod.search')}}",{
					params:{
					  method_name:'serarchProject',
					  keyword:search,
					}
				   })
				   .then(function (response)
				   {
					 this.project_list=[];
					 if(response.data.length>0)
					 {
						this.project_list=response.data;
						// console.log('test 22',this.project_list);
					 }
					 loading(false);
				   })
				   .catch(function (error)
				   {
					  console.log(error);
				   });
				},getDebounceTime()),

                // Search Ngo Project
                searchNgoProjects(search, loading) {
                    loading(true);
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'anyTable',
                            keyword: search,
                            table_name: 'ngo_projects',
                        }
                    })
                    .then(function (response) {
                        this.NgoProject_list = [];
                        if (response.data.length > 0) {
                            this.NgoProject_list = response.data;
                        }
                        loading(false);
                    })
                    .catch(function (error) {
                        console.log(error);
                    })
                },
                // Search Contract
                searchContracts(search, loading) {
                    loading(true);
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'anyTable',
                            keyword: search,
                            table_name: 'contracts',
                            search_column:'company_name'
                        }
                    })
                    .then(function (response) {
                        this.contract_list = [];
                        if (response.data.length > 0) {
                            this.contract_list = response.data;
                        }
                        loading(false);
                    })
                    .catch(function (error) {
                        console.log(error);
                    })
                },

                getSalaryRecord(id)
                {  
                    // console.log('idd',id);
                        axios.get("{{route('callMethod.search')}}",
                       {
                        params:{
                          method_name:'memberSalary',
                          employee_id:id,
                        },
                       })
                       .then(function (response)
                       {
                        // console.log('ssssssssss',response.data)
                         if(response.data)
                         {
                            this.salary=response.data;
                         }
                       })
                       .catch(function (error)
                       {
                          console.log(error);
                       });  
                },

                // generic function for adding item to list
                addNew(type = null, index) {
                    if (type != null) {
                        if (type == 'multiContract') {
                            if (this.multiContractData[index + 1] == undefined) {
                                this.multiContractData.push({
                                    percentage: 0,
                                    selected: null
                                });
                            }
                        }
                    }

                },


                // delete item from list
                deleteItem(type = null, index) {
                    if (type != null) {
                        if (type == 'multiContract') {
                            this.multiContractData.splice(index, 1);
                        }
                    }

                },
                
            }
        }); 
</script>


@endpush