@extends('layouts.app')
@section('content')
@section('style')
@stop
<div class="row">
    @if (count($errors) > 0)
    <div class="m-heading-1 border-red m-bordered errors-action">
        <h4 class="error-title"><strong>Whoops!</strong> There were some problems with your input</h4>
        <ul class="error-body">
            @foreach ($errors->all() as $error)
            <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
    @endif
    <div class="portlet light bg-inverse" style="min-height: 100%;">
        <div class="portlet-title">
            <div class="caption">
                <i class="icon-equalizer font-green-haze"></i>&nbsp;
                <span class="caption-subject font-green-haze bold uppercase">@lang('layout.CreateNewPayroll') </span>
                <!-- <span class="caption-helper">some info...</span> -->
            </div>
            <div class="tools">

            </div>
        </div>
        <div class="portlet-body form" id="app" style="margin-bottom: 30%;" v-cloak>
            {{Form::open(['route' => 'payrollFromAttendanceAll.store','method' => 'POST','id' => 'payroll-form'])}}
            <div class="form-body">
                <div>
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.ExpenseAccount')</label>
                                <v-select placeholder="@lang('layout.Select')" label="name" v-model="selected_expense" :options="expense">
                                </v-select>
                                <input type="hidden" name="expense_id" v-model.number="(!selected_expense)?null:selected_expense.id" v-validate="'required'" data-vv-as="@lang('layout.ExpenseAccount')">
                                <span class="required">@{{ errors.first('expense_id') }}</span>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.Date')</label>
                                <div class="input-group">
                                    <input class="form-control date" id="from_date" name="from_date" autocomplete="off" v-validate="'required'" data-vv-as="@lang('layout.Date')">
                                    <span class="required">@{{ errors.first('from_date') }}</span>
                                    <span class="input-group-addon"> @lang('layout.To') </span>
                                    <input class="form-control date" id="to_date" name="to_date" autocomplete="off" v-validate="'required'" data-vv-as="@lang('layout.Date')">
                                    <span class="required">@{{ errors.first('to_date') }}</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                            <div class="form-group">

                                <div class="col-md-12">
                                <label class="control-label">@lang('layout.EmployeeAttendanceClass')</label>
                                    <v-select 
                                        label="name" 
                                        :options="attendance_class"
                                        v-model="selected_attendance_class"
                                        >
                                    </v-select>
                                    <input type="hidden" name="attendance_class_id"
                                        :value="!selected_attendance_class?null:selected_attendance_class.id" >
                                </div>
                            </div>
                        </div>

                        <div class="col-md-1">
                            <br />
                            <button type="button" @click="searchType" class="btn btn-info" style="background-color: rgb(80, 129, 141) !important;border: 1px solid rgb(80, 129, 141) !important;"><i class="fa fa-search"></i>@lang('layout.Search')</button>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                            <div class="form-group">
                                <div class="col-md-12">
                                    <label class="control-label">@lang('layout.Date')</label>
                                    {{Form::text('date',null,['class' => 'form-control date','id'=>'date','autocomplete'=>'off'])}}
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.Description')</label>
                                <textarea name="description" class="form-control" rows="2"></textarea>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <div style="display: flex; flex-direction: column; justify-content: center; align-items: center;">
                                            <label class="control-label">@lang('layout.BuildExpense')</label>
                                            <input type="checkbox" name="build_expense_confirm" id="" value="On">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        @if(systemConfig()[5] != 0 )
                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                            <label class="control-label">@lang('layout.Project')</label>
                            <v-select class="vue-select2" label="name" @search="ProjectSearch" :options="project_list" v-model="selectedProject">
                            </v-select>
                            <input type="hidden" name="project_id" v-model.number="(!selectedProject)?null:selectedProject.project_id">
                        </div>
                        @endif
                        @if(systemConfig()[19] == 1)
                            <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12"> 
                                <label class="control-label">@lang('layout.NGOProject')</label>
                                <v-select class="vue-select2" label="name" @search="searchNgoProjects" :options="NgoProject_list" v-model="selectedNgoProject">
                                </v-select>
                                <input type="hidden" name="ngo_project_id" v-model.number="(!selectedNgoProject)?null:selectedNgoProject.id">
                            </div>
                        @endif

                        @if(systemConfig()[20] == 1)
                        <div v-if="!contract_percentage" class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                            <label class="control-label">@lang('layout.ContractName')</label>
                            <v-select class="vue-select2" placeholder="@lang('layout.Select')"
                                    v-model="selectedContract" 
                                    label="company_name"
                                    @search="searchContracts"
                                    :options="contract_list">
                            </v-select>
                            <input type="hidden" name="contract_id" v-model.number="(!selectedContract)?null:selectedContract.id" />
                        </div>
                        @endif

                        @if(systemConfig()[20] == 1)
                        <div class="col-md-2">
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <div style="display: flex; flex-direction: column; justify-content: center; align-items: center;">
                                            <label class="control-label">@lang('layout.MultiContract')</label>
                                            <input type="checkbox" name="contract_percentage" v-model="contract_percentage" value="on">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        @endif

                    </div> 
                     <!-- begin tax -->
                     <div class="row" style="margin-top: 20px; margin-right:2px;">
                        <input type="checkbox" name="tax" v-model="tax">
                        @lang('layout.Tax')
                       <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12" v-if="tax">
                           <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                               <div class="col-md-12">
                                   <label class="control-label">@lang('layout.TaxCurrency')</label>
                                   <v-select  label="code" :options="taxCurrency" v-model="selectedTaxCurrency"></v-select> 
                                   <input type="hidden" name="tax_currency" class="form-control" v-validate="'required'"
                                    data-vv-as="@lang('layout.TaxCurrency')" :value=(!selectedTaxCurrency)?null:selectedTaxCurrency.code>
                                   <span class="required">@{{ errors.first('tax_currency') }}</span> 
                                 <span class="required">@{{ errors.first('tax_currency') }}</span>
                               </div>
                           </div>

                           <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                               <div class="col-md-12">
                                   <label class="control-label ">@lang('layout.Rate')</label>
                                   <input type="number" name="tax_rate" class="form-control" v-validate="'required'"
                                                  data-vv-as="@lang('layout.Rate')" v-model=(!selectedTaxCurrency)?null:selectedTaxCurrency.rate>
                                   <span class="required">@{{ errors.first('tax_currency') }}</span>

                                   
                               </div>
                           </div>

                           <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                               <div class="col-md-12">
                                   <label class="control-label ">@lang('layout.PaymentType')</label>
                                   <br>
                                   <input type="checkbox" readonly name="by_employee" v-model="paymentType">
                                   @lang('layout.ByEmployee')
                                   
                               </div>
                           </div>

                             <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                               <div class="form-group">
                                   <label class="control-label"> @lang('layout.AgencyTax')</label>
                                  <v-select   
                                  placeholder="@lang('layout.SelectEmployee')" 
                                  label="name"
                                   v-model="selectedMember"
                                   :options="members"
                                   @search="onAgencySearch"
                                       >       
                                   </v-select>
                                   <input type="hidden" name="tax_member" v-model.number="(!selectedMember)?null:selectedMember.id" >
                               </div>
                           </div>

                           <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <label class="control-label"> @lang('layout.ExpenseAccount')</label>
                                       <v-select   placeholder="@lang('layout.ExpenseAccount')" label="name"
                                           v-model="selected_tax_expense"
                                        :options="{{$expense_tax}}">       
                                       </v-select>
                                       <input type="hidden" name="selected_tax_expense" v-model="(!selected_tax_expense)?null:selected_tax_expense.id" >

                                   </div>
                           </div> 
                       </div> 
                   </div>
                   <!-- end tax -->

                   <br/>
                   @if(systemConfig()[20] == 1)
                   <!-- begin multiContract -->
                   <table v-if="contract_percentage" id="table_content" class="table table-striped table-bordered table-advance table-hover">
                       <thead>
                           <tr>
                               <th class="text-center" style="min-width: 8px;"> #</th>
                               <th class="text-center" style="min-width: 160px;">@lang('layout.ContractName')</th>
                               <th class="text-center" style="min-width: 160px;">@lang('layout.Percentage')</th>
                               <th></th>
                           </tr>
                       </thead>
                       <tbody>
                           <tr v-for="(record,index) in multiContractData">
                               <td class="text-center">@{{index+1}}</td>
                               <td class="highlight">
                                   <v-select class="vue-select2" placeholder="@lang('layout.Select')"
                                           v-model="record.selected" 
                                           label="company_name"
                                           @search="searchContracts"
                                           :options="contract_list" @click.native="addNew('multiContract',index)" >
                                   </v-select>
                                   <input type="hidden" name="multiContract_id[]" :value="(record.selected==null)?null:record.selected.id">
                               </td>

                               <td>
                                   <input class="form-control" type="number" name="percentage[]"
                                       v-model.number="record.percentage" placeholder="@lang('layout.Percentage')">
                               </td>

                               <td class="text-center" style="vertical-align: middle;">
                                   <span v-on:click="deleteItem('multiContract',index)"><i class="paddint-both glyphicon glyphicon-trash text-danger" style="cursor: pointer;"></i></span>
                               </td>
                           </tr>
                       </tbody>
                   </table>
                   <!-- end multiContract -->
                   @endif


                    <hr>
                    <div class="row" style="overflow-x: scroll;">
                        <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                            <thead>
                                <tr>
                                    <th style="min-width: 100px">@lang('layout.SelectMember') </th>
                                    <th style="min-width: 100px">@lang('layout.Number') </th>
                                    <th style="min-width: 100px">@lang('layout.Name') </th>
                                    <th style="min-width: 100px">@lang('layout.ExpenseAccount') </th>
                                    @if(systemConfig()[7] != 0 )
                                    <th style="min-width: 100px">@lang('layout.PlateNumber') </th>
                                    @endif
                                    <th style="min-width: 150px">@lang('layout.BasicSalary') </th>
                                    <th style="min-width: 150px">@lang('layout.SalaryRate') </th>
                                    <th style="min-width: 100px">@lang('layout.PaidLeave') </th>
                                    <th style="min-width: 100px">@lang('layout.WorkedDay') </th>
                                    <!-- <th style="min-width: 100px">@lang('layout.AbsentDays') </th> -->
                                    <th style="min-width: 100px">@lang('layout.HoursOrShifts') </th>
                                    <th style="min-width: 100px">@lang('layout.Currency') </th>
                                    <th style="min-width: 150px">@lang('layout.PaymentRate') </th>
                                    <th style="min-width: 150px">@lang('layout.TotalOverTime') </th>
                                    <th style="min-width: 100px">@lang('layout.Rent') </th>
                                    <th style="min-width: 150px">@lang('layout.OvertimeHours') </th>
                                    <th style="min-width: 150px">@lang('layout.DelayHours') </th>
                                    <th style="min-width: 150px">@lang('layout.JustLeaveDay') </th>
                                    <th style="min-width: 150px">@lang('layout.JustLeaveHour') </th>
                                    <th style="min-width: 150px">@lang('layout.UnJustLeaveDay') </th>
                                    <th style="min-width: 150px">@lang('layout.UnJustLeaveHour') </th>
                                    <th style="min-width: 150px">@lang('layout.NetPayable') </th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr v-for="(item,index) in employees">
                                    <td>
                                        <input type="checkbox" @click="toggleCheck(index)" :checked="item.selected">
                                        <input type="hidden" name="selected[]" :value="item.selected">
                                        <input type="hidden" name="member_id[]" :value="(!item.member)?null:item.member.id">
                                        <input type="hidden" name="salary_id[]" :value="(!item.member)?null:item.member.salary_id">
                                        <input type="hidden" name="attendance_type[]" :value="(!item.member)?null:item.member.attendance_type">
                                    </td>
                                    <td>@{{index+1}}</td>
                                    <td>@{{(!item.member)?null:item.member.name}}</td>
                                    <td>
                                        @{{(!item.member)?null:item.member.account_name}}
                                        <input type="hidden" name="expense_account_id[]" :value="(!item.member)?null:item.member.account_id">
                                    </td>
                                    @if(systemConfig()[7] != 0 )
                                    <td>
                                        <input type="text" class="form-control" name="plate_number[]" v-model="(!item.member)?null:item.member.plate_number">
                                    </td>
                                    @endif
                                    <td>
                                        <div class="input-group">
                                            <input type="number" class="form-control" name="basicSalary[]" :value="(!item.member)?null:item.member.amount" readonly>
                                            <span class="input-group-addon">@{{(item.member)?item.member.currency:null}}</span>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="input-group">
                                            <input type="number" class="form-control" name="salaryRate[]" v-model="(!item.member)?null:item.member.rate">
                                            <span class="input-group-addon">@{{(item.member)?item.member.currency:null}}</span>
                                        </div> 
                                    </td>
                                    <td>
                                        <input type="number" class="form-control" name="paidLeave[]" v-model="(!item.member)?null:item.member.paidLeave" v-validate="'required'" data-vv-as="@lang('layout.PaidLeave')">
                                        <span class="required">@{{ errors.first('paidLeave') }}</span>
                                    </td>

                                    <td>
                                        <input type="number" class="form-control" name="workedDay[]" v-model="(!item.member)?null:item.member.Presents" v-validate="'required'" data-vv-as="@lang('layout.WorkedDay')">
                                        <span class="required">@{{ errors.first('WorkedDay') }}</span>
                                    </td>
                                    <!-- <td>

                                    <input type="number" class="form-control" name="absent_day[]">

                                </td> -->
                                    <td>
                                        <input type="number" class="form-control" v-model="(!item.member)?null:item.member.PresentsHS" name="PresentsHS[]">
                                    </td>
                                    <td>
                                        <v-select label="code" :options="currency" v-model="(!item.payment_currency)?[]:item.payment_currency"></v-select>
                                        <input type="hidden" name="payroll_currency[]" v-model="(!item.payment_currency)?null:item.payment_currency.code">
                                    </td>
                                    <td>
                                        <div class="input-group">
                                            <input type="number" name="payroll_rate[]" v-model="(!item.payment_currency)?rate:item.payment_currency.rate" class="form-control" min="0" step="any">
                                            <span class="input-group-addon">@{{(!item.payment_currency)?null:item.payment_currency.code}}</span>
                                        </div>
                                    </td>
                                    @if(systemConfig()[30] == 1)
                                    <td>
                                        <div class="input-group">
                                            <input type="number" class="form-control" name="totalOverTime[]" :value="(((!item.member)?null:item.member.totalOvertime * item.member.static_rate) / ((!item.payment_currency)?1:item.payment_currency.rate))" readonly>
                                            <input type="hidden" class="form-control" name="overtime[]" :value="(!item.member)?null:item.member.totalOvertime">
                                            <input type="hidden" class="form-control" name="member_currency[]" :value="(!item.member)?null:item.member.currency">
                                            <span class="input-group-addon">@{{(!item.payment_currency)?null:item.payment_currency.code}}</span>
                                        </div>
                                    </td>
                                    @else 
                                    <td>
                                        <div class="input-group">
                                            <input type="number" class="form-control" name="totalOverTime[]" :value="(!item.member)?null:(item.member.totalOvertime * ((!item.payment_currency)?1:item.payment_currency.rate))" readonly>
                                            <input type="hidden" class="form-control" name="overtime[]" :value="(!item.member)?null:item.member.totalOvertime">
                                            <span class="input-group-addon">@{{(!item.payment_currency)?null:item.payment_currency.code}}</span>
                                        </div>
                                    </td>
                                    @endif
                                    @if(systemConfig()[30] == 1)
                                    <td> 
                                        @{{(!item.member)?null:myRound(((item.member.rent / item.member.static_rate  * item.member.rate) * item.payment_currency.static_rate /  ((!item.payment_currency)?1:item.payment_currency.rate)))}} @{{(!item.payment_currency)?null:item.payment_currency.code}}
                                        <input type="hidden" class="form-control" name="rent[]" :value="(!item.member)?null:item.member.rent">
                                    </td> 
                                    @else 
                                    <td>
                                        @{{(!item.member)?null:myRound((item.member.rent * ((!item.payment_currency)?1:item.payment_currency.rate)) / ((!item.member.rate)?1:item.member.rate))}}   @{{(!item.payment_currency)?null:item.payment_currency.code}}
                                        <input type="hidden" class="form-control" name="rent[]" :value="(!item.member)?null:item.member.rent">
                                    </td> 
                                    @endif

                                    @if(systemConfig()[30] == 1)
                                    <td>
                                        @{{(item)?myRound((item.overtime_amount / item.member.static_rate * item.member.rate ) * item.payment_currency.static_rate / (((!item.payment_currency)?1:item.payment_currency.rate))):null}} @{{(!item.payment_currency)?null:item.payment_currency.code}}
                                        <br> <span class="label label-success"> @{{(item)?item.overtime_qty : null}} </span>
                                        <input type="hidden" class="form-control" name="overtime_amount[]" :value="(item)?item.overtime_amount* (((!item.payment_currency)?1:item.payment_currency.rate) / ((!item.member.rate)?1:item.member.rate)):null">
                                    </td>
                                    @else 
                                    <td>
                                        @{{(item)?myRound(item.overtime_amount* (((!item.payment_currency)?1:item.payment_currency.rate) / ((!item.member.rate)?1:item.member.rate))):null}} @{{(!item.payment_currency)?null:item.payment_currency.code}}
                                        <br> <span class="label label-success"> @{{(item)?item.overtime_qty : null}} </span>
                                        <input type="hidden" class="form-control" name="overtime_amount[]" :value="(item)?item.overtime_amount* (((!item.payment_currency)?1:item.payment_currency.rate) / ((!item.member.rate)?1:item.member.rate)):null">
                                    </td>
                                    @endif


                                    @if(systemConfig()[30] == 1)
                                    <td>
                                        @{{(item)?myRound(((item.delay_amount / item.member.sttaic_rate * item.member.rate) *  item.payment_currency.static_rate) / (((!item.payment_currency)?1:item.payment_currency.rate))):null}} @{{(!item.payment_currency)?null:item.payment_currency.code}}
                                        <br> <span class="label label-danger"> @{{(item)?item.delay_qty : null}} </span>
                                        <input type="hidden" class="form-control" name="delay_amount[]" :value="(item)?item.delay_amount* (((!item.payment_currency)?1:item.payment_currency.rate) / ((!item.member.rate)?1:item.member.rate)):null">
                                    </td>
                                    @else 
                                    <td>
                                        @{{(item)?myRound(item.delay_amount* (((!item.payment_currency)?1:item.payment_currency.rate) / ((!item.member.rate)?1:item.member.rate))):null}} @{{(!item.payment_currency)?null:item.payment_currency.code}}
                                        <br> <span class="label label-danger"> @{{(item)?item.delay_qty : null}} </span>
                                        <input type="hidden" class="form-control" name="delay_amount[]" :value="(item)?item.delay_amount* (((!item.payment_currency)?1:item.payment_currency.rate) / ((!item.member.rate)?1:item.member.rate)):null">
                                    </td>
                                    @endif


                                    <td>
                                        @{{item.justLeaveDay}}
                                    </td>
                                    <td>
                                        @{{item.justLeaveHour}}
                                    </td>
                                    <td>
                                        @{{item.unJustLeaveDay}}
                                    </td>
                                    <td>
                                        @{{item.unJustLeaveHour}}
                                    </td>

                                    <td>
                                        <input type="number" class="form-control" name="netPayable[]" :value="(!item.member)?null:netPayable(index)" readonly>
                                    </td>
                                </tr>

                            </tbody>
                        </table>
                    </div>

                </div>
                <!--/row-->





            </div>
            <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                <button type="button" @click="handleSubmit($event)" class="btn green">@lang('layout.Submit')</button>
                <button type="button" class="btn blue" @click="saveAndNew($event)">@lang('layout.SaveAndNew')</button>
                <a href="{{route('payroll.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
            </div>
            {{Form::close()}}
        </div>
        <!-- END FORM-->
    </div>
</div>
@endsection
@push('scripts')

<script>
    @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
    Vue.use(VeeValidate, {
        locale: 'en',
    });
    @endif

    
    ////
    Vue.component("v-select", VueSelect.VueSelect);
    var Currency ={!! $currency !!};
    var expense = {!! $expenses !!};
    var employeeAttendanceClass={!! json_encode($employeeAttendanceClass) !!};
    var TaxCurrency ={!! $currency !!}

    var app = new Vue({
        el: '#app',
        data: {
            selectedCurrency: defaultCurrency(),
            currency: Currency,
            currencyList: Currency,
            employees: [],
            expense: expense,
            selected_expense: null,
            workdays: null,
            salary: null,
            selectedBank: null,
            selectedEmployee: null,
            paidLeave: null,
            pay: false,
            type: null,
            amount: 0,
            salaryAmount: 0,
            fee: null,
            basicSalary: 0,
            from: null,
            to: null,
            advancePaid: 0,
            hourlyAtt: 0,
            hourlyStatick: 0,
            overtime: 0,
            overtimes: 0,
            rate: 0,
            hourly: false,
            selectedProject: null,
            project_list: [],
            selectedNgoProject: null,
            NgoProject_list: [],
            Presents: null,
            PresentsHS: null,
            Absent: null,
            AbsentHS: null,
            total_justified_absent: null,
            num_days: null,
            // fridays:null,

            fee_amount: 0,
            attendance_class:employeeAttendanceClass,
            selected_attendance_class:null,
            contract_list:[],
            selectedContract:null,
            paymentType:1,
            tax:0,  
            taxCurrency:TaxCurrency,
            selectedTaxCurrency:null,
            members:[],
            selectedMember:null,
            selected_tax_expense:null,
            contract_percentage:null,
            multiContractData: [
                {percentage: 0, selected: null},
                {percentage: 0, selected: null},
            ],

        },
        watch: {},
        computed: {
            netPayable() {
                var total = 0;
                return total;
            },
        },
        methods: {
            searchType() {
                var from_date = document.getElementById('from_date').value;
                var to_date = document.getElementById('to_date').value;

                var attendance_class = (app.selected_attendance_class)?app.selected_attendance_class.id:null;

                // console.log('dddpp',from_date,to_date,member_id);
                this.employess = [];
                // this.typeInfo = null; 
                if (from_date && to_date) {
                    axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'allEmployeeFindAttendance',
                                from_date: from_date,
                                to_date: to_date,
                                attendance_class:attendance_class
                            }
                        })
                        .then(function(response) {
 
                            if (response.data) {
 
                                // console.log('Whyyy', response.data);

                                if (response.data.data) {
                                    if (response.data.data.length > 0) {
                                        // console.log('All Data', response.data.data)
                                        app.employees = [];
                                        for (var i = 0; i < response.data.data.length; i++) {

                                            var s_currency = app.selectedCurrency
                                            if (response.data.data[i].currency) {
                                                s_currency = _.find(app.currency, (c) => c.code == response.data.data[i].currency);
                                            }

                                            //begin overtime and delay----------------------------------------
                                            var overtime_amount = 0;
                                            var delay_amount = 0;

                                            var total_overtime_amount = 0;
                                            var total_delay_amount = 0;

                                            var salaryType = response.data.data[i].salaryType;
                                            var attendance_type = response.data.data[i].attendance_type;
                                            var rate = response.data.data[i].rate;
                                            var salary = parseFloat((response.data.data[i].amount)?response.data.data[i].amount:0);
                                            var num_days = parseFloat((response.data.data[i].num_days)?response.data.data[i].num_days:1);
                                            var hourlyStatick = parseFloat((response.data.data[i].static_hour)?response.data.data[i].static_hour:8);
                                            var shiftStatick = parseFloat((response.data.data[i].static_shift)?response.data.data[i].static_shift:1);
                                            var overtime_qty = parseFloat((response.data.data[i].total_overtime_and_delay.total_overtime)?response.data.data[i].total_overtime_and_delay.total_overtime:0);
                                            var delay_qty = parseFloat((response.data.data[i].total_overtime_and_delay.total_delay)?response.data.data[i].total_overtime_and_delay.total_delay:0);
                                            var total_overtime_amount = parseFloat((response.data.data[i].total_overtime_and_delay.total_overtime_amount)?response.data.data[i].total_overtime_and_delay.total_overtime_amount:0);
                                            var total_delay_amount = parseFloat((response.data.data[i].total_overtime_and_delay.total_delay_amount)?response.data.data[i].total_overtime_and_delay.total_delay_amount:0);

                                            var justLeaveDay = parseFloat((response.data.data[i].count_total_justified_leave)? response.data.data[i].count_total_justified_leave:0);
                                            var unJustLeaveDay = parseFloat((response.data.data[i].count_total_unjustifiend_leave)?response.data.data[i].count_total_unjustifiend_leave:0);
                                            var justLeaveHour = parseFloat((response.data.data[i].count_justifiend_leave_hourly)?response.data.data[i].count_justifiend_leave_hourly:0);
                                            var unJustLeaveHour = parseFloat((response.data.data[i].count_unJustifiend_leave_houly)?response.data.data[i].count_unJustifiend_leave_houly:0);


                                            if(attendance_type == "daily")
                                            {
                                                if(salaryType =="TwiceAMonth"){
                                                    num_days = 15;
                                                }else if(salaryType =="TwoWeek"){
                                                    num_days = 14;
                                                }else if(salaryType =="Weekly"){
                                                    num_days = 7;
                                                }else if(salaryType =="Daily"){
                                                    num_days = 1;
                                                }else{ 
                                                    num_days = 30;
                                                }
                                                var day = ((salary * s_currency.exchange_rate / rate) / (num_days * hourlyStatick));
                                            }
                                            if(attendance_type == "hourly")
                                            {
                                                var day = ((salary * s_currency.exchange_rate / rate));
                                            }
                                            if(attendance_type == "shifty")
                                            {
                                                var day = ((salary * s_currency.exchange_rate / rate)*shiftStatick)/hourlyStatick;
                                            }

                                            @if(getOvertimeDelaySalary()=="true")
                                                var overtime_amount = overtime_qty*day;
                                                var delay_amount = delay_qty*day;
                                            @else
                                                var overtime_amount = total_overtime_amount;
                                                var delay_amount = total_delay_amount;
                                            @endif
                                            //End overtime and delay---------------------------------------------- 

                                            app.employees.push({
                                                selected: true,
                                                member: response.data.data[i],
                                                payment: null,
                                                payment_currency: s_currency,
                                                overtime_amount:overtime_amount,
                                                delay_amount:delay_amount,
                                                overtime_qty:overtime_qty,
                                                delay_qty:delay_qty,
                                                justLeaveDay:justLeaveDay,
                                                unJustLeaveDay:unJustLeaveDay,
                                                justLeaveHour:justLeaveHour,
                                                unJustLeaveHour:unJustLeaveHour
                                            });
                                        }
                                    }
                                }


                            }
                            // console.log('workdays',app.workdays)
                        })
                        .catch(function(error) {
                            console.log(error);
                        });
                }

            },

            netPayable(index) { 
                var data = app.employees[index].member;
                var payment_currency = app.employees[index].payment_currency;
   
                var total = 0;
                if (data && payment_currency) {
                    var rate = parseFloat((data.rate) ? data.rate : 0);
                    var static_rate = parseFloat((data.static_rate) ? data.static_rate : 0);
                    var salaryAmount = parseFloat((data.amount) ? data.amount : 0);
                    var workdays = parseFloat((data.Presents) ? data.Presents : 0);
                    var paidLeave = parseFloat((data.paidLeave) ? data.paidLeave : 0);
                    var num_days = parseFloat((data.num_days) ? data.num_days : 1);
                    var amount = parseFloat((data.amount) ? data.amount : 0);
                    var fee = parseFloat((this.fee) ? this.fee : 0);
                    var hourlyStatick = parseFloat((data.static_hour) ? data.static_hour : 8);
                    var shiftStatick = parseFloat((data.static_shift)?data.static_shift:1);
                    var hourlyAtt = parseFloat((data.PresentsHS) ? data.PresentsHS : 0);
                    var overtime = (data.totalOvertime * payment_currency.rate);

                    @if(systemConfig()[30] == 1)
                    var rent = ((data.rent / static_rate * rate) * payment_currency.static_rate / payment_currency.rate);
                    @else 
                    var rent = ((data.rent * payment_currency.rate) / rate);
                    @endif

                    // this.overtime   = (data.totalOvertime * payment_currency.rate);
                    if (workdays && data.attendance_type == 'daily') {

                        // console.log('Amount', salaryAmount, data, data.salaryType);

                        if(data.salaryType =="TwiceAMonth"){
                            num_days = 15;
                        }else if(data.salaryType =="TwoWeek"){
                            num_days = 14;
                        }else if(data.salaryType =="Weekly"){
                            num_days = 7;
                        }else if(data.salaryType =="Daily"){
                            num_days = 1;
                        }else{ 
                            num_days = 30;
                        }

                        @if(systemConfig()[30] == 1)
                        var day = (((salaryAmount / static_rate * rate) *  payment_currency.static_rate / payment_currency.rate) / num_days);
                        @else 
                        var day = ((salaryAmount * payment_currency.rate / rate) / num_days);
                        @endif
 
                        total = Number.parseFloat(day * (workdays + paidLeave)) + Number.parseFloat(overtime) + Number.parseFloat(rent);
                     
                    } else if (hourlyAtt) {
                        @if(systemConfig()[30] == 1)
                        var amounts = ((salaryAmount / static_rate * rate) *  payment_currency.static_rate / payment_currency.rate);
                        @else 
                        var amounts = (salaryAmount * payment_currency.rate / rate);
                        @endif

                        total = Number.parseFloat(amounts * hourlyAtt) + Number.parseFloat(overtime) + Number.parseFloat(rent);
                        // console.log('kkkkkk',total);
                    }

                    //begin overtime and delay----------------------------------------
                    var overtime_amount = 0;
                    var delay_amount = 0;

                    var total_overtime_amount = 0;
                    var total_delay_amount = 0;

                    var attendance_type = data.attendance_type;
                    var overtime_qty = parseFloat((data.total_overtime_and_delay.total_overtime)?data.total_overtime_and_delay.total_overtime:0);
                    var delay_qty = parseFloat((data.total_overtime_and_delay.total_delay)?data.total_overtime_and_delay.total_delay:0);

                    var total_overtime_amount =parseFloat((data.total_overtime_and_delay.total_overtime_amount)?data.total_overtime_and_delay.total_overtime_amount:0);
                    var total_delay_amount = parseFloat((data.total_overtime_and_delay.total_delay_amount)?data.total_overtime_and_delay.total_delay_amount:0);
 
                    if(attendance_type == "daily" && hourlyStatick != 0)
                    {
                        @if(systemConfig()[30] == 1)
                        var day = (((salaryAmount / static_rate * rate) *  payment_currency.static_rate / payment_currency.rate) / (num_days * hourlyStatick));
                        @else 
                        var day = ((salaryAmount * payment_currency.exchange_rate / rate) / (num_days * hourlyStatick));
                        @endif
                    }
                    if(attendance_type == "hourly")
                    {
                        @if(systemConfig()[30] == 1)
                        var day = (((salaryAmount / static_rate * rate) *  payment_currency.static_rate / payment_currency.rate));
                        @else 
                        var day = ((salaryAmount * payment_currency.exchange_rate / rate));
                        @endif 
                    }
                    if(attendance_type == "shifty" && hourlyStatick != 0)
                    {
                        @if(systemConfig()[30] == 1)
                        var day = (((salaryAmount / static_rate * rate) *  payment_currency.static_rate / payment_currency.rate)*shiftStatick)/hourlyStatick;
                        @else 
                        var day = ((salaryAmount * payment_currency.exchange_rate / rate)*shiftStatick)/hourlyStatick;
                        @endif
                    
                    }
                    @if(getOvertimeDelaySalary()=="true")
                        var overtime_amount = overtime_qty*day;
                        var delay_amount = delay_qty*day;
                    @else
                        var overtime_amount = total_overtime_amount;
                        var delay_amount = total_delay_amount;
                    @endif
                   //End overtime and delay----------------------------------------------
                   total = total + Number.parseFloat(overtime_amount) - Number.parseFloat(delay_amount)
                    
                }
                // console.log('ffffpppp', total);
                return myRound(total);
            },

            toggleCheck(index) {
                this.employees[index].selected = !this.employees[index].selected;
            },

            getSalary() {
                if (this.selectedEmployee) {
                    // console.log('se', this.selectedEmployee.attendance_type);
                    this.getSalaryRecord(this.selectedEmployee.id);

                }
            },
            onAgencySearch(search, loading) {
                    loading(true);
                    this.searchAgencyMember(search, loading, this);
                },
                searchAgencyMember(search, loading, vm) {
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'member',
                            type: '',
                            search: search,
                        }
                    })
                    .then(function (response) {
                        this.members = [];
                        if (response.data.length > 0) {
                            vm.members = response.data;
                        }
                        loading(false);
                    })
                    .catch(function (error) {
                        console.log(error);
                    })
                },

            getSalaryRecord(id) {
                $.ajax({
                    url: "{{route('callMethod.search')}}",
                    async: false,
                    data: {
                        method_name: 'memberSalary',
                        employee_id: id,
                    },
                    success: function(data) {
                        this.salary = data;
                        // console.log('sallkjk', this.salary);


                    }.bind(this),

                    error: function(error) {
                        console.log(error)
                    }
                });

            },

            // Search Project
            ProjectSearch: _.debounce((search, loading) => {
                app.project_list = [];
                loading(true);
                axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'serarchProject',
                            keyword: search,
                        }
                    })
                    .then(function(response) {
                        this.project_list = [];
                        if (response.data.length > 0) {
                            app.project_list = response.data;
                            // console.log('test 22', app.project_list);
                        }
                        loading(false);
                    })
                    .catch(function(error) {
                        console.log(error);
                    });
            }, getDebounceTime()),

            // Search Ngo Project

            searchNgoProjects(search, loading) {
                    loading(true);
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'anyTable',
                            keyword: search,
                            table_name: 'ngo_projects',

                        }
                    })
                    .then(function (response) {
                        app.NgoProject_list = [];
                        if (response.data.length > 0) {
                            app.NgoProject_list = response.data;
                        }
                        loading(false);
                    })
                    .catch(function (error) {
                        console.log(error);
                    })
                },
                // Search Contract
                searchContracts(search, loading) {
                    loading(true);
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'anyTable',
                            keyword: search,
                            table_name: 'contracts',
                            search_column:'company_name'
                        }
                    })
                    .then(function (response) {
                        app.contract_list = [];
                        if (response.data.length > 0) {
                            app.contract_list = response.data;
                        }
                        loading(false);
                    })
                    .catch(function (error) {
                        console.log(error);
                    })
                },

                // generic function for adding item to list
                addNew(type = null, index) {
                    if (type != null) {
                        if (type == 'multiContract') {
                            if (this.multiContractData[index + 1] == undefined) {
                                this.multiContractData.push({
                                    percentage: 0,
                                    selected: null
                                });
                            }
                        }
                    }

                },


                // delete item from list
                deleteItem(type = null, index) {
                    if (type != null) {
                        if (type == 'multiContract') {
                            this.multiContractData.splice(index, 1);
                        }
                    }

                },

            handleSubmit(e) {
                this.$validator.validate().then(valid => {
                    if (valid) {
                        // alert(e.target);
                        regForm(e.target);
                    }
                });
            },

            saveAndNew() {
                this.$validator.validate()
                    .then(valid => {
                        if (valid) {
                            var url = "{{route('payrollFromAttendanceAll.store')}}";
                            form_id = 'payroll-form';
                            var data = $('#' + form_id).serialize();
                            // console.log(444, data);
                            toggleBlock(true);
                            axios.post(url, data)
                                .then(function(response) {
                                    toggleBlock(0);
                                    if (response.data.result == 1) {
                                        $('#' + form_id).trigger('reset');

                                        toastr.success('', response.data.message);
                                        location.reload();

                                    } else {
                                        var message = "{{__('message.Warning')}}";
                                        //$('#error-sound')[0].play();
                                        toastr.warning('', message);
                                    }
                                })
                                .catch(function(error) {
                                    toggleBlock(0);
                                    console.log(error);
                                    var message = "{{__('message.Warning')}}";
                                    //$('#error-sound')[0].play();
                                    toastr.warning('', message);
                                });

                        }
                    })
            },
        }
    });
</script>
@endpush