@extends('layouts.app')
@section('content')
@section('style')
@stop
    <div class="row">
        @if (count($errors) > 0)
            <div class="m-heading-1 border-red m-bordered errors-action">
                <h4 class="error-title"><strong>Whoops!</strong> There were some problems with your input</h4>
                <ul class="error-body">
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul> 
            </div>
        @endif 
        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.CreateNewPayroll') </span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools">
                   
                </div>
            </div>
            <div class="portlet-body form" id="app" style="margin-bottom: 30%;" v-cloak>
                {{Form::open(['route' => 'payrollFromAttendance.store','method' => 'POST','id' => 'payroll-form'])}}
                <div class="form-body">
                    <div >
                        <div class="row"> 
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="control-label"> @lang('layout.EmployeeName')</label>
                                   <v-select @input="getSalary"  placeholder="@lang('layout.SelectEmployee')" label="name"
                                        @search="onMemberSearch"
                                        v-model="selectedEmployee"
                                        :options="employees"
                                         >       
                                    </v-select>
                                    <input type="hidden" name="employee" v-model.number="(!selectedEmployee)?null:selectedEmployee.id"  v-validate="'required'" data-vv-as="@lang('layout.Employee')">
                                    <span class="required">@{{ errors.first('employee') }}</span>
                                </div>
                            </div>
                           <div class="col-md-4">
                                <div class="form-group">
                                    <label class="control-label"> @lang('layout.Date')</label>
                                    <div class="input-group">
                                         <input class="form-control date" id="from_date" name="from_date" autocomplete="off" v-validate="'required'" data-vv-as="@lang('layout.Date')">
                                         <span class="required">@{{ errors.first('from_date') }}</span>
                                        <span class="input-group-addon"> @lang('layout.To') </span>
                                        <input class="form-control date" id="to_date" name="to_date" autocomplete="off" v-validate="'required'" data-vv-as="@lang('layout.Date')"> 
                                        <span class="required">@{{ errors.first('to_date') }}</span>
                                    </div>
                                </div>
                            </div>
							<div class="col-md-1">
								<div class="form-group">
								<label class="control-label">@lang('layout.Hourly')   
								<input type="checkbox" name="hourly"  v-model="hourly" class="form-control">
								</label>
								</div>
							</div>
                            <div class="col-md-1">
                                <br/>
                                <button type="button" @click="searchType" class="btn btn-info" style="background-color: rgb(80, 129, 141) !important;border: 1px solid rgb(80, 129, 141) !important;"><i class="fa fa-search"></i>@lang('layout.Search')</button>
                            </div>
                            <div class="col-lg-3 col-md-3 col-sm-3 col-xs-12">
							    <div class="form-group">
									<label class="control-label">@lang('layout.Date')</label>
									{{Form::text('date',null,['class' => 'form-control date','id'=>'date','autocomplete'=>'off'])}}
								</div>
						    </div> 
                        </div>
                        
                        <div class="row" v-if="selectedEmployee">
                            <div class="col-md-6">
                                <div class="row">
                                    <div class="col-md-6" v-if="justLeaveDay>0">
                                        <div class="form-group">
                                                <label class="control-label">@lang('layout.JustLeaveDay')</label>
                                            <input type="number" class="form-control" :value="justLeaveDay" readonly>
                                        </div>
                                    </div>
                                    <div class="col-md-6" v-if="justLeaveHour>0">
                                        <div class="form-group">
                                                <label class="control-label">@lang('layout.JustLeaveHour')</label>
                                            <input type="number" class="form-control" :value="justLeaveHour" readonly>
                                        </div>
                                    </div>
                                    
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="row">
                                    <div class="col-md-6" v-if="unJustLeaveDay>0">
                                        <div class="form-group">
                                            <label class="control-label">@lang('layout.UnJustLeaveDay')</label>
                                            <input type="number" class="form-control"  :value="unJustLeaveDay" readonly>
                                        </div>
                                    </div>
                                    <div class="col-md-6" v-if="unJustLeaveHour>0">
                                        <div class="form-group">
                                            <label class="control-label">@lang('layout.UnJustLeaveHour')</label>
                                            <input type="number" class="form-control"  :value="unJustLeaveHour" readonly>
                                        </div>
                                    </div>
                                    
                                </div>
                            </div>
                        </div>
                        <div class="row" v-if="selectedEmployee && selectedEmployee.attendance_type=='daily'">
                            <div class="col-md-6" > 
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="control-label">@lang('layout.BasicSalary')</label>
                                            <div class="input-group">
                                                <input type="number" class="form-control" name="basicSalary" :value="(!salary)?null:salary.amount" readonly="readonly">

                                                 <input type="hidden" name="sal_id" v-model.salnumer="(!selectedEmployee)?null:selectedEmployee.sal_id">

                                                 <input type="hidden" name="sal_currency" v-model.salnumer="(!selectedEmployee)?null:selectedEmployee.currency">
                                                  <span class="input-group-addon">@{{(selectedEmployee)?selectedEmployee.currency:null}}</span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6" >
                                        <span v-if="(selectedEmployee && selectedEmployee.currency != '{{getHomeCurrency()["code"]}}')?selectedEmployee.currency:null">
                                            <div class="form-group">
                                                <label class="control-label">@lang('layout.SalaryRate') </label>
                                                <div :class="{'has-error':selectedEmployee.rate < 0}">
                                                    <div class="input-group">
                                                        <input v-model="selectedEmployee.rate" @click="cRate(selectedEmployee.rate)"  class="form-control" name="salaryRate"
                                                               type="number" min="0" step="any">
                                                        <span class="input-group-addon">@{{(selectedEmployee)?selectedEmployee.currency:null}}</span>
                                                    </div>
                                                </div>
                                            </div>
                                        </span>
                                    </div>

                                    <div class="col-md-6" >
                                        <div class="form-group">
                                            <label class="control-label">@lang('layout.Currency')</label>
                                               <v-select  label="code" :options="currency" v-model="selectedCurrency"></v-select>
                                        </div>
                                    </div>      

                                    <input type="hidden" name="payroll_currency" v-bind:value="selectedCurrency.code"/>
                                    <div class="col-md-6" v-if="selectedCurrency.code != '{{getHomeCurrency()["code"]}}'">
                                        <div class="form-group">
                                            <label class="control-label">@lang('layout.PaymentRate') </label>
                                                <div :class="{'has-error':selectedCurrency.rate < 0}">
                                                    <div class="input-group">
                                                    <input  v-model="selectedCurrency.exchange_rate" class="form-control"
                                                           type="number" min="0" step="any">
                                                    <span class="input-group-addon">@{{selectedCurrency.code}}</span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <input type="hidden" name="currency_rate" :value="selectedCurrency.exchange_rate">

                                </div>
                            </div> 
                            <div class="col-md-6" > 
                                <div class="row">
                              
                                    

                                    <div class="col-md-6">
                                         <div class="form-group">
                                             <label class="control-label">@lang('layout.PaidLeave')</label>
                                             {{Form::number('paidLeave',null,['class' => 'form-control','step' => 'any','min' =>'0','v-model'=>'paidLeave'])}}

                                             {{-- <span class="required">@{{ errors.first('paidLeave') }}</span> --}}
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                         <div class="form-group">
                                            <label class="control-label"> @lang('layout.WorkedDay')</label>
                                             {{Form::number('workedDay',null,['class' => 'form-control','step' => 'any','min' =>'0','v-model'=>'workdays','v-validate' =>'"required"','data-vv-as' => __('layout.WorkedDay'),'readonly'])}}
                                             <span class="required">@{{ errors.first('workedDay') }}</span>

                                        </div>
                                    </div>    

                                    <div class="col-md-6" v-if="hourly">
                                         <div class="form-group">
                                             <label class="control-label">@lang('layout.HourNo')</label>
                                             {{Form::number('hourlyStatick',null,['class' => 'form-control','step' => 'any','min' =>'0','v-model'=>'hourlyStatick','v-validate' =>'"required"','data-vv-as' => __('layout.HourNo')])}}

                                             <span class="required">@{{ errors.first('hourlyStatick') }}</span>
                                        </div>
                                    </div>
                                    <div class="col-md-6" v-if="hourly">
                                         <div class="form-group">
                                            <label class="control-label"> @lang('layout.WorkedHour')</label>
                                             {{Form::number('hourlyAtt',null,['class' => 'form-control','step' => 'any','min' =>'0','v-model'=>'hourlyAtt','v-validate' =>'"required"','data-vv-as' => __('layout.WorkedHour'),'readonly'])}}
                                             <span class="required">@{{ errors.first('hourlyAtt') }}</span>

                                        </div>
                                    </div>
                                </div> 
                            </div> 
                        </div>
                        <div class="row" v-if="selectedEmployee && selectedEmployee.attendance_type=='daily'">
                            <!-- div class="col-md-6">
                                <div class="row">
                                    <div class="col-md-6">
                                         <div class="form-group">
                                            <label class="control-label">@lang('layout.OverTimeAdditionType')</label>
                                            <select class="form-control" placeholder="selectype" name="type" v-model="type">
                                                <option disabled>@lang('layout.SelectType')</option>
                                                <option value="daily">@lang('layout.Daily')</option>
                                                <option value="hourly">@lang('layout.Hourly')</option>
                                                <option value="montly">@lang('layout.Montly')</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="control-label"> @lang('layout.Amount')</label>
                                             {{Form::number('amount',null,['class' => 'form-control','step' => 'any','min' =>'0','v-model'=>'amount'])}}
                                        </div>
                                    </div>
                                </div>
                            </div -->
                            <!-- div class="col-md-6">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="control-label"> @lang('layout.Fee')</label>
                                             {{Form::number('fee',null,['class' => 'form-control','step' => 'any','min' =>'0','v-model'=>'fee'])}}
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                             <label class="control-label">@lang('layout.TotalOverTime')</label>
                                            <input type="number" class="form-control" value="0" name="overtime" :value="amount*fee" readonly>
                                        </div>
                                    </div>
                                </div>
                            </div -->
                        </div>

                        <div class="row" v-if="selectedEmployee && (overtime_qty||delay_qty)">
                            <div class="col-md-6">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                                <label class="control-label">@lang('layout.OvertimeHours')</label>
                                            <input type="number" class="form-control" :value="overtime_qty" readonly>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                                <label class="control-label">@lang('layout.OvertimeAmount')</label>
                                            <input type="number" class="form-control" name="overtime_amount"  :value="overtime_amount" readonly>
                                        </div>
                                    </div>
                                    
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="control-label">@lang('layout.DelayHours')</label>
                                            <input type="number" class="form-control"  :value="delay_qty" readonly>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                                <label class="control-label">@lang('layout.DelayAmount')</label>
                                            <input type="number" class="form-control" name="delay_amount" :value="delay_amount" readonly>
                                        </div>
                                    </div>
                                    
                                </div>
                            </div>
                        </div>
                        <div class="row" v-if="selectedEmployee && selectedEmployee.attendance_type=='daily'">
                            <div class="col-md-6">
                                <div class="row">
									<div class="col-md-4">
                                        <div class="form-group">
                                             <label class="control-label">@lang('layout.Rent')</label>
                                            <input type="number" class="form-control" :value="rent" readonly>
                                            <input type="hidden" class="form-control" name="rent" :value="rents" readonly>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                             <label class="control-label">@lang('layout.TotalOverTime')</label>
                                            <input type="number" class="form-control" name="overtime" :value="overtime" readonly>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                         <div class="form-group">
                                             <label class="control-label">@lang('layout.NetPayable')</label>
                                            <input type="number" class="form-control"  name="netPayable" :value="netPayable.toFixed(3)" step="any" readonly="readonly">
                                        </div>
                                    </div>
                                    
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="row">
								    <div class="col-md-6">
                                         <div class="form-group">
                                            <label class="control-label">@lang('layout.ExpenseAccount')</label>
                                            {{Form::select('expense_id',$expense,null,['class' => 'form-control','v-validate' =>'"required"','data-vv-as' => __('layout.ExpenseAccount')])}}
                                             <span class="required">@{{ errors.first('expense_id') }}</span>

                                        </div>
                                    </div> 
                                    <div class="col-md-6">
                                         <div class="form-group">
                                            <label class="control-label"> @lang('layout.Description')</label>
                                            {!! Form::textarea('description', null, array('placeholder' => __('layout.Description'),'class' => 'form-control','rows' => 2, 'cols' => 30)) !!}
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                         <div class="row" v-if="selectedEmployee && selectedEmployee.attendance_type!='daily'">
                           
                            <div class="col-md-12" > 
                                <div class="row">
                                      <div class="col-md-3">
                                        <div class="form-group">
                                            <label class="control-label">@lang('layout.BasicSalary')</label>
                                            <div class="input-group">
                                                <input type="number" class="form-control" name="basicSalary" v-model="(!salary)?null:salary.amount" >

                                                 <input type="hidden" name="sal_id" v-model.salnumer="(!selectedEmployee)?null:selectedEmployee.sal_id">

                                                 <input type="hidden" name="sal_currency" v-model.salnumer="(!selectedEmployee)?null:selectedEmployee.currency">
                                                  <span class="input-group-addon">@{{(selectedEmployee)?selectedEmployee.currency:null}}</span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-3" >
                                        <span v-if="(selectedEmployee && selectedEmployee.currency != '{{getHomeCurrency()["code"]}}')?selectedEmployee.currency:null">
                                            <div class="form-group">
                                                <label class="control-label">@lang('layout.SalaryRate') </label>
                                                <div :class="{'has-error':selectedCurrency.rate < 0}">
                                                    <div class="input-group">
                                                        <input v-model="selectedEmployee.rate" class="form-control" name="salaryRate"
                                                               type="number" min="0" step="any">
                                                        <span class="input-group-addon">@{{(selectedEmployee)?selectedEmployee.currency:null}}</span>
                                                    </div>
                                                </div>
                                            </div>
                                        </span>
                                    </div>

                                    <div class="col-md-3" >
                                        <div class="form-group">
                                            <label class="control-label">@lang('layout.Currency')</label>
                                           
                                               <v-select  label="code" :options="currency" v-model="selectedCurrency"></v-select>
                                             
                                        </div>
                                    </div>      

                                    <input type="hidden" name="payroll_currency" v-bind:value="selectedCurrency.code"/>
                                    <div class="col-md-3" v-if="selectedCurrency.code != '{{getHomeCurrency()["code"]}}'">
                                        <div class="form-group">
                                            <label class="control-label">@lang('layout.PaymentRate') </label>
                                                <div :class="{'has-error':selectedCurrency.rate < 0}">
                                                    <div class="input-group">
                                                    <input  v-model="selectedCurrency.exchange_rate" class="form-control"
                                                           type="number" min="0" step="any">
                                                    <span class="input-group-addon">@{{selectedCurrency.exchange_rate}}</span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <input type="hidden" name="currency_rate" :value="selectedCurrency.exchange_rate">

                                    


                                </div>
                            </div> 
                            <div class="col-md-6" > 
                                <div class="row">
                              
                                    <div class="col-md-6">
                                         <div class="form-group">
                                             <label class="control-label">@lang('layout.Fee')</label>
                                             {{Form::number('PresentsHS',null,['class' => 'form-control','step' => 'any','min' =>'0','v-model'=>'PresentsHS ','v-validate' =>'"required"','data-vv-as' => __('layout.PaidLeave'),'readonly'])}}

                                             <span class="required">@{{ errors.first('paidLeave') }}</span>
                                        </div>
                                    </div>
                                </div> 
                            </div> 
                        </div>

						<div class="row" v-if="selectedEmployee && selectedEmployee.attendance_type !='daily'">
                            <div class="col-md-6">
                                <div class="row">
									<div class="col-md-6">
                                        <div class="form-group">
                                             <label class="control-label">@lang('layout.TotalOverTime')</label>
                                            <input type="number" class="form-control" name="overtime" :value="overtime" readonly>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                         <div class="form-group">
                                             <label class="control-label">@lang('layout.NetPayable')</label>
                                            <input type="number" class="form-control"  name="netPayableNotDaily" :value="netPayableNotDaily.toFixed(3)" step="any" readonly="readonly">
                                        </div>
                                    </div>
                                    
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="row">
								    <div class="col-md-6">
                                         <div class="form-group">
                                            <label class="control-label">@lang('layout.ExpenseAccount')</label>
                                            {{Form::select('expense_id',$expense,null,['class' => 'form-control','v-validate' =>'"required"','data-vv-as' => __('layout.ExpenseAccount')])}}
                                             <span class="required">@{{ errors.first('expense_id') }}</span>

                                        </div>
                                    </div> 
                                    <div class="col-md-6">
                                         <div class="form-group">
                                            <label class="control-label"> @lang('layout.Description')</label>
                                            {!! Form::textarea('description', null, array('placeholder' => __('layout.Description'),'class' => 'form-control','rows' => 2, 'cols' => 30)) !!}
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            @if(systemConfig()[5] != 0 )
                                <div class="col-md-3"> 
                                    <label class="control-label">@lang('layout.Project')</label>
                                    <v-select class="vue-select2" label="name" @search="ProjectSearch"
                                            :options="project_list" v-model="selectedProject">
                                    </v-select>
                                    <input type="hidden" name="project_id" v-model.number="(!selectedProject)?null:selectedProject.project_id">
                                </div>
                            @endif
                            @if(systemConfig()[19] == 1)
                                <div class="col-md-3"> 
                                    <label class="control-label">@lang('layout.NGOProject')</label>
                                    <v-select class="vue-select2" label="name" @search="searchNgoProjects" :options="NgoProject_list" v-model="selectedNgoProject">
                                    </v-select>
                                    <input type="hidden" name="ngo_project_id" v-model.number="(!selectedNgoProject)?null:selectedNgoProject.id">
                                </div>
                            @endif
                            @if(systemConfig()[20] == 1)
                            <div v-if="!contract_percentage" class="col-md-2"> 
                                <label class="control-label">@lang('menu.Contract')</label>
                                <v-select class="vue-select2" 
                                        @search="searchContracts"
                                        v-model="selectedContract" label="company_name"
                                        :options="contract_list">
                                </v-select>
                                <input type="hidden" name="contract_id" v-model.number="(!selectedContract)?null:selectedContract.id" />
                            </div>
                            @endif
                            <div class="col-md-2">
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <div style="display: flex; flex-direction: column; justify-content: center; align-items: center;">
                                                <label class="control-label">@lang('layout.BuildExpense')</label>
                                                <input type="checkbox" name="build_expense_confirm" id="" value="On">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            @if(systemConfig()[20] == 1)
                            <div class="col-md-2">
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <div style="display: flex; flex-direction: column; justify-content: center; align-items: center;">
                                                <label class="control-label">@lang('layout.MultiContract')</label>
                                                <input type="checkbox" name="contract_percentage" v-model="contract_percentage" value="on">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            @endif

                        </div>
						
                    </div>
                    <!--/row-->



                     <!-- begin tax -->
                     <div class="row">
                        <input type="checkbox" name="tax" v-model="tax">
                        @lang('layout.Tax')
                       <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12" v-if="tax">
                           <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                               <div class="col-md-12">
                                   <label class="control-label">@lang('layout.TaxCurrency')</label>
                                   <v-select  label="code" :options="taxCurrency" v-model="selectedTaxCurrency"></v-select> 
                                   <input type="hidden" name="tax_currency" class="form-control" v-validate="'required'"
                                                  data-vv-as="@lang('layout.TaxCurrency')" :value=(!selectedTaxCurrency)?null:selectedTaxCurrency.code>
                                   <span class="required">@{{ errors.first('tax_currency') }}</span>
                                   

                                 <span class="required">@{{ errors.first('tax_currency') }}</span>
                               </div>
                           </div>

                           <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                               <div class="col-md-12">
                                   <label class="control-label ">@lang('layout.Rate')</label>
                                   <input type="number" name="tax_rate" class="form-control" v-validate="'required'"
                                                  data-vv-as="@lang('layout.Rate')" v-model=(!selectedTaxCurrency)?null:selectedTaxCurrency.rate>
                                   <span class="required">@{{ errors.first('tax_currency') }}</span>

                                   
                               </div>
                           </div>

                           <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                               <div class="col-md-12">
                                   <label class="control-label ">@lang('layout.PaymentType')</label>
                                   <br>
                                   <input type="checkbox" readonly name="by_employee" v-model="paymentType">
                                   @lang('layout.ByEmployee')
                                   
                               </div>
                           </div>

                             <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                               <div class="form-group">
                                   <label class="control-label"> @lang('layout.AgencyTax')</label>
                                  <v-select   
                                  placeholder="@lang('layout.SelectEmployee')" 
                                  label="name"
                                   v-model="selectedMember"
                                   :options="members"
                                   @search="onAgencySearch"
                                       >       
                                   </v-select>
                                   <input type="hidden" name="tax_member" v-model.number="(!selectedMember)?null:selectedMember.id" >
                               </div>
                           </div>

                           <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <label class="control-label"> @lang('layout.ExpenseAccount')</label>
                                       <v-select   placeholder="@lang('layout.ExpenseAccount')" label="name"
                                           v-model="selected_tax_expense"
                                        :options="{{$expense_tax}}">       
                                       </v-select>
                                       <input type="hidden" name="selected_tax_expense" v-model="(!selected_tax_expense)?null:selected_tax_expense.id" >

                                   </div>
                           </div> 
                       </div> 
                   </div>
                   <!-- end tax -->

                   <br/>
                    @if(systemConfig()[20] == 1)
                    <!-- begin multiContract -->
                    <table v-if="contract_percentage" id="table_content" class="table table-striped table-bordered table-advance table-hover">
                        <thead>
                            <tr>
                                <th class="text-center" style="min-width: 8px;"> #</th>
                                <th class="text-center" style="min-width: 160px;">@lang('layout.ContractName')</th>
                                <th class="text-center" style="min-width: 160px;">@lang('layout.Percentage')</th>
                                <th></th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr v-for="(record,index) in multiContractData">
                                <td class="text-center">@{{index+1}}</td>
                                <td class="highlight">
                                    <v-select class="vue-select2" placeholder="@lang('layout.Select')"
                                            v-model="record.selected" 
                                            label="company_name"
                                            @search="searchContracts"
                                            :options="contract_list" @click.native="addNew('multiContract',index)" >
                                    </v-select>
                                    <input type="hidden" name="multiContract_id[]" :value="(record.selected==null)?null:record.selected.id">
                                </td>

                                <td>
                                    <input class="form-control" type="number" name="percentage[]"
                                        v-model.number="record.percentage" placeholder="@lang('layout.Percentage')">
                                </td>

                                <td class="text-center" style="vertical-align: middle;">
                                    <span v-on:click="deleteItem('multiContract',index)"><i class="paddint-both glyphicon glyphicon-trash text-danger" style="cursor: pointer;"></i></span>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                    <!-- end multiContract -->
                    @endif


                </div>
                <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                        <button type="button" @click="handleSubmit($event)" class="btn green">@lang('layout.Submit')</button>
                        <button type="button" class="btn blue" @click="saveAndNew($event)" >@lang('layout.SaveAndNew')</button>
                     <a href="{{route('payroll.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
               </div> 
             {{Form::close()}}
            </div>               
            <!-- END FORM-->
        </div>
    </div> 
@endsection
@push('scripts')

<script>
      @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
    Vue.use(VeeValidate, {
        locale: 'en',
    });
    @endif

    
    
      ////
     Vue.component("v-select", VueSelect.VueSelect);
        var Currency ={!! $currency !!};
        
        var TaxCurrency ={!! $currency !!}

        var app = new Vue({
            el: '#app',
            data: {
                selectedCurrency:defaultCurrency(),
                currency:Currency,
                currencyList: Currency,
                employees: [],
                salaryType:null,
                workdays:0,
                salary:null,
                selectedBank:null,
                selectedEmployee:null,
                members:[],
                selectedMember:null,
                paidLeave:0,
                selected_tax_expense:null,
                pay:false,
                type:null,
                amount:0,
                salaryAmount:0,
                fee:null,
                basicSalary:0,
                from:null,
                to:null,
                advancePaid:0,
                hourlyAtt:0,
                hourlyStatick:0,
                overtime:0,
                overtimes:0,
                hourly:false, 
                taxCurrency:TaxCurrency,
                selectedTaxCurrency:null,
                selectedProject: null,
                project_list: [],
                selectedNgoProject: null,
                NgoProject_list: [],
                rent  :null,
                rents  :null,
                Presents  :null,
                PresentsHS:null,
                Absent    :null,
                AbsentHS :null,
                total_justified_absent:null,
                num_days:null,
                // fridays:null, 
                fee_amount:0,
                overtime_qty:0,
                delay_qty:0,
                overtime_amount:0,
                delay_amount:0,
                total_overtime_amount:0,
                total_delay_amount:0,
                shiftStatick:0,
                justLeaveDay:0,
                unJustLeaveDay:0,
                justLeaveHour:0,
                unJustLeaveHour:0,
                contract_list:[],
                selectedContract :null, 
                paymentType:1,
                tax:0,
                contract_percentage:null,
                multiContractData: [
                    {percentage: 0, selected: null},
                    {percentage: 0, selected: null},
                ],
            
            },
            watch: {
            },
            computed:{
                  netPayable()
                        {  
                            // if(this.salary !=undefined && this.salary !=null)
                            // {
                            //   this.salaryAmount=this.salary.amount;
                            //   this.selectedEmployee['currency']=this.salary.currency;
                            //   this.selectedEmployee['sal_id']=this.salary.id;
                            //   this.selectedEmployee['rate']=this.salary.rate;
                            // }
                            this.selectedEmployee.rate = Number.parseFloat(this.selectedEmployee.rate);
                            var em_rate = this.selectedEmployee.rate;
                            var static_rate = Number.parseFloat(this.selectedEmployee.static_rate);
                            var total=0;
                            var workdays   = parseFloat((this.workdays)?this.workdays:0)
                            var paidLeave  = parseFloat((this.paidLeave)?this.paidLeave:0)
                            var num_days  = parseFloat((this.num_days)?this.num_days:1)
                            var amount     = parseFloat((this.amount)?this.amount:0);
                            var fee        = parseFloat((this.fee)?this.fee:0);
                            var hourlyStatick = parseFloat((this.hourlyStatick)?this.hourlyStatick:8);
                            var hourlyAtt = parseFloat((this.hourlyAtt)?this.hourlyAtt:0);
                            var overtime  = (this.overtimes * app.selectedCurrency.exchange_rate);
							this.overtime  = (this.overtimes * app.selectedCurrency.exchange_rate);
							var ex_static_rate  = (this.overtimes * app.selectedCurrency.static_rate);

                            @if(systemConfig()[30] == 1)
                            var rent  = (((this.rents / static_rate * em_rate)  *  ex_static_rate /  app.selectedCurrency.exchange_rate));
                            @else 
                            var rent  = ((this.rents * app.selectedCurrency.exchange_rate) / app.selectedEmployee.rate);
                            @endif

							this.rent  = rent;
							
							var overtime_qty = 0;
							var delay_qty = 0;
							
                            let temp_s_e=this.selectedEmployee;
                           
                            if(this.selectedEmployee && app.selectedEmployee.rate > 0) {
                                if(workdays && !this.hourly)
                                {
                                    if(app.salaryType =="TwiceAMonth"){
                                        num_days = 15;
                                    }else if(app.salaryType =="TwoWeek"){
                                        num_days = 14;
                                    }else if(app.salaryType =="Weekly"){
                                        num_days = 7;
                                    }else if(app.salaryType =="Daily"){
                                        num_days = 1;
                                    }else{ 
                                        num_days = 30;
                                    }

                                    // console.log(12, num_days);

                                    @if(systemConfig()[30] == 1)
                                     var day = (((this.salaryAmount / app.selectedEmployee.static_rate * app.selectedEmployee.rate) * this.selectedCurrency.static_rate / this.selectedCurrency.exchange_rate) / num_days);
                                  // var day = ((this.salaryAmount * this.selectedCurrency.exchange_rate / app.selectedEmployee.rate) / num_days);
                                     @else 
                                     var day = ((this.salaryAmount * this.selectedCurrency.exchange_rate / app.selectedEmployee.rate) / num_days);
                                     @endif
                                     // var ff=fee*this.selectedCurrency.exchange_rate;
                                    //  console.log('ffffcckk',this.selectedEmployee['rate']);
                                    // overtime and delay
                                    @if(getOvertimeDelaySalary()=="true")
                                        var overtime_qty = this.overtime_qty*(day / hourlyStatick);
                                        var delay_qty = this.delay_qty*(day / hourlyStatick);
                                    @else
                                        var overtime_qty = this.total_overtime_amount;
                                        var delay_qty = this.total_delay_amount;
                                    @endif

                                     total = Number.parseFloat(day * (workdays + paidLeave)) + Number.parseFloat(overtime) + Number.parseFloat(rent) + Number.parseFloat(overtime_qty) - Number.parseFloat(delay_qty);
									//  console.log('ffffccpp',day,workdays,paidLeave,overtime,total);
                                }
								else if(hourlyAtt && this.hourly)
                                {
                                    @if(systemConfig()[30] == 1)
                                    var day = (((this.salaryAmount / app.selectedEmployee.static_rate * app.selectedEmployee.rate) * this.selectedCurrency.static_rate / this.selectedCurrency.exchange_rate) / (num_days * hourlyStatick));
                               //   var day = ((this.salaryAmount * this.selectedCurrency.exchange_rate / this.selectedEmployee['rate']) / (num_days * hourlyStatick));
                                    @else 
                                     var day = ((this.salaryAmount * this.selectedCurrency.exchange_rate / this.selectedEmployee['rate']) / (num_days * hourlyStatick));
                                    @endif
                                     // var ff=fee*this.selectedCurrency.exchange_rate;
                                    //  console.log('ffffcc',day,hourlyAtt,paidLeave,hourlyStatick);

                                    // overtime and delay
                                    @if(getOvertimeDelaySalary()=="true")
                                        var overtime_qty = this.overtime_qty*day;
                                        var delay_qty = this.delay_qty*day;
                                    @else
                                        var overtime_qty = this.total_overtime_amount;
                                        var delay_qty = this.total_delay_amount;
                                    @endif


                                     total = Number.parseFloat(day * (hourlyAtt + (paidLeave * hourlyStatick))) + Number.parseFloat(overtime) + Number.parseFloat(rent) + Number.parseFloat(overtime_qty) - Number.parseFloat(delay_qty);
							        // console.log('kkkkkk',total);
                                }
                                else
                                {
                                    // console.log('kkkkkk',total);

                                    // overtime and delay
                                    @if(getOvertimeDelaySalary()=="true")
                                    @if(systemConfig()[30] == 1)
                                        var overtime_qty = this.overtime_qty*((((this.salaryAmount / app.selectedEmployee.static_rate * app.selectedEmployee.rate) * this.selectedCurrency.static_rate / this.selectedCurrency.exchange_rate)) / (num_days*hourlyStatick));
                                    @else 
                                        var overtime_qty = this.overtime_qty*((this.salaryAmount * this.selectedCurrency.exchange_rate/this.selectedEmployee['rate']) / (num_days*hourlyStatick));
                                    @endif
                                    @if(systemConfig()[30] == 1)
                                        var delay_qty = this.delay_qty*((((this.salaryAmount / app.selectedEmployee.static_rate * app.selectedEmployee.rate) * this.selectedCurrency.static_rate / this.selectedCurrency.exchange_rate)) / (num_days*hourlyStatick));
                                    @else 
                                        var delay_qty = this.delay_qty*((this.salaryAmount * this.selectedCurrency.exchange_rate/this.selectedEmployee['rate']) / (num_days*hourlyStatick));
                                    @endif   
                                                                     
                                    @else
                                        var overtime_qty = this.total_overtime_amount;
                                        var delay_qty = this.total_delay_amount; 
                                    @endif

                                    @if(systemConfig()[30] == 1)
                                    var ff=fee*this.selectedCurrency.static_rate / this.selectedCurrency.exchange_rate; 
                                    @else 
                                    var ff=fee*this.selectedCurrency.exchange_rate; 
                                    @endif  
 
                                    @if(systemConfig()[30] == 1)
                                    total=Number.parseFloat((((this.salaryAmount / app.selectedEmployee.static_rate * app.selectedEmployee.rate) * this.selectedCurrency.static_rate / this.selectedCurrency.exchange_rate)) / num_days)+Number.parseFloat(overtime)+Number.parseFloat(rent) + Number.parseFloat(overtime_qty) - Number.parseFloat(delay_qty);
                                    @else 
                                    total=Number.parseFloat((this.salaryAmount * this.selectedCurrency.exchange_rate/this.selectedEmployee['rate']) / num_days)+Number.parseFloat(overtime)+Number.parseFloat(rent) + Number.parseFloat(overtime_qty) - Number.parseFloat(delay_qty);
                                    @endif 
                                }
                                this.overtime_amount = overtime_qty;
                                this.delay_amount = delay_qty;
                            }
							// console.log('ffffpppp',total);
                             return total;
                        },  

                        netPayableNotDaily()
                        {
                         
                            // if(this.salary !=undefined && this.salary !=null)
                            // {
                            //   this.salaryAmount=this.salary.amount;
                            //   this.selectedEmployee['currency']=this.salary.currency;
                            //   this.selectedEmployee['sal_id']=this.salary.id;
                            //   this.selectedEmployee['rate']=this.salary.rate;
                            // }
                            var total=0;
                            var workdays    = parseFloat((this.PresentsHS )?this.PresentsHS :0)
                            var amount     = parseFloat((this.amount)?this.amount:0);
                            var fee        = parseFloat((this.fee)?this.fee:0);
                            let temp_s_e=this.selectedEmployee;
                            @if(systemConfig()[30] == 1)
							var overtime  = (this.overtimes * app.selectedCurrency.static_rate / app.selectedCurrency.exchange_rate);
							this.overtime  = (this.overtimes * app.selectedCurrency.static_rate / app.selectedCurrency.exchange_rate);
                            @else 
							var overtime  = (this.overtimes * app.selectedCurrency.exchange_rate);
							this.overtime  = (this.overtimes * app.selectedCurrency.exchange_rate);
                            @endif
 
                            @if(systemConfig()[30] == 1)
							var rent  = (((this.rents / app.selectedEmployee.static_rate * app.selectedEmployee.rate) * this.selectedCurrency.static_rate / this.selectedCurrency.exchange_rate));
							@else 
							var rent  = ((this.rents * app.selectedCurrency.exchange_rate) / app.selectedEmployee.rate);
                            @endif

                            this.rent  = rent;

                            var hourlyStatick = parseFloat((this.hourlyStatick)?this.hourlyStatick:8);
                            var shiftStatick = parseFloat((this.shiftStatick)?this.shiftStatick:1);

                            var overtime_qty = 0;
							var delay_qty = 0;
                           
                            if(this.selectedEmployee) {
                                if(workdays)
                                {
                                    // console.log("works days",workdays,this.selectedEmployee);
                                    @if(systemConfig()[30] == 1)
                                    var day = ((((this.salaryAmount / app.selectedEmployee.static_rate * app.selectedEmployee.rate) * this.selectedCurrency.static_rate / this.selectedCurrency.exchange_rate)));
                                    @else 
                                    var day = ((this.salaryAmount * this.selectedCurrency.exchange_rate / this.selectedEmployee['rate']));
                                    @endif
                                    // overtime and delay
                                    var overtime_qty = this.overtime_qty*day;
                                    var delay_qty = this.delay_qty*day;

                                    if(this.selectedEmployee.attendance_type == "shifty")
                                    {
                                        var overtime_qty = this.overtime_qty*((day*shiftStatick)/hourlyStatick);
                                        var delay_qty = this.delay_qty*((day*shiftStatick)/hourlyStatick);
                                    }
                                    

                                    @if(systemConfig()[30] == 1)
                                     var ff=fee / this.selectedCurrency.static_rate * this.selectedCurrency.exchange_rate;
                                     @else 
                                     var ff=fee*this.selectedCurrency.exchange_rate;
                                    @endif

                                    //  console.log('ffff',this.salaryAmount,workdays,day);
                                     total = Number.parseFloat(day * workdays) + Number.parseFloat(overtime) + Number.parseFloat(rent) + Number.parseFloat(overtime_qty) - Number.parseFloat(delay_qty);
                                    //  console.log('total',total);
                                }
                                else
                                {
                                    @if(systemConfig()[30] == 1)
                                    var overtime_qty = this.overtime_qty*(((this.salaryAmount / app.selectedEmployee.static_rate * app.selectedEmployee.rate) * this.selectedCurrency.static_rate / this.selectedCurrency.exchange_rate));
                                    @else 
                                    var overtime_qty = this.overtime_qty*(this.salaryAmount * this.selectedCurrency.exchange_rate / this.selectedEmployee['rate']);
                                    @endif

                                    @if(systemConfig()[30] == 1)
                                    var delay_qty = this.delay_qty*(((this.salaryAmount / app.selectedEmployee.static_rate * app.selectedEmployee.rate) * this.selectedCurrency.static_rate / this.selectedCurrency.exchange_rate));
                                    @else 
                                    var delay_qty = this.delay_qty*(this.salaryAmount * this.selectedCurrency.exchange_rate / this.selectedEmployee['rate']);
                                    @endif


                                    @if(systemConfig()[30] == 1)
                                    var ff=fee / this.selectedCurrency.static_rate * this.selectedCurrency.exchange_rate;
                                    @else 
                                    var ff=fee*this.selectedCurrency.exchange_rate;
                                    @endif

                                    
                                    @if(systemConfig()[30] == 1)
                                    total = Number.parseFloat((((this.salaryAmount / app.selectedEmployee.static_rate * app.selectedEmployee.rate) * this.selectedCurrency.static_rate / this.selectedCurrency.exchange_rate)))+Number.parseFloat(overtime) + Number.parseFloat(rent) + Number.parseFloat(overtime_qty) - Number.parseFloat(delay_qty);
                                    @else 
                                    total = Number.parseFloat(this.salaryAmount * this.selectedCurrency.exchange_rate/this.selectedEmployee['rate'])+Number.parseFloat(overtime) + Number.parseFloat(rent) + Number.parseFloat(overtime_qty) - Number.parseFloat(delay_qty);
                                    @endif

                                }

                                this.overtime_amount = overtime_qty;
                                this.delay_amount = delay_qty;
                            }
                             return total;
                        },   
            },
            methods: { 
                 searchType() {
                    var from_date = document.getElementById('from_date').value;
                    var to_date = document.getElementById('to_date').value;
                    var member_id = app.selectedEmployee.id;
                    console.log('dddpp',from_date,to_date,member_id);
                    this.employess = [];
                    // this.typeInfo = null; 
                    if (from_date && to_date ) {
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'employeeFindAttendance',
                                from_date: from_date,
                                to_date:   to_date,
                                member_id:member_id
                            }
                        })
                            .then(function (response) {
                                    console.log('lalaresponse',response.data);
                                    
                                if (response.data) {
                                    app.workdays =response.data.Presents;
                                    app.Presents =response.data.Presents;
                                    app.PresentsHS=response.data.PresentsHS;
                                    app.Absent  =response.data.Absent;
                                    app.AbsentHS=response.data.AbsentHS;
                                    app.total_justified_absent=response.data.total_justified_absent;
                                    app.num_days=response.data.num_days;
                                    app.hourlyStatick=response.data.static_hour;
                                    app.hourlyAtt=response.data.PresentsHS;
                                    app.paidLeave=(response.data.fdcout + response.data.total_justified_absent);
									
									app.overtimes = response.data.totalOvertime;
                                    @if(systemConfig()[30] == 1)
									app.overtime = (response.data.totalOvertime / app.selectedCurrency.static_rate * app.selectedCurrency.exchange_rate);
                                    @else 
									app.overtime = (response.data.totalOvertime * app.selectedCurrency.exchange_rate);
                                    @endif
									app.rents = response.data.rent;

                                    @if(systemConfig()[30] == 1)
									app.rent = (((response.data.rent / app.selectedEmployee.static_rate * app.selectedEmployee.rate)* app.selectedCurrency.static_rate / app.selectedCurrency.exchange_rate));
                                    @else 
									app.rent = ((response.data.rent * app.selectedCurrency.exchange_rate) / app.selectedEmployee.rate);
                                    @endif

                                    app.overtime_qty = response.data.total_overtime_and_delay.total_overtime;
                                    app.delay_qty = response.data.total_overtime_and_delay.total_delay;

                                    app.total_overtime_amount = response.data.total_overtime_and_delay.total_overtime_amount;
                                    app.total_delay_amount = response.data.total_overtime_and_delay.total_delay_amount;


                                    app.shiftStatick=response.data.static_shift;

                                    app.justLeaveDay = response.data.count_total_justified_leave;
                                    app.unJustLeaveDay = response.data.count_total_unjustifiend_leave;
                                    app.justLeaveHour = response.data.count_justifiend_leave_hourly;
                                    app.unJustLeaveHour = response.data.count_unJustifiend_leave_houly;

                                    
                                    if(response.data.member){
                                        app.salaryType = response.data.member.salaryType;
                                    }
                                    if(response.data.member.attendance_type == "daily")
                                    {
                                        // if(data.salaryType =="TwiceAMonth"){
                                        //     num_days = 15;
                                        // }else if(data.salaryType =="TwoWeek"){
                                        //     num_days = 14;
                                        // }else if(data.salaryType =="Weekly"){
                                        //     num_days = 7;
                                        // }else if(data.salaryType =="Daily"){
                                        //     num_days = 1;
                                        // }else{ 
                                        //     num_days = 30;
                                        // }

                                        var hourlyStatick = parseFloat((app.hourlyStatick)?app.hourlyStatick:8);
                                        
                                        // app.workdays = app.workdays - app.justLeaveDay - (app.justLeaveHour/hourlyStatick) + app.unJustLeaveDay + (app.unJustLeaveHour/hourlyStatick) ;
                                        // app.paidLeave = app.paidLeave + app.justLeaveDay + (app.justLeaveHour/hourlyStatick) - app.unJustLeaveDay - (app.unJustLeaveHour/hourlyStatick) ;
                                        
                                        // app.workdays = app.workdays - app.justLeaveDay - (app.justLeaveHour/hourlyStatick) - app.unJustLeaveDay - (app.unJustLeaveHour/hourlyStatick) ;
                                        // app.paidLeave = app.paidLeave + app.justLeaveDay + (app.justLeaveHour/hourlyStatick); 
                                        
                                        app.paidLeave = app.paidLeave + app.justLeaveDay + (app.justLeaveHour/hourlyStatick) - app.unJustLeaveDay - (app.unJustLeaveHour/hourlyStatick);

                                        // app.hourlyAtt = app.hourlyAtt - (app.justLeaveDay*hourlyStatick) - app.justLeaveHour - (app.unJustLeaveDay*hourlyStatick) - app.unJustLeaveHour;
                                        // app.hourlyAtt = app.hourlyAtt + (app.justLeaveDay*hourlyStatick) + app.justLeaveHour - (app.unJustLeaveDay*hourlyStatick) - app.unJustLeaveHour;
                                    }
                                    if(response.data.member.attendance_type == "hourly")
                                    {
                                        var hourlyStatick = parseFloat((app.hourlyStatick)?app.hourlyStatick:8);

                                        app.PresentsHS = app.PresentsHS + (app.justLeaveDay*hourlyStatick) + app.justLeaveHour - (app.unJustLeaveDay*hourlyStatick) - app.unJustLeaveHour;
                                    }
                                    if(response.data.member.attendance_type == "shifty")
                                    {
                                        var hourlyStatick = parseFloat((app.hourlyStatick)?app.hourlyStatick:8);
                                        var shiftStatick = parseFloat((app.shiftStatick)?app.shiftStatick:1);

                                        app.PresentsHS = app.PresentsHS + (app.justLeaveDay*shiftStatick) + ((app.justLeaveHour/hourlyStatick)*shiftStatick) - (app.unJustLeaveDay*shiftStatick) - ((app.unJustLeaveHour/hourlyStatick)*shiftStatick);
                                    }
                                    
                                    

                                }
                                

                                // console.log('overtime_qty',app.overtime_qty)
                                // console.log('delay_qty',app.delay_qty)
                                // console.log('Presents',app.Presents)
                                // console.log('PresentsHS',app.PresentsHS)
                                // console.log('Absent',app.Absent)
                                // console.log('AbsentHS',app.AbsentHS)
                                // console.log('total_justified_absent',app.total_justified_absent)
                                // console.log('fdcout',response.data.fdcout)
                                // console.log('num_days',response.data.num_days)
                                // console.log('paidLeave',app.paidLeave)
                            })
                            .catch(function (error) {
                                console.log(error);
                            });

                            
                    }


                },
        
            onMemberSearch(search, loading) {
                axios.get("{{route('callMethod.search')}}", {
                    params: {
                        method_name: 'member',
                        type: 'Employee',
                        search: search,
                    }
                })
                .then(function (response) {
                    app.employees = [];
                    if (response.data.length > 0) {
                        app.employees = response.data;
                    }
                    loading(false);
                })
                .catch(function (error) {
                    console.log(error);
                })
            },

            getSalary(){
                if(this.selectedEmployee)
                {   console.log('se',this.selectedEmployee.attendance_type);
                    this.getSalaryRecord(this.selectedEmployee.id);
                  
                } 
            },



            onAgencySearch(search, loading) {
                    loading(true);
                    this.searchAgencyMember(search, loading, this);
                },
                searchAgencyMember(search, loading, vm) {
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'member',
                            type: '',
                            search: search,
                        }
                    })
                    .then(function (response) {
                        this.members = [];
                        if (response.data.length > 0) {
                            vm.members = response.data;
                            console.log(222, vm.members);
                        }
                        loading(false);
                    })
                    .catch(function (error) {
                        console.log(error);
                    })
                },







            cRate(rate){
                // if(this.selectedEmployee && rate)
                // {   console.log('se',this.selectedEmployee,  rate);
                    
                //   this.selectedEmployee.rate = rate;
                //   var a = app.selectedCurrency.exchange_rate;
                //   app.selectedCurrency.exchange_rate = Number.parseFloat(a) * 1;
                // } 
            },
            getSalaryRecord(id)
            {
                    $.ajax({
                    url: "{{route('callMethod.search')}}",
                    async:false,
                    data:{
                          method_name:'memberSalary',
                          employee_id:id,
                        },
                    success:function(data){
                        this.salary=data;
                        if(this.salary !=undefined && this.salary !=null)
                        {
                            this.salaryAmount=this.salary.amount;
                            this.selectedEmployee['currency']=this.salary.currency;
                            this.selectedEmployee['sal_id']=this.salary.id;
                            this.selectedEmployee['rate']=this.salary.rate;
                            this.selectedEmployee['static_rate']=this.salary.static_rate;
                        }
                        // console.log('sallkjk',this.salary);


                    }.bind(this),

                    error: function(error){
                        console.log(error)
                    }
                });
                  
            },   

            // Search Project
				ProjectSearch:_.debounce((search,loading)=>{
                    app.project_list=[];
				   loading(true);
				   axios.get("{{route('callMethod.search')}}",{
					params:{
					  method_name:'serarchProject',
					  keyword:search,
					}
				   })
				   .then(function (response)
				   {
					 this.project_list=[];
					 if(response.data.length>0)
					 {
						app.project_list=response.data;
						console.log('test 22',app.project_list);
					 }
					 loading(false);
				   })
				   .catch(function (error)
				   {
					  console.log(error);
				   });
				},getDebounceTime()),

                // Search Ngo Project

                searchNgoProjects(search, loading) {
                    loading(true);
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'anyTable',
                            keyword: search,
                            table_name: 'ngo_projects',

                        }
                    })
                    .then(function (response) {
                        app.NgoProject_list = [];
                        if (response.data.length > 0) {
                            app.NgoProject_list = response.data;
                        }
                        loading(false);
                    })
                    .catch(function (error) {
                        console.log(error);
                    })
                },
                // Search Contract
                searchContracts(search, loading) {
                    loading(true);
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'anyTable',
                            keyword: search,
                            table_name: 'contracts',
                            search_column:'company_name'
                        }
                    })
                    .then(function (response) {
                        app.contract_list = [];
                        if (response.data.length > 0) {
                            app.contract_list = response.data;
                        }
                        loading(false);
                    })
                    .catch(function (error) {
                        console.log(error);
                    })
                },

                // generic function for adding item to list
                addNew(type = null, index) {
                    if (type != null) {
                        if (type == 'multiContract') {
                            if (this.multiContractData[index + 1] == undefined) {
                                this.multiContractData.push({
                                    percentage: 0,
                                    selected: null
                                });
                            }
                        }
                    }

                },


                // delete item from list
                deleteItem(type = null, index) {
                    if (type != null) {
                        if (type == 'multiContract') {
                            this.multiContractData.splice(index, 1);
                        }
                    }

                },

              handleSubmit(e) {
                this.$validator.validate().then(valid => {
                    if (valid) {
                        // alert(e.target);
                        regForm(e.target);
                    }
                });
                }, 

                saveAndNew()
                {
                    this.$validator.validate()
                    .then(valid =>{
                        if(valid)
                        { 
                            var url="{{route('payrollFromAttendance.store')}}";
                            form_id='payroll-form';
                            var data= $('#'+form_id).serialize();
                            // console.log(444, data);
                            toggleBlock(true);
                            axios.post(url,data)
                            .then(function(response){
                                    toggleBlock(0);
                                    if(response.data.result==1)
                                    {
                                        $('#'+form_id).trigger('reset');
                                        
                                        toastr.success('',response.data.message); 
                                        location.reload();
                                    
                                    }
                                    else
                                    {
                                        var message="{{__('message.Warning')}}";
                                        //$('#error-sound')[0].play();
                                        toastr.warning('',message);
                                    }
                            })
                            .catch(function(error){
                            toggleBlock(0);
                                console.log(error);
                                var message="{{__('message.Warning')}}";
                                //$('#error-sound')[0].play();
                                toastr.warning('',message);
                            });
                        
                        }
                    })
                },
            }
        }); 
</script>
@endpush