@extends('layouts.app')
@section('style')
<style type="text/css">
   table.td{
        border-top:0px;
    }
    .header{
    
    }
</style>
@stop

@section('content')
 
      <div class="row">
            <!-- BEGIN EXAMPLE TABLE PORTLET-->
            <div class="portlet light bordered sale">
                <div class="portlet-title">
                    <div class="caption font-dark">
                        <i class="icon-settings font-dark"></i>
                        <span class="caption-subject bold uppercase">@lang('layout.PayrollDetails')</span>
                    </div>
                    <div class="tools"></div>
                </div>
                <div class="portlet-body">
                    <div class="row">
                       <div class="col-md-9">
                           <table class="table">
                                <thead>
                                 <tr class="header">
                                      <th>@lang('layout.Title')</th>
                                      <th>@lang('layout.Data')</th>
                                  </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>
                                            <i class="fa fa-user"></i> <b>@lang('layout.Name')</b>
                                        </td>
                                        <td>
                                            {{$payroll->Employee}}
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <i class="fa  "></i> <b>@lang('layout.BasicSalary')</b>
                                        </td> 
                                        <td>
                                            {{$payroll->amount}}
                                        </td>
                                    </tr> 
                                    <tr>
                                        <td>
                                            <i class="fa fa-clock-o"></i><b> @lang('layout.From')</b>
                                        </td> 
                                        <td>
                                            {{convertDate($payroll->From_Date)}}
                                        </td>
                                    </tr> 
                                    <tr>
                                        <td>
                                            <i class="fa fa-history"></i><b> @lang('layout.To')</b>
                                        </td> 
                                        <td>
                                            {{convertDate($payroll->To_Date)}}
                                        </td>
                                    </tr> 
                                    <tr>
                                        <td>
                                            <i class="fa fa-calendar-o"></i><b> @lang('layout.PaidLeave')</b>
                                        </td> 
                                        <td>
                                            {{$payroll->Paid_Leave}}
                                        </td>
                                    </tr> 
                                    <tr>
                                        <td>
                                            <i class="fa fa-calendar-check-o"></i><b> @lang('layout.WorkedDay')</b>
                                        </td> 
                                        <td>
                                            {{$payroll->Worked_Days}}
                                        </td>
                                    </tr><tr>
                                        <td>
                                            <i class="fa fa-calendar-check-o"></i><b> @lang('layout.AbsentDays')</b>
                                        </td> 
                                        <td>
                                            {{$payroll->absent_day}}
                                        </td>
                                    </tr>  

                                 @if($payroll->payroll_type == "salary_attendance")
                                    <tr>
                                        <td>
                                            <i class="fa fa-calendar-o"></i><b> @lang('layout.HourNo')</b>
                                        </td> 
                                        <td>
                                            {{$payroll->worked_hour}}
                                        </td>
                                    </tr> 
                                    <tr>
                                        <td>
                                            <i class="fa fa-calendar-check-o"></i><b> @lang('layout.WorkedHour')</b>
                                        </td> 
                                        <td>
                                            {{$payroll->static_time}}
                                        </td>
                                    </tr> 
                                    @endif

                                     <tr>
                                        <td>
                                            <i class="fa fa-calendar-plus-o"></i><b> 
                                            @lang('layout.Rent')</b>
                                        </td> 
                                        <td>
                                            {{$payroll->rent}}
                                        </td>
                                    </tr>
                                    @if($payroll->overtime_amount)
                                    <tr style="color: green">
                                        <td>
                                            <b> 
                                            @lang('layout.OvertimeAmount')</b>
                                        </td> 
                                        <td>
                                            {{$payroll->overtime_amount}}
                                        </td>
                                    </tr>
                                    @endif
                                    @if($payroll->delay_amount)
                                    <tr style="color: red">
                                        <td>
                                            <b> 
                                            @lang('layout.DelayAmount')</b>
                                        </td> 
                                        <td>
                                            {{$payroll->delay_amount}}
                                        </td>
                                    </tr>
                                    @endif
                                     <tr>
                                        <td>
                                            <i class="fa fa-calendar-plus-o"></i><b> 
                                            @lang('layout.OverTimeAddition')</b>
                                        </td> 
                                        <td>
                                            {{$payroll->overtime_addition}}
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <i class="fa fa-file-excel-o"></i> <b>@lang('layout.Account')</b>
                                        </td> 
                                        <td>
                                            {{$payroll->account}}
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <i class="fa fa-file-excel-o"></i> <b>@lang('layout.ExpenseAccount')</b>
                                        </td> 
                                        <td>
                                            {{$payroll->exAccount}}
                                        </td>
                                    </tr>
									@if(systemConfig()[7] != 0 )
                                    <tr>
                                        <td>
                                            <i class="fa  "></i><b> @lang('layout.PlateNumber')</b>
                                        </td> 
                                        <td>
                                            {{$payroll->vehicle_palet_num}}
                                        </td>
                                    </tr>
									@endif
                                    <tr>
                                        <td>
                                            <i class="fa  "></i><b> @lang('layout.Tax')</b>
                                        </td> 
                                        <td>
                                            {{myRound($payroll->tax_amount)}} {{$payroll->tax_currency}}
                                        </td>
                                    </tr>                                    

                                    <tr>
                                        <td>
                                            <i class="fa  "></i><b> @lang('layout.NetPayable')</b>
                                        </td> 
                                        <td>
                                            <?php
                                                $tax = 0;
                                                if($payroll->tax_rate > 0){
                                                    $tax = ($payroll->tax_amount/$payroll->tax_rate) * $payroll->rate;
                                                }
                                            ?>
                                            {{myRound($payroll->Net_Payable-$tax)}}
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <i class="fa "></i> <b>@lang('layout.Currency')</b>
                                        </td> 
                                        <td>
                                            {{$payroll->currency}}
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <i class="fa fa-bars"></i> <b>@lang('layout.BuildExpense')</b>
                                        </td> 
                                        @if($payroll->build_expense_confirm)
                                        <td class="">
                                            {{__('layout.'.ucfirst($payroll->build_expense_confirm))}}
                                        </td>
                                        @else
                                            <td>

                                            </td>
                                        @endif
                                    </tr>
                                    <tr>
                                        <td>
                                            <i class="fa fa-bars"></i> <b>@lang('layout.Description')</b>
                                        </td> 
                                        <td>
                                            {{$payroll->description}} 
                                        </td>
                                    </tr>
                                    @if(systemConfig()[20] == 1 && $payroll->contract_name)
                                    <tr>
                                        <td>
                                            <i class="fa fa-bars"></i> <b>@lang('menu.Contract')</b>
                                        </td> 
                                        <td>
                                            {{$payroll->contract_name}} 
                                        </td>
                                    </tr>
                                    @endif

                                </tbody>
                            </table>
                       </div> 
                    </div>
                </div>
            </div>
            <!-- END EXAMPLE TABLE PORTLET-->
    </div>
@endsection
 
