@extends('layouts.factor-master')
@section('content')
<h4 class="bold uppercase" style="text-align: center; font-size: 20px;">@lang('layout.PayrollVouchar') <bdo dir="ltr">
    (PV) </bdo></h4>



<table style="width: 100%; margin-bottom: 10px;">

  <tr class="myclass">
    <td>
      <span style="text-align: right; width:20%;font-size:14px">@lang('layout.Number'): </span>
      <span style="text-align: right; width:30%;font-size:14px">{{$payrolls[0]->id}}</span>
    </td>
    <td>

      <span style="text-align: right; width:20% ;font-size:14px">@lang('layout.From'): </span>
      <BDO DIR="LTR"> <span
          style="text-align: right; width:30% ;font-size:14px">{{convertDate($payrolls[0]->From_Date)}}</span> </BDO>
    </td>

    <td>
      <span style="text-align: right; width:20% ;font-size:14px">@lang('layout.To'):</span>
      <BDO DIR="LTR"> <span
          style="text-align: right; width:30% ;font-size:14px">{{convertDate($payrolls[0]->To_Date)}}</span> </BDO>
    </td>
    <td>
      <span style="text-align: right; width:20% ;font-size:14px">@lang('layout.BasicSalary'):</span>
      <span style="text-align: right; width:30% ;font-size:14px">{{$payrolls[0]->BasicSalary}}</span> <span
        style="text-align: right;font-size:14px">{{$payrolls[0]->SalaryCurrency}}</span>
    </td>
  </tr>
</table>


<table style="width: 100%; margin-bottom: 10px;" class=" main-table">
  <thead>
    <tr class="">
      <th class=""> @lang('layout.Currency') </th>
      <th class=""> @lang('layout.Receivable')</th>
      <th class=""> @lang('layout.Payable') </th>
    </tr>
  </thead>
  <tbody>
    @foreach(getStatement($payrolls[0]->member_id) as $value )
    <tr class="">
      <td class="">
        {{$value['currency']}}
      </td>
      <td class="">
        {{$value['invoice']}}
      </td>
      <td class="">
        {{$value['payment']}}
      </td>
    </tr>
    @endforeach
  </tbody>
</table>



<table style="width: 100%; margin-bottom: 10px;">

  <tr>
    <td>
      <span style="font-size:14px">@lang('layout.Amount'):</span>
      <span style="font-size:14px">{{myRound($payrolls[0]->Net_Payable)}} {{$payrolls[0]->Curreny}}</span>
    </td>


    <td>
      <span style="font-size:14px">@lang('layout.Tax'):</span>
      <span style="font-size:14px">{{myRound($payrolls[0]->tax_amount)}} {{$payrolls[0]->tax_currency}}</span>
    </td>
    <td>
      <span style="font-size:14px">@lang('layout.Receiver'):</span>
      <span style="font-size:14px">{{$payrolls[0]->Employee}}</span>
    </td>
    <td>
      <span style="font-size:14px">@lang('layout.Accountant'):</span>
      <span style="font-size:14px">{{$user}}</span>
    </td>
    <!--  <td>
     <span >@lang('layout.Description')</span>
     <span >{{$payrolls[0]->description}}</span>
  </td> -->
  </tr>
</table>

<table style="width: 100%; margin-bottom: 10px;" class=" main-table">
  <thead>
    <tr class="">
      <th class=""> @lang('layout.WorkedDay') </th>
      <th class=""> @lang('layout.PaidLeave')</th>
      <th class=""> @lang('layout.AbsentDays')</th>
      @if($payrolls[0]->payroll_type == "salary_attendance")
      <th class=""> @lang('layout.HourNo') </th>
      <th class=""> @lang('layout.WorkedHour')</th>
      @endif
      @if($payrolls[0]->overtime_amount)
      <th class=""> @lang('layout.OvertimeAmount')</th>
      @endif
      @if($payrolls[0]->delay_amount)
      <th class=""> @lang('layout.DelayAmount')</th>
      @endif
      <th class=""> @lang('layout.OverTimeAdditionType') </th>
      <th class=""> @lang('layout.NetPayable') </th>
    </tr>
  </thead>
  <tbody>
    <tr class="">
      <td class="">
        {{$payrolls[0]->Worked_Days}}
      </td>
      <td class="">
        {{$payrolls[0]->Paid_Leave}}
      </td>
      <td class="">
        {{$payrolls[0]->absent_day}}
      </td>
      @if($payrolls[0]->payroll_type == "salary_attendance")
      <td class="">
        {{$payrolls[0]->worked_hour}}
      </td>
      <td class="">
        {{$payrolls[0]->static_time}}
      </td>
      @endif
      @if($payrolls[0]->overtime_amount)
      <td class="">{{$payrolls[0]->overtime_amount}}</td>
      @endif
      @if($payrolls[0]->delay_amount)
      <td class="">{{$payrolls[0]->delay_amount}}</td>
      @endif
      <td class="">
        {{$payrolls[0]->Overtime_addition}}
      </td>
      <td class="">
        {{myRound($payrolls[0]->Amount)}}
      </td>

    </tr>
  </tbody>
</table>





<!--<table style="width: 100%" class="signtable">
    <tr>
	<td style="width:30%;font-size:14px">@lang('layout.NameAndSignatureOfAprover'):</td>
      <td style="width: 30%;font-size:14px">@lang('layout.ReceiverSignature'):</td>
      <td style="width: 40%;font-size:14px">@lang('layout.Description'):{{$payrolls[0]->Des}}</td>
    </tr>
</table>-->

<table style="width: 100%" class="signtable">
  <tr>
    @foreach(getCompanyInfo('sign','reports') AS $info)
    <td style="text-align: left; width:40%">
      <table>

        <tr>
          <td align="right" class="signsize">{{$info['name']}}</td>

        </tr>

      </table>
    </td>
    @endforeach
    <td style="width: 40%;font-size:14px">@lang('layout.Description'):{{$payrolls[0]->Des}}</td>
  </tr>
</table>






@endsection