@extends('layouts.app')
@section('style')
<style>
    .modal-container {
        width: 70% !important;
    }
</style>
@endsection
@section('content')
    <!-- END PAGE HEADER-->
    <!-- BEGIN CONTENT -->
    <div id="print-modal">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show" :value-type="'all_payrolls'" @closed="closeModal">
            <div slot="body">
                <!----------------------------------------------
                ----Begin Report Body And Custome Report-------
                ----------------------------------------------->
                <div class="row" v-cloak>
                    <div class="tabbable tabbable-tabdrop">
                        <ul class="nav nav-tabs">
                            <li class="active">
                                <a href="#tab1" data-toggle="tab" id="tab_main">@lang('menu.Report')</a>
                            </li>
                            @if(systemConfig()[2] != 0 )
                            @permission(['payroll-list'])
                            <li class="">
                                <a href="#tab2" data-toggle="tab" id="tab_custome">@lang('layout.CustomReportM')</a>
                            </li>
                            @endpermission
                            @endif
                        </ul>
                        <div class="tab-content">
                            <div class="tab-pane active" id="tab1">
                                <div class="portlet light bordered">
                                    <div class="portlet-body">
                                        <div class="row">
                                            <div class="form-group">
                                                <div class="col-md-12">
                                                    <label class="control-label ">@lang('layout.SelectType') </label>
                                                    <select name="category" id="" class="form-control">
                                                        <option value="" selected="selected">@lang('layout.WithDetail')</option>
                                                        <option value="1">@lang('layout.WithoutDetail')</option>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="form-group">                  
                                                <div class="col-md-12" v-show="period == 'CustomDates'">
                                                    <div class="form-group">
                                                        <label class="control-label"> @lang('layout.Date')</label>
                                                        <div class="input-group">
                                                            <input class="form-control date" id="range-from-example" v-model="from_date" name="from_date" autocomplete="off">
                                                            <span class="input-group-addon"> @lang('layout.To') </span>
                                                            <input class="form-control date" id="range-to-example" v-model="to_date" name="to_date" autocomplete="off">
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="form-group">
                                                <div class="col-md-4">
                                                    <label class="control-label ">@lang('layout.SelectMember') </label>
                                                    <v-select class="vue-select2" v-model="selectedMember" label="name" :options="member" @search="onMemberSearch" >
                                                    </v-select>
                                                    <input type="hidden" name="member_id" v-model.number="(!selectedMember)?null:selectedMember.id">
                                                </div>
                                                <div class="col-md-4">
                                                    <label class="control-label ">@lang('layout.SelectClass') </label>
                                                    <select name="class_id" id="" class="form-control">
                                                        <option value="">@lang('layout.SelectClass')</option>
                                                        @foreach($member_class as  $class)
                                                        <option value="{{$class->id}}">{{$class->name}}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                                <div class="col-md-4">
                                                    <label class="control-label ">@lang('menu.EmployeeAttendanceClass') </label>
                                                    <v-select class="vue-select2" v-model="selected_attendance_class" label="name" :options="attendance_class">
                                                    </v-select>
                                                    <input type="hidden" name="attendance_class_id" v-model.number="(!selected_attendance_class)?null:selected_attendance_class.id">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="form-group">
                                                <div class="col-md-4">
                                                    <label class="control-label ">@lang('layout.Date')</label>
                                                    <select name="period" v-model="period" @input="getDates()" class="form-control">
                                                        <option value="CustomDates">@lang('type.CustomDates')</option>
                                                        <option value="Today">@lang('type.Today')</option>
                                                        <option value="Yesterday">@lang('type.Yesterday')</option>
                                                        <option value="ThisWeek">@lang('type.ThisWeek')</option>
                                                        <option value="LastWeek">@lang('type.LastWeek')</option>
                                                        <option value="WeekToDate">@lang('type.WeekToDate')</option>
                                                        <option value="ThisMonth">@lang('type.ThisMonth')</option>
                                                        <option value="MonthToDate">@lang('type.MonthToDate')</option>
                                                        <option value="ThisQuarter">@lang('type.ThisQuarter')</option>
                                                        <option value="QuarterToDate">@lang('type.QuarterToDate')</option>
                                                        <option value="ThisYear">@lang('type.ThisYear')</option>
                                                        <option value="YearToDate">@lang('type.YearToDate')</option>
                                                    </select>
                                                </div>
                                                <div class="col-md-8" v-show="period == 'CustomDates'">
                                                    <div class="form-group">
                                                        <label class="control-label"> @lang('layout.Date')</label>
                                                        <div class="input-group">
                                                            <input class="form-control date" id="range-from-example" v-model="from_date" name="from_date" autocomplete="off">
                                                            <span class="input-group-addon"> @lang('layout.To') </span>
                                                            <input class="form-control date" id="range-to-example" v-model="to_date" name="to_date" autocomplete="off">
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>                                                                     
                            <div class="tab-pane" id="tab2">
                                <div class="portlet light bordered">
                                    <div class="portlet-body">
                                        <form id="saveCustomeReport" role="form" action="{{route('customeReport.storeCustomeReport')}}" method="post">
                                            @csrf
                                            <input type="hidden" name="part_name" value="payroll">
                                            <div class="col-md-12 col-sm-12 col-xs-12">
                                                <div class="mt-checkbox-inline col-md-2" style="padding: 0px;" v-for="(row,itemIndex) in customReportData">
                                                    <div class="form-group">
                                                        <table class="table table-striped table-bordered table-advance table-hover">
                                                            <tr>
                                                                <td style="text-align: center;">@{{ row.Name }}</td>
                                                            </tr>
                                                            <tr>
                                                                <td style="text-align: center;">
                                                                    <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">
                                                                    <label class="switch">
                                                                        <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                        :checked="row.checkedColumn" >
                                                                        <span class="slider round"></span>
                                                                    </label>
                                                                    <select :name="'column_percentage['+itemIndex+']'" v-model="row.column_percentage" class="form-control" style="width: 90%;">
                                                                        <option value="">@lang('layout.Select')</option>
                                                                        <option value="2">2 %</option>
                                                                        <option value="6">6 %</option>
                                                                        <option value="10">10 %</option>
                                                                        <option value="15">15 %</option>
                                                                        <option value="20">20 %</option>
                                                                        <option value="25">25 %</option>
                                                                        <option value="30">30 %</option>
                                                                        <option value="40">40 %</option>
                                                                        <option value="50">50 %</option>
                                                                        <option value="60">60 %</option>
                                                                    </select>
                                                                </td>
                                                            </tr>
                                                        </table>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="margiv-top-10">
                                                <!-- <button type="button" onclick="regForm(this)" class="btn green"> <i class="fa fa-save"></i> </button> -->
                                                <button type="button" onclick="saveCustomeReport(this)" class="btn blue"> <i class="fa fa-save"></i> </button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </report-modal>
    </div>
    <!-- BEGIN TAB PORTLET-->
    <div class="row">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>&nbsp;
                    <span class="caption-subject bold uppercase">@lang('layout.PayrollList')</span>
                </div>
                <div class="tools"></div>
                <div class="pull-right">
                    @permission('payroll-export')
                    <span id="anchore-modal">
                        <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                        <i class="fa fa-print"></i>
                        </a>
                    </span>
                    @endpermission
                    @permission('payroll-create') 
                    <a href="{{route('payrollFromAttendanceAll.create')}}">
                        <button class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.PayrollFromAttendance') @lang('layout.All')
                        </button>
                    </a> 
                    <a href="{{route('payrollFromAttendance.create')}}">
                        <button class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.PayrollFromAttendance')
                        </button>
                    </a>   
                    <a href="{{route('simplePayroll.create')}}">
                        <button class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.SimplePayroll')
                        </button>
                    </a>
                    <a href="{{route('payroll.create')}}">
                        <button class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                        </button>
                    </a>
                </div>
                @endpermission
            </div>
            <div class="portlet-body">
                <template v-cloak id="company_ll">
                    <company @company="setCompany"></company>
                </template>
                <table class="table table-striped table-bordered " cellspacing="0" id="payroll">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>@lang('layout.Name')</th>
                            <th>@lang('layout.BasicSalary')</th>
                            <th>@lang('layout.Tax')</th>
                            <th>@lang('layout.WorkedDay')</th>
                            <th>@lang('layout.AbsentDays')</th>
                            <th>@lang('layout.NetPayable')</th>
                            <th>@lang('layout.Currency')</th>
                            <th>@lang('layout.Date')</th>
                            @if(systemConfig()[5] != 0 )
                            <th>@lang('layout.Project')</th>
                            @endif
                            <th>@lang('layout.FromDate')</th>
                            <th>@lang('layout.ToDate')</th>
                            @if(systemConfig()[5] != 0 )
                            <th>@lang('layout.Status')</th>
                            @endif
                            <th>@lang('layout.User')</th>
                            <th>@lang('layout.Description')</th>
                            <th>@lang('layout.Actions')</th> 
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>
    <!-- END TAB PORTLET-->
    <!-- END CONTENT BODY -->
    <iframe id="payframe" style="display: none;"></iframe>
@stop
@include('print.modal')
@include('groupCompanyFilter.select')
@push('scripts')
    <script>
        @if (Session('payroll_id'))
        printVoucher("{{Session('payroll_id')}}")
        @endif
        function printVoucher(id) {
            var a = document.createElement('a');
            a.href = "{{url('printPayroll')}}/" + id;
            a.target = "_blank";
            document.body.appendChild(a);
            a.click();
            document.body.removeChild(a);
        }
        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            $('#payroll').DataTable({
                // 'order': [[ 8, 'desc' ]],
                ajax: '{{route("payroll.index")}}',
                pageLength: '{{getPageRows()}}',
                scrollY: 450,
                scrollCollapse: true,
                order: [["{{orderByColumn()=='number'?0:8}}", "{{getRowOrder()}}"]],
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                serverSide: true,
                paging: true,
                buttons: [{
                    extend: 'excel',
                    text: '',
                    key: {
                        key: 'x',
                        altkey: true
                    }
                }],
                columns: [
                    {data: 'id', name: 'payrolls.id'},
                    {data: 'Employee', name: 'members.name'},
                    {data: 'BasicSalary', name: 'BasicSalary', orderabel: false, searchable: false},
                    {data: 'tax_amount', name: 'tax_amount', orderabel: false, searchable: false},
                    {data: 'Worked_Days', name: 'Worked_Days', orderabel: false, searchable: false},
                    {data: 'absent_day', name: 'absent_day', orderabel: false, searchable: false},
                    {data: 'Net_Payable', name: 'Net_Payable', orderabel: false, searchable: false},
                    {data: 'Curreny', name: 'Curreny', orderabel: false, searchable: false},
                    {data: 'Date', name: 'Date', searchable: false},
                    @if(systemConfig()[5] != 0 )
                    {data: 'project_name', name: 'project_name', orderabel: false, searchable: false},
                    @endif
                    {data: 'From_Date', name: 'From_Date', orderabel: false, searchable: false},
                    {data: 'To_Date', name: 'To_Date', orderabel: false, searchable: false},
                    @if(systemConfig()[5] != 0 )
                    {data: 'status', name: 'payrolls.status', searchable: false},
                    @endif
                    {data: 'username', name: 'users.name', orderabel: false, searchable: false},
                    {data: 'description', name: 'description'},
                    {data: 'actions', name: 'actions',searchable: false, orderabel: false},
                ]
            });
        });
        new Vue({
            el: '#company_ll',
            methods: {
                setCompany: function (event) {
                    window.location.reload()
                }
            }
        });
        Vue.component("v-select", VueSelect.VueSelect);
        var attendance_class = {!! json_encode($attendance_class) !!}
        var cust_rep = {!!customeReportNewData('payroll')!!};
        //  for new modal
        var vm = new Vue({
            el: '#print-modal',
            data: {
                period: 'CustomDates',
                from_date: null,
                to_date: null,
                is_show: false,
                pdfRoute: '{!!route('export.PDFAll') !!}',
                excelRoute: '{!! route('export.ExcelAll') !!}',
                selectedMember: null,
                member:[],
                attendance_class:attendance_class,
                selected_attendance_class:null,
                customReportData:
                [
                 {Name: '@lang("layout.Record")', column_name: 'record',checkedColumn:(cust_rep.record)?'checked':'',column_percentage:(cust_rep.record___percent)?cust_rep.record___percent:''},
                 {Name: '@lang("layout.FromDate")', column_name: 'from_date',checkedColumn:(cust_rep.from_date)?'checked':'',column_percentage:(cust_rep.from_date___percent)?cust_rep.from_date___percent:''},
                 {Name: '@lang("layout.ToDate")', column_name: 'to_date',checkedColumn:(cust_rep.to_date)?'checked':'',column_percentage:(cust_rep.to_date___percent)?cust_rep.to_date___percent:''},
                 {Name: '@lang("layout.Name")', column_name: 'name',checkedColumn:(cust_rep.name)?'checked':'',column_percentage:(cust_rep.name___percent)?cust_rep.name___percent:''},
                 {Name: '@lang("layout.Class")', column_name: 'class',checkedColumn:(cust_rep.class)?'checked':'',column_percentage:(cust_rep.class___percent)?cust_rep.class___percent:''},
                 {Name: '@lang("layout.Status")', column_name: 'status',checkedColumn:(cust_rep.status)?'checked':'',column_percentage:(cust_rep.status___percent)?cust_rep.status___percent:''},
                 {Name: '@lang("layout.HourNo")', column_name: 'hours_no',checkedColumn:(cust_rep.hours_no)?'checked':'',column_percentage:(cust_rep.hours_no___percent)?cust_rep.hours_no___percent:''},
                 {Name: '@lang("layout.WorkedDay")', column_name: 'worked_day',checkedColumn:(cust_rep.worked_day)?'checked':'',column_percentage:(cust_rep.worked_day___percent)?cust_rep.worked_day___percent:''},
                 {Name: '@lang("layout.AbsentDay")', column_name: 'absent_day',checkedColumn:(cust_rep.absent_day)?'checked':'',column_percentage:(cust_rep.absent_day___percent)?cust_rep.absent_day___percent:''},
                 {Name: '@lang("layout.User")', column_name: 'user',checkedColumn:(cust_rep.user)?'checked':'',column_percentage:(cust_rep.user___percent)?cust_rep.user___percent:''},
                 {Name: '@lang("layout.Tax")', column_name: 'tax',checkedColumn:(cust_rep.tax)?'checked':'',column_percentage:(cust_rep.tax___percent)?cust_rep.tax___percent:''},
                 {Name: '@lang("layout.PaidLeave")', column_name: 'paid_leave',checkedColumn:(cust_rep.paid_leave)?'checked':'',column_percentage:(cust_rep.paid_leave___percent)?cust_rep.paid_leave___percent:''},
                 {Name: '@lang("layout.Rent")', column_name: 'rent',checkedColumn:(cust_rep.rent)?'checked':'',column_percentage:(cust_rep.rent___percent)?cust_rep.rent___percent:''},
                 {Name: '@lang("layout.OverTimeAddition")', column_name: 'overtime_addition',checkedColumn:(cust_rep.overtime_addition)?'checked':'',column_percentage:(cust_rep.overtime_addition___percent)?cust_rep.overtime_addition___percent:''},
                 {Name: '@lang("layout.OvertimeAmount")', column_name: 'overtime_amount',checkedColumn:(cust_rep.overtime_amount)?'checked':'',column_percentage:(cust_rep.overtime_amount___percent)?cust_rep.overtime_amount___percent:''},
                 {Name: '@lang("layout.DelayAmount")', column_name: 'delay_amount',checkedColumn:(cust_rep.delay_amount)?'checked':'',column_percentage:(cust_rep.delay_amount___percent)?cust_rep.delay_amount___percent:''},
                 {Name: '@lang("layout.BasicSalary")', column_name: 'basic_salary',checkedColumn:(cust_rep.basic_salary)?'checked':'',column_percentage:(cust_rep.basic_salary___percent)?cust_rep.basic_salary___percent:''},
                 {Name: '@lang("layout.NetPayable")', column_name: 'net_payable',checkedColumn:(cust_rep.net_payable)?'checked':'',column_percentage:(cust_rep.net_payable___percent)?cust_rep.net_payable___percent:''},
                 {Name: '@lang("layout.Project")', column_name: 'project',checkedColumn:(cust_rep.project)?'checked':'',column_percentage:(cust_rep.project___percent)?cust_rep.project___percent:''},
                 {Name: '@lang("layout.Currency")', column_name: 'currency',checkedColumn:(cust_rep.currency)?'checked':'',column_percentage:(cust_rep.currency___percent)?cust_rep.currency___percent:''},
                 {Name: '@lang("layout.Amount")', column_name: 'amount',checkedColumn:(cust_rep.amount)?'checked':'',column_percentage:(cust_rep.amount___percent)?cust_rep.amount___percent:''},
                 {Name: '@lang("layout.Description")', column_name: 'description',checkedColumn:(cust_rep.description)?'checked':'',column_percentage:(cust_rep.description___percent)?cust_rep.description___percent:''},
                 {Name: '@lang("layout.EmployeeAttendanceClass")', column_name: 'employee_attendance_class',checkedColumn:(cust_rep.employee_attendance_class)?'checked':'',column_percentage:(cust_rep.employee_attendance_class___percent)?cust_rep.employee_attendance_class___percent:''},
                 {Name: '@lang("layout.WorkedHour")', column_name: 'worked_hour',checkedColumn:(cust_rep.worked_hour)?'checked':'',column_percentage:(cust_rep.worked_hour___percent)?cust_rep.worked_hour___percent:''},
                 {Name: '@lang("menu.Contract")', column_name: 'contract',checkedColumn:(cust_rep.contract)?'checked':'',column_percentage:(cust_rep.contract___percent)?cust_rep.contract___percent:''},
                 {Name: '@lang("layout.UserSignature")', column_name: 'userSignature',checkedColumn:(cust_rep.userSignature)?'checked':'',column_percentage:(cust_rep.userSignature___percent)?cust_rep.userSignature___percent:''},
                ],
                cust_rep:cust_rep
            },
            methods: {
                onMemberSearch(search, loading) {
                    loading(true);
                    this.searchMember(search, loading, this);
                },
                searchMember(search, loading, vm) {
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'member',
                            type: 'Employee',
                            search: search,
                        }
                    })
                    .then(function (response) {
                        this.member = [];
                        if (response.data.length > 0) {
                            vm.member = response.data;
                        }
                        loading(false);
                    })
                    .catch(function (error) {
                        console.log(error);
                    })
                },
                closeModal: function () {
                    this.is_show = !this.is_show
                },
                //ajax call to get dates
                getDates() {
                    setTimeout((function () {
                    vm.getDate(vm.period);
                        // console.log(12);
                    }), 2e2);
                },
                getDate(period) {
                    if (period) {
                    // console.log(3232, period);
                    if (period != 'CustomDates') {
                        axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'getDatesByPeriod',
                            period: period,
                        }
                        })
                        .then(function(response) {
                        vm.from_date = null;
                        vm.to_date = null;
                        if (response.data) {
                            vm.from_date = response.data.start;
                            vm.to_date = response.data.end;
                            // console.log('data', response.data);
                        }
                        })
                        .catch(function(error) {
                        vm.period = 'CustomDates';
                        vm.from_date = null;
                        vm.to_date = null;
                        })
                    } else {
                        vm.from_date = null;
                        vm.to_date = null;
                    }
                    }
                },
            }
        });
        new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    console.log('trr')
                    vm.$data.is_show = true;
                }
            }
        });
        // /for new modal
        var Modal = Vue.component('modal', {
            template: '#modal-template',
            methods: {
                ok: function () {
                    this.$emit('ok')
                }
            }
        })
        // start app
    </script>
@endpush