@extends('layouts.app')
@section('content')
@section('style')
    <link href="{{url('select2/css/select2.min.css')}}" rel="stylesheet" type="text/css" />
    <link href="{{url('select2/css/select2-bootstrap.min.css')}}" rel="stylesheet" type="text/css" />
@stop 
    <div class="row">
        @if (count($errors) > 0)
            <div class="m-heading-1 border-red m-bordered errors-action">
                <h4 class="error-title"><strong>Whoops!</strong> There were some problems with your input</h4>
                <ul class="error-body">
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul> 
            </div>
        @endif 
        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.CreateNewPayroll') </span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools">
                </div>
            </div>
            <div class="portlet-body form" id="app" style="margin-bottom: 30%;">
                {{-- <div class="page-bar">
                    <ul class="page-breadcrumb">
                        <li>
                            <a href="{{url('/')}}">@lang('menu.Home')</a>
                            <i class="fa fa-circle"></i>
                        </li>
                        @for($i = 0; $i<=count(Request::segments()); $i++)
                        @if($i<count(Request::segments()))
                            @if($i == count(Request::segments())-1)
                            <li>
                                {{__('layout.'.ucfirst(Request::segments()[$i]))}}
                            </li>
                            @else
                            <li>
                                <a href="{{Request::segments()[$i]}}">{{__("layout.".ucfirst(Request::segments()[$i]))}}</a>
                                <i class="fa fa-circle"></i>
                            </li>
                            @endif
                        @endif
                        @endfor
                    </ul>
                </div> --}}
                {{Form::open(['route' => 'payroll.store','method' => 'POST','id'=>'payroll-form'])}}
                <div class="form-body">
                    <div id="app" v-cloak>
                        <div class="row"> 
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="control-label"> @lang('layout.EmployeeName')</label>
                                   <v-select
                                    @input="getSalary"  
                                    placeholder="@lang('layout.SelectEmployee')" 
                                    label="name"
                                    @search="onMemberSearch"
                                    v-model="selectedEmployee"
                                    :options="employees">       
                                    </v-select>
                                    <input type="hidden" name="employee" v-model.number="(!selectedEmployee)?null:selectedEmployee.id"  v-validate="'required'" data-vv-as="@lang('layout.Employee')">
                                    <span class="required">@{{ errors.first('employee') }}</span>
                                </div>
                            </div>
                            <div class="col-md-2" v-if="selectedEmployee">
                                <div class="form-group">
                                    <label class="control-label"> @lang('layout.SalaryType')</label>
                                    <input type="text" class="form-control" readonly v-model="(!selectedEmployee)?null:emp_salary_type" >
                                </div>
                            </div>
                           <div :class="(selectedEmployee)?'col-md-4':'col-md-6'">
                                <div class="form-group">
                                    <label class="control-label"> @lang('layout.Date')</label>
                                    <div class="input-group">
                                         <input class="form-control date" id="range-from-example" name="from_date" ref="from_date" autocomplete="off" v-validate="'required'" data-vv-as="@lang('layout.Date')">
                                         <span class="required">@{{ errors.first('from_date') }}</span>
                                        <span class="input-group-addon"> @lang('layout.To') </span>
                                        <input class="form-control date" id="range-to-example" name="to_date" ref="to_date" autocomplete="off" v-validate="'required'" data-vv-as="@lang('layout.Date')"> 
                                        <span class="required">@{{ errors.first('to_date') }}</span>
                                        <!-- <span class="input-group-addon btn"  @Click="getData()" > @lang('layout.Calculate') </span> -->
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-3 col-md-3 col-sm-3 col-xs-12">
							    <div class="form-group">
									<label class="control-label">@lang('layout.Date')</label>
									{{Form::text('date',null,['class' => 'form-control date','id'=>'date','autocomplete'=>'off'])}}
								</div>
						</div>
                        </div>
                        <div class="row">
                            <div class="col-md-6" > 
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="control-label">@lang('layout.BasicSalary')</label>
                                            <div class="input-group">
                                                <input type="number" class="form-control" name="basicSalary" :value="(!salary)?null:salary.amount" >

                                                 <input type="hidden" name="sal_id" v-model.salnumer="(!selectedEmployee)?null:selectedEmployee.sal_id">

                                                 <input type="hidden" name="sal_currency" v-model.salnumer="(!selectedEmployee)?null:selectedEmployee.currency">
                                                  <span class="input-group-addon">@{{(selectedEmployee)?selectedEmployee.currency:null}}</span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6" >
                                        <span v-if="(selectedEmployee && selectedEmployee.currency != '{{getHomeCurrency()["code"]}}')?selectedEmployee.currency:null">
                                            <div class="form-group">
                                                <label class="control-label">@lang('layout.SalaryRate') </label>
                                                <div :class="{'has-error':selectedCurrency.rate < 0}">
                                                    <div class="input-group">
                                                        <input v-model="selectedEmployee.rate" class="form-control" name="salaryRate"
                                                               type="number" min="0" step="any">
                                                        <span class="input-group-addon">@{{(selectedEmployee)?selectedEmployee.currency:null}}</span>
                                                    </div>
                                                </div>
                                            </div>
                                        </span>
                                    </div>

                                    <div class="col-md-6" >
                                        <div class="form-group">
                                            <label class="control-label">@lang('layout.Currency')</label>
                                           

                                               <v-select  label="code" :options="currency" v-model="selectedCurrency"></v-select>
                                             
                                           

                                        </div>
                                    </div>

                                    <input type="hidden" name="payroll_currency" v-bind:value="selectedCurrency.code"/>
                                    <div class="col-md-6" v-if="selectedCurrency.code != '{{getHomeCurrency()["code"]}}'">
                                        <div class="form-group">
                                            <label class="control-label">@lang('layout.PaymentRate') </label>
                                                <div :class="{'has-error':selectedCurrency.rate < 0}">
                                                    <div class="input-group">
                                                    <input  v-model="selectedCurrency.exchange_rate" class="form-control"
                                                           type="number" min="0" step="any">
                                                    <span class="input-group-addon">@{{selectedCurrency.code}}</span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <input type="hidden" name="currency_rate" :value="selectedCurrency.exchange_rate">

                                </div>
                            </div> 
                            <div class="col-md-6" > 
                                <div class="row">
                               
                                    <div class="col-md-3">
                                         <div class="form-group">
                                             <label class="control-label">@lang('layout.PaidLeave')</label>
                                             {{Form::number('paidLeave',null,['class' => 'form-control','step' => 'any','min' =>'0','v-model'=>'paidLeave','@keyUp'=>'changeWorkdays','@Click'=>'changeWorkdays','v-validate' =>'"required"','data-vv-as' => __('layout.PaidLeave')])}}

                                             <span class="required">@{{ errors.first('paidLeave') }}</span>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                         <div class="form-group">
                                            <label class="control-label"> @lang('layout.AbsentDays')</label>
                                             {{Form::number('absent_days',null,['class' => 'form-control','v-model'=>'absent_days','@keyUp'=>'changeWorkdays','@Click'=>'changeWorkdays'])}}

                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                         <div class="form-group">
                                            <label class="control-label"> @lang('layout.WorkedDay')</label>
                                             {{Form::number('workedDay',null,['class' => 'form-control','step' => 'any','min' =>'0','v-model'=>'workdays','v-validate' =>'"required"','data-vv-as' => __('layout.WorkedDay')])}}
                                             <span class="required">@{{ errors.first('workedDay') }}</span>

                                        </div>
                                    </div>
                                </div> 
                            </div> 
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="row">
                                    <div class="col-md-6">
                                         <div class="form-group">
                                            <label class="control-label">@lang('layout.OverTimeAdditionType')</label>
                                            <select class="form-control" placeholder="selectype" name="type" v-model="type">
                                                <option disabled>@lang('layout.SelectType')</option>
                                                <option value="daily">@lang('layout.Daily')</option>
                                                <option value="hourly">@lang('layout.Hourly')</option>
                                                <option value="montly">@lang('layout.Montly')</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="control-label"> @lang('layout.Amount')</label>
                                             {{Form::number('amount',null,['class' => 'form-control','step' => 'any','min' =>'0','v-model'=>'amount'])}}
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="control-label"> @lang('layout.Fee')</label>
                                             {{Form::number('fee',null,['class' => 'form-control','step' => 'any','min' =>'0','v-model'=>'fee'])}}
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                             <label class="control-label">@lang('layout.TotalOverTime')</label>
                                            <input type="number" class="form-control" value="0" name="overtime" :value="amount*fee" readonly>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="row">
                                    <div class="col-md-6">
                                         <div class="form-group">
                                             <label class="control-label">@lang('layout.NetPayable')</label>
                                            <input type="number" class="form-control"  name="netPayable" :value="netPayable" step="any">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                         <div class="form-group">
                                            <label class="control-label">@lang('layout.ExpenseAccount')</label>
                                            {{Form::select('expense_id',$expense,null,['class' => 'form-control select2','v-validate' =>'"required"','data-vv-as' => __('layout.ExpenseAccount')])}}
                                             <span class="required">@{{ errors.first('expense_id') }}</span>
                                        </div>
                                    </div> 
                                </div>
                            </div>
                            @if(systemConfig()[5] != 0 )
                                <div class="col-md-3"> 
                                    <label class="control-label">@lang('layout.Project')</label>
                                    <v-select class="vue-select2" label="name" @search="ProjectSearch"
                                            :options="project_list" v-model="selectedProject">
                                    </v-select>
                                    <input type="hidden" name="project_id" v-model.number="(!selectedProject)?null:selectedProject.project_id">
                                </div>
                            @endif
                            @if(systemConfig()[19] == 1)
                                <div class="col-md-3"> 
                                    <label class="control-label">@lang('layout.NGOProject')</label>
                                    <v-select class="vue-select2" label="name" @search="searchNgoProjects" :options="NgoProject_list" v-model="selectedNgoProject">
                                    </v-select>
                                    <input type="hidden" name="ngo_project_id" v-model.number="(!selectedNgoProject)?null:selectedNgoProject.id">
                                </div>
                            @endif
                        </div>

                        <div class="row">
                            @if(systemConfig()[20] == 1)
                            <div v-if="!contract_percentage" class="col-md-3">
                                <label class="control-label">@lang('layout.ContractName')</label>
                                <v-select class="vue-select2" placeholder="@lang('layout.Select')"
                                        v-model="selectedContract" 
                                        label="company_name"
                                        @search="searchContracts"
                                        :options="contract_list">
                                </v-select>
                                <input type="hidden" name="contract_id" v-model.number="(!selectedContract)?null:selectedContract.id" />
                            </div>
                            @endif

                            <div class="col-md-3">
                                <div class="row">
                                    <div class="col-md-12">
                                         <div class="form-group">
                                            <label class="control-label"> @lang('layout.Description')</label>
                                            {!! Form::textarea('description', null, array('placeholder' => __('layout.Description'),'class' => 'form-control','rows' => 1, 'cols' => 30)) !!}
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <div style="display: flex; flex-direction: column; justify-content: center; align-items: center;">
                                                <label class="control-label">@lang('layout.BuildExpense')</label>
                                                <input type="checkbox" name="build_expense_confirm" id="" value="On">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            @if(systemConfig()[20] == 1)
                            <div class="col-md-2">
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <div style="display: flex; flex-direction: column; justify-content: center; align-items: center;">
                                                <label class="control-label">@lang('layout.MultiContract')</label>
                                                <input type="checkbox" name="contract_percentage" v-model="contract_percentage" value="on">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            @endif
                        </div>

                        <hr>
                        <!-- begin tax -->
                        <div class="row">
                             <input type="checkbox" name="tax" v-model="tax">
                             @lang('layout.Tax')
                            <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12" v-if="tax">
                                <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                    <div class="col-md-12">
                                        <label class="control-label">@lang('layout.TaxCurrency')</label>
                                        <v-select  label="code" :options="taxCurrency" v-model="selectedTaxCurrency"></v-select> 
                                        <input type="hidden" name="tax_currency" class="form-control" v-validate="'required'"
                                                       data-vv-as="@lang('layout.TaxCurrency')" :value=(!selectedTaxCurrency)?null:selectedTaxCurrency.code>
                                        <span class="required">@{{ errors.first('tax_currency') }}</span>
                                        

                                      <span class="required">@{{ errors.first('tax_currency') }}</span>
                                    </div>
                                </div>

                                <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                    <div class="col-md-12">
                                        <label class="control-label ">@lang('layout.Rate')</label>
                                        <input type="number" name="tax_rate" class="form-control" v-validate="'required'"
                                                       data-vv-as="@lang('layout.Rate')" v-model=(!selectedTaxCurrency)?null:selectedTaxCurrency.rate>
                                        <span class="required">@{{ errors.first('tax_currency') }}</span>

                                        
                                    </div>
                                </div>

                                <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                    <div class="col-md-12">
                                        <label class="control-label ">@lang('layout.PaymentType')</label>
                                        <br>
                                        <input type="checkbox" readonly name="by_employee" v-model="paymentType">
                                        @lang('layout.ByEmployee')
                                        
                                    </div>
                                </div>

                                  <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <label class="control-label"> @lang('layout.AgencyTax')</label>
                                       <v-select   
                                       placeholder="@lang('layout.SelectEmployee')" 
                                       label="name"
                                        v-model="selectedMember"
                                        :options="members"
                                        @search="onAgencySearch"
                                            >       
                                        </v-select>
                                        <input type="hidden" name="tax_member" v-model.number="(!selectedMember)?null:selectedMember.id" >
                                    </div>
                                </div>

                                <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                         <div class="form-group">
                                             <label class="control-label"> @lang('layout.ExpenseAccount')</label>
                                            <v-select   placeholder="@lang('layout.ExpenseAccount')" label="name"
                                                v-model="selected_tax_expense"
                                             :options="{{$expense_tax}}">       
                                            </v-select>
                                            <input type="hidden" name="selected_tax_expense" v-model="(!selected_tax_expense)?null:selected_tax_expense.id" >
                                        </div>
                                </div>
                                


                            </div>


                           


                        </div>
                        <!-- end tax -->
                        <br/>
                        <br/>
                        <br/>
                        @if(systemConfig()[20] == 1)
                        <!-- begin multiContract -->
                        <table v-if="contract_percentage" id="table_content" class="table table-striped table-bordered table-advance table-hover">
                            <thead>
                                <tr>
                                    <th class="text-center" style="min-width: 8px;"> #</th>
                                    <th class="text-center" style="min-width: 160px;">@lang('layout.ContractName')</th>
                                    <th class="text-center" style="min-width: 160px;">@lang('layout.Percentage')</th>
                                    <th></th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr v-for="(record,index) in multiContractData">
                                    <td class="text-center">@{{index+1}}</td>
                                    <td class="highlight">
                                        <v-select class="vue-select2" placeholder="@lang('layout.Select')"
                                                v-model="record.selected" 
                                                label="company_name"
                                                @search="searchContracts"
                                                :options="contract_list" @click.native="addNew('multiContract',index)" >
                                        </v-select>
                                        <input type="hidden" name="multiContract_id[]" :value="(record.selected==null)?null:record.selected.id">
                                    </td>

                                    <td>
                                        <input class="form-control" type="number" name="percentage[]"
                                            v-model.number="record.percentage" placeholder="@lang('layout.Percentage')">
                                    </td>

                                    <td class="text-center" style="vertical-align: middle;">
                                        <span v-on:click="deleteItem('multiContract',index)"><i class="paddint-both glyphicon glyphicon-trash text-danger" style="cursor: pointer;"></i></span>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                        <!-- end multiContract -->
                        @endif

                    </div>
                    <!--/row-->
                </div>
                <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                        <button type="button" @click="handleSubmit($event)" class="btn green">@lang('layout.Submit')</button>
                        <button type="button" class="btn blue" @click="saveAndNew($event)" >@lang('layout.SaveAndNew')</button>
                     <a href="{{route('payroll.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
               </div> 
             {{Form::close()}}
            </div>               
            <!-- END FORM-->
        </div>
    </div> 
@endsection
@push('scripts')
<script src="{{url('select2/js/select2.full.min.js')}}" type="text/javascript"></script>
<script src="{{url('select2/js/components-select2.min.js')}}" type="text/javascript"></script>
<script>
    @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
    Vue.use(VeeValidate, {
        locale: 'en',
    });
    @endif
    
      ////
     Vue.component("v-select", VueSelect.VueSelect);
        var Currency ={!! $currency !!};
        var TaxCurrency ={!! $taxCurrency !!}
        var one = {!!json_encode(getHomeCurrency()) !!}
        var app = new Vue({
            el: '#app', 
            data: {
                selectedCurrency:one,
                currency:Currency,
                currencyList: Currency,
                employees:[],
                members:[],
                selectedProject: null,
                project_list: [],
                selectedNgoProject: null,
                NgoProject_list: [],
                workdays:0,
                absent_days:null,
                salary:null,
                selectedBank:null,
                selectedEmployee:null,
                selectedMember:null,
                selected_tax_expense:null,
                paidLeave:0,
                pay:false,
                type:null,
                amount:0,
                salaryAmount:0,
                fee:null,
                basicSalary:0,
                from:null,
                to:null,
                from_date:null,
                to_date:null,
                advancePaid:0,
                taxCurrency:TaxCurrency,
                selectedTaxCurrency:null,
                paymentType:1,
                tax:0,
                total_justifiend_leave:0,
                total_unJustifiend_leave:0,
                selectedContract: null,
                contract_list:[],
                emp_salary_type:null,
                salary_type: [
                    {tag: 'Daily', type: '@lang("layout.Daily")'},
                    {tag: 'Weekly', type: '@lang("layout.Weekly")'},
                    {tag: 'TwiceAMonth', type: '@lang("layout.TwiceAMonth")'},
                    {tag: 'Montly', type: '@lang("layout.Montly")'},
                    {tag: 'TwoWeek', type: '@lang("layout.TwoWeek")'}
                ],

                contract_percentage:null,
                multiContractData: [
                    {percentage: 0, selected: null},
                    {percentage: 0, selected: null},
                ],
            }, 
            watch: {

            },
            computed:{
                netPayable()
                    {
                    
                        // console.log( 'Hello', this.selectedEmployee['static_rate'] );
                        var total=0;
                        var workdays   = parseFloat((this.workdays)?this.workdays:0)
                        var paidLeave  = parseFloat((this.paidLeave)?this.paidLeave:0)
                        var amount     = parseFloat((this.amount)?this.amount:0);
                        var fee        = parseFloat((this.fee)?this.fee:0);
                        let temp_s_e=this.selectedEmployee;
                        console.log(12, this.selectedEmployee, this.selectedCurrency, workdays);
                        // attendance_type
                        if(this.selectedEmployee && this.selectedCurrency) {
                            if(workdays)
                            {  
                                // console.log(123, this.selectedEmployee['static_rate']);
                                if(this.selectedEmployee.salaryType =="TwiceAMonth"){
 
                                    @if(systemConfig()[30] == 1)
                                    // var day = ((this.salaryAmount * this.selectedCurrency.exchange_rate / this.selectedEmployee['rate']) / 15);
                                    var day = (((this.salaryAmount / this.selectedEmployee['static_rate'] * this.selectedEmployee['rate']) * this.selectedCurrency.static_rate / this.selectedCurrency.exchange_rate) / 15);
                                    // vv.exchange_amount = myRound(((vv.amount / vv.selectedCurrency.static_rate * vv.selected_rate) * vv.paymentCurrency.static_rate) / vv.selected_rate1);
                                    @else 
                                    var day = ((this.salaryAmount * this.selectedCurrency.exchange_rate / this.selectedEmployee['rate']) / 15);
                                    @endif

                                }else if(this.selectedEmployee.salaryType =="TwoWeek"){

                                    @if(systemConfig()[30] == 1)
                                    var day = (((this.salaryAmount / this.selectedEmployee['static_rate'] * this.selectedEmployee['rate']) * this.selectedCurrency.static_rate / this.selectedCurrency.exchange_rate) / 14);
                                   // var day = ((this.salaryAmount * this.selectedCurrency.exchange_rate / this.selectedEmployee['rate']) / 14);
                                    @else 
                                    var day = ((this.salaryAmount * this.selectedCurrency.exchange_rate / this.selectedEmployee['rate']) / 14);
                                    @endif

                                }else if(this.selectedEmployee.salaryType =="Weekly"){
                                    @if(systemConfig()[30] == 1)
                                    var day = (((this.salaryAmount / this.selectedEmployee['static_rate'] * this.selectedEmployee['rate']) * this.selectedCurrency.static_rate / this.selectedCurrency.exchange_rate) / 7);
                                //   var day = ((this.salaryAmount * this.selectedCurrency.exchange_rate / this.selectedEmployee['rate']) / 7);
                                    @else 
                                    var day = ((this.salaryAmount * this.selectedCurrency.exchange_rate / this.selectedEmployee['rate']) / 7);
                                    @endif

                                }else if(this.selectedEmployee.salaryType =="Daily"){

                                    @if(systemConfig()[30] == 1)
                              //     var day = ((this.salaryAmount * this.selectedCurrency.exchange_rate / this.selectedEmployee['rate']) / 1);
                                    var day = (((this.salaryAmount / this.selectedEmployee['static_rate'] * this.selectedEmployee['rate']) * this.selectedCurrency.static_rate / this.selectedCurrency.exchange_rate) / 1);
                                    @else 
                                    var day = ((this.salaryAmount * this.selectedCurrency.exchange_rate / this.selectedEmployee['rate']) / 1);
                                    @endif

                                }
                                else{ 
                                    @if(systemConfig()[30] == 1)
                                    // var day = ((this.salaryAmount * this.selectedCurrency.exchange_rate / this.selectedEmployee['rate']) / 30);
                                    var day = (((this.salaryAmount / this.selectedEmployee['static_rate'] * this.selectedEmployee['rate']) * this.selectedCurrency.static_rate / this.selectedCurrency.exchange_rate) / 30);
                                    @else 
                                    var day = ((this.salaryAmount * this.selectedCurrency.exchange_rate / this.selectedEmployee['rate']) / 30);
                                    @endif 
                                }

                                @if(systemConfig()[30] == 1)
                                    var ff=fee* this.selectedCurrency.static_rate / this.selectedCurrency.exchange_rate;
                                @else 
                                    var ff=fee*this.selectedCurrency.exchange_rate;
                                @endif 
                                
                                total = myRound((day * (workdays + paidLeave)) + (amount * fee));
                            } 
                            else
                            {
                                @if(systemConfig()[30] == 1)
                                var ff=fee* this.selectedCurrency.static_rate / this.selectedCurrency.exchange_rate;
                                @else 
                                var ff=fee*this.selectedCurrency.exchange_rate;
                                @endif

                                @if(systemConfig()[30] == 1)
                                total = myRound((((this.salaryAmount / this.selectedEmployee['static_rate'] * this.selectedEmployee['rate']) * this.selectedCurrency.static_rate / this.selectedCurrency.exchange_rate) + (fee*amount)));
                                // total=(this.salaryAmount * this.selectedCurrency.exchange_rate/this.selectedEmployee['rate'])+(fee*amount);
                                @else 
                                total= myRound((this.salaryAmount * this.selectedCurrency.exchange_rate/this.selectedEmployee['rate'])+(fee*amount));
                                @endif
                            }
                                return total;
                        }
                        
                    },
                },

            methods: { 
                onMemberSearch(search, loading) {
                    loading(true);
                    this.searchMember(search, loading, this);
                },
                searchMember(search, loading, vm) {
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'member',
                            type: 'Employee',
                            search: search,
                        }
                    })
                    .then(function (response) {
                        this.employees = [];
                        if (response.data.length > 0) {
                            vm.employees = response.data;
                        }
                        loading(false);
                    })
                    .catch(function (error) {
                        console.log(error);
                    })
                },
                onAgencySearch(search, loading) {
                    loading(true);
                    this.searchAgencyMember(search, loading, this);
                },
                searchAgencyMember(search, loading, vm) {
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'member',
                            type: '',
                            search: search,
                        }
                    })
                    .then(function (response) {
                        this.members = [];
                        if (response.data.length > 0) {
                            vm.members = response.data;
                        }
                        loading(false);
                    })
                    .catch(function (error) {
                        console.log(error);
                    })
                },
                // Search Contract
                searchContracts(search, loading) {
                    loading(true);
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'anyTable',
                            keyword: search,
                            table_name: 'contracts',
                            search_column:'company_name'
                        }
                    })
                    .then(function (response) {
                        app.contract_list = [];
                        if (response.data.length > 0) {
                            app.contract_list = response.data;
                        }
                        loading(false);
                    })
                    .catch(function (error) {
                        console.log(error);
                    })
                },
                getSalary(){
                    if(this.selectedEmployee)
                    {   
                        this.emp_salary_type = null;
                        if(this.selectedEmployee.salaryType){
                            this.salary_type.forEach((s_type) => {
                                if (s_type.tag == this.selectedEmployee.salaryType) {
                                    this.emp_salary_type = s_type.type;
                                    return;
                                }
                            })
                        }

                        //calculat workday and paidleave 
                        if(this.selectedEmployee.salaryType == "TwiceAMonth"){
                            this.workdays = 13;
                            this.paidLeave = 2;
                        }
                        else if(this.selectedEmployee.salaryType == "TwoWeek"){
                            this.workdays = 12;
                            this.paidLeave = 2;
                        }
                        else if(this.selectedEmployee.salaryType == "Weekly"){
                            this.workdays = 6;
                            this.paidLeave = 1;
                        }
                        else if(this.selectedEmployee.salaryType == "Daily"){
                            this.workdays = 1;
                            this.paidLeave = 0;
                        }
                        else{
                            this.workdays = 26;
                            this.paidLeave = 4;
                        }

                        this.getSalaryRecord(this.selectedEmployee.id);
                        // this.getLeaves(this.selectedEmployee.id);


                        var s_currency=this.selectedCurrency;
                        if (this.selectedEmployee && this.selectedEmployee.currency) {
                            s_currency=_.find(this.currency,(c)=>c.code==this.selectedEmployee.currency);
                        }
                        this.selectedCurrency = s_currency;

                    
                    } 
                },
                getSalaryRecord(id)
                {
                        $.ajax({
                        url: "{{route('callMethod.search')}}",
                        async:false,
                        data:{
                            method_name:'memberSalary',
                            employee_id:id,
                            },
                        success:function(data){
                            this.salary=data; 
                            if(this.salary !=undefined && this.salary !=null)
                            {
                              this.salaryAmount=this.salary.amount;
                              this.selectedEmployee['currency']=this.salary.currency;
                              this.selectedEmployee['sal_id']=this.salary.id;
                              this.selectedEmployee['rate']=this.salary.rate;
                              this.selectedEmployee['static_rate']=this.salary.static_rate;
                            }

                        console.log('sallkjk',this.salary);


                        }.bind(this),

                        error: function(error){
                            console.log(error)
                        }
                    });
                    
                },
                getLeaves(id) 
                {
                    if (id) {
                        // app.members = [];
                        // let type = vu.selected_member_types.name;
                        axios.get("{{route('callEmployeeLeaves.leaves')}}", {
                            params: {
                                method_name: 'leaves',
                                employee_id:id
                            }
                        })
                        .then(function (response) {
                            if (response.data) {
                                console.log('All Leaves', response.data)
                                app.total_justifiend_leave = response.data.total_justifiend_leave;
                                app.total_unJustifiend_leave = response.data.total_unJustifiend_leave;
                                app.paidLeave = app.paidLeave + parseFloat(app.total_justifiend_leave)
                                app.absent_days = app.absent_days + parseFloat(app.total_unJustifiend_leave)
                                app.workdays  = app.workdays - parseFloat(app.total_justifiend_leave) - parseFloat(app.total_unJustifiend_leave)
                            }

                        })
                        .catch(function (error) {
                            console.log(error);
                        });

                }

                },  

                // Search Project

				ProjectSearch:_.debounce((search,loading)=>{
                    app.project_list=[];
				   loading(true);
				   axios.get("{{route('callMethod.search')}}",{
					params:{
					  method_name:'serarchProject',
					  keyword:search,
					}
				   })
				   .then(function (response)
				   {
					 this.project_list=[];
					 if(response.data.length>0)
					 {
						app.project_list=response.data;
						console.log('test 22',app.project_list);
					 }
					 loading(false);
				   })
				   .catch(function (error)
				   {
					  console.log(error);
				   });
				},getDebounceTime()),

                // Search Ngo Project

                searchNgoProjects(search, loading) {
                    loading(true);
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'anyTable',
                            keyword: search,
                            table_name: 'ngo_projects',

                        }
                    })
                    .then(function (response) {
                        app.NgoProject_list = [];
                        if (response.data.length > 0) {
                            app.NgoProject_list = response.data;
                        }
                        loading(false);
                    })
                    .catch(function (error) {
                        console.log(error);
                    })
                },

              handleSubmit(e) {
                this.$validator.validate().then(valid => {
                    if (valid) {
                        // alert(e.target);
                        regForm(e.target);
                    }
                });
            },

                getData() {
                    this.from_date = this.$refs.from_date.value;
                    this.to_date = this.$refs.to_date.value;
                    // if (this.from_date && this.to_date ) {
                    //     axios.get("{{route('callMethod.search')}}", {
                    //         params: {
                    //             method_name: 'getDateDays',
                    //             from_date: this.from_date,
                    //             to_date:   this.to_date
                    //         }
                    //     })
                    //         .then(function (response) {
                    //             if (response.data) {
                    //                 app.paidLeave =response.data.fdcout;
                    //                 app.workdays =(response.data.num_days - response.data.fdcout);
                    //             }
                    //         })
                    //         .catch(function (error) {
                    //             console.log(error);
                    //         });
                    // }
                    // console.log(234, this.from_date, this.to_date,this.$refs.from_date.value);
                    // getRecord();
                }, 


                // generic function for adding item to list
                addNew(type = null, index) {
                    if (type != null) {
                        if (type == 'multiContract') {
                            if (this.multiContractData[index + 1] == undefined) {
                                this.multiContractData.push({
                                    percentage: 0,
                                    selected: null
                                });
                            }
                        }
                    }

                },


                // delete item from list
                deleteItem(type = null, index) {
                    if (type != null) {
                        if (type == 'multiContract') {
                            this.multiContractData.splice(index, 1);
                        }
                    }

                },

                changeWorkdays() {
                    if(this.paidLeave > 0 || this.absent_days > 0)
                    {
                        this.workdays = (30 - (parseFloat((this.paidLeave)?this.paidLeave:0) + parseFloat((this.absent_days)?this.absent_days:0)));
                    }
                },
                saveAndNew()
                {
                    this.$validator.validate()
                    .then(valid =>{
                        if(valid)
                        { 
                            var url="{{route('payroll.store')}}";
                            form_id='payroll-form';
                            var data= $('#'+form_id).serialize();
                            // console.log(444, data);
                            toggleBlock(true);
                            axios.post(url,data)
                            .then(function(response){
                                    toggleBlock(0);
                                    if(response.data.result==1)
                                    {
                                        $('#'+form_id).trigger('reset');
                                        
                                        toastr.success('',response.data.message); 
                                        location.reload();
                                    
                                    }
                                    else
                                    {
                                        var message="{{__('message.Warning')}}";
                                        //$('#error-sound')[0].play();
                                        toastr.warning('',message);
                                    }
                            })
                            .catch(function(error){
                            toggleBlock(0);
                                console.log(error);
                                var message="{{__('message.Warning')}}";
                                //$('#error-sound')[0].play();
                                toastr.warning('',message);
                            });
                        
                        }
                    })
                }, 
            }
        }); 
</script>
@endpush