@extends('layouts.factor-master')

@section('content')
<?php
$report = customeReport('payroll','index');
?>
 
    <h3 class="table-caption" style="text-align: center;">@lang('layout.ContractBasedPayroll')</h3>

 <table class="main-table">
    <thead>
    <tr class="bg">
      <td class="center" ><div> #</div></td>
      <td class="center" ><div> @lang('layout.ChargeName') </div></td>
      <td class="center" ><div> @lang('layout.Name') </div></td>
      <td class="center" ><div> @lang('layout.Type')</div></td>
      @if(systemConfig()[5] != 0 )
      <th>@lang('layout.Project')</th>
      @endif
      <th>@lang('layout.Account')</th>
      <th>@lang('layout.ExpenseAccount')</th>
      <td class="center" ><div> @lang('layout.Currency')</div></td>
      <td class="center" ><div> @lang('layout.Amount')</div></td>
      <td class="center" ><div> @lang('layout.Rate')</div></td>
    </tr>
    </thead>
    <?php
    $count = 0;
     $total_home_currency=0;
  $currencies=[];
    ?>
    @foreach($data AS $record)
    <tr>
      <?php
      
    if(systemConfig()[30] == 1){
      $total_home_currency+=($record->amounts / $record->static_rate * $record->rate);
    }else{
      $total_home_currency+=($record->amounts / $record->rate);
    }
 
   if(array_key_exists($record->currency, $currencies))
   {
    $currencies[$record->currency]=$currencies[$record->currency]+$record->amounts;
  }
  else
  {
    $currencies[$record->currency]=$record->amounts;
  }
  ?>

    <tr>
      <td class="center">{{++$count}}</td>
      <td class="center">{{$record->name}}</td>
      <td class="center">{{$record->member_name}}</td>
      <td class="center">{{$record->type}}</td>
      @if(systemConfig()[5] != 0 )<td  class="center">{{$record->project_name}}</td>@endif
      <td  class="center">{{$record->account}}</td>
      <td  class="center">{{$record->exAccount}}</td>
      <td  class="center">{{$record->currency}}</td>
      <td  class="center">{{$record->amount}}</td>
      <td  class="center">{{$record->rate}}</td>
    </tr>
    @endforeach
</table>

<table class="main-table">
 <tr class="bg">
  <td colspan="3"><div class="center">@lang('layout.PerCurrency')</div></td>
</tr>
<tr>
  <td><div class="center"> #</div></td>
  <td><div class="center"> @lang('layout.Currency') </div></td>
  <td><div class="center"> @lang('layout.Amount') </div></td>
</tr>
<?php
$count=0;
foreach($currencies As $key=>$currency)
{
  ?>
  <tr>
    <td><div class="center">{{++$count}}</div></td>
    <td><div class="center">{{$key}}</div></td>
    <td><div class="center">{{round($currency,2)}}</div></td>

  </tr>
  <?php
}
?>
<tr>
 <td colspan="2"><div class="center">@lang('layout.HomeCurrencyTotal')</div></td>
 <td><div class="center">{{round($total_home_currency,2)}} {{getHomeCurrency()[getCurrencyType()]}}</div></td>

</tr>
</table>
 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection
