@extends('layouts.factor-master')
@section('content')
  <?php
    $report = customeReportNew('payroll');
      $_record= !in_array('record', $report);
      $_from_date=!in_array('from_date', $report);
      $_to_date=!in_array('to_date', $report);
      $_name=!in_array('name', $report);
      $_class=!in_array('class', $report);
      $_status =!in_array('status', $report);
      $_hours=!in_array('hours', $report);
      $_worked_day=!in_array('worked_day', $report);
      $_absent_day=!in_array('absent_day', $report);
      $_user=!in_array('user', $report);
      $_tax=!in_array('tax', $report);
      $_rent=!in_array('rent', $report);
      $_overtime_addition=!in_array('overtime_addition', $report);
      $_overtime_amount=!in_array('overtime_amount', $report);
      $_delay_amount=!in_array('delay_amount', $report);
      $_basic_salary=!in_array('basic_salary', $report);
      $_net_payable=!in_array('net_payable', $report);
      $_project=!in_array('project', $report);
      $_employee_attendance_class=!in_array('employee_attendance_class', $report);
      $_currency=!in_array('currency', $report);
      $_amount=!in_array('amount', $report);
      $_description=!in_array('description', $report);
      $_worked_hour=!in_array('worked_hour', $report);
      // $_employee=!in_array('employee', $report);
      $_paid_leave=!in_array('paid_leave', $report);
      $_hours_no=!in_array('hours_no', $report);
      $_contract=!in_array('contract', $report);
      $_userSignature=!in_array('userSignature', $report);

    $report_percent = customeReportNewPercent('payroll');
      $_record_percent= (array_key_exists('record___percent', $report_percent))?$report_percent['record___percent']:null;
      $_from_date_percent= (array_key_exists('from_date___percent', $report_percent))?$report_percent['from_date___percent']:null;
      $_to_date_percent= (array_key_exists('to_date___percent', $report_percent))?$report_percent['to_date___percent']:null;
      $_name_percent= (array_key_exists('name___percent', $report_percent))?$report_percent['name___percent']:null;
      $_class_percent= (array_key_exists('class___percent', $report_percent))?$report_percent['class___percent']:null;
      $_status_percent= (array_key_exists('status___percent', $report_percent))?$report_percent['status___percent']:null;
      $_hours_no_percent= (array_key_exists('hours_no___percent', $report_percent))?$report_percent['hours_no___percent']:null;
      $_worked_day_percent= (array_key_exists('worked_day___percent', $report_percent))?$report_percent['worked_day___percent']:null;
      $_absent_day_percent= (array_key_exists('absent_day___percent', $report_percent))?$report_percent['absent_day___percent']:null;
      $_user_percent= (array_key_exists('user___percent', $report_percent))?$report_percent['user___percent']:null;
      $_tax_percent= (array_key_exists('tax___percent', $report_percent))?$report_percent['tax___percent']:null;
      $_paid_leave_percent= (array_key_exists('paid_leave___percent', $report_percent))?$report_percent['paid_leave___percent']:null;
      $_rent_percent= (array_key_exists('rent___percent', $report_percent))?$report_percent['rent___percent']:null;
      $_overtime_addition_percent= (array_key_exists('overtime_addition___percent', $report_percent))?$report_percent['overtime_addition___percent']:null;
      $_overtime_amount_percent= (array_key_exists('overtime_amount___percent', $report_percent))?$report_percent['overtime_amount___percent']:null;
      $_delay_amount_percent= (array_key_exists('delay_amount___percent', $report_percent))?$report_percent['delay_amount___percent']:null;
      $_basic_salary_percent= (array_key_exists('basic_salary___percent', $report_percent))?$report_percent['basic_salary___percent']:null;
      $_net_payable_salary_percent= (array_key_exists('net_payable___percent', $report_percent))?$report_percent['net_payable___percent']:null;
      $_project_percent= (array_key_exists('project___percent', $report_percent))?$report_percent['project___percent']:null;
      $_status_percent= (array_key_exists('status___percent', $report_percent))?$report_percent['status___percent']:null;
      $_currency_percent= (array_key_exists('currency___percent', $report_percent))?$report_percent['currency___percent']:null;
      $_amount_percent= (array_key_exists('amount___percent', $report_percent))?$report_percent['amount___percent']:null;
      $_description_percent= (array_key_exists('description___percent', $report_percent))?$report_percent['description___percent']:null;
      $_employee_attendance_class_percent= (array_key_exists('employee_attendance_class___percent', $report_percent))?$report_percent['employee_attendance_class___percent']:null;
      $_worked_hour_percent= (array_key_exists('worked_hour___percent', $report_percent))?$report_percent['worked_hour___percent']:null;
      $_contract_percent= (array_key_exists('contract___percent', $report_percent))?$report_percent['contract___percent']:null;
      $_userSignature_percent= (array_key_exists('userSignature___percent', $report_percent))?$report_percent['userSignature___percent']:null;
      // dd($_hours_no);
      $setting_jalali = isset(uSetting()->jalali_and_gerogarian_date);
      $setting_date_type = isset(uSetting()->date_type);
  ?>
  <h3 class="table-caption" style="text-align: center;">@lang('layout.PayrollReport')</h3>
  @if($from_date || $to_date)
  <table class="main-table">
    <tr>
      @if($from_date)
      <td>
        <span>@lang('layout.FromDate')</span>:
        <BDO DIR="LTR">    @if($setting_jalali == 'true')  {{convertDate($from_date, null, null, (($setting_date_type == 'jalali')?'gregorian':'jalali'))}}  <span dir="rtl"> &nbsp;&nbsp;&nbsp;  @lang('layout.MarchingAt')  </span>  @endif      {{convertDate($from_date)}}</BDO>
      </td>
      @endif
      @if($to_date)
      <td>
        <span>@lang('layout.ToDate')</span>:
        <BDO DIR="LTR">    @if($setting_jalali == 'true')  {{convertDate($to_date, null, null, (($setting_date_type == 'jalali')?'gregorian':'jalali'))}}  <span dir="rtl"> &nbsp;&nbsp;&nbsp;  @lang('layout.MarchingAt')  </span>  @endif      {{convertDate($to_date)}}</BDO>
      </td>
      @endif
    </tr>
  </table>
  @endif
  @if($attendance_class_name || $member_class_name || $category == '' || $member_name)
  <table class="main-table" style="margin: 6px 0px;" >
    <tr>
      @if($category == '')
      <td>
        <span>@lang('layout.Type')</span>: @lang('layout.WithDetail')
      </td>
      @endif 
      @if($attendance_class_name)
      <td>
        <span>@lang('menu.EmployeeAttendanceClass')</span>: {{$attendance_class_name}}
      </td>
      @endif
      @if($member_class_name)
      <td>
        <span>@lang('layout.Class')</span>: {{$member_class_name}}
      </td>
      @endif
      @if($member_name)
      <td>
        <span>@lang('layout.Name')</span>: {{$member_name}}
      </td>
      @endif
    </tr>
  </table>
  @endif
  <table class="main-table">
    <thead>
      <tr class="bg"> 
        @if($_record)
          <th @if($_record_percent) width="{{$_record_percent}}%" @endif>@lang('layout.Record')</th>
        @endif
        @if($_from_date)
          <th @if($_from_date_percent) width="{{$_from_date_percent}}%" @endif> @lang('layout.FromDate')</th>
        @endif
        @if($_to_date) 
          <th @if($_to_date_percent) width="{{$_to_date_percent}}%" @endif> @lang('layout.ToDate')</th>
        @endif
        @if(!$member_name) 
          @if($_name)
            <th @if($_name_percent) width="{{$_name_percent}}%" @endif> @lang('layout.Name') </th>
          @endif
        @endif 
        @if(!$member_class_name)
          @if($_class)
            <th @if($_class_percent) width="{{$_class_percent}}%" @endif> @lang('layout.Class') </th>
          @endif 
        @endif
        @if($_employee_attendance_class)
          <th @if($_employee_attendance_class_percent) width="{{$_employee_attendance_class_percent}}%" @endif> @lang('menu.EmployeeAttendanceClass') </th>
        @endif
        @if($_worked_day)
          <th @if($_worked_day_percent) width="{{$_worked_day_percent}}%" @endif> @lang('layout.WorkedDay')</th>
        @endif
        @if($_absent_day)
          <th @if($_absent_day_percent) width="{{$_absent_day_percent}}%" @endif> @lang('layout.AbsentDay')</th>
        @endif
        @if($_paid_leave)
          <th @if($_paid_leave_percent) width="{{$_paid_leave_percent}}%" @endif> @lang('layout.PaidLeave')</th>
        @endif 
        @if($_hours_no)
          <th @if($_hours_no_percent) width="{{$_hours_no_percent}}%" @endif> @lang('layout.HourNo')</th>
        @endif
        @if($_worked_hour)
          <th @if($_worked_hour_percent) width="{{$_worked_hour_percent}}%" @endif> @lang('layout.WorkedHour')</th>
        @endif
        @if($_rent)
          <th @if($_rent_percent) width="{{$_rent_percent}}%" @endif> @lang('layout.Rent')</th>
        @endif
        @if($_overtime_addition)
          <th @if($_overtime_addition_percent) width="{{$_overtime_addition_percent}}%" @endif> @lang('layout.OverTimeAddition')</th>
        @endif
        @if($_overtime_amount)
          <th @if($_overtime_amount_percent) width="{{$_overtime_amount_percent}}%" @endif> @lang('layout.OvertimeAmount')</th>
        @endif
        @if($_delay_amount)
          <th @if($_delay_amount_percent) width="{{$_delay_amount_percent}}%" @endif> @lang('layout.DelayAmount')</th>
        @endif
        @if($_basic_salary)
          <th @if($_basic_salary_percent) width="{{$_basic_salary_percent}}%" @endif> @lang('layout.BasicSalary')</th>
        @endif
        @if($_net_payable)
          <th @if($_net_payable_salary_percent) width="{{$_net_payable_salary_percent}}%" @endif> @lang('layout.Amount')</th>
        @endif
        @if(systemConfig()[5] != 0 )
          @if($_project)
            <th @if($_project_percent) width="{{$_project_percent}}%" @endif>@lang('layout.Project')</th>
          @endif
          @if($_status)
            <th @if($_status_percent) width="{{$_status_percent}}%" @endif>@lang('layout.Status')</th>
          @endif
        @endif  
        @if(systemConfig()[20] == 1)
          @if($_contract)
            <th @if($_contract_percent) width="{{$_contract_percent}}%" @endif>@lang('menu.Contract')</th>
          @endif
        @endif
        {{-- @if($_currency)<th @if($_currency_percent) width="{{$_currency_percent}}%" @endif> @lang('layout.Currency')</th>@endif --}}
        @if($_tax)
          <th @if($_tax_percent) width="{{$_tax_percent}}%" @endif> @lang('layout.Tax')</th>
        @endif
        @if($_amount)
          <th @if($_amount_percent) width="{{$_amount_percent}}%" @endif> @lang('layout.NetPayable')</th>
        @endif
        @if($_description)
          <th @if($_description_percent) width="{{$_description_percent}}%" @endif> @lang('layout.Description')</th>
        @endif 
        @if($_user)
          <th @if($_user_percent) width="{{$_user_percent}}%" @endif> @lang('layout.User')</th>
        @endif
        @if($_userSignature)
          <th @if($_userSignature_percent) width="{{$_userSignature_percent}}%" @endif>@lang('layout.UserSignature')</th>
        @endif
      </tr>
    </thead>
    <?php
      $count = 0;
      $total_home_currency=0;
      $total_home_currencyTax=0;
      $currencies=[];
      $currenciesTax=[];
    ?>
    @foreach($data AS $record)
    <tr>
      <?php
        $total_home_currency+=$record->exchanged_amount;
        if(systemConfig()[30] == 1){
        $total_home_currencyTax+= ($record->tax_rate > 0)?($record->tax_amount/ $record->static_rate * $record->tax_rate) : 0;
        }else{
        $total_home_currencyTax+= ($record->tax_rate > 0)?($record->tax_amount/$record->tax_rate) : 0;
        }
        $tax = 0;
        if($record->tax_rate > 0){
          if(systemConfig()[30] == 1){
          $tax = ($record->tax_amount/ $record->static_rate * $record->tax_rate) * $record->rate;
        }else{
          $tax = ($record->tax_amount/$record->tax_rate) * $record->rate;
          }
        }
        if(array_key_exists($record->Currency, $currencies))
        {
          $currencies[$record->Currency]=$currencies[$record->Currency]+$record->Amount;
        }
        else
        {  
          $currencies[$record->Currency]=$record->Amount;
        }
        if(array_key_exists($record->tax_currency, $currenciesTax))
        {
          $currenciesTax[$record->tax_currency]=$currenciesTax[$record->tax_currency]+$record->tax_amount;
        }
        else
        {  
          $currenciesTax[$record->tax_currency]=$record->tax_amount; 
        }
      ?>
    <tr>
      @if($_record)
        <td  class="center">{{++$count}}</td>
      @endif
      @if($_from_date)
        <td  class="center">{{convertDate($record->From_Date)}}</td>
      @endif
      @if($_to_date)
        <td  class="center">{{convertDate($record->To_Date)}}</td>
      @endif
      @if(!$member_name) 
        @if($_name)
          <td class="center">{{$record->Employee}}</td>
        @endif
      @endif
      @if(!$member_class_name)
        @if($_class)
          <td class="center">{{$record->member_class}}</td>
        @endif 
      @endif
      @if($_employee_attendance_class)
        <td class="center">{{$record->attendance_class_name}}</td>
      @endif
      @if($_worked_day)
        <td  class="center">{{$record->Worked_Days}}</td>
      @endif
      @if($_absent_day)
        <td  class="center">{{$record->absent_day}}</td>
      @endif
      @if($_paid_leave)
        <td  class="center">{{$record->Paid_Leave}}</td>
      @endif
      @if($_hours_no)
        <td  class="center">{{$record->worked_hour}}</td>
      @endif
      @if($_worked_hour)
        <td  class="center">{{$record->static_time}}</td>
      @endif
      @if($_rent)
        <td class="center">{{$record->rent}}</td>
      @endif  
      @if($_overtime_addition)
        <td class="center">{{myRound($record->Overtime_addition)}}</td>
      @endif
      @if($_overtime_amount)
        <td class="center">{{$record->overtime_amount}}</td>
      @endif 
      @if($_delay_amount)
        <td class="center">{{$record->delay_amount}}</td>
      @endif
      @if($_basic_salary)
        <td  class="center">{{$record->BasicSalary}} <span>{{$record->SalaryCurrency}}</span></td>
      @endif
      @if($_net_payable)
        <td  class="center">{{myRound($record->Net_Payable)}}</td>
      @endif
      @if(systemConfig()[5] != 0 ) 
        @if($_project)
          <td  class="center">{{$record->project_name}}</td>
        @endif
        @if($_status) 
          <td  class="center"> @if($record->status){{__('type.'.$record->status)}} @endif </td>
        @endif
        @if(systemConfig()[20] == 1)
          @if($_contract)
            <td  class="center">{{$record->contract_name}}</td>
          @endif
        @endif
      @endif
      {{-- @if($_currency)<td  class="center">{{$record->Currency}}</td>@endif --}}
      @if($_tax)
        <td  class="center">{{myRound($record->tax_amount)}} {{$record->tax_currency}}</td>
      @endif
      @if($_amount)
        <td  class="center">{{myRound($record->Amount)}} {{$record->Currency}}</td>
      @endif
      @if($_description)
        <td  class="center" style="@if($_description_percent) text-align: justify @endif">{{$record->description}}</td>
      @endif
      @if($_user) 
        <td  class="center">{{$record->user}}</td>
      @endif
      @if($_userSignature)
        <td class="text-center"></td>
      @endif
    </tr>
    @endforeach
  </table>
  <!-- "payroll_type" => "salary_attendance"
  "worked_hour" => 32.0
  "static_time" => 8.0
  "hourly" => "on" -->
  <table class="main-table">
    <tr class="bg">
      <td colspan="3"><div class="center">@lang('layout.PerCurrency')</div></td>
    </tr>
    <tr>
      <td><div class="center">  @lang('layout.Record') </div></td>
      <td><div class="center"> @lang('layout.Currency') </div></td>
      <td><div class="center"> @lang('layout.Amount') </div></td>
    </tr>
    <?php
      $count=0;
      foreach($currencies As $key=>$currency)
      {
    ?>
    <tr>
      <td><div class="center">{{++$count}}</div></td>
      <td><div class="center">{{$key}}</div></td>
      <td><div class="center">{{myRound($currency)}}</div></td>
    </tr>
    <?php
      }
    ?>
    <tr>
      <td colspan="2"><div class="center">@lang('layout.HomeCurrencyTotal')</div></td>
      <td><div class="center">{{myRound($total_home_currency)}} {{getHomeCurrency()[getCurrencyType()]}}</div></td>
    </tr>
  </table>
  {{-- Currencies Tax................................................................................... --}}
  <table class="main-table">
    <tr class="bg">
      <td colspan="3"><div class="center">@lang('layout.PerCurrency') @lang('layout.Tax')</div></td>
    </tr>
    <tr>
      <td><div class="center">  @lang('layout.Record') </div></td>
      <td><div class="center"> @lang('layout.Currency') </div></td>
      <td><div class="center"> @lang('layout.Amount') </div></td>
    </tr>
    <?php
      $count=0;
      foreach($currenciesTax As $key=>$currency)
      {
    ?>
    <tr>
      <td><div class="center">{{++$count}}</div></td>
      <td><div class="center">{{$key}}</div></td>
      <td><div class="center">{{myRound($currency)}}</div></td>
    </tr>
    <?php
      }
    ?> 
    <tr>
      <td colspan="2"><div class="center">@lang('layout.HomeCurrencyTotal')</div></td>
      <td><div class="center">{{myRound($total_home_currencyTax)}} {{getHomeCurrency()[getCurrencyType()]}}</div></td>
    </tr>
  </table>
  {{-- Currency Tax .................................................................................................. --}}
  <!--  signature -->
  <table style="width: 100%" class="signtable">
    <tr>
      @foreach(getCompanyInfo('sign','reports') AS $info)
      <td style="text-align: left; width:40%">
        <table>
          <tr>
            <td align="right" class="signsize">{{$info['name']}}</td>
          </tr>
        </table>
      </td>
      @endforeach
    </tr>
  </table>
  <!-- End signature -->
@endsection