@extends('layouts.app')

@section('content')

    <div class="portlet">
        <div class="portlet-title" id="backbtn">
            <div class="caption">
                <i class=""></i>@lang('layout.PayrollTaxDetail')
            </div>
            <div class="tools">
                <a href="javascript:;" class="collapse" data-original-title="" title=""> </a>
                <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
                {{--<a href="javascript:;" class="reload" data-original-title="" title=""> </a>--}}
                {{--<a href="javascript:;" class="remove" data-original-title="" title=""> </a>--}}
            </div>
        </div>
        <div class="portlet-body">
            <div class="table-scrollable">
                <table class="table table-striped table-bordered table-advance table-hover">
                    <thead>
                    <tr>
                        <th>
                            <i class="fa  fa-bars"></i> @lang('layout.Title')
                        </th>

                        <th>
                            <i class="fa fa-code"></i> @lang('layout.Currency')
                        </th>
                        <th>
                            <i class="fa fa-file-excel-o"></i> @lang('layout.Description')
                        </th>
                    </tr>
                    </thead>
                    <tbody>
                    <tr>
                        <td>  {{$payrollTax->title}} </td>
                        <td> {{$payrollTax->currency}}  </td>
                        <td>  {{$payrollTax->description}} </td>

                    </tr>
                   
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            <!-- BEGIN EXAMPLE TABLE PORTLET-->
            <div class="portlet light bordered">
                <div class="portlet-title">
                    <div class="caption font-dark">
                        <i class="icon-settings font-dark"></i>
                        <span class="caption-subject bold uppercase">@lang('layout.Details') </span>
                    </div>
                    <div class="tools"></div>

                </div>
                <div class="portlet-body">
                    <table class="table table-striped table-bordered table-hover" id="payroll_tax_details">
                        <thead>
                        <tr>

                            <th>@lang('layout.IncomeFrom')</th>
                            <th>@lang('layout.IncomeTo')</th>
                            <th>@lang('layout.Tax')</th>
                            <th>@lang('layout.ExtraAmount')</th>


                        </tr>
                        </thead>
                    </table>
                </div>
            </div>
            <!-- END EXAMPLE TABLE PORTLET-->
        </div>
    </div>
@endsection
@push('scripts')

    <script>
        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            $('#payroll_tax_details').DataTable({
                ajax: '{{route("payrollTax.show",$payrollTax->id)}}',
                scrollCollapse: true,
                serverSide: true,
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                paging: true,
                columns: [
                    {data: 'from_amount', name: 'from_amount'},
                    {data: 'to_amount', name: 'to_amount'},
                    {data: 'tax_percentage', name: 'tax_percentage'},
                    {data: 'extra_amount', name: 'extra_amount'},
                ]

            });
        });
    </script>


@endpush
