@extends('layouts.app')

@section('content')


    <div id="print-modal">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show"
                      :value-type="'allNoteReport'"
                      @closed="closeModal">

            <div slot=body>
                <div class="row">
                    <div class="form-group">
                        <label class="control-label"> @lang('layout.Number')</label>
                        <input class="form-control" type="number" name="note_number">
                    </div>
                </div>

                <div class="row">
                    <div class="form-group">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.Date')</label>
                                <div class="input-group">
                                    <input class="form-control date" id="range-from-example" name="from_date"
                                           autocomplete="off">

                                    <span class="input-group-addon"> @lang('layout.To') </span>
                                    <input class="form-control date" id="range-to-example" name="to_date"
                                           autocomplete="off">

                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </report-modal>
    </div>


    <!-- BEGIN TAB PORTLET-->
    <div class="row">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">  @lang('layout.PayrollTaxList')  </span>
                </div>
                <div class="tools"></div>
                <div class="pull-right">


                    @permission('payrollTax-export')
                   <!--  <span id="anchore-modal">
                     <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                        <i class="fa fa-print"></i>
                     </a>
                 </span> -->
                    @endpermission


                    @permission('payrollTax-create')
                    <a href="{{route('payrollTax.create')}}">
                        <!-- <button id="sample_editable_1_new" class="btn green btn-sm btn-outline"> -->
                        <button id="sample_editable_1_new" class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                        </button>
                    </a>
                    @endpermission
                </div>


            </div>
            <div class="portlet-body">
                <template v-cloak id="company_all">
                    <company @company="setCompany"></company>
                </template>
                <table class="table table-striped table-bordered table-hover" id="payroll_tax">
                    <thead>
                    <tr>
                        <th>@lang('layout.Title')</th>
                        <th>@lang('layout.Currency')</th>
                        <th>@lang('layout.Type')</th>
                        <th>@lang('layout.Description')</th>
                        <th>@lang('layout.Actions')</th>
                    </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>


    <!-- END TAB PORTLET-->
    <iframe id="payframe" style="display: none;"></iframe>
    <!-- END CONTENT BODY -->
@stop
@include('print.modal')
@include('groupCompanyFilter.select')
@push('scripts')

    <script>
        let data_table;
        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            data_table =$('#payroll_tax').DataTable({
                ajax: '{{route("payrollTax.index")}}',
                pageLength: '{{getPageRows()}}',
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                scrollCollapse: true,
                paging: true,
                serverSide: true,
                columns: [
                    {data: 'title', name: 'payroll_taxes.title'},
                    {data: 'currency', name: 'payroll_taxes.currency'},
                    {data: 'type', name: 'payroll_taxes.type' , searchable: false},
                    {data: 'description', name: 'payroll_taxes.description'},
                    {data: 'action', name: 'action', orderable: false, searchable: false},

                ]
            });
        });


        var vm = new Vue({
            el: '#print-modal',
            data: {
                is_show: false,
                pdfRoute: '{!!route('export.PDFAll') !!}',
                excelRoute: '',

            },
            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show
                },
            }
        });


        new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    console.log('trr')
                    vm.$data.is_show = true;

                }
            }
        });

        new Vue({
            el: '#company_all',
            methods: {
                setCompany: function (event) {
                    if (typeof data_table == 'object'){
                        data_table.clear();
                        data_table.ajax.reload();
                    }
                }
            }
        });


    </script>
@endpush