@extends('layouts.app')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">

@section('content')
    <div class="row">

        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.PayrollTaxEdit') </span>
                    --- <a href="{{asset('helps/tax_laws.pdf')}}" target="_blank" style="text-decoration: none"><i class="fa fa-download"></i> [@lang('help.DownloadSalaryTaxLaw')]</a>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools">
                </div>
            </div>
            <div id="app" class="portlet-body form" style="margin-bottom:50%;" v-cloak>
                <!-- BEGIN FORM-->
             
                {!! Form::model($payrollTax, ['method' => 'PATCH','class'=>'form-horizontal','route' => ['payrollTax.update',$payrollTax->id]]) !!}
                {{ csrf_field() }}
                <div class="form-body">
                    <div class="row">
                        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                          {{-- <p style="color:red">@lang('layout.Note'): @lang('layout.PayrollTaxNote')</p> --}}
                            <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">

                                <div class="col-md-12">
                                    <label class="control-label ">@lang('layout.Title')</label>
                                    <input type="text" name="title" value="{{$payrollTax->title}}" class="form-control" v-validate="'required'"
                                                   data-vv-as="@lang('layout.Title')">
                                    <span class="required">@{{ errors.first('title') }}</span>
                                </div>
                            </div>


                         


                            <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                <div class="col-md-12">
                                    <label class="control-label ">@lang('layout.TaxCurrency')</label>
                                    <v-select label="code" v-model="selected_currency" :options="currency"></v-select>
                                    <input type="hidden" name="currency" :value="(!selected_currency)?null:selected_currency.code" v-validate="'required'"
                                                   data-vv-as="@lang('layout.TaxCurrency')">
                                    <span class="required">@{{ errors.first('currency') }}</span>
                                </div>
                            </div>
                            <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                <div class="col-md-12">
                                    <label class="control-label">@lang('layout.Type')</label>
                                    <select name="type" class="form-control">
                                        <option value="Montly" @if($payrollTax->type=="Montly") selected @endif>@lang('layout.Montly')</option>
                                        <option value="Daily" @if($payrollTax->type=="Daily") selected @endif >@lang('layout.Daily')</option>
                                        <option value="Weekly"@if($payrollTax->type=="Weekly") selected @endif >@lang('layout.Weekly')</option>
                                        <option value="TwoWeek" @if($payrollTax->type=="TwoWeek") selected @endif >@lang('layout.TwoWeek')</option>
                                        <option value="TwiceAMonth" @if($payrollTax->type=="TwiceAMonth") selected @endif>@lang('layout.TwiceAMonth')</option>
                                    </select>
                                </div>
                            </div>


                            <div class="col-md-12">
                                <div class="col-md-12">
                                    <label class="control-label ">@lang('layout.Description')</label>
                                        <textarea name="description" class="form-control" rows="3">
                                            {{$payrollTax->description}}
                                        </textarea>
                              
                                </div>
                            </div>
                            

                            <div style="margin-top: 50px !important">
                                <table id="table_content" class="table table-bordered">
                                    <thead>
                                    <tr>
                                        <th>#</th>
                                        <th style="min-width: 300px">@lang('layout.IncomeFrom') </th>
                                        <th >@lang('layout.IncomeTo') </th>
                                        <th >@lang('layout.Tax')% </th>
                                        <th >@lang('layout.ExtraAmount') </th>
                                        <th></th>

                                    </tr>
                                    </thead>
                                    <tbody>
                                    <tr v-for="(item,index) in payrollTaxArray">
                                        <td @click="addNew(index)">@{{index+1}}</td>
                                        <td @click="addNew(index)" class="highlight">
                                            <input type="number" 
                                                   name="from_amount[]" v-model="(!item)?null:item.from_amount" class="form-control">
                                        </td>
                                        <td @click="addNew(index)" class="highlight">
                                            <input type="number" 
                                                   name="to_amount[]" v-model="(!item)?null:item.to_amount" class="form-control">
                                        </td>
                                        <td @click="addNew(index)" class="highlight">
                                            <input type="number" 
                                                   name="tax[]" v-model="(!item)?null:item.tax" class="form-control">
                                        </td>
                                         <td @click="addNew(index)" class="highlight">
                                            <input type="number"  
                                                   name="extra_amount[]" v-model="(!item)?null:item.extra_amount" class="form-control">
                                        </td>
                                       
                                        <td>
                                            <span v-on:click="deleteItem('index')"><i
                                                        class="paddint-both glyphicon glyphicon-trash"></i></span>
                                        </td>

                                    </tr>
                                    </tbody>
                                </table>

                                <button v-if="payrollTaxArray.length<1" class="btn btn-info" @click="addNew(0)">+</button>
                            </div>
                        </div>


                    </div>
                </div>
                <div class="col-md-4 col-md-offset-4 text-center">
                    <br>
                    <button type="button" 
                                                    @click="handleSubmit($event)"
                                                    class="btn green">@lang('layout.Submit')</button>
                    <a href="{{route('payrollTax.index')}}" class="btn default"><i
                                class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                </div>
                {!! Form::close() !!}

            </div>

            <!-- END FORM-->
        </div>
    </div>

@endsection
@push('scripts')
    <script type="text/javascript">

        @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
        Vue.use(VeeValidate, {
            locale: 'en',
        });
        @endif
        Vue.component('v-select', VueSelect.VueSelect);

        var currency= {!! $currency !!};
        var homeCurrency= {!! $homeCurrency !!};
        var payrollTax = {!! $payrollTax !!};
        var payrollTaxDetail = {!! $payrollTaxDetail !!};
        let v = new Vue({
            el: '#app',
            data: {
                payrollTax:payrollTax,
                payrollTaxDetail:payrollTaxDetail,
                currency:currency,
                selected_currency:homeCurrency,
                payrollTaxArray:
                [

                ]
            },
            mounted:function(){
                if(this.payrollTax)
                {
                    
                    this.selected_currency = _.find(this.currency, (v) => v.code == this.payrollTax.currency);

                    for(var i=0;i<this.payrollTaxDetail.length;i++)
                    {
                        this.payrollTaxArray.push({from_amount: this.payrollTaxDetail[i].from_amount, to_amount: this.payrollTaxDetail[i].to_amount,
                            tax:this.payrollTaxDetail[i].tax_percentage,
                            extra_amount:this.payrollTaxDetail[i].extra_amount});
                    }

                }
            },
            methods: {
                handleSubmit(e) {
                    this.$validator.validate().then(valid => {
                        if (valid) {
                            v.submitForm(e.target.form);
                        }
                    });
                },
                 submitForm(form) {

                        
                        swal({
                            title: "@lang('layout.AreYouSure?')",
                            buttons: ["@lang('layout.Cancel')", "@lang('layout.Submit')"],
                            text: "",
                            icon: "info",
                            dangerMode: true,
                        }).then((willDelete) => {
                            if (willDelete) {
                                form.submit()

                            }
                            else {

                            }
                        });

                    },
                addNew(index) {
                    if (this.payrollTaxArray[index + 1] == undefined) {
                        this.payrollTaxArray.push({from_amount: null, to_amount: null,tax:null,extra_amount:null});
                    }

                },

                deleteItem(index) {
                    this.payrollTaxArray.splice(index, 1);
                },
            }
        })
    </script>

@endpush
 