@extends('layouts.app')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">

@section('content')
    <div class="row">

        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.AddNewPayrollTax')</span>
                    --- <a href="{{asset('helps/tax_laws.pdf')}}" target="_blank" style="text-decoration: none"><i class="fa fa-download"></i> [@lang('help.DownloadSalaryTaxLaw')]</a>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools">
                </div>
            </div>
            <div id="app" class="portlet-body form" style="margin-bottom:50%;" v-cloak>
                <!-- BEGIN FORM-->
                {!! Form::open(array('route' => 'payrollTax.store','method'=>'POST','class'=>'form-horizontal')) !!}
                {{ csrf_field() }}
                <div class="form-body">
                    <div class="row">
                        <div class="col-lg-10 col-md-10 col-sm-12 col-xs-12">
                            {{-- <p style="color:red">@lang('layout.Note'): @lang('layout.PayrollTaxNote')</p> --}}
                            <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                <div class="col-md-12">
                                    <label class="control-label ">@lang('layout.Title')</label>
                                    <input type="text" name="title" class="form-control" v-validate="'required'"
                                                   data-vv-as="@lang('layout.Title')">
                                    <span class="required">@{{ errors.first('title') }}</span>
                                </div>
                            </div>
                            <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                <div class="col-md-12">
                                    <label class="control-label ">@lang('layout.TaxCurrency')</label>
                                    <v-select label="code" v-model="selected_currency" :options="currency"></v-select>
                                    <input type="hidden" name="currency" :value="(!selected_currency)?null:selected_currency.code" v-validate="'required'"
                                                   data-vv-as="@lang('layout.TaxCurrency')">
                                    <span class="required">@{{ errors.first('currency') }}</span>

                                </div>
                            </div>
                            <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                <div class="col-md-12">
                                    <label class="control-label">@lang('layout.Type')</label>
                                    <select name="type" class="form-control">
                                        <option value="Montly">@lang('layout.Montly')</option>
                                        <option value="Daily">@lang('layout.Daily')</option>
                                        <option value="Weekly">@lang('layout.Weekly')</option>
                                        <option value="TwoWeek">@lang('layout.TwoWeek')</option>
                                        <option value="TwiceAMonth">@lang('layout.TwiceAMonth')</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="col-md-12">
                                    <label class="control-label ">@lang('layout.Description')</label>
                                    <textarea name="description" class="form-control" rows="3"></textarea>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                            <div style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px;margin-bottom: 1em;">
                                <div class="dashboard-stat2" style="text-align: left; direction: ltr !important">
                                        <pre style="padding: 0px !important; text-align:center;color:red">@lang('layout.Example')</pre>
                                        <pre style="padding: 0px !important;">20000</pre>
                                        <pre style="padding: 0px !important;">20000 - 12500 = 7500</pre>
                                        <pre style="padding: 0px !important;">7500 * 10 / 100 = 750</pre>
                                        <pre style="padding: 0px !important;">750 + 150 = <span style="color: red">900</span></pre>
                                    
                                </div>
                            </div>
                        </div>
                            

                            <div style="margin-top: 50px !important">
                                <table id="table_content" class="table table-bordered">
                                    <thead>
                                    <tr>
                                        <th>#</th>
                                        <th style="min-width: 300px">@lang('layout.IncomeFrom') </th>
                                        <th >@lang('layout.IncomeTo') </th>
                                        <th >@lang('layout.Tax')% </th>
                                        <th >@lang('layout.ExtraAmount') </th>
                                        <th></th>

                                    </tr>
                                    </thead>
                                    <tbody>
                                    <tr v-for="(item,index) in payrollTax">
                                        <td @click="addNew(index)">@{{index+1}}</td>
                                        <td @click="addNew(index)" class="highlight">
                                            <input type="number" 
                                                   name="from_amount[]" class="form-control">
                                        </td>
                                        <td @click="addNew(index)" class="highlight">
                                            <input type="number" 
                                                   name="to_amount[]" class="form-control">
                                        </td>
                                        <td @click="addNew(index)" class="highlight">
                                            <input type="number" 
                                                   name="tax[]" class="form-control">
                                        </td>
                                         <td @click="addNew(index)" class="highlight">
                                            <input type="number" 
                                                   name="extra_amount[]" class="form-control">
                                        </td>
                                       
                                        <td>
                                            <span v-on:click="deleteItem('index')"><i
                                                        class="paddint-both glyphicon glyphicon-trash"></i></span>
                                        </td>

                                    </tr>
                                    </tbody>
                                </table>

                                <button v-if="payrollTax.length<1" class="btn btn-info" @click="addNew(0)">+</button>
                            </div>
                        


                    </div>
                </div>
                <div class="col-md-4 col-md-offset-4 text-center">
                    <br>
                    <button type="button" 
                                                    @click="handleSubmit($event)"
                                                    class="btn green">@lang('layout.Submit')</button>
                    <a href="{{route('payrollTax.index')}}" class="btn default"><i
                                class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                </div>
                {!! Form::close() !!}

            </div>

            <!-- END FORM-->
        </div>
    </div>

@endsection
@push('scripts')
    <script type="text/javascript">

        @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
        Vue.use(VeeValidate, {
            locale: 'en',
        });
        @endif

        Vue.component('v-select', VueSelect.VueSelect);

        var currency= {!! $currency !!};
        var homeCurrency= {!! $homeCurrency !!};
        let v = new Vue({
            el: '#app',
            data: {
                currency:currency,
                selected_currency:homeCurrency,
                payrollTax:
                [
                    {from_amount: null, to_amount: null,tax:null,extra_amount:null},
                    {from_amount: null, to_amount: null,tax:null,extra_amount:null},

                ]
            },
            methods: {
                handleSubmit(e) {
                    this.$validator.validate().then(valid => {
                        if (valid) {
                            v.submitForm(e.target.form);
                        }
                    });
                },
                 submitForm(form) {

                        
                        swal({
                            title: "@lang('layout.AreYouSure?')",
                            buttons: ["@lang('layout.Cancel')", "@lang('layout.Submit')"],
                            text: "",
                            icon: "info",
                            dangerMode: true,
                        }).then((willDelete) => {
                            if (willDelete) {
                                form.submit()

                            }
                            else {

                            }
                        });

                    },
                addNew(index) {
                    if (this.payrollTax[index + 1] == undefined) {
                        this.payrollTax.push({from_amount: null, to_amount: null,tax:null,extra_amount:null});
                    }

                },

                deleteItem(index) {
                    this.payrollTax.splice(index, 1);
                },
            }
        })
    </script>

@endpush
 