@extends('layouts.app')

@section('content')
    <div class="row">

        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.ItemPayrollTypeList')</span>
                </div>
                <div class="tools">

                </div>
                <div class="btn-group pull-right">
                    <div id="measure">

                        @permission('itemTypePayroll-create')
                        <a href="{{route('payroll.price.level.index')}}" class="btn btn-danger">
                           <i class="fa fa-backward"></i> @lang('layout.Back')
                        </a>
                        @endpermission

                    </div>
                </div>
            </div>
            <div class="portlet-body">
                <table class="table table-striped table-bordered table-hover" id="payrollPriceLevel">
                    <thead>
                    <tr>
                        <th>@lang('layout.Account')</th>
                        <th>@lang('layout.Name')</th>
                        <th>@lang('layout.PayrollType')</th>
                        <th>@lang('layout.Type')</th>
                        <th>@lang('layout.Measure')</th>
                        <th>@lang('layout.Amount')</th>
                        <th>@lang('layout.Actions')</th>
                    </tr>
                    </thead>

                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->

    </div>



@stop

@push('scripts')
    <script>
        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            $('#payrollPriceLevel').DataTable({
                ajax: '{{route("payroll.price.level.show",['id'=>$id])}}',
                paging: true,
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                server: true,
                serverSide: true,
                columns: [
                    {data: 'account_name', name: 'accounts.name'},
                    {data: 'name', name: 'payroll_price_levels.name'},
                    {data: 'payroll_name', name: 'item_type_payrolls.name'},
                    {data: 'type', name: 'item_type_payrolls.type'},
                    {data: 'measure', name: 'measure_units.name'},
                    {data: 'amount', name: 'payroll_price_level_details.amount'},
                    {data: 'actions', name: 'actions', orderable: false, searchable: false}
                ]
            });

        });
    </script>
@endpush
