@extends('layouts.app')

@section('content')

    <div id="print-modal">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show"
                      :value-type="'payroll_price'"
                      @closed="closeModal">

            <div slot="body">
                <div class="row">
                    <div class="form-group">
                        <div  class="col-md-12">
                            <label class="control-label ">@lang('layout.SelectType') </label>
                            <select name="category" id="" class="form-control">
                                <option  value="1" selected="selected">@lang('layout.WithDetail')</option>
                                <option  value="2">@lang('layout.WithoutDetail')</option>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.Date')</label>
                                <div class="input-group">
                                    <input class="form-control date" id="range-from-example" name="from_date" autocomplete="off">

                                    <span class="input-group-addon">@lang('layout.To') </span>
                                    <input class="form-control date" id="range-to-example" name="to_date" autocomplete="off">

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </report-modal>
    </div>

    <div class="row">

        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.ItemPriceLevel')</span>
                </div>
                <div class="tools">

                </div>
                <div class="btn-group pull-right">
                    <div id="measure">
                        @permission('payroll-export')
                        <span id="anchore-modal">
                            <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                                <i class="fa fa-print"></i>
                            </a>
                        </span>
                        @endpermission
                        @permission('payrollPriceLevel-create')
                        <a href="{{route('payroll.price.level.create')}}" class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                        </a>
                        @endpermission

                    </div>
                </div>
            </div>
            <div class="portlet-body">

                <template v-cloak id="company_ll">
                    <company @company="setCompany"></company>
                </template>

                <table class="table table-striped table-bordered table-hover" id="payrollPriceLevel">
                    <thead>
                    <tr>
                        <th>@lang('layout.Name')</th>
                        <th>@lang('layout.Currency')</th>
                        <th>@lang('layout.Description')</th>
                        <th>@lang('layout.User')</th>
                        <th>@lang('layout.Actions')</th>

                    </tr>
                    </thead>

                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->

    </div>



@stop
@include('groupCompanyFilter.select')
@include('print.modal')
@push('scripts')
    <script>
        let data_table;
        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            data_table = $('#payrollPriceLevel').DataTable({
                ajax: '{{route("payroll.price.level.index")}}',
                paging: true,
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                server: true,
                serverSide: true,
                buttons: [{
                    extend: 'excel',
                    text: '',
                    key: {
                        key: 'x',
                        altkey: true
                    }
                }],
                columns: [
                    {data: 'name', name: 'payroll_price_levels.name'},
                    {data: 'code', name: 'currencies.code'},
                    {data: 'description', name: 'payroll_price_levels.description'},
                    {data: 'user', name: 'users.name'},
                    {data: 'actions', name: 'actions', orderable: false, searchable: false}
                ]
            });

        });

        //  for new modal

        var vm =new Vue({
            el: '#print-modal',
            data:{
                is_show:false,
                pdfRoute: '{!!route('payroll.price.level.report') !!}',
                excelRoute: '{!! route('payroll.price.level.report') !!}'
            },
            methods:{
                closeModal: function(){
                    this.is_show = !this.is_show
                },



            }
        });

        new Vue({
            el:'#anchore-modal',
            methods:{
                showModal:function(){
                    console.log('trr')
                    vm.$data.is_show = true;

                }
            }
        });

        new Vue({
            el: '#company_ll',
            methods: {
                setCompany: function (event) {
                    if (typeof data_table =='object'){
                        data_table.clear();
                        data_table.ajax.reload();
                    }
                }
            }
        });
    </script>
@endpush
