@extends('layouts.app')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">


@section('content')
    <div class="row">
        <div class="portlet light bordered">
            <!-- BEGIN TAB PORTLET-->
            <div class="portlet light bordered">
                <div class="portlet-title">
                    <div class="caption">
                        <i class="icon-anchor font-green-sharp"></i>
                        <span class="caption-subject font-green-sharp bold uppercase">@lang('layout.CreateNewItemPriceLevel')</span>
                    </div>
                    <div class="actions">
                    </div>
                </div>
                <div id="appPriceLevel" class="portlet-body">

                    <div class="tabbable tabbable-tabdrop">


                        <div>
                            {{Form::open(['route' => 'payroll.price.level.store','method' => 'POST','class' => 'form-horizontal','id'=>'price-level-form'])}}
                            {{ csrf_field() }}
                            <div class="tab-content">

                                <div class="tab-pane active" id="tab1">

                                    <div v-cloak class="portlet-body form" style="margin-bottom:50%;">

                                        <div class="form-body">
                                            <div class="row">

                                                <div class="col-lg-4 col-md-4 col-sm-12">
                                                    <div class="form-group">
                                                        <label for="name">@lang('layout.Name')</label>
                                                        <input type="text" name="name"
                                                               placeholder="@lang('layout.Name')" required
                                                               class="form-control">
                                                    </div>
                                                </div>
                                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                    <div class="form-group">
                                                        <div class="col-md-12">
                                                            <label class="control-label">@lang('layout.Currency')</label>

                                                            <v-select label="code"
                                                                      :options="currencies"
                                                                      v-model="selected_currency"></v-select>
                                                            <input type="hidden" name="currency"
                                                                   v-if="selected_currency != null"
                                                                   v-validate="'required'"
                                                                   data-vv-as="@lang('layout.Currency')"
                                                                   :value="selected_currency.id">
                                                            <span class="required">@{{ errors.first('currency') }}</span>
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="col-lg-4 col-md-4 col-sm-12">
                                                    <div class="form-group">
                                                        <label for="description"> @lang('layout.Description')</label>
                                                        <textarea name="description" id="description" cols="30"
                                                                  class="form-control"
                                                                  placeholder="@lang('layout.Description')"
                                                                  rows="1"></textarea>
                                                    </div>
                                                </div>

                                            </div>

                                            <div class="row" style="overflow-x: scroll;">
                                                <div class="col-md-12 col-lg-12 col-sm-12">
                                                    <table id="table_content"
                                                           class="table table-bordered table-advance">
                                                        <thead>
                                                        <tr>
                                                            <th>#</th>
                                                            <th style="min-width: 130px">@lang('layout.PayrollType') </th>
                                                            <th style="min-width: 100px">@lang('layout.Measure') </th>
                                                            <th style="min-width: 130px">@lang('layout.Amount') </th>
                                                            <th v-show="showWhat('contract_salary')=='yes'" style="min-width: 130px">@lang('layout.AmountOfWork') </th>
                                                            <th></th>
                                                        </tr>
                                                        </thead>
                                                        <tbody>
                                                        <tr v-for="(type,index) in types">
                                                            <td>@{{index+1}}</td>
                                                            <td>
                                                                <v-select label="name" :options="itemTypes"
                                                                          @input="addNew(index)"
                                                                          v-model="type.item_id"></v-select>
                                                                <input type="hidden" name="item_type_id[]"
                                                                       :value="type.item_id ? type.item_id.id:null">
                                                            </td>
                                                            <td>
                                                                <v-select placeholder="@lang('layout.SelectUnitMeasure') " label="name"  :options="measureList" v-model="type.measure" ></v-select>
                                                                <input type="hidden" name="um_id[]" :value="type.measure?type.measure.id:null">
                                                            </td>
                                                            <td>
                                                                <input type="number" class="form-control"
                                                                       name="amount[]"
                                                                       placeholder="@lang('layout.Amount')">
                                                            </td> 
                                                            <td v-show="showWhat('contract_salary')=='yes'">
                                                                <input type="number" class="form-control"
                                                                       name="amount_of_work[]"
                                                                       placeholder="@lang('layout.AmountOfWork')">
                                                            </td>
                                                            <td>
                                                            <span @click="deleteItem(index)">
                                                                <i class="paddint-both glyphicon glyphicon-trash"></i></span>

                                                            </td>
                                                        </tr>
                                                        <tr style="background-color: #ffffff;">
                                                            <td colspan="4">
                                                                <center>
                                                                    <button type="button" @click="addNew()"
                                                                            class="btn btn-success"><i
                                                                                class="fa fa-plus"></i></button>
                                                                </center>
                                                            </td>
                                                        </tr>
                                                        </tbody>
                                                    </table>
                                                </div>

                                            </div>


                                        </div>
                                        <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                                            <button type="button"  onclick="regForm(this)" class="btn green">@lang('layout.Submit')</button>
                                            <button type="button" class="btn blue" @click="saveAndNew($event)" >@lang('layout.SaveAndNew')</button>
                                            <a href="{{route('payroll.price.level.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>

                                        </div>
                                    </div>


                                </div>


                                {!! Form::close() !!}

                            </div>

                        </div>


                    </div>
                    <p> &nbsp; </p>
                    <p> &nbsp; </p>
                </div>
            </div>
            <!-- END TAB PORTLET-->
        </div>
    </div>

@endsection
@push('scripts')


    <script type="text/javascript">

        @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
        Vue.use(VeeValidate, {
            locale: 'en',
        });
        @endif



        Vue.component('v-select', VueSelect.VueSelect);

        // end new member

        let currency = {!! $currencies !!};
        let itemType = {!! $itemTypes !!};
        let homeCurrency = {!! json_encode(getHomeCurrency()) !!};
        let measureList = {!! json_encode($measure) !!};

        new Vue({
            el: '#appPriceLevel',
            data: {
                currencies: currency,
                selected_currency: homeCurrency,
                itemTypes: itemType,
                measureList: measureList,
                types: [
                    {
                        item_id: null,
                        amount: null,
                        measure:null,
                        amount_of_work:null
                    }
                ],
            },
            created() {
                // console.log('currencies', this.currencies);
                // console.log('selected currency', this.selected_currency);
            },
            methods:
                {
                    submit() {
                        $("#price-level-form").submit();
                    },
                    deleteItem(index) {

                        if (this.types.length > 1)
                            this.types.splice(index, 1);
                        else
                            this.types = [{
                                item_id: null,
                                amount: null,
                                measure:null,
                                amount_of_work:null
                            }];
                    },
                    addNew(index = -1) {

                        if (index < 0 || (index == this.types.length - 1)) {
                            this.types.push({
                                item_id: null,
                                amount: null,
                                measure:null,
                                amount_of_work:null
                            })
                        }
                    },
                    saveAndNew()
                    {
                        this.$validator.validate()
                        .then(valid =>{
                            if(valid)
                            {
                                
                                var url="{{route('payroll.price.level.store')}}";
                                form_id='price-level-form';
                                var data= $('#'+form_id).serialize();
                                // console.log(444, data);
                                toggleBlock(true);
                                axios.post(url,data)
                                .then(function(response){
                                        toggleBlock(0);
                                        if(response.data.result==1)
                                        {
                                            $('#'+form_id).trigger('reset');
                                            
                                            toastr.success('',response.data.message); 
                                            location.reload();
                                        
                                        }
                                        else
                                        {
                                            var message="{{__('message.Warning')}}";
                                            //$('#error-sound')[0].play();
                                            toastr.warning('',message);
                                        }
                                })
                                .catch(function(error){
                                toggleBlock(0);
                                    console.log(error);
                                    var message="{{__('message.Warning')}}";
                                    //$('#error-sound')[0].play();
                                    toastr.warning('',message);
                                });
                            
                            }
                        })
                    },

                },


        });

    </script>



@endpush