@extends('layouts.app')
@section('content')
    <!-- END PAGE HEADER-->
    <div class="portlet">
        <div class="portlet-title" id="backbtn">
            <div class="caption">
                <i class=""></i>@lang('layout.ContractBasedPayrollDetails')
            </div>
            <div class="tools">
                <a href="javascript:;" class="collapse" data-original-title="" title=""> </a>
                <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
            </div>
        </div>
        <div class="portlet-body">
            <div class="table-scrollable">
                <table class="table table-striped table-bordered table-advance table-hover">
                    <thead>
                    <tr> 
                        <th>
                            <i class="fa  fa-user"></i> @lang('layout.Name') 
                        </th>
                         <th>
                            <i class="fa fa-clock-o"></i> @lang('layout.From')
                        </th>
                        <th>
                            <i class="fa fa-clock-o"></i> @lang('layout.To')
                        </th>
                        @if(systemConfig()[20] == 1)
                        <th>
                            @lang('menu.Contract')
                        </th>
                        @endif
                        <th> 
                            <i class="fa  "></i> @lang('layout.Currency') 
                        </th>
                        <th>
                            <i class="fa "></i> @lang('layout.NetPayable')
                        </th>  
                        <th>
                            <i class="fa "></i> @lang('layout.AgencyTax')
                        </th>    
                        <th>
                            <i class="fa "></i> @lang('layout.Percent') @lang('layout.Tax') 
                        </th>     
                        <th>
                            <i class="fa "></i> @lang('layout.Amount') @lang('layout.Tax') 
                        </th>  
                        <th>
                            <i class="fa fa-bars"></i> @lang('layout.Description')
                        </th>  
                        <th>
                            <i class="fa fa-bars"></i> @lang('layout.SalaryCategory')
                        </th>  
                        
                    </tr>
                    </thead>
                    <tbody>
                    <tr>  
                        <td>{{$payroll->Employee}}</td>
                        <td>{{convertDate($payroll->From_Date)}}</td>
                        <td>{{convertDate($payroll->To_Date)}}</td>
                        @if(systemConfig()[20] == 1)
                        <td>{{ $payroll->contract_name}}</td>
                        @endif
                        <td>{{$payroll->currency}}</td>
                        <td>{{myRound($payroll->Net_Payable)}}</td>
                        <td>{{$payroll->taxMember}}</td>
                        <td>{{myRound($payroll->percent)}} %</td>
                        <td>{{myRound($payroll->tax_amount)}}</td>
                        <td>{{$payroll->description}}</td>
                        <td>{{$payroll->esc_name}}</td> 
                    </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>


    <!-- BEGIN TAB PORTLET-->
    <div class="row">

        <!-- BEGIN EXAMPLE TABLE PORTLET-->

        <div class="portlet light bordered">
            <div class="portlet-title">
                
                <div class="tools"> </div>
                <div class="pull-right">

                </div>
            </div>
            <div class="portlet-body">
                <table class="table table-striped table-bordered "  cellspacing="0" id="payroll">
                    <thead>
                    <tr>
                        <th>@lang('layout.Name')</th>
                        <th>@lang('layout.Type')</th>
                        <th>@lang('layout.Times')</th>
                        <th>@lang('layout.Amount')</th>
                        @if(getContractSalary()=="true")
                        <th>@lang('layout.AmountOfWork')</th>
                        @endif
                        <th>@lang('layout.Total')</th>
                        <th>@lang('layout.Currency')</th>
                        @if(systemConfig()[21] == 1)
                        <th>@lang('layout.BuildQuantity')</th>
                        <th>@lang('layout.ItemType')</th>
                        @endif
                    </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>
    <!-- END TAB PORTLET-->
    <!-- END CONTENT BODY -->
    <iframe id="payframe" style="display: none;" ></iframe>
@stop

@push('scripts')


    <script>


        $(document).ready(function() {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            $('#payroll').DataTable( {
                // 'order': [[ 8, 'desc' ]],
                ajax:           '{{route("payroll.form.show",['id'=>$id])}}',
                pageLength:'{{getPageRows()}}',
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                scrollY:        450,
                scrollCollapse: true,
                serverSide: true,
                paging:         true,
                columns: [
                    { data: 'name', orderabel:false,searchable:false },
                    { data: 'type', name:'item_type_payrolls.type',orderabel:false,searchable:false },
                    { data: 'times', orderabel:false,searchable:false },
                    { data: 'per_amount', orderabel:false,searchable:false },
                    @if(getContractSalary()=="true")
                    { data: 'amount_of_work', orderabel:false,searchable:false },
                    @endif
                    { data: 'amount', orderabel:false,searchable:false },
                    { data: 'currency',           name: 'currencies.code' , orderabel:false,searchable:false},
                    @if(systemConfig()[21] == 1)
                    { data: 'build_quantity', orderabel:false,searchable:false },
                    { data: 'item_type', orderabel:false,searchable:false },
                    @endif
                ]
            });
        });
    </script>
@endpush