@extends('layouts.factor-master')

@section('content')
<?php
$report = customeReport('payment_by_factor');
$_description=in_array('description', $report);
$_test=true;

?>
  <h3 class="table-caption" style="text-align: center;">@lang('layout.PayrollReport')</h3>
  <p>@lang('layout.ContractBasedPayroll')</p>

<table class="report-table">
  
   <thead>
      <tr class="bg">
        <td  class="center" >@lang('layout.Record') </td>
        <td  class="center" >@lang('layout.Number')</td>
        <td  class="center" >@lang('layout.Employee')</td>
        @if(systemConfig()[5] != 0 ) <td  class="center" >@lang('layout.Project')</td> @endif
        <td    class="center" >@lang('menu.Overtime')</td>
        <td    class="center" >@lang('layout.NetPayable')</td>
        <td   class="center" >@lang('layout.Currency')</td>
        <td  class="center" >@lang('layout.Rate')</td>
        <td    class="center" >@lang('layout.Tax')</td>
        <td  class="center" >@lang('layout.FromDate')</td>
        <td  class="center" >@lang('layout.ToDate')</td>
        <td  class="center" >@lang('layout.Description')</td>
        <td  class="center" >@lang('layout.User')</td>
        <td width="50%" ><center> @lang('layout.Details')</center></td>
      </tr>
    </thead>
 <?php
 $count = 0;
 $items = [];
 $currencies = [];
 ?>
 <tbody>
   
 @foreach($data AS $record)
 
 <?php 
    if(array_key_exists($record->currency, $currencies)){
        $currencies[$record->currency]['tax_amount']=$currencies[$record->currency]['tax_amount']+$record->tax_amount;
        $currencies[$record->currency]['amount'] = $currencies[$record->currency]['amount'] + ($record->net_payable);
    } else {
        $currencies[$record->currency]['tax_amount'] = $record->tax_amount;
        $currencies[$record->currency]['amount'] = $record->net_payable;
    }
  ?>

  <tr>

   <td class="center"> {{++$count}}</td>
   <td class="center"> {{$record->id}}</td>
   <td class="center"> {{$record->member_name}}</td>
   @if(systemConfig()[5] != 0 )<td class="center"> {{$record->project_name}}</td>@endif
   <td class="center"> {{ myRound($record->salary_contract_overtime)}}</td>
   <td class="center"> {{ myRound($record->net_payable)}}</td>
   <td class="center"> {{$record->currency}}</td>
   <td class="center"> {{$record->rate}}</td>
   <td class="center"> {{ myRound($record->tax_amount)}} {{$record->tax_currency}} </td> 
   <td class="center"> {{convertDate($record->from_date)}}</td>
   <td class="center"> {{convertDate($record->to_date)}}</td>
   <td class="center"> {{$record->description}}</td>
   <td class="center"> {{$record->user}}</td>
   <td width="50%" >

   @if($record->detail)
      <table class="main-table" style="width:100%">
          <tr class="bg">
              <td width="30%" class="center">@lang('layout.Name')</td>
              <td width="25%" class="center">@lang('layout.Type')</td>
              <td width="10%" class="center">@lang('layout.Times')</td>
              <td width="7%" class="center">@lang('layout.UnitPrice')</td>
			  @if(getContractSalary()=="true")
			  <td width="7%" class="center">@lang('layout.AmountOfWork')</td>
			  @endif
              <td width="20%" class="center">@lang('layout.Amount')</td>
          </tr>
          @foreach($record->detail AS $k=>$v)
          <?php 
            if(array_key_exists($v['name'], $items)){
                $items[$v['name']]['quantity']=$items[$v['name']]['quantity']+$v['times'];
                if(systemConfig()[30] == 1){
                  $items[$v['name']]['amount'] = $items[$v['name']]['amount'] + ($v['amount'] / $v['static_rate'] * $v['rate']);
                }else{
                  $items[$v['name']]['amount'] = $items[$v['name']]['amount'] + ($v['amount'] / $v['rate']);
                }
            } else {
                $items[$v['name']]['quantity'] = $v['times'];
                if(systemConfig()[30] == 1){
                  $items[$v['name']]['amount'] = $v['amount'] / $v['static_rate'] * $v['rate'];
                }else{
                  $items[$v['name']]['amount'] = $v['amount'] / $v['rate'];
                }
            }
          ?>
              <tr>
                  <td class="center ltr">{{$v['name']}}</td>
                  <td class="center ltr">{{__('layout.'.$v['type'])}}</td>
                  <td class="center ltr">{{$v['times']}}</td>
                  <td class="center ltr"><BDO DIR="LTR">{{myRound($v['per_amount'])}}</BDO></td>
				          @if(getContractSalary()=="true")
                  <td class="center ltr"><BDO DIR="LTR">{{myRound($v['amount_of_work'])}}</BDO></td>
				          @endif
                  <td class="center ltr"><BDO DIR="LTR">{{myRound($v['amount'])}} {{$v['symbol']}}</BDO></td>
              </tr>
          @endforeach
      </table>
   @endif 
  </td>
 </tr> 
  @endforeach    
 </tbody>
</table>

<p>@lang('layout.Items')</p>
<table class="main-table">
   <tr class="bg">
     <td class="center"><b> @lang('layout.Record') </b></td>
     <td class="center"><b> @lang('layout.Item') </b></td>
     <td class="center"><b> @lang('layout.Quantity') </b></td>
     <td class="center"><b> @lang('layout.TotalAmount') {{getHomeCurrency()[getCurrencyType()]}} </b></td>
   </tr>
   <?php
    $count=0;
   foreach($items As $key=>$item)
   {
     ?>
     <tr>
       <td class="center">{{++$count}}</td>
       <td class="center">{{$key}}</td>
       <td class="center">{{myRound($item['quantity'])}}</td>
       <td class="center">{{myRound($item['amount'])}}</td>
     </tr>
     <?php
   }
   ?>
</table>

<p>@lang('layout.PerCurrency')</p>
<table class="main-table">
   <tr class="bg">
     <td class="center"><b> @lang('layout.Record') </b></td>
     <td class="center"><b> @lang('layout.Currency') </b></td>
     <td class="center"><b> @lang('layout.Total') @lang('layout.NetPayable') </b></td>
     <td class="center"><b> @lang('layout.Total') @lang('layout.Tax') </b></td>
   </tr>
   <?php
    $count=0;
   foreach($currencies As $key1=>$ro)
   {
     ?>
     <tr>
       <td class="center">{{++$count}}</td>
       <td class="center">{{$key1}}</td>
       <td class="center">{{myRound($ro['amount'])}}</td>
       <td class="center">{{myRound($ro['tax_amount'])}}</td>
     </tr>
     <?php
   }
   ?>
</table>

 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table> 
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr> 
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection