@extends('layouts.factor-master')

@section('content')
<?php
$report = customeReport('payment_by_factor');
$_description=in_array('description', $report);
$_test=true;

?>
  <h3 class="table-caption" style="text-align: center;">@lang('layout.PayrollReport')</h3>
  <p>@lang('layout.ContractBasedPayroll')</p>



<table class="report-table">
  
   <thead>
      <tr class="bg">
      <td  class="center" ><div>  @lang('layout.Record') </div></td>
      @if($_test)<td  class="center" ><div> @lang('layout.Number')</div></td>@endif
      @if($_test)<td  class="center" ><div> @lang('layout.Employee')</div></td>@endif
      @if($_test)<td  class="center" ><div> @lang('layout.Category')</div></td>@endif
      @if(systemConfig()[5] != 0 ) <td  class="center" ><div> @lang('layout.Project')</div></td> @endif
      @if($_test)<td  class="center" ><div> @lang('layout.NetPayable')</div></td>@endif
      @if($_test)<td  class="center" ><div> @lang('layout.Currency')</div></td>@endif
      @if($_test)<td  class="center" ><div> @lang('layout.Rate')</div></td>@endif
      @if($_test)<td  class="center" ><div> @lang('layout.FromDate')</div></td>@endif
      @if($_test)<td  class="center" ><div> @lang('layout.ToDate')</div></td>@endif
      @if($_test)<td  class="center" ><div> @lang('layout.Description')</div></td>@endif
      <td  class="center" ><div> @lang('layout.User')</div></td>


      </tr>
    </thead>
 <?php
 $count = 0;
 ?>
 <tbody>
   
 @foreach($data AS $record)
 
  <tr>

   @if($_test)<td><div class="center"> {{++$count}}</div></td>@endif
   @if($_test)<td><div class="center"> {{$record->id}}</div></td>@endif
   @if($_test)<td><div class="center"> {{$record->member_name}}</div></td>@endif
   @if($_test)<td><div class="center"> {{$record->esc_name}}</div></td>@endif
   @if(systemConfig()[5] != 0 ) <td><div class="center"> {{$record->project_name}}</div></td> @endif
   @if($_test)<td><div class="center"> {{myRound($record->net_payable)}}</div></td>@endif
   @if($_test)<td><div class="center"> {{$record->currency}}</div></td>@endif
   @if($_test)<td><div class="center"> {{$record->rate}}</div></td>@endif
   @if($_test)<td><div class="center"> {{convertDate($record->from_date)}}</div></td>@endif
   @if($_test)<td><div class="center"> {{convertDate($record->to_date)}}</div></td>@endif
   @if($_test)<td><div class="center"> {{$record->description}}</div></td>@endif
   <td><div class="center"> {{$record->user}}</div></td>
 </tr>

  @endforeach   
  
 </tbody>
</table>


 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table>
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection