@extends('layouts.app')

@section('content')
    <!-- END PAGE HEADER-->
    <div id="print-modal">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show"
                      :value-type="'payroll_contract'"
                      @closed="closeModal"> 
            <div slot="body">
                <div class="row">
                    <div class="form-group">
                        <div  class="col-md-12">
                            <label class="control-label ">@lang('layout.SelectType') </label>
                            <select name="category" id="" class="form-control">
                                <option  value="1" selected="selected">@lang('layout.WithDetail')</option>
                                <option  value="2">@lang('layout.WithoutDetail')</option>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="form-group">
                        <div  class="col-md-6">
                            <label class="control-label ">@lang('layout.SelectMember') </label>
                            <v-select class="vue-select2" v-model="selectedMember" label="name"
                                      :options="member">
                            </v-select>
                            <input type="hidden" name="member_id" v-model.number="(!selectedMember)?null:selectedMember.id">
                        </div>
                        <div  class="col-md-6">
                            <label class="control-label ">@lang('layout.SalaryCategory') </label>
                            <v-select class="vue-select2" v-model="selectedemployeeCategory" label="name"
                                      :options="employeeCategory">
                            </v-select>
                            <input type="hidden" name="category_id" v-model.number="(!selectedemployeeCategory)?null:selectedemployeeCategory.id">
                        </div> 
                    </div>
                </div>
                <div class="row">
                    <div class="form-group">
                        <div  class="col-md-12">
                            <label class="control-label ">@lang('layout.EmployeeTask') </label>
                            <v-select class="vue-select2" v-model="selectedCharge" label="name" :options="employeeDetailCharge">
                            </v-select>
                            <input type="hidden" name="charge_id" v-model.number="(!selectedCharge)?null:selectedCharge.id">
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="form-group">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.Date')</label>
                                <div class="input-group">
                                    <input class="form-control date" id="range-from-example" name="from_date" autocomplete="off">

                                    <span class="input-group-addon">@lang('layout.To') </span>
                                    <input class="form-control date" id="range-to-example" name="to_date" autocomplete="off">

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </report-modal>
    </div>

    <div id="print-factor">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show"
                      :value-type="'payroll_contract'"
                      @closed="closeModal">

            <div slot="body">
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-12">
                            <label class="control-label ">@lang('layout.Number')</label>
                            <div class="input-group">
                            <input class="form-control" autocomplete="off" name="from_number">

                            <span class="input-group-addon"> @lang('layout.To') </span>
                            <input class="form-control" autocomplete="off" name="to_number">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </report-modal>
    </div>

    <!-- BEGIN TAB PORTLET-->
    <div class="row">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>&nbsp;
                    <span class="caption-subject bold uppercase">@lang('layout.ContractBasedPayroll')</span>
                </div>
                <div class="tools"> </div>
                <div class="pull-right">
                    @if(systemConfig()[21] == 1)
                    <span id="anchore-modal1">
                        <a href="#" @click.prevent="showModal" id="" class="btn  btn-primary">
                        <i class="fa fa-print"></i>
                        </a>
                    </span>
                    @endif
                    @permission('payroll-export')
                    <span id="anchore-modal">
                         <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                            <i class="fa fa-print"></i>
                         </a>
                     </span>
                    @endpermission
                    @permission('payroll-create')
                    <a href="{{route('payroll.form.create')}}">
                        <button class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                        </button>
                    </a>
                </div>
                @endpermission
            </div>
            <div class="portlet-body">
                <template v-cloak id="company_ll">
                    <company @company="setCompany"></company>
                </template>
                <table class="table table-striped table-bordered "  cellspacing="0" id="payroll">
                    <thead>
                    <tr>
                        <th>#</th>
                        <th>@lang('layout.Number')</th>
                        <th>@lang('layout.Name')</th>
                        @if(systemConfig()[5] != 0 )
                        <th>@lang('layout.Project')</th>
                        @endif
                        <th>@lang('layout.NetPayable')</th>
                        <th>@lang('layout.Currency')</th>
                        <th>@lang('layout.FromDate')</th>
                        <th>@lang('layout.ToDate')</th>
                        <th>@lang('layout.Description')</th>
                        <th>@lang('layout.User')</th>
                        <th>@lang('layout.Actions')</th>
                    </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>
    <!-- END TAB PORTLET-->
    <!-- END CONTENT BODY -->
    <iframe id="payframe" style="display: none;" ></iframe>
@endsection
@include('print.modal')
@include('groupCompanyFilter.select')
@push('scripts')


    <script>

        var employeeCategory = {!! $employeeCategory !!}

        function printFactor(id) {
            var a = document.createElement('a');
            a.href = "{{url('payrollItemCharge/factor')}}/" + id;
            a.target = "_blank";
            document.body.appendChild(a);
            a.click();
            document.body.removeChild(a);
        }

        $(document).ready(function() {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            $('#payroll').DataTable( {
                // 'order': [[ 8, 'desc' ]],
                ajax:           '{{route("payroll.form.index")}}',
                pageLength:'{{getPageRows()}}',
                order: [["{{orderByColumn()=='number'?0:2}}", "{{getRowOrder()}}"]],
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                // scrollY:        450,
                scrollCollapse: true,
                serverSide: true,
                paging:         true,
                columns: [
                    { data: 'id',          name: 'payrolls.id' },
                    { data: 'number',          name: 'payrolls.number' },
                    { data: 'Employee',          name: 'members.name' },
                    @if(systemConfig()[5] != 0 )
                    {data: 'project_name', name: 'project_name', orderabel: false, searchable: false},
                    @endif
                    { data: 'Net_Payable',       name: 'Net_Payable', orderabel:false,searchable:false },
                    { data: 'currency',           name: 'currency' , orderabel:false,searchable:false},
                    { data: 'From_Date',         name: 'From_Date', orderabel:false,searchable:false },
                    { data: 'To_Date',           name: 'To_Date', orderabel:false,searchable:false },
                    { data: 'description',       name: 'description' },
                    { data: 'user',       name: 'users.name' },
                    { data: 'actions',           name: 'actions',orderabel:false,searchable:false},
                ]
            });
        });

        Vue.component("v-select", VueSelect.VueSelect);

        //  for new modal

        var vm =new Vue({
            el: '#print-modal',
            data:{
                is_show:false,
                pdfRoute: '{!!route("payroll.form.report") !!}',
                excelRoute: '{!! route("payroll.form.report") !!}',

                selectedMember:null,
                member:{!!$member!!},

                employeeCategory: employeeCategory,
                selectedemployeeCategory: null,

                selectedCharge:null,
                employeeDetailCharge : {!! $employeeDetailCharge !!},

            },
            methods:{
                closeModal: function(){
                    this.is_show = !this.is_show
                },



            }
        });


        new Vue({
            el:'#anchore-modal',
            methods:{
                showModal:function(){
                    console.log('trr')
                    vm.$data.is_show = true;

                }
            }
        });

        // /for new modal

        
        //  for new modal1

        var vf =new Vue({
            el: '#print-factor',
            data:{
                is_show:false,
                pdfRoute: '{!!route("payroll.form.all.factor") !!}',
                excelRoute: '{!! route("payroll.form.all.factor") !!}',
            },
            methods:{
                closeModal: function(){
                    this.is_show = !this.is_show
                },
            }
        });


        new Vue({
            el:'#anchore-modal1',
            methods:{
                showModal:function(){
                    console.log('trr')
                    vf.$data.is_show = true;

                }
            }
        });

        // /for new modal

        
        var Modal=Vue.component('modal', {
            template: '#modal-template',
            methods: {
                ok: function() {
                    this.$emit('ok')
                }
            }
        })
        // start app

        new Vue({
            el: '#company_ll',
            methods: {
                setCompany: function (event) {
                    window.location.reload();
                }
            }
        });
    </script>
@endpush