@extends('layouts.app')
@section('style')
    <link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">
@stop
@section('content')
    <div class="row">
        @if (count($errors) > 0)
            <div class="m-heading-1 border-red m-bordered errors-action">
                <h4 class="error-title"><strong>Whoops!</strong> There were some problems with your input</h4>
                <ul class="error-body">
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif
        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.CreateNewContractBasedPayroll') </span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools"> 

                </div>
            </div>
            <div class="portlet-body form" id="app" style="margin-bottom: 30%;">
                {{Form::open(['route' => ['payroll.form.update','id'=>$payroll->id],'method' => 'PATCH'])}}
                <div class="form-body">
                    <div id="app" v-cloak>
                        <div class="row">
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="control-label"> @lang('layout.EmployeeName')</label>
                                    <v-select placeholder="@lang('layout.SelectEmployee')" label="name"
                                              @input="setCurrencyRate"
                                              v-model="selectedEmployee"
                                              :options="employee">
                                    </v-select>
                                    <input type="hidden" name="employee"
                                           v-model.number="(!selectedEmployee)?null:selectedEmployee.id"
                                           v-validate="'required'" data-vv-as="@lang('layout.Employee')">
                                    <span class="required">@{{ errors.first('employee') }}</span>
                                </div>
                            </div>

                            <div class="col-md-3" v-if="selectedEmployee">
                                <div class="form-group">
                                    <label for="employee-task">@lang('layout.EmployeeTask')</label>
                                    <input type="text" disabled
                                           :value="getTaskName(selectedEmployee.payroll_price_level_id)"
                                           class="form-control">
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label class="control-label"> @lang('layout.Date')</label>
                                    <div class="input-group">
                                        <input class="form-control date" id="range-from-example" name="from_date"
                                               autocomplete="off" v-validate="'required'"
                                               data-vv-as="@lang('layout.Date')" value="{{$payroll->From_Date}}">
                                        <span class="required">@{{ errors.first('from_date') }}</span>
                                        <span class="input-group-addon"> @lang('layout.To') </span>
                                        <input class="form-control date" id="range-to-example" name="to_date"
                                               autocomplete="off" v-validate="'required'"
                                               data-vv-as="@lang('layout.Date')" value="{{$payroll->To_Date}}">
                                        <span class="required">@{{ errors.first('to_date') }}</span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-2 col-md-2 col-sm-2 col-xs-12">
                                <div class="form-group">
                                    <label class="control-label">@lang('layout.Date')</label>
                                    {{Form::text('date',$payroll->date,['class' => 'form-control date','id'=>'date','autocomplete'=>'off'])}}
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="row">
                                    <div class="col-md-6" v-if="selectedEmployee">
                                        <div class="form-group">
                                            <label class="control-label">@lang('layout.Currency')</label>
                                            <input type="text" name="currency"
                                                   :value="selectedEmployee ? selectedEmployee.currency : null"
                                                   class="form-control" disabled>
                                            <input type="hidden" name="currency"
                                                   :value="selectedEmployee ? selectedEmployee.currency : null">
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="control-label">@lang('layout.PaymentRate') </label>
                                            <div :class="{'has-error':rate < 0}">
                                                <div class="input-group">
                                                    <input v-model="homeCurrency.rate" class="form-control" name="payable_rate"
                                                           type="number" min="0" step="any">
                                                    <span class="input-group-addon">@{{homeCurrency.symbol}}</span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <input type="hidden" name="memeber_name"
                                           :value="selectedEmployee ? selectedEmployee.name: null">
                                    <input type="hidden" name="sal_id"
                                           :value="selectedEmployee ? selectedEmployee.sal_id: null">
                                    {{--@if(getCompanyTag() != 1)
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label class="control-label">@lang('layout.ExchangeRateHQ') </label>
                                                <div :class="{'has-error':selectedCurrency.rate < 0}">
                                                    <div class="input-group">
                                                        <input  class="form-control"
                                                               type="hidden" min="0" step="any" >
                                                        <span class="input-group-addon">@{{homeCurrency.hq_rate}}</span>
                                                    </div>
                                                </div>
                                            </div>
                                            <input type="hidden" name="rate" :value="homeCurrency.hq_rate">
                                        </div>
                                    @endif--}}
                                    <!--input type="hidden" name="payable_rate" :value="rate" -->
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="control-label">@lang('layout.Number')</label>
                                    <input type="number" class="form-control" name="number" value="{{$payroll->number}}" step="any">
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="control-label">@lang('layout.NetPayable')</label>
                                            @if(getContractSalary()=="true")       
                                            <input type="number" class="form-control" name="netPayable"
                                            :value="myRound(getFinalAmountWithSalary().total+overtime)" step="any">
                                            @else
                                            <input type="number" class="form-control" name="netPayable"
                                            :value="myRound(getFinalAmount().total)" step="any">   
                                            @endif
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="control-label">@lang('layout.ExpenseAccount')</label>
                                            <select name="expense_id" class="form-control" required>
                                                <option disabled>@lang('layout.Select')</option>
                                                @foreach($expense as $ex=>$value)
                                                    <option value="{{$value['id']}}" @if($value['id'] == $payroll['expense_id']) selected @endif>{{$value['name']}}</option>
                                                @endforeach

                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            @if(systemConfig()[5] != 0 )
                                <div class="col-md-3"> 
                                    <label class="control-label">@lang('layout.Project')</label>
                                    <v-select class="vue-select2" label="name" @search="ProjectSearch"
                                            :options="project_list" v-model="selectedProject">
                                    </v-select>
                                    <input type="hidden" name="project_id" v-model.number="(!selectedProject)?null:selectedProject.project_id">
                                </div>
                            @endif

                            @if(systemConfig()[21] != 0 )
                                <div class="col-md-3"> 
                                    <label class="control-label">@lang('layout.CarpetContract')</label>
                                    <v-select class="vue-select2" label="name" @search="carContractSearch"
                                            :options="carContract_list" v-model="selectedCarContract">
                                    </v-select>
                                    <input type="hidden" name="carpet_contract_id" v-model.number="(!selectedCarContract)?null:selectedCarContract.id">
                                </div>
                            @endif

                        </div>
                            <div class="row">
                                @if(getContractSalary()=="true")
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label class="control-label">@lang('menu.Overtime')</label>
                                        <input type="number" class="form-control" name="overtime"  v-model.number="overtime" step="any" >
                                    </div>
                                </div>
                                @endif
                                @if(systemConfig()[20] == 1)
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label class="control-label">@lang('layout.ContractName')</label>
                                        <v-select class="vue-select2" placeholder="@lang('layout.Select')"
                                                v-model="selectedContract" label="company_name"
                                                :options="contract">
                                        </v-select>
                                        <input type="hidden" name="contract_id" v-model.number="(!selectedContract)?null:selectedContract.id" />
                                    </div>
                                </div>
                                @endif

                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label class="control-label">@lang('layout.SalaryCategory')</label>
                                        <v-select label="name"
                                          v-model="selectedemployeeCategory" :options="employeeCategory">
                                        </v-select>
                                        <input type="hidden" name="category_id"
                                           v-model.number="(!selectedemployeeCategory)?null:selectedemployeeCategory.id">
                                    </div>
                                </div>

                                <div @if(getContractSalary()=="true") class="col-md-3" @else class="col-md-6" @endif >
                                    <div class="form-group">
                                        <label class="control-label"> @lang('layout.Description')</label>
                                        {!! Form::textarea('description', $payroll->description, array('placeholder' => __('layout.Description'),'class' => 'form-control','rows' => 1, 'cols' => 30)) !!}
                                    </div>
                                </div>
                                    <!--Begin Totals-->
                                @if(getContractSalary()=="true")
                                <div class="col-md-3" v-if="selectedEmployee">
                                    <div class="dashboard-stat2" style="padding: 5px 1px 1px 1px; margin-bottom: 5px;">

                                        <table class="dashboard-tabel table-bordered" width="100%">
                                            <thead>
                                                <tr>
                                                    <th colspan="2">
                                                        <center>@lang('layout.Total')</center>
                                                    </th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <span>
                                                    <tr>
                                                        <td class="highlight">
                                                            @lang('layout.BasicSalary'):
                                                        </td>
                                                        <td class="highlight">
                                                            <center v-show="!show_salary">
                                                                <span class="text-right" data-counter="counterup" data-value="7800">
                                                                    
                                                                    @{{(selectedEmployee) ? format_number(Number(selectedEmployee.salary)) : null}}
                                                                </span>
                                                                <small class="font-green-sharp">
                                                                    @{{(selectedEmployee)? selectedEmployee.currency: null }}
                                                                </small>
                                                               
                                                            </center>
                                                            <center v-show="show_salary">
                                                                <input type="number" class="form-control" name="handy_salary"  step="any" v-model.number="handy_salary">
                                                            </center>
                                                            <span>
                                                                <i class="fa fa-pencil" style="cursor: pointer" @click="show_salary = !show_salary, handy_salary=null"></i>
                                                            </span>
    
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td class="highlight">
                                                            @lang('layout.PerDay'):
                                                        </td>
                                                        <td class="highlight">
                                                            <center>
                                                                <span class="text-right" data-counter="counterup" data-value="7800">
                                                                    @{{(selectedEmployee) ? format_number(Number((handy_salary)?handy_salary/30:selectedEmployee.salary/30)) : null}}
                                                                </span>
                                                                <small class="font-green-sharp">
                                                                    @{{(selectedEmployee)? selectedEmployee.currency: null }}
                                                                </small>
                                                            </center>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td class="highlight">
                                                            @lang('layout.Ratio'):
                                                        </td>
                                                        <td class="highlight">
                                                            <center>
                                                                <span class="text-right" data-counter="counterup" data-value="7800">
                                                                    @{{myRound(getFinalAmountWithSalary().subTotal)}}
                                                                </span>
                                                            </center>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td class="highlight">
                                                            @lang('layout.AccordingToTheAmount'):
                                                        </td>
                                                        <td class="highlight">
                                                            <center>
                                                                <span class="text-right" data-counter="counterup" data-value="7800">
                                                                    @{{myRound(getFinalAmountWithSalary().sum_amount)}}
                                                                </span>
                                                            </center>
                                                        </td>
                                                    </tr> 
                                                    <tr>
                                                        <td class="highlight">
                                                            @lang('menu.Overtime'):
                                                        </td>
                                                        <td class="highlight">
                                                            <center>
                                                                <span class="text-right" data-counter="counterup" data-value="7800">
                                                                    @{{myRound(getFinalAmountWithSalary().overtime)}}
                                                                </span>
                                                            </center>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td class="highlight">
                                                            @lang('layout.NetPayable'):
                                                        </td>
                                                        <td class="highlight">
                                                            <center>
                                                                <span class="text-right" data-counter="counterup" data-value="7800">
                                                                    @{{myRound(getFinalAmountWithSalary().total+overtime)}}
                                                                </span>
                                                            </center>
                                                        </td>
                                                    </tr>
                                                </span>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                                @endif
                                <!--End Totals-->
                            </div>
                            <!-- begin tax -->
                            <div class="row">
                                <div class="col-md-1">
                                    <div class="input-group">
                                        <input type="checkbox" class="form-control" name="tax" @checked($payroll->tax) v-model="tax">
                                        <span class="input-group-addon">@lang('layout.Tax')</span>
                                    </div>
                                    
                                </div>
                                <div class="col-lg-5 col-md-5 col-sm-12 col-xs-12" v-if="tax">
                                    <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <label class="control-label"> @lang('layout.AgencyTax')</label>
                                        <v-select   
                                        placeholder="@lang('layout.SelectEmployee')" 
                                        label="name"
                                        v-model="selectedMember"
                                        :options="members"
                                        @search="onAgencySearch" >       
                                        </v-select>
                                        <input type="hidden" name="tax_member" v-model.number="(!selectedMember)?null:selectedMember.id" >
                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <label class="control-label"> @lang('layout.ExpenseAccount')</label>
                                        <v-select   placeholder="@lang('layout.ExpenseAccount')" label="name"
                                            v-model="selected_tax_expense"
                                            :options="expense">       
                                        </v-select>
                                        <input type="hidden" name="selected_tax_expense" v-model="(!selected_tax_expense)?null:selected_tax_expense.id" >
                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <label class="control-label"> @lang('layout.Percent') % </label>
                                        <input type="number" name="percent" v-model="percent" step="any" class="form-control" >
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- end tax -->

                        {{--employee other charge--}}

                        <div class="row" style="overflow-x: scroll;">
                            <div class="col-md-12 col-lg-12 col-sm-12">
                                <table id="table_content"
                                       class="table table-bordered table-advance">
                                    <thead>
                                    <tr>
                                        
                                        @if(getContractSalary()=="true")
                                        <th @if(getCompanyTag()!= 1) colspan="9" @else colspan="11" @endif >
                                            <center>
                                                @lang('layout.EmployeeOtherCharge')
                                            </center>

                                        </th>
                                        @else
                                        <th @if(getCompanyTag()!= 1) colspan="9" @else colspan="10" @endif >
                                            <center>
                                                @lang('layout.EmployeeOtherCharge')
                                            </center>

                                        </th>
                                        @endif

                                        @if(systemConfig()[21] == 1)
                                        <th colspan="2">
                                        </th>
                                        @endif
                                    </tr>
                                    <tr>
                                        <th>#</th>
                                        <th style="min-width: 130px">@lang('layout.Item')</th>
                                        <th style="min-width: 130px">@lang('layout.EmployeeTask')</th>
                                        <th style="min-width: 100px">@lang('layout.Measure')</th>
                                        <th style="min-width: 100px">@lang('layout.Currency') </th>
                                        <th style="min-width: 130px">@lang('layout.Rate') </th>
                                        @if(getCompanyTag() != 1)
                                            <th style="min-width: 130px">@lang('layout.ExchangeRateHQ') </th>
                                        @endif
                                        <th style="min-width: 130px">@lang('layout.Times') </th>
                                        <th style="min-width: 130px">@lang('layout.Amount') </th>
                                        <th v-show="showWhat('contract_salary')=='yes'" style="min-width: 130px">@lang('layout.AmountOfWork') </th>
                                        <th style="min-width: 130px">@lang('layout.Total') </th>
                                        @if(systemConfig()[21] == 1)
                                        <th style="min-width: 130px">@lang('layout.InventoryPart') </th>
                                        <th style="min-width: 130px">@lang('layout.ItemType') </th>
                                        @endif
                                        <th></th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <tr v-for="(charge,index) in employeeCharge">
                                        <td>@{{index+1}}</td>
                                        <td>
                                            <v-select label="name" @click.native="setAmount(employeeCharge,index)" @keyup.native="setAmount(employeeCharge,index)"
                                                      :options="employeeOtherCharge"
                                                      v-model="charge.itemType"></v-select>
                                            <input type="hidden" name="item_type_id[]" :value="charge.itemType? charge.itemType.id: null">
                                        </td>
                                        <td>
                                            <v-select label="name" @input="setCurrency('emp',index)"
                                                      :options="charge.itemType ? relatedPriceLevel(charge.itemType.id):[]"
                                                      v-model="charge.itemTypePrice"></v-select>

                                            <input type="hidden" name="detail_id[]"
                                                   :value="charge && charge.itemTypePrice ? charge.itemTypePrice.details_id: null">
                                            <input type="hidden" v-if="charge.itemTypePrice"
                                                   name="employee_account_id[]"
                                                   :value="charge.itemTypePrice.account_id">
                                            <input type="hidden" name="type[]" v-if="charge.itemTypePrice"
                                                   :value="charge.itemTypePrice.type">
                                        </td>
                                        <td>
                                            <b v-if="charge.itemTypePrice"> @{{ charge.itemTypePrice.measure }}</b>
                                        </td>
                                        <td>
                                            <v-select label="code" :options="currency"
                                                      v-model="charge.currency"></v-select>
                                            <input type="hidden" name="employee_currency[]"
                                                   :value="charge.currency? charge.currency.code: null">
                                        </td>
                                        <td>
                                            <input type="number" class="form-control" v-if="charge.currency"
                                                   name="employee_rate[]"
                                                   v-model="charge.currency.rate">
                                        </td>
                                        @if(getCompanyTag() != 1)
                                            <td>
                                                <input type="number" class="form-control" v-if="charge.currency"
                                                       name="employee_hq_rate[]"
                                                       v-model="charge.currency.hq_rate">
                                            </td>
                                        @endif
                                        <td>
                                            <input type="number" class="form-control" name="times_add[]"
                                                   v-model="charge.times">
                                        </td>
                                        <td>
                                            <input type="number" class="form-control"
                                                   name="employee_amount[]" v-if="charge.itemTypePrice"
                                                   v-model="charge.itemTypePrice.amount">
                                        </td>
                                        <!--Begin-->
                                        <td v-show="showWhat('contract_salary')=='yes'">
                                            <input type="number" class="form-control" name="amount_of_work[]"
                                                   v-model="(!charge.itemTypePrice)?null:charge.itemTypePrice.amount_of_work"> 
                                        </td>
                                        <!--End-->
                                        <td>
                                            <b v-if="charge.currency && charge.itemTypePrice">
                                                @{{calculateTotal(charge.itemTypePrice.amount,charge.times,charge.currency.rate).total}}
                                            </b>
                                        </td>
                                        @if(systemConfig()[21] == 1)
                                        <td>
                                            <input type="number" class="form-control" v-model="charge.build_quantity" name="build_quantity[]" />
                                        </td>
                                        <td>
                                            <input type="text" class="form-control" v-model="charge.item_types" name="item_type[]" />
                                        </td>
                                        @endif
                                        <td>
                                            <span @click="deleteItem(employeeCharge,index)">
                                                <i class="paddint-both glyphicon glyphicon-trash"></i></span>
                                        </td>
                                    </tr>
                                    <tr style="background-color: #ffffff;">
                                        <td colspan="8">
                                            <center>
                                                <button type="button" @click="addNew(employeeCharge,'emp')"
                                                        class="btn btn-success"><i
                                                            class="fa fa-plus"></i></button>
                                            </center>
                                        </td>
                                    </tr>
                                    </tbody>
                                </table>
                            </div>


                        </div>
                        {{--end of employee other charge--}}

                        {{--company other charge--}}

                        <div class="row" style="overflow-x: scroll;">
                            <div class="col-md-12 col-lg-12 col-sm-12">
                                <table id="table_content"
                                       class="table table-bordered table-advance">
                                    <thead>
                                    <tr>
                                        <th @if(getCompanyTag()!= 1) colspan="8" @else colspan="9"
                                            @endif align="center">
                                            <center>
                                                @lang('layout.CompanyOtherCharge')
                                            </center>

                                        </th>
                                    </tr>
                                    <tr>
                                        <th>#</th>
                                        <th style="min-width: 130px">@lang('layout.PayrollType')</th>
                                        <th style="min-width: 100px">@lang('layout.Measure')</th>
                                        <th style="min-width: 100px">@lang('layout.Currency') </th>
                                        <th style="min-width: 130px">@lang('layout.Rate') </th>

                                        @if(getCompanyTag() != 1)
                                            <th style="min-width: 130px">@lang('layout.ExchangeRateHQ') </th>
                                        @endif
                                        <th style="min-width: 130px">@lang('layout.Times') </th>
                                        <th style="min-width: 130px">@lang('layout.Amount') </th>
                                        <th style="min-width: 130px">@lang('layout.Total') </th>
                                        <th></th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <tr v-for="(charge,index) in companyCharge">
                                        <td>@{{index+1}}</td>
                                        <td>
                                            <v-select label="name" @input="setCurrency('comp',index)"
                                                      :options="companyOtherCharge"
                                                      v-model="charge.itemTypePrice"></v-select>
                                            <input type="hidden" name="company_item_type_id[]" :value="charge.itemTypePrice.item_type_id" v-if="charge.itemTypePrice">
                                            <input type="hidden" name="company_detail_id[]"
                                                   :value="charge && charge.itemTypePrice ? charge.itemTypePrice.details_id: null">
                                            <input type="hidden" name="company_account_id[]"
                                                   :value="charge.itemTypePrice?charge.itemTypePrice.account_id: null">
                                        </td>
                                        <td>
                                            <b v-if="charge.itemTypePrice"> @{{ charge.itemTypePrice.measure }}</b>
                                        </td>
                                        <td>
                                            <v-select label="code" :options="currency"
                                                      v-model="charge.currency"></v-select>
                                            <input type="hidden" name="company_currency[]"
                                                   :value="charge.currency? charge.currency.code: null">
                                        </td>
                                        <td>
                                            <input type="number" class="form-control" v-if="charge.currency"
                                                   name="company_rate[]"
                                                   v-model="charge.currency.rate">

                                            <input type="hidden" class="form-control" v-if="charge.currency"
                                                   name="company_hq_rate[]"
                                                   v-model="charge.currency.hq_rate">
                                        </td>
                                        @if(getCompanyTag() != 1)
                                            <td>
                                                <input type="number" class="form-control" v-if="charge.currency"
                                                       name="employee_hq_rate[]"
                                                       v-model="charge.currency.hq_rate">
                                            </td>
                                        @endif

                                        <td>
                                            <input type="number" class="form-control" v-model="charge.times"
                                                   name="times_sub[]">
                                        </td>
                                        <td>
                                            <input type="number" class="form-control"
                                                   name="company_amount[]" v-if="charge.itemTypePrice"
                                                   v-model="charge.itemTypePrice.amount">
                                        </td>
                                        <td>
                                            <b v-if="charge.currency && charge.itemTypePrice">
                                                @{{calculateTotal(charge.itemTypePrice.amount,charge.times,charge.currency.rate).total
                                                }}
                                            </b>
                                        </td>
                                        <td>
                                            <span @click="deleteItem(companyCharge,index)">
                                                <i class="paddint-both glyphicon glyphicon-trash"></i></span>
                                        </td>
                                    </tr>
                                    <tr style="background-color: #ffffff;">
                                        <td colspan="8">
                                            <center>
                                                <button type="button" @click="addNew(companyCharge)"
                                                        class="btn btn-success"><i
                                                            class="fa fa-plus"></i></button>
                                            </center>
                                        </td>
                                    </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>

                        {{--end of company other charge--}}
                    </div>
                    <!--/row-->
                </div>
                <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                    <button type="button" @click="handleSubmit($event)"
                            class="btn green">@lang('layout.Submit')</button>

                    <a href="{{route('payroll.form.index')}}" class="btn default"><i
                                class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                </div>
                {{Form::close()}}
            </div>
            <!-- END FORM-->
        </div>
    </div>
@endsection
@push('scripts')

    <script>
        @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
        Vue.use(VeeValidate, {
            locale: 'en',
        });
        @endif

        Vue.component("v-select", VueSelect.VueSelect);

        let Currency = {!! $currency !!};
        let employee = {!! $employee !!};
        let employeeDetailCharge = {!! $employeeDetailCharge !!};
        let homeCurrency = {!! json_encode(getHomeCurrency())!!};
        let rates = {!! $rates !!};
        let payroll = {!! json_encode($payroll) !!};
        let details = {!! json_encode($details) !!};
        let itemType = {!! $itemType !!};
        var contract        = {!! $contract!!}
        let expense = {!! json_encode($expense) !!};
        let employeeCategory = {!! $employeeCategory !!};

        let app = new Vue({
            el: '#app',
            data: {
                contract: contract,
                selectedContract: null,
                itemType: itemType,
                employeeDetailCharge: null,
                employeeCharge: [],
                companyCharge: [],
                homeCurrency: homeCurrency,
                rate:1,
                currency: Currency,
                employees: employee,
                employeeCategory: employeeCategory,
                selectedemployeeCategory: null,
                workdays: null,
                salary: null,
                selectedBank: null,
                selectedEmployee: null,
                paidLeave: null,
                expense: expense,
                tax: false,
                members:[],
                selectedMember:{!! $selectedMember !!},
                selected_tax_expense: null,
                pay: false,
                type: null,
                amount: 0,
                salaryAmount: 0,
                fee: null,
                basicSalary: 0,
                from: null,
                to: null,
                advancePaid: 0,
                project_list: [],
                selectedProject:{!!$project!!},
                selectedCarContract: {!! $selected_CarP_contract !!},
                carContract_list: [],
                overtime:payroll.salary_contract_overtime,
                handy_salary: payroll.handy_salary,
                show_salary: (payroll.handy_salary!=null)?true:false
            },
            mounted(){
                console.log('thiss' , this.getFinalAmount());
                if (payroll.category_id) {
                    this.selectedemployeeCategory = _.find(employeeCategory, (s) => s.id == payroll.category_id);
                }
            },
            computed: {
                employeeOtherCharge() {
                    return this.itemType.filter((a) => {
                        return (a.type == 'Simple' || a.type == 'EmployeeOtherCharge');
                    })
                },
                companyOtherCharge() {
                    return this.employeeDetailCharge.filter((a) => {
                        return a.type == 'CompanyOtherCharge';
                    })
                },
            },
            created() {
                this.setRates();
                this.employeeDetailCharge = _.clone(employeeDetailCharge);
                this.initializer();
                @if($payroll->contract_id != null)    
                    this.selectedContract = _.find(this.contract, (e) => e.id == {{$payroll->contract_id}});
                @endif

                @if($payroll->tax_expense_id != null)    
                    this.selected_tax_expense = _.find(this.expense, (e) => e.id == {{$payroll->tax_expense_id}});
                @endif
                @if($payroll->tax != null)    
                    this.tax = true;
                @endif
                @if($payroll->percent != null)    
                    this.percent = {{$payroll->percent}};
                @endif
            },
            methods: {
                nullSetter() {
                    return {
                        currency: null,
                        itemTypePrice: null,
                        times: 1,
                        itemType:null,
                    }
                },
                initializer() {
                    employee.forEach((emp)=>{
                        if(payroll.member_id == emp.id){
                            this.selectedEmployee = emp;
                        }
                    });
                    details.forEach((detail) => {
                        this.rate = detail.rate;
                        let currency = null;
                        let itemTypePrice = null;
                        let times = null;
                        let build_quantity = null;
                        let item_types = null;
                        let type = null;
                        employeeDetailCharge.forEach((charge) => {
                            if (detail.price_detail_id == charge.details_id) {
                                type = charge.type;
                                itemTypePrice = {
                                    details_id: detail.price_detail_id,
                                    account_id: charge.account_id,
                                    amount: detail.amount,
                                    name: charge.name,
                                    type: charge.type,
                                    currency_name: this.getCurrency(detail.currency).name,
                                    code: detail.currency,
                                    symbol: this.getCurrency(detail.currency).symbol,
                                    currency_id: this.getCurrency(detail.currency).id,
                                    measure: charge.measure,
                                    item_type_id: detail.item_type_id,
                                    amount_of_work:detail.amount_of_work
                                };

                                times = detail.times;
                                build_quantity = detail.build_quantity;
                                item_types = detail.item_type;
                                this.currency.forEach((cur) => {
                                    if (detail.currency == cur.code) {
                                        currency = cur;
                                        currency.rate = detail.rate;
                                    }
                                });
                            }

                        });
                        if(type== 'Simple' || type== 'EmployeeOtherCharge'){
                            
                            let item_type = null;
                            itemType.forEach((type)=>{
                                if (detail.item_type_id == type.id)
                                    item_type =  type;
                            });
                            this.employeeCharge.push({
                                currency:currency,
                                itemTypePrice: itemTypePrice,
                                times: times,
                                build_quantity: build_quantity,
                                item_types: item_types,
                                itemType:item_type
                            })
                        }

                        if(type == 'CompanyOtherCharge'){
                            this.companyCharge.push({
                                currency:currency,
                                itemTypePrice: itemTypePrice,
                                times: times,
                            })
                        }
                    });
                    
                    // console.log(12, this.employeeCharge);

                    if(this.companyCharge.length < 1){
                        this.companyCharge = [this.nullSetter()];
                    }
                    if(this.employeeCharge.length < 1){
                        this.employeeCharge = [this.nullSetter()]
                    }
                },

                onAgencySearch(search, loading) {
                    loading(true);
                    var vm = this;
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'member',
                            type: '',
                            search: search,
                        }
                    })
                    .then(function (response) {
                        this.members = [];
                        if (response.data.length > 0) {
                            vm.members = response.data;
                        }
                        loading(false);
                    })
                    .catch(function (error) {
                        console.log(error);
                    })
                },

                getCurrency(code) {
                    let currency = {};
                    this.currency.forEach((cur) => {
                        if (cur.code == code) {
                            currency = cur;
                        }
                    });

                    return currency;
                },

                setRates() {
                    let copied = _.clone(Currency);
                    Currency = [];
                    copied.forEach((b) => {
                        rates.forEach((a) => {
                            if (a.currency_id == b.id) {
                                Currency.push({
                                    name: a.name,
                                    code: a.code,
                                    symbol: a.symbol,
                                    static_rate: a.static_rate,
                                    rate: a.rate != null ? Number.parseFloat(a.rate) : 1,
                                    exchange_rate: a.rate != null ? Number.parseFloat(a.rate) : 1,
                                    hq_rate: a.hq_rate != null ? Number.parseFloat(a.hq_rate) : 1,
                                    currency: b.id,
                                    id: b.id
                                });
                            }
                        })
                    });

                    copied.forEach((b) => {
                        let found = false;
                        Currency.forEach((a) => {
                            if (a.code == b.code) {
                                found = true;
                                return;
                            }
                        });

                        if (!found) {

                            Currency.push({
                                name: b.name,
                                code: b.code,
                                symbol: b.symbol,
                                static_rate: b.static_rate,
                                rate: 1,
                                exchange_rate: 1,
                                hq_rate: 1,
                                currency: b.id,
                                id: b.id
                            });
                        }
                    });

                    this.currency = Currency;


                },
                deleteItem(charge, index) {
                    charge.splice(index, 1)
                },
                calculateTotal(amount, times, rate, hq_rate) {
                    let total = amount * times ;
                    let hq_total = amount * times;

                    return {total: total, hq_total: hq_total};
                },
                addNew(charge,type = null) {
                    charge.push(this.nullSetter());
                    if (type == 'emp'){
                        let priceLevel = null;
                        employeeDetailCharge.forEach((level)=>{
                            if(this.selectedEmployee.payroll_price_level_id == level.id){
                                priceLevel = {
                                    details_id:level.details_id,
                                    amount:0,
                                    account_id:level.account_id,
                                    name:level.name,
                                    id:level.id,
                                    type:level.type,
                                    currency_name:level.currency_name,
                                    currency_id:level.currency_id,
                                    code:level.code,
                                    symbol:level.symbol,
                                    measure:level.measure,
                                    item_type_id:level,
                                    amount_of_work:level.amount_of_work
                                };
                                return;
                            }
                        });
                        priceLevel.amount = 0;
                        charge[charge.length -1].itemTypePrice = priceLevel;
                        this.setCurrency('emp',charge.length-1)
                    }
                },
                getFinalAmount() {
                    let sum, hq_sum;
                    let sub, hq_sub = 0; 
                    sum = hq_sum = 0;
                    sub = hq_sub = 0;
                    let rateT = 1;

                    if (this.selectedEmployee) {
                        rateT = this.getCurrencyRate(this.selectedEmployee.currency);
                    }
                    this.employeeCharge.forEach((charge) => {
                    if (charge.currency && charge.itemTypePrice) { 
                        @if(systemConfig()[30] == 1)
                        sum += Number.parseFloat(((Number.parseFloat(charge.itemTypePrice.amount) * Number.parseFloat(charge.times) / Number.parseFloat(charge.currency.static_rate) * Number.parseFloat(charge.currency.rate) ) * Number.parseFloat(rateT.static_rate)) / Number.parseFloat(rateT.rate));                        
                        @else 
                        sum += Number.parseFloat((Number.parseFloat(charge.itemTypePrice.amount) * Number.parseFloat(charge.times) / Number.parseFloat(charge.currency.rate))* Number.parseFloat(rateT.rate));
                        @endif
 
                        @if(systemConfig()[30] == 1)
                        hq_sum += (((charge.itemTypePrice.amount * charge.times / rateT.static_rate * rateT.rate) * charge.currency.hq_rate) / charge.currency.static_rate);
                        @else 
                        hq_sum += ((charge.itemTypePrice.amount * charge.times / charge.currency.hq_rate)* rateT.rate);
                        @endif  

                        }
                    }); 
                    this.companyCharge.forEach((charge) => {
                        if (charge.currency && charge.itemTypePrice) {                            
                            @if(systemConfig()[30] == 1)
                            sum += Number.parseFloat(((Number.parseFloat(charge.itemTypePrice.amount) * Number.parseFloat(charge.times) / Number.parseFloat(charge.currency.static_rate) * Number.parseFloat(charge.currency.rate) ) * Number.parseFloat(rateT.static_rate)) / Number.parseFloat(rateT.rate));
                            hq_sum += (((charge.itemTypePrice.amount * charge.times / rateT.static_rate * rateT.rate) * charge.currency.hq_rate) / charge.currency.static_rate);
                            @else 
                            sub += ((charge.itemTypePrice.amount * charge.times / charge.currency.rate)* rateT.rate);
                            hq_sub += ((charge.itemTypePrice.amount * charge.times / charge.currency.hq_rate)* rateT.rate); 
                            @endif 
                        }

                    }); 
                    return { 
                        total: (sum - sub),
                        hq_total: (hq_sum - sub)
                    } 
                },       
                getFinalAmountWithSalary() {
                    let sum, hq_sum;
                    let sub, hq_sub = 0;

                    sum = hq_sum = 0;
                    sub = hq_sub = 0;
                    let rateT = 1;

                    let salary =0;
                    let day_fee =0;

                    let overtime = 0; 
                    let sum_amount = 0;
                    let hq_sum_amount = 0;
 
                    if (this.selectedEmployee) {
                        rateT = this.getCurrencyRate(this.selectedEmployee.currency);
                        salary = this.selectedEmployee.salary;
                        day_fee = (this.handy_salary)?this.handy_salary/30:salary/30;
                        overtime = this.overtime;
                    }
                    // console.log('ddddd',this.employeeCharge)
                    this.employeeCharge.forEach((charge) => {
                        if (charge.currency && charge.itemTypePrice && charge.itemTypePrice.amount_of_work>0) { 
                            @if(systemConfig()[30] == 1)
                            sum += Number.parseFloat(((Number.parseFloat(charge.itemTypePrice.amount) * Number.parseFloat(charge.times) / Number.parseFloat(charge.currency.static_rate) * Number.parseFloat(charge.currency.rate) ) * Number.parseFloat(rateT.static_rate)) / Number.parseFloat(rateT.rate));
                            hq_sum += (((charge.itemTypePrice.amount * charge.times / rateT.static_rate * rateT.rate) * charge.currency.hq_rate) / charge.currency.static_rate);
                            @else 
                            sum += (((charge.times/charge.itemTypePrice.amount_of_work) / charge.currency.rate)* rateT.rate);
                            hq_sum += (((charge.times/charge.itemTypePrice.amount_of_work) / charge.currency.hq_rate)* rateT.rate);
                            @endif 
                        }
                        if (charge.currency && charge.itemTypePrice && charge.itemTypePrice.amount>0 &&  charge.itemTypePrice.amount_of_work == null) {  
                            @if(systemConfig()[30] == 1)
                            sum += Number.parseFloat(((Number.parseFloat(charge.itemTypePrice.amount) * Number.parseFloat(charge.times) / Number.parseFloat(charge.currency.static_rate) * Number.parseFloat(charge.currency.rate) ) * Number.parseFloat(rateT.static_rate)) / Number.parseFloat(rateT.rate));
                            hq_sum += (((charge.itemTypePrice.amount * charge.times / rateT.static_rate * rateT.rate) * charge.currency.hq_rate) / charge.currency.static_rate);    
                            @else 
                            sum_amount += (((charge.times*charge.itemTypePrice.amount) / charge.currency.rate)* rateT.rate);
                            hq_sum_amount += (((charge.times*charge.itemTypePrice.amount) / charge.currency.hq_rate)* rateT.rate);
                            @endif
                        }

                    });

                    return {
                        total: ((sum)*day_fee) + sum_amount,
                        hq_total: (hq_sum)*day_fee,
                        subTotal:(sum),
                        overtime:overtime,
                        sum_amount:(sum_amount)
                    }

                },
                
                setCurrency(type, index) {

                    switch (type) {
                        case 'emp':
                            this.currency.forEach((a) => {
                                if (a.code == this.employeeCharge[index].itemTypePrice.code) {
                                    if (this.selectedEmployee && this.selectedEmployee.currency== a.code)
                                    {
                                        // console.log('a',a);
                                        // console.log('homeCurrency',this.homeCurrency);
                                        // // rate = 1;
                                        // this.homeCurrency.rate = rate;
                                    }
                                    this.employeeCharge[index].currency = {
                                        id: a.id,
                                        name: a.name,
                                        rate: a.rate,
                                        static_rate: a.static_rate,
                                        hq_rate:a.hq_rate,
                                        symbol: a.symbol,
                                        code: a.code,

                                    };
                                }
                            });
                            break;

                        case 'comp':
                            this.currency.forEach((a) => {
                                if (this.selectedEmployee && this.selectedEmployee.currency== a.code)
                                {
                                    // rate = 1;
                                        // console.log('homeCurrency',this.homeCurrency);
                                    this.homeCurrency.rate = this.rate;
                                }
                                if (a.code == this.companyCharge[index].itemTypePrice.code) {
                                    this.companyCharge[index].currency = {
                                        id: a.id,
                                        name: a.name,
                                        rate: a.rate,
                                        static_rate: a.static_rate,
                                        hq_rate:a.hq_rate,
                                        symbol: a.symbol,
                                        code: a.code,

                                    };
                                }
                            });
                    }

                },

                getCurrencyRate(code) {
                    let rate = 1;
                    let hq_rate = 1;
                    Currency.forEach((a) => {
                        if (a.code == code) {
                            rate = a.rate;
                            hq_rate = a.hq_rate;
                            static_rate = a.static_rate;
                            return;
                        }
                    });

                    return {
                        rate: rate,
                        hq_rate: hq_rate,
                        static_rate: static_rate
                    }
                },
                setCurrencyRate(){
                    this.currency.forEach((cur)=>{
                        if(this.selectedEmployee.currency == cur.code){
                            this.homeCurrency = {
                                id:cur.id,
                                name:cur.name,
                                code:cur.code,
                                symbol:cur.symbol,
                                rate:cur.rate,
                                static_rate:cur.static_rate,
                                hq_rate:cur.hq_rate
                            }
                        }
                    })
                },
                                // Search Project
				ProjectSearch:_.debounce((search,loading)=>{
                    app.project_list=[];
				   loading(true);
				   axios.get("{{route('callMethod.search')}}",{
					params:{
					  method_name:'serarchProject',
					  keyword:search,
					}
				   })
				   .then(function (response)
				   {
					 this.project_list=[];
					 if(response.data.length>0)
					 {
						app.project_list=response.data;
						console.log('test 22',app.project_list);
					 }
					 loading(false);
				   })
				   .catch(function (error)
				   {
					  console.log(error);
				   });
				},getDebounceTime()),

                carContractSearch:_.debounce((search,loading)=>{
				   loading(true);
				   axios.get("{{route('callMethod.search')}}",{
					params:{
					  method_name:'serarchCarpetContract',
					  keyword:search,
					}
				   })
				   .then(function (response)
				   {
					 app.carContract_list=[];
					 if(response.data.length>0)
					 {
						app.carContract_list=response.data;
						// console.log('test 22',app.carContract_list);
					 }
					 loading(false);
				   })
				   .catch(function (error)
				   {
					  console.log(error);
				   });
                },getDebounceTime()),

                handleSubmit(e) {
                    this.$validator.validate().then(valid => {
                        if (valid) {
                            // alert(e.target);
                            regForm(e.target);
                        }
                    });
                },
                relatedPriceLevel(id) {
                    return this.employeeDetailCharge.filter((a) => {
                        return (a.item_type_id == id)
                    });
                },
                getTaskName(id) {
                    let name = '-';
                    this.employeeDetailCharge.forEach((a)=>{
                        if(id == a.id){
                            name = a.name;
                        }
                    });
                    return name;
                },
                setAmount(charge,index){
                    let amount = 0;
                    employeeDetailCharge.forEach((a)=>{
                        if (charge[index].itemType.id == a.item_type_id){
                            charge[index].itemTypePrice.amount = a.amount;
                            return
                        }
                    })
                }
            }
        });
    </script>
@endpush