@extends('layouts.app')
<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/1.10.15/css/dataTables.bootstrap.min.css">
@section('content')
<!-- BEGIN CONTENT -->
<!-- BEGIN PAGE BAR -->
<div class="page-bar">
    <ul class="page-breadcrumb">
        <li>
            <a href="index.html">Home</a>
            <i class="fa fa-circle"></i>
        </li>
        <li>
            <a href="#">Tables</a>
            <i class="fa fa-circle"></i>
        </li>
        <li>
            <span>Datatables</span>
        </li>
    </ul>
    <div class="page-toolbar">
        <div class="btn-group pull-right">
            @permission('payment-create')
                <a href="{{route('payment.create')}}">
                    <button id="sample_editable_1_new" class="btn green btn-sm btn-outline">
                        <i class="fa fa-plus"></i> Add New
                    </button></a>
            @endpermission    
        </div>
    </div>
</div>
<!-- END PAGE BAR -->

<!-- END PAGE HEADER-->
@if (Session('message'))
    <div class="m-heading-1 border-green m-bordered">
        <h3>DataTables Responsive Extension Demo</h3>
        <p> Responsive is an extension for DataTables that resolves that problem by optimising the table's layout for different screen sizes through the dynamic insertion and removal of columns from the table. </p>
        <p >{{ Session('message') }}</p>
    </div>
    {{--<div class="alert alert-success ">--}}
        {{--<ul>--}}
            {{--<li >{{ Session('message') }}</li>--}}
        {{--</ul>--}}
    {{--</div>--}}
@endif
@if (count($errors) > 0)

    <div class="m-heading-1 border-green m-bordered">
        <h3>DataTables Responsive Extension Demo</h3>
        <p> Responsive is an extension for DataTables that resolves that problem by optimising the table's layout for different screen sizes through the dynamic insertion and removal of columns from the table. </p>

    {{--</div>--}}
    {{--<div class="alert alert-danger">--}}
        {{--<ul>--}}
            @foreach ($errors->all() as $error)
                <p>{{ $error }}</p>
            @endforeach
        {{--</ul>--}}
    </div>

@endif
<!-- BEGIN TAB PORTLET-->
<div class="row">
    <div class="portlet light bordered">
        <div class="portlet-body">
            <div class="tabbable tabbable-tabdrop">
                <div class="tab-content">
                    <table id="invoice-table" class="table table-striped table-bordered " cellspacing="0" width="100%">
                        <thead>
                        <tr>
                            <th>@lang('layout.Vendor')</th>
                            <th>@lang('layout.Amount')</th>
                        </tr>
                        </thead>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- END TAB PORTLET-->

<!-- END CONTENT BODY -->


@stop

@push('scripts')


<script sec=//code.jquery.com/jquery-1.12.4.js"></script>
<script sec=//maxcdn.bootstrapcdn.com/bootstrap/3.3.7/js/bootstrap.min.js"></script>
<script sec="https://cdn.datatables.net/1.10.15/js/jquery.dataTables.min.js"></script>
<script sec="https://cdn.datatables.net/1.10.15/js/dataTables.bootstrap.min.js"></script>
<script>

</script>
<script>

    $(document).ready(function() {


        $('#invoice-table').DataTable( {
            ajax:           '{{route("invoice.index")}}',
            pageLength:'{{getPageRows()}}',
//            scrollY:        400,
            scrollCollapse: true,
            paging:         false,
            columns: [
            { data: 'name', name: 'number' },
            { data: 'amount', name: 'rate' },


            ]


    } );
    } );
</script>


@endpush
