@extends('layouts.factor-master')
@section('content')
<h4 class="bold uppercase" style="text-align: center; font-size: 20px;">@lang('layout.SalaryPaymentVouchar')(SV)</h4>
<table style="width: 100%; margin-bottom: 10px;">

  <tr class="myclass">
    <td>
      <span style="text-align: right; width:20%; font-size: 14px">@lang('layout.PaymentNumber'): </span>
      <span style="text-align: right; width:30%; font-size: 14px">{{$payments->payment_number}}</span>
    </td>
    <td>

      <span style="text-align: right; width:20%; font-size: 14px">@lang('layout.Date'): </span>
      <BDO DIR="LTR"> <span
          style="text-align: right; width:30%; font-size: 14px">{{convertDate($payments->Date)}}</span></BDO>
    </td>

    <td>
      <span style="text-align: right; width:20%; font-size: 14px">@lang('layout.ReceivedBy'):</span>
      <span style="text-align: right; width:30%; font-size: 14px">{{$payments->member}}</span>
    </td>
    <td>
      <span style="text-align: right; width:20%; font-size: 14px">@lang('layout.Code'):</span>
      <span style="text-align: right; width:30%; font-size: 14px">{{$payments->code}}</span>
    </td>
  </tr>
</table>

<?php
if(count($itemTypePayroll)>0){
?>
<table style="width: 100%; margin-bottom: 10px;" class=" main-table">
  <thead>
    <tr class="">
      <th class=""> @lang('layout.ItemType') </th>
      <th class=""> @lang('layout.Measure')</th>
      <th class=""> @lang('layout.Currency')</th>
      <th class=""> @lang('layout.Total') </th>
    </tr>
  </thead>
  <tbody>
    @foreach($itemTypePayroll as $value )
    <tr style="text-align: center;">
      <td class="">
        {{$value->item_type_payroll}}
      </td>
      <td class="">
        {{$value->measure}}
      </td>
      <td class="">
        {{$value->currency}}
      </td>
      <td class="">
        {{simpleRound($value->amount)}}
      </td>
    </tr>
    @endforeach
  </tbody>
</table>
<?php
}
 ?>


<table style="width: 100%; margin-bottom: 10px;" class=" main-table">
  <thead>
    <tr class="">
      <th class=""> @lang('layout.Currency') </th>
      <th class=""> @lang('layout.Receivable')</th>
      <th class=""> @lang('layout.Payable') </th>
    </tr>
  </thead>
  <tbody>
    @foreach(getStatement($payments->member_id) as $value )
    <tr style="text-align: center;">
      <td class="">
        {{$value['currency']}}
      </td>
      <td class="">
        {{$value['invoice']}}
      </td>
      <td class="">
        {{simpleRound($value['payment'])}}
      </td>
    </tr>
    @endforeach
  </tbody>
</table>



<table style="width: 100%; margin-bottom: 10px;">

  <tr>
    <td>
      <span style="font-size: 14px;">@lang('layout.Amount'):</span>
      <span style="font-size: 14px;">{{simpleRound($payments->Amount)}} {{$payments->currency}}</span>
    </td>
    <td>
      <span style="font-size: 14px;">@lang('layout.Receiver'):</span>
      <span style="font-size: 14px;">{{$payments->member}}</span>
    </td>
    <td>
      <span style="font-size: 14px;">@lang('layout.Accountant'):</span>
      <span style="font-size: 14px;">{{$user}}</span>
    </td>
    <td>
      <span style="font-size: 14px;">@lang('layout.Description'):</span>
      <span style="font-size: 14px;">{{$payments->description}}</span>
    </td>
  </tr>
</table>


<table style="width: 100%; margin-bottom: 10px;" class=" main-table">
  <thead>
    <tr class="">
      <th class=""> @lang('layout.Prepared')</th>
      <th class=""> @lang('layout.Checker') </th>
      <th class=""> @lang('layout.Aprover')</th>
      <th class=""> @lang('layout.ReceiverSignature')</th>
      <th colspan="3" class="">
        @lang('layout.MainSalary')
        <span></span>
        {{$payments->amount}} {{$payments->s_currency}}
      </th>
    </tr>
  </thead>
  <tbody style="text-align: center;">
    <tr>
      <td rowspan="4" class=""></td>
      <td rowspan="4" class=""></td>
      <td rowspan="4" class=""></td>
      <td rowspan="4" class=""></td>
      <td class="">@lang('layout.Receive')</td>
      <td class=""> {{simpleRound($payments->Amount)}} {{$payments->unit}}</td>
      <td rowspan="4" class=""></td>
    </tr>
    <tr>
      <td>@lang('layout.Name')</td>
      <td>{{$payments->member}}</td>
    </tr>
    <tr class="">
      <td colspan="2">@lang('layout.Signature')</td>
    </tr>

    <tr class="">
      <td colspan="2"></td>
    </tr>
  </tbody>
</table>
@if(company()['pay_salary_message'])
<table width="100%">
  <tr>
    <td style="font-size: 14px;">{!!company()['pay_salary_message']!!}</td>
  </tr>

  <tr>
    <td></td>
    <td></td>
  </tr>


</table>
@endif


@endsection