@extends('layouts.factor-master')

@section('content')
<?php
$report = customeReport('pay_salary');
$_type=in_array('type', $report);
$_date=in_array('date', $report);
$_description=in_array('description', $report);
$_name=in_array('name', $report);
$_amount=in_array('amount', $report);
$_exchanged_amount=in_array('exchanged_amount', $report);
$_currency=in_array('currency', $report);
$_rate=in_array('rate', $report);
$_account=in_array('account', $report);
?>
<h3 class="table-caption" style="text-align: center;">@lang('layout.PaySalaryReport')</h3>
<table class="main-table">
  <tr>
    @if($from_date)
   <td>
    <span>@lang('layout.FromDate')</span>:
    <BDO DIR="LTR">    @if(\Setting::get('jalali_and_gerogarian_date') == 'true')  {{convertDate($from_date, null, null, ((\Setting::get('date_type') == 'jalali')?'gregorian':'jalali'))}}  <span dir="rtl"> &nbsp;&nbsp;&nbsp;  @lang('layout.MarchingAt')  </span>  @endif      {{convertDate($from_date)}}</BDO>
  </td>
  @endif
  @if($to_date)
  <td>
    <span>@lang('layout.ToDate')</span>:
    <BDO DIR="LTR">    @if(\Setting::get('jalali_and_gerogarian_date') == 'true')  {{convertDate($to_date, null, null, ((\Setting::get('date_type') == 'jalali')?'gregorian':'jalali'))}}  <span dir="rtl"> &nbsp;&nbsp;&nbsp;  @lang('layout.MarchingAt')  </span>  @endif      {{convertDate($to_date)}}</BDO>
  </td>
  @endif
</tr>
</table>


@if($member_class_name || $member_name)
<table class="main-table" style="margin: 6px 0px;" >
  <tr>
      @if($member_class_name)
      <td>
        <span>@lang('layout.Class')</span>: {{$member_class_name}}
      </td>
      @endif

      @if($member_name)
      <td>
        <span>@lang('layout.Name')</span>: {{$member_name}}
      </td>
      @endif
    </tr>
</table>
@endif
<br>
<table class="main-table">

  <thead>
    <tr class="bg">
    <td class="center" ><div > @lang('layout.Record')</div></td>
    <td class="center" ><div >@lang('layout.Number')</div></td>
    @if($_type)<td class="center" ><div > @lang('layout.Type')</div></td>@endif
    @if($_date)<td class="center" ><div > @lang('layout.Date')</div></td>@endif
    @if($_description)<td class="center" ><div > @lang('layout.Description')</div></td>@endif
    @if(!$member_name)
    @if($_name)<td class="center" ><div > @lang('layout.Name') </div></td>@endif
    @endif
    @if(!$member_class_name)
    @if($_name)<td class="center" ><div > @lang('layout.Class') </div></td>@endif
    @endif
    @if($_amount)<td class="center" ><div > @lang('layout.Amount')</div></td>@endif
    @if($_exchanged_amount)<td class="center" ><div > @lang('layout.ExchangedAmount')</div></td>@endif
    @if($_currency)<td class="center" ><div > @lang('layout.Currency')</div></td>@endif
    @if($_rate)<td class="center" ><div > @lang('layout.Rate')</div></td>@endif
    @if($_account)<td class="center" ><div > @lang('layout.Account')</div></td>@endif
    <td class="center" ><div > @lang('layout.User')</div></td>
  </tr>
  </thead>
  <?php
  $count = 0;
  $total_home_currency=0;
  $currencies=[];
  ?>
  @foreach($data AS $record)
  <tr>
   <?php
   $total_home_currency+=$record->exchanged_amount;
   if(array_key_exists($record->currency, $currencies))
   {
    $currencies[$record->currency]=$currencies[$record->currency]+$record->Amount;
  }
  else
  {

    $currencies[$record->currency]=$record->Amount;
  }
  ?>
  <td class="center">{{++$count}}</td>
  <td class="center">{{$record->number}}</td>
  @if($_type)<td  class="center">{{$record->Payment_type}}</td> @endif
  @if($_date)<td  class="center">{{convertDate($record->Date)}}</td>@endif
   @if($_description)<td   class="center">{{$record->Description}}</td>@endif
   @if(!$member_name)
  @if($_name)<td  class="center">{{$record->Name}}</td>@endif
  @endif
  @if(!$member_class_name)
  @if($_name)<td  class="center">{{$record->member_class}}</td>@endif
  @endif
  @if($_amount)<td  class="center">{{Currency()->format($record->Amount,$record->currency)}}</td>@endif
  @if(systemConfig()[30] == 1)
  @if($_exchanged_amount)<td  class="center">{{Currency()->format(($record->Amount)/ $record->static_rate * $record->Rate,getReportCurrency())}}</td>@endif
  @else 
  @if($_exchanged_amount)<td  class="center">{{Currency()->format(($record->Amount)/$record->Rate,getReportCurrency())}}</td>@endif
  @endif
  @if($_currency)<td  class="center">{{$record->currency}}</td>@endif
  @if($_rate)<td class="center">{{$record->Rate}}</td>@endif
  @if($_account)<td  class="center">{{$record->Account}}</td>@endif
  <td  class="center">{{$record->user}}</td>
 
</tr>
@endforeach
</table>
<table class="main-table">
 <tr class="bg">
  <td colspan="3"><div class="center">@lang('layout.PerCurrency')</div></td>
</tr>
<tr>
  <td><div class="center"> #</div></td>
  <td><div class="center"> @lang('layout.Currency') </div></td>
  <td><div class="center"> @lang('layout.Amount') </div></td>
</tr>
<?php
$count=0;
foreach($currencies As $key=>$currency)
{
  ?>
  <tr>
    <td><div class="center">{{++$count}}</div></td>
    <td><div class="center">{{$key}}</div></td>
    <td><div class="center">{{round($currency,2)}}</div></td>

  </tr>
  <?php
}
?>
<tr>
 <td colspan="2"><div class="center">@lang('layout.HomeCurrencyTotal')</div></td>
 <td><div class="center">{{round($total_home_currency,2)}}  {{getHomeCurrency()[getCurrencyType()]}}</div></td>

</tr>
</table>

 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection