@extends('layouts.app')
 
@section('content') 
    <div class="row">

        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.CreateNewPaySalary') </span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools">
                     
                </div>
            </div>
            <div class="portlet-body form" style="margin-bottom:50%;">
                <!-- BEGIN FORM-->
                {{Form::open(['route' => 'paySalary.store','method' => 'POST','class' => 'form-horizontal','id'=>'pay-submit'])}}
                    <div class="form-body" id="app" v-cloak>
                        <div class="row">
                            <div class="col-md-8">
                                <div class="row">
                                    <div class="col-md-6">
                                        <label class="control-label">@lang('layout.SelectMember')</label>
                                        <v-select @input="getSummary" @search="MemberSearch"  class="vue-select2" v-model="selectedMember" label="name"
                                                :options="member">
                                        </v-select>
                                        <input type="hidden" name="member_id" v-model.number="(!selectedMember)?null:selectedMember.id">
                                    </div>
                                    <div class="col-md-2">
                                        <label class="control-label">@lang('layout.Number')</label>
                                        <input type="number" name="number" class="form-control" v-model="number" />
                                        <span class="required"></span>
                                    </div>
                                    <div class="">
                                        <div class="col-md-4">
                                            <label class="control-label">@lang('layout.Date')</label>

                                            <input class="form-control date" id="range-from-example" name="date"
                                               autocomplete="off">
                                        </div>
                                    </div> 
                                </div>
                                <div class="row">
                                    <div class="col-md-6" style="padding: 0px;">
                                        <div :class="currency_len">
                                           <label class="control-label">@lang('layout.PaymentCurrency')</label>
                                            <select  class="form-control" v-model="selectedCurrency" v-on:change="setSize(selectedCurrency.code)">
                                                 <option v-for="curre in currency" :value="curre">@{{ curre.code }}</option>
                                            </select>
                                            <input type="hidden" name="currency" v-bind:value="selectedCurrency.code"/> 
                                        </div>
                                        <div :class="rate_len" v-if="selectedCurrency.code != '{{getHomeCurrency()["code"]}}'">
                                            <label class="control-label">@lang('layout.Rate') </label>
                                            <div :class="{'has-error':selectedCurrency.rate < 0}">
                                                <div class="input-group">
                                                    <input  v-model="selected_rate" class="form-control"
                                                           type="number" step="any" min="0" @keyup="check_code(paymentCurrency.code)">
                                                    <span class="input-group-addon">@{{selectedCurrency.symbol}}</span>
                                                </div>
                                                <input type="hidden" name="currency_rate" :value="selected_rate">
                                            </div>
                                        </div> 
                                    </div> 
                                    <div class="col-md-6">
                                        <label class="control-label">@lang('layout.Account')</label>
                                        <div class="input-group">
                                            <select class="form-control" name="account_id" v-model="defaultAccount" v-on:change="test(defaultAccount)">
                                                <option v-for="Account in accountUpdate" :value="Account.id">@{{
                                                    Account.name }}
                                                </option>
                                            </select>
                                            <!-- <span class="input-group-addon">@{{ Number(selectedBank.balance)-(Number(amount)-Number(defaultAmount)) }}</span> -->
                                            <span class="input-group-addon">@{{ ( Number(selectedBank.balance)-(Number(amount)-Number(defaultAmount))).toFixed(precision()) }}</span>
                                            
                                        </div>
                                    </div>
                                </div> 
                                <div class="row">  
                                    <div class="col-md-6" style="padding: 0px;">
                                        <div :class="pcurrency_len">
                                           <label class="control-label">@lang('layout.Currency')</label>
                                            <select  class="form-control" v-model="paymentCurrency" v-on:change="setPaymentSize(paymentCurrency.code), setAmount()"  >
                                                 <option v-for="curre in currency1" :value="curre">@{{ curre.code }}</option>
                                            </select>
                                            <input type="hidden" name="paymentCurrency" v-bind:value="paymentCurrency.code"/> 
                                        </div>
                                        <div :class="prate_len" v-if="paymentCurrency.code != '{{getHomeCurrency()["code"]}}'">
                                            <label class="control-label">@lang('layout.Rate') </label>
                                            <div :class="{'has-error':paymentCurrency.exchange_rate < 0}">
                                                <div class="input-group">
                                                    <input  v-model="selected_rate1" class="form-control"
                                                           type="number" min="0" step="any" @input="setAmount()" :readonly="selectedCurrency.code==paymentCurrency.code" name="rate">
                                                    
                                                           <span class="input-group-addon" name="rate">@{{paymentCurrency.symbol}}</span>
                                                </div>
                                                <!-- <input type="hidden" name="rate" :value="selected_rate1"> -->
                                            </div>
                                        </div>  
                                    </div>                                       
                                    <div class="col-md-6">
                                        <label class="control-label">@lang('layout.Amount')</label>
                                        <div class="input-group">
                                            <input type="number" name="amount" @input="setAmount()" class="form-control" v-model="amount" step="any" min="0">
                                            <span class="input-group-addon">@{{selectedCurrency.symbol}}</span>
                                        </div>
                                    </div> 
                                </div>
                                <div class="row">
                                    <div class="col-md-6">
                                        <label class="control-label">@lang('layout.ExchangedAmount')</label>
                                        <div class="input-group">
                                            <input type="number" :value="exchanged_amount" class="form-control" min="0" step="any" readonly>
                                            <span class="input-group-addon">@{{paymentCurrency.symbol}}</span>
                                            
                                        </div>    
                                    </div>
                                    <div class="col-md-6">
                                        <label class="control-label">@lang('layout.Description')</label>
                                        {{Form::textarea('description',null,['class'=>'form-control','rows'=>'3'])}}
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="panel panel-default" style="background-color:rgb(204, 216, 228);position: relative;top: 24px;">
                                    <div class="panel-body">
                                        <table class="table table-bordered">
                                            <thead>
                                                <tr>
                                                    <th>@lang('layout.Currency') </th>
                                                    <th>@lang('layout.Payable')</th>
                                                    <th>@lang('layout.Receivable')</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                  <span v-if="selectedMember">
                                                   <tr v-for="summ in summary" >
                                                      <td class="highlight">
                                                         @{{ summ.currency }}
                                                      </td>
                                                      <td class=""> @{{ summ.payment }}</td>
                                                      <td>
                                                          @{{summ.invoice }}
                                                      </td>
                                                    </tr>
                                                </span>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>      
                                <div v-if="selectedMember && memberAmount" class="panel panel-default" style="background-color:rgb(204, 216, 228);position: relative;top: 24px;">
                                    <h4>@lang('layout.LastPayroll')</h4>
                                    <div class="panel-body">
                                        <table class="table table-bordered">
                                            <thead>
                                                <tr>
                                                    <th>@lang('layout.Currency') </th>
                                                    <th>@lang('layout.Amount')</th>
                                                    <th>@lang('layout.FromDate')</th>
                                                    <th>@lang('layout.ToDate')</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                  <span> 
                                                   <tr>
                                                      <td class="highlight">
                                                         @{{ memberCurrency }}
                                                      </td>
                                                      <td>@{{ memberAmount }}</td>
                                                      <td>
                                                          @{{ memberFromDate }}
                                                      </td>
                                                      <td>
                                                          @{{ memberToDate }}
                                                      </td>
                                                    </tr>
                                                </span>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>                            
                            </div>
                        </div>
                    
                    <div class="col-md-10">
                        <div class="row">
                            <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                                <button  type="button" class="btn green" onclick="regForm(this)">@lang('layout.Submit')</button>
                                <button type="button" class="btn blue" @click="saveAndNew($event)" >@lang('layout.SaveAndNew')</button>
                                <a href="{{route('paySalary.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                            </div>  
                        </div>
                    </div>
                    </div>
                {!! Form::close() !!}
            </div>                  
            <!-- END FORM-->
        </div>
    </div> 
@endsection
@push('scripts') 
 
<script> 
        @if(App::getLocale())
        Vue.use(VeeValidate, {
            locale: '{{App::getLocale()}}',
        });
        @else
        Vue.use(VeeValidate, {
            locale: 'en',
        });
        @endif

    $(document).ready(function(){
          $('#date').persianDatepicker({
            observer: true,
            format: 'YYYY/MM/DD',
            altFormat: 'u',
            autoClose:true,
                });
        });
    Vue.component("v-select", VueSelect.VueSelect);
        var Banks     = {!! $bank!!}
        var Currency  = {!! $currency!!}
        var Currency1  = {!! $currency!!}
        var one = {!!json_encode(getHomeCurrency()) !!}
        var two = {!!json_encode(getHomeCurrency()) !!}
        var code = "{!! getHomeCurrency()["code"] !!}";
      var app = new Vue({
        el: '#app',
        data: {
            selectedCurrency:one,
            selectedCurrencyTemp:null,
            paymentCurrency:two, 
            summary:[],
            payrollSummary:null,
            selectedCurrency2:null,

            memberAmount: 0,
            memberFromDate: null,
            memberToDate: null,
            memberCurrency: 0,

            currency:{!! json_encode(getCurrencies()) !!},
            currency1:{!! json_encode(getCurrencies()) !!}, 
                bankes: {!! $banks !!},
                number: "{!! $number !!}",
                selectedBank: null,
                defaultValue: 0,
                defaultAmount:0,
                defaultAccount: 0,
                selected_rate:0,
                selected_rate1:0,
                listAccounts:[],
                member: [],
                selectedMember:null,
                newAmount:null,
                amount:null,
                currencyList: Currency,
                type: 'bank',
                account: {},
                currency_len: 'col-md-12',
                rate_len: 'col-md-0',
                pcurrency_len:'col-md-12',
                prate_len:'col-md-0',
                code: code,
                first_currency: 0,
                second_currency: 0,
                exchanged_amount: null,

        },
        computed: {
            accountUpdate() { 
                var b = _.clone(Banks) 

                var test = this.accounts = b.filter((account) => {
                    return (new RegExp(this.selectedCurrency.code.toLowerCase())).test(account.code.toLowerCase())
                }) 
                if (test.length > 0) {
                    this.defaultValue = test[0].id;
                } else {
                    this.defaultValue = 0;
                }
                
                // console.log("Nice" , test); 
                
                // this.defaultValue = test[0].id; 
                        for(var x in this.bankes){
                            for(z in this.bankes[x]){
                                if(this.bankes[x][z] == this.defaultValue && z == 'id'){
                                    this.selectedBank = this.bankes[x];
                                    this.defaultAccount = this.defaultValue;                                    
                                    break;
                                }
                            }

                        }
                return test; 
                
                
            },
 
        }, 
        methods: { 
            setAmount(){
                @if(systemConfig()[30] == 1) 
                this.exchanged_amount = (((this.amount / this.selectedCurrency.static_rate * this.selected_rate) * this.paymentCurrency.static_rate) / this.selected_rate1).toFixed(2);
                @else  
                this.exchanged_amount = (this.amount*this.selected_rate1/(this.selected_rate)).toFixed(2);
                @endif 
            }, 
            MemberSearch: _.debounce((search, loading) => {
                    loading(true);
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'SearchMember', 
                            keyword: search,
                            type: 'Employee'
                        }
                    })
                    .then(function(response) {
                        if (response.data.length > 0) {
                            // console.log(response.data);
                            app.member = [];
                            app.member = response.data;
                        }
                        loading(false);
                    })
                    .catch(function(error) {
                        loading(false);
                        console.log(error);
                    })
                }, getDebounceTime()),

            getSummary(){
                if(this.selectedMember)
                { 
                    this.getSummaryRecor(this.selectedMember.id,this);
                    this.getPayrollSummaryRecor(this.selectedMember.id,this);
                    this.getSalaryRecord(this.selectedMember.id); 
                }
                
            },
            getSummaryRecor(id,vm)
            {
                vm.summary = null;
                axios.get("{{route('callMethod.search')}}",{
                params:{
                    method_name:'memberStatment',
                    member_id:id,
                }
                })
                .then(function (response)
                {
                    
                    if(response.data.length>0)
                    {
                    vm.summary=response.data;
                    }
                })
                .catch(function (error)
                {
                    console.log(error);
                });
            },
            getPayrollSummaryRecor(id,vm)
            {
                vm.payrollSummary=null;
                axios.get("{{route('callMethod.search')}}",{
                params:{
                    method_name:'payrollMemberStatment',
                    member_id:id,
                }
                })
                .then(function (response)
                {
                    if(response.data != null)
                    {
                        vm.memberAmount = response.data.amount;
                        vm.memberCurrency = response.data.currency;
                        vm.memberFromDate = response.data.from_date;
                        vm.memberToDate = response.data.to_date;
                        // vm.payrollSummary = response.data; 
                        
                    }
                })
                .catch(function (error)
                {
                    console.log(error);
                });
            },
            getSalaryRecord(id)
                {
                    $.ajax({
                    url: "{{route('callMethod.search')}}",
                    async:false,
                    data:{
                        method_name:'memberSalary',
                        employee_id:id,
                        },
                    success:function(data){
                        if(data !=undefined && data !=null)
                        {
                            if(data.currency !=null)
                            {
                                // dataAmount=data.amount;
                                app.selectedCurrency = _.find(app.currency,(o) => o.code == data.currency);
                                if (app.selectedCurrency && app.selectedCurrency != undefined) {
                                    app.setSize(app.selectedCurrency.code);
                                }
                                // console.log(32, app.selectedCurrency);
                            }
                        }

                    // console.log('sallkjk',data);

                    }.bind(this),

                    error: function(error){
                        console.log(error)
                    }
                });
                
            },
            setSize(selected_code) {
                this.paymentCurrency=this.selectedCurrency;
                this.selected_rate = this.selectedCurrency.exchange_rate;
                this.static_rate = this.selectedCurrency.static_rate;
                this.selected_rate1 = this.selectedCurrency.exchange_rate;

                if(selected_code ==  this.code){
                    this.currency_len = 'col-md-12';
                    this.rate_len = 'col-md-0';
                }
                else {
                    this.currency_len = 'col-md-6';
                    this.rate_len = 'col-md-6';
                }
                this.pcurrency_len=this.currency_len;
                this.prate_len=this.rate_len;
            }, 
            setPaymentSize(selected_code) {
                // this.selected_rate = this.paymentCurrency.exchange_rate;
                this.selected_rate1 = this.paymentCurrency.exchange_rate;
                
                if(selected_code ==  this.code){
                    this.pcurrency_len = 'col-md-12';
                    this.prate_len = 'col-md-0';
                }
                else  {
                    this.pcurrency_len = 'col-md-6';
                    this.prate_len = 'col-md-6';
                }
            },
            check_code(code){
                if(this.paymentCurrency.code == this.selectedCurrency.code){
                    this.selected_rate1 = this.selected_rate;
                }

            },
            test(defaultAccount){ 
                    for(var x in this.bankes){
                            for(z in this.bankes[x]){
                                if(this.bankes[x][z] == defaultAccount && z == 'id'){
                                    this.selectedBank = this.bankes[x];
                                    break;
                                }
                            }

                        }

            },
            saveAndNew()
            {
                this.$validator.validate()
                .then(valid =>{
                    if(valid)
                    { 
                        var url="{{route('paySalary.store')}}";
                        form_id='pay-submit';
                        var data= $('#'+form_id).serialize();
                        // console.log(444, data);
                        toggleBlock(true);
                        axios.post(url,data)
                        .then(function(response){
                                toggleBlock(0);
                                if(response.data.result==1)
                                {
                                    $('#'+form_id).trigger('reset');
                                    
                                    toastr.success('',response.data.message); 
                                    location.reload();
                                
                                }
                                else
                                {
                                    var message="{{__('message.Warning')}}";
                                    //$('#error-sound')[0].play();
                                    toastr.warning('',message);
                                }
                        })
                        .catch(function(error){
                        toggleBlock(0);
                            console.log(error);
                            var message="{{__('message.Warning')}}";
                            //$('#error-sound')[0].play();
                            toastr.warning('',message);
                        });
                    
                    }
                })
            },
        }
    });   
</script>


@endpush
 