@extends('layouts.factor-master')
@section('content')
<h4 class="bold uppercase" style="text-align: center; font-size: 20px;">@lang('layout.PaymentVouchar') (PV)</h4>
<table style="width: 100%; margin-bottom: 10px;">
  <tr class="myclass">
    <td>
      <span style="text-align: right; font-size: 18px">@lang('layout.PaymentNumber'): </span>
      <span style="text-align: right; font-size: 18px">{{$paymentByFactor->number}}</span>
    </td>
    <td>
      <span style="text-align: right; font-size: 18px">@lang('layout.ReferenceNumber'): </span>
      <span style="text-align: right; font-size: 18px">{{$paymentByFactor->ref_no}}</span>
    </td>
    <td>

      <span style="text-align: right; font-size: 18px">@lang('layout.Date'): </span>
      <BDO DIR="LTR"> <span
          style="text-align: right; font-size: 18px">{{$paymentByFactor->date}}</span></BDO>
    </td>

    <td>
      <span style="text-align: right; font-size: 18px">@lang('layout.ReceivedBy'): </span>
      <span style="text-align: right; font-size: 18px">{{$paymentByFactor->member_name}}</span>
    </td>
  </tr>
</table>



<table style="width: 100%; margin-bottom: 10px;" class=" main-table">
  <thead>
    <tr>
      <th> @lang('layout.Currency') </th>
      <th> @lang('layout.Receivable')</th>
      <th> @lang('layout.Payable') </th>
    </tr>
  </thead>
  <tbody>
    @foreach(getStatement($paymentByFactor->member_id) as $value )
    <tr style="text-align: center;">
      <td class="center">
        {{$value['currency']}}
      </td>
      <td class="center">
        {{$value['invoice']}}
      </td>
      <td class="center">
        {{simpleRound($value['payment'])}}
      </td>
    </tr>
    @endforeach
  </tbody>
</table>



<table style="width: 100%; margin-bottom: 10px;" class=" main-table">
  <thead>
    <tr>
      <th style="font-size: 18px"> @lang('layout.Amount')</th>
      <th> @lang('layout.Accountant') </th>
      <th> @lang('layout.Description')</th>
      {{-- <th> @lang('layout.Memo')</th> --}}
      <th> @lang('layout.ReceiverSignature')</th>
    </tr>
  </thead>
    <tr>
      <td  class="center" style="font-size: 18px;height:70px">{{simpleRound($paymentByFactor->amount)}} {{$paymentByFactor->currency}}</td>
      <td  class="center">{{$user}}</td>
      <td  class="center">
        {!! wordwrap($paymentByFactor->description,40,"<br/>\n",false) !!}
      </td>
      {{-- <td  class="center">
        {!! wordwrap($paymentByFactor->memo,40,"<br/>\n",false) !!}
      </td> --}}
      <td class="center"></td>
    </tr>
</table>
@if(company()['pay_message'])
<table width="100%">
  <tr>
    <td style="font-size: 14px;">{!!company()['pay_message']!!}</td>
  </tr>

  <tr>
    <td></td>
    <td></td>
  </tr>


</table>
@endif


@endsection