@extends('layouts.factor-master')

@section('style')
<style>
  .bhead{
    height: 35px;
    font-size: 18px;
  }
</style>
@endsection

@section('content')
<?php
$report = customeReport('payment_by_factor');
$_description=in_array('description', $report);
$_test=true;

?>
  <h3 class="table-caption" style="text-align: center;">@lang('layout.PaymentByFactorReport')</h3>

<!-- begin loop root -->
@foreach($data AS $record)


<!-- if root -->
@if(isset($record['detail']) && isset($record['info']))

<table class="report-table">
	<thead>
	<tr>
		<th>@lang('layout.Number')</th> 
		<th> @lang('layout.ReferenceNumber')</th> 
    <th>@lang('layout.Date')</th>
    <th>@lang('layout.Hour')</th>
		<th>@lang('layout.Description')</th>  
    <th>@lang('layout.Name')</th>
		<th>@lang('layout.Amount')</th>  
		<th>@lang('layout.Currency')</th>  
		<th>@lang('layout.Rate')</th>  
		<th>@lang('layout.User')</th> 
	</tr>
	</thead>
	<tbody>
	<tr>  
		<td class="center"> {{ $record['info']->number}}  </td>
		<td class="center"> {{ $record['info']->ref_no}}  </td>
    <td class="center"> {{ convertDate($record['info']->date)}}  </td>
    <td  class="center">
    @if(getHourType() == 24)
    {{ (($record['info']->hour != null)?(date_format(date_create($record['info']->hour), 'H:i')):'') }}
    @else
    {{ (($record['info']->hour != null)?(date_format(date_create($record['info']->hour), 'h:i:a')):'') }}
    @endif
    </td>
    {{-- <td class="center"> {{ $record['info']->hour}}  </td> --}}
		<td class="center"> {{ $record['info']->description}}  </td>
    <td class="center"> {{ $record['info']->member_name}}  </td>
		<td class="center"> {{ $record['info']->amount}}  </td>
		<td class="center"> {{ $record['info']->currency}}  </td>
		<td class="center"> {{ $record['info']->rate}}  </td>
		<td class="center"> {{ $record['info']->user}}  </td>

	</tr>
	</tbody>
</table>
<br/>



<table class="report-table">
  

 <?php
 $count = 0;
 ?>
 @foreach($record['detail'] AS $detail)
  <!-- loop check detail of each payment -->
  
  @if(isset($detail[0]['purchase']) && isset($detail[0]['payments']))
  <?php
  $purchaseData=$detail[0]['purchase'];
  if($purchaseData){
  ?>
  <tr style="background-color: rgb(183, 225, 244); ">
    <td class="bhead">@lang('layout.BillNumber'):{{$purchaseData->number}}</td>
    <td class="bhead">@lang('layout.Currency'):
        {{$purchaseData->currency}}</td>
    <td class="bhead">@lang('layout.Rate'):
      {{$purchaseData->rate}}</td>
    <td class="bhead">@lang('layout.Amount'):
      {{$purchaseData->amount}}</td>
    <td class="bhead">@lang('layout.Remain'):
      {{myRound($purchaseData->remain_amount)}}</td>  
    <td class="bhead">
      @if($purchaseData->gain_or_Loss>0)
      {{myRound(ABS($purchaseData->gain_or_Loss))}} {{getHomeCurrency()[getCurrencyType()]}}
          @lang('layout.Loss')
          
        @else
      {{myRound(ABS($purchaseData->gain_or_Loss))}} {{getHomeCurrency()[getCurrencyType()]}}
          @lang('layout.Gain')
        @endif
    </td>
  </tr>  
  @if(systemConfig()[7] != 0 )
  <tr style="background-color: rgb(183, 225, 244); ">
    <td class="bhead">@lang('layout.FactorNumber'):{{$purchaseData->factor_number}}</td>
    <td class="bhead">@lang('layout.PaletNumber'):{{$purchaseData->other_vehicle_name}}</td>
    <td class="bhead">@lang('layout.RentQuantity'):{{$purchaseData->rent_quantity}}</td>
    <td class="bhead">@lang('layout.LoadingDate'):{{$purchaseData->loading_date}}</td>
    <td class="bhead"></td>
    <td class="bhead"></td>
  </tr>
  @endif
  <?php } ?>
  <tr class="bg">

   @if($_test)<td class="center">@lang('layout.ReferenceNumber')</td>@endif
   @if($_test)<td class="center">@lang('layout.PaymentCurrency')</td>@endif
   @if($_test)<td class="center">@lang('layout.Rate')</td>@endif
   @if($_test)<td class="center">@lang('layout.Bank')</td>@endif
   @if($_test)<td class="center">@lang('layout.Amount')</td>@endif
   <td class="bhead"></td>
 </tr>

  @foreach($detail[0]['payments'] AS $pay)
  {
  <tr>
     @if($_test)<td class="center">{{$pay->ref_Number}}</td>@endif
     @if($_test)<td class="center">{{$pay->bcurrency}}</td>@endif
     @if($_test)<td class="center">{{$pay->brate}}</td>@endif
     @if($_test)<td class="center">{{$pay->aName}}</td>@endif
     @if($_test)<td class="center">{{$pay->amount}}</td>@endif
     <td class="bhead"></td>
  </tr>

  @endforeach
  @endif
  <!-- end loop check detail of each payment -->

  @endforeach   
</table>
<br/>
<br/>

@endif
<!-- end if root -->
@endforeach
<!-- end loop root -->


 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table>
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection