@extends('layouts.app')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">

@section('style')
<style type="text/css">
    .has_shadow{
        padding:2px;
        box-shadow: 0px 2px 5px grey;
        padding-bottom:1px;

    }
</style>
@stop
@section('content')
  <div class="row">

        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.PaymentByFactor') </span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools">

                </div>
            </div>
            <div class="portlet-body form" style="margin-bottom:50%;" id="app" v-cloak>
                <!-- BEGIN FORM-->
                {{Form::open(['route' => 'payByFactor.store','method' => 'POST','class' => 'form-horizontal','id'=>'payByFactor-form'])}}
                <div class="form-body">
                    <div class="row">
                        <div class="col-md-9">

                            <div class="row">
                                <div v-show="showWhat('member_class')=='yes'"
                                     class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="">
                                            <label class="control-label">@lang('layout.MemberClass') </label>

                                            <v-select label="name" :options="memberClass"
                                                      v-model="selected_class"
                                                      @input="memberClassChange()"></v-select>
                                            <input type="hidden" name="class_id"
                                                   :value="!selected_class?null:selected_class.id">
                                    </div>
                                </div>
                            </div>

                            <!-- second row -->
                            <div class="row">
                                <div class="col-md-4">
                                    <label class="control-label">@lang('layout.SelectMember')</label>
                                    <v-select @input="getSummary" class="vue-select2" v-model="selectedMember"
                                        @search="MemberSearch" label="name" :options="member">
                                    </v-select>

                                    <input type="hidden" name="member_id"
                                           v-model.number="(!selectedMember)?null:selectedMember.id"
                                           v-validate="'required'" data-vv-as="@lang('layout.Member')">
                                    <span class="required">@{{errors.first('member_id')}}</span>
                                </div>

                                <div class="col-md-4">
                                    <label class="control-label">@lang('layout.Number')</label>
                                    

                                    <input type="number" name="number" v-model="number" class="form-control" v-validate="'required'" data-vv-as="@lang('layout.Number')">
                                    <span class="required">@{{errors.first('number')}}</span>
                                </div>

                                <div class="col-md-4">
                                    <label class="control-label">@lang('layout.ReferenceNumber')</label>
                                    

                                    <input type="text" name="ref_no" @input="checkRefPaymentByFactor($event)" class="form-control">
                                    <span id="ref_msg" class="required"></span>
                                    <span class="required">@{{errors.first('ref_no')}}</span>
                                </div>
                            </div>
                            <!-- end second row -->
							
							 <div class="row">
                                <div class="col-md-4" style="padding: 0px;">
                                    <div :class="currency_len">
                                        <label class="control-label">@lang('layout.RecieveCurrency')</label>
                                        <select class="form-control" v-model="selectedCurrency"
                                                v-on:change="setSize(selectedCurrency.code), get_exchange(), getSummary()">
                                            <option v-for="curre in currency" :value="curre">@{{ curre.code }}</option>
                                        </select>
                                        <input type="hidden" name="currency" v-bind:value="selectedCurrency.code"/>
										
                                    </div>
                                    <div :class="rate_len" v-if="selectedCurrency.code != '{{getHomeCurrency()["code"]}}'">
                                        <label class="control-label">@lang('layout.Rate') </label>
                                        <div :class="{'has-error':selectedCurrency.rate < 0}">
                                            <div class="input-group">
                                                <input v-model="selected_rate" class="form-control"
                                                       type="number" step="any" min="0"
                                                       @keyup="get_exchange()">
                                                <span class="input-group-addon">@{{selectedCurrency.symbol}}</span>
                                            </div>
                                            <input type="hidden" name="currency_rate" :value="selected_rate">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <label class="control-label">@lang('layout.Account')</label>
                                    <div class="input-group">
                                        <select class="form-control" name="account_id" v-model="defaultAccount"
                                                v-on:change="test(defaultAccount)">
                                            <option v-for="Account in accountUpdate" :value="Account.id">@{{ Account.name }}
                                            </option>
                                        </select>
                                        <!--  <span class="input-group-addon">@{{ Number(selectedBank.balance)+(Number(amount)-Number(defaultAmount)) }}</span> -->

                                        <span class="input-group-addon">@{{ (selectedBank)?format_number( Number(selectedBank.balance)-(Number(amount)-Number(defaultAmount))):0 }}</span>
                                    </div>
                                </div>
								
								<div class="col-md-4">
                                    <label class="control-label">@lang('layout.Amount')</label>
                                    <vue-numeric
                                        class="form-control"
                                        v-model="amount"
                                        :max="99999999999999"
                                        :currency="selectedCurrency.code"
                                        :precision="precision()"
                                        @input="get_exchange()"
                                        >
                                    </vue-numeric>
                                    <input type="hidden" name="amount" class="form-control" v-model="amount" step="any" min="0" v-validate="'required'" data-vv-as="@lang('layout.Amount')">
                                    <span class="required">@{{ errors.first('amount') }}</span>
                                </div>
								
                            </div>

                            <!-- third row -->

                            <!-- end third row -->
                            <div class="row">
                                <div class="col-md-4">
                                    <label class="control-label">@lang('layout.Date')</label>
                                    
                                    <input type="text" name="date" class="form-control date" autocomplete="off">
                                    <span class="required">@{{errors.first('date')}}</span>
                                </div>

                                <div class="col-md-4">
                                    <label class="control-label">@lang('layout.Description')</label>
                                    <textarea name="description" class="form-control"></textarea>
                                    <span class="required">@{{errors.first('description')}}</span>
                                </div>
                                <div class="col-md-4" v-if="selectedCurrency.code != '{{getHomeCurrency()["code"]}}'">
                                    <label class="control-label">@lang('layout.ExchangedAmount')</label>
                                    <div class="input-group">
                                        <vue-numeric
                                            class="form-control"
                                            v-model="exchange_amount"
                                            :max="99999999999999"
                                            :currency="'{{getHomeCurrency()["code"]}}'"
                                            :precision="precision()"
                                            @input="set_rate()"
                                            >
                                        </vue-numeric>
                                        <span class="input-group-addon">{{getHomeCurrency()["symbol"]}}</span>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Memo')</label>
                                            <textarea name="memo" class="form-control" rows="2"></textarea>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- begin payments -->

                            <div class="row" v-if="paymentData">

                                <div class="col-md-12 has_shadow" v-for="(item,index) in paymentData" style="margin:2px">
                                    <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                                        <thead>
                                            <tr>
												<th>@lang('layout.ReferenceNumber')</th>
                                                <th>@lang('layout.BillNumber')</th>
                                                <th>@lang('layout.Currency')</th>
                                                <th>@lang('layout.Rate') @lang('layout.Enterbill')</th>
                                                <th>@lang('layout.Amount')</th>
                                                <th>@lang('layout.Remain')</th>
                                                <!-- <th>@lang('layout.Rate')</th> -->
                                                <th></th>
												
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr>
												<td>
													<input type="text"  :name="'payment_ref_no['+index+']'" @input="checkRef($event,index)" class="form-control">
													<span :id="`pay_${index}`"  style="color: red"></span>
												</td>
                                                <td>
                                                    <v-select label="bill_info" @input="onFactorSelect(index)" v-model="item.factor"
                                              :options="temp_items" @search="onFactorSearch"></v-select>
                                                    <input type="hidden" :name="'purchase_id['+index+']'"
                                                           :value="(!item.factor)?null:item.factor.id">
                                                    <span class="required">@{{ errors.first('purchase_id['+index+']') }}</span>
                                                </td>
                                                <td>
                                                    <input type="text" :name="'purchase_currency['+index+']'" readonly :value="(!item.factor)?null:item.factor.currency" class="form-control">
                                                </td>
                                                <td>
                                                    
                                                     <input type="number" :name="'purchase_rate['+index+']'" readonly :value="(!item.factor)?null:item.factor.rate" class="form-control">
                                                </td>
                                                <td>
                                                    
                                                     <input type="number" readonly :value="(!item.factor)?null:item.factor.amount" class="form-control">
                                                </td>
                                                <td>
                                                    
                                                     <input type="number" readonly :value="(!item.factor)?null:item.factor.remain_amount" class="form-control">
                                                </td>
                                                <!-- <td>
                                                    <input type="number" :name="'today_rate['+index+']'"  :value="(!item.factor)?null:item.factor.today_rate" class="form-control">
                                                </td> -->
												<td>
													<span v-if="index > 0" v-on:click="deleteItem('payment',index,index)">
													<i class="paddint-both glyphicon glyphicon-trash"></i></span>
												</td>
                                            </tr>



                                        </tbody>
                                    </table>


                                </div>
                            </div>
                            <button type="button" @click="addNew('factor')" class="btn btn-sm btn-info">+</button>
                            <!-- end payments -->


                        </div>

                        <!-- begin member summary -->
                        <div class="col-md-3">
                            <div class="panel panel-default"
                                 style="background-color:rgb(204, 216, 228);position: relative;top: 24px;">
                                <div class="panel-body">

                                    <table class="table table-bordered">
                                        <thead>
                                        <tr>
                                            <th>@lang('layout.Currency') </th>
                                            <th>@lang('layout.Payable')</th>
                                            <th>@lang('layout.Receivable')</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                                 <span v-if="selectedMember">
                                                   <tr v-for="summ in summary">
                                                      <td class="highlight">
                                                         @{{ summ.currency }}
                                                      </td>
                                                      <td class="hidden-xs"> @{{ format_number(Number(summ.payment)) }}</td>
                                                      <td>
                                                          @{{ format_number(Number(summ.invoice)) }}
                                                      </td>
                                                    </tr>
                                                </span>
                                        </tbody>
                                    </table>


                                </div>
                            </div>

                            <div class="panel panel-default"
                                 style="position: relative;top: 24px;">
                                <div class="panel-body">
                                    <table class="dashboard-tabel" width="100%">
                                        <tr>
                                            <td>
                                                <small>@lang('layout.Total') @lang('layout.Amount') :</small>
                                            </td>
                                            <td class="text-right">
                                                <span data-counter="counterup" data-value="7800">
                                                    @{{myRound(amount)}}
                                                </span>
                                                <small class="font-green-sharp">
                                                    @{{selectedCurrency.symbol}}
                                                </small>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <small>@lang('layout.Total') @lang('layout.Factor') :</small>
                                            </td>
                                            <td class="text-right">
                                                <span data-counter="counterup" data-value="7800">
                                                    @{{myRound(sub_Subtotal)}}
                                                </span>
                                                <small class="font-green-sharp">
                                                    @{{selectedCurrency.symbol}}
                                                </small>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <small>@lang('layout.Total') @lang('layout.Remain') @lang('layout.Factor') :</small>
                                            </td>
                                            <td class="text-right">
                                                <span data-counter="counterup" data-value="7800">
                                                    @{{myRound(sum_remain)}}
                                                </span>
                                                <small class="font-green-sharp">
                                                    @{{selectedCurrency.symbol}}
                                                </small>
                                            </td>
                                        </tr>
                                    </table>


                                </div>
                            </div>
                            
                        </div>

                    </div>
                </div>
                <div class="col-md-10">
                    <div class="row">
                        <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                            <!-- <input v-if="isError ==false" type="submit" value="submit" class="btn green" > -->
                            <button v-if="isError ==false" type="button" class="btn green"
                            :disabled="disabled" @click="saveAndNew($event)">@lang('layout.Submit')</button>
                            <button v-if="isError ==false" type="button" class="btn blue"
                            :disabled="disabled" @click="saveAndNew($event,'new')">@lang('layout.SaveAndNew')</button>
                            <a href="{{route('payByFactor.index')}}" class="btn default"><i
                                        class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                        </div>
                    </div>
                </div>
                {!! Form::close() !!}
            </div>
            <!-- END FORM-->
        </div>
    </div>
@endsection

@push('scripts')
<script>

    @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
    Vue.use(VeeValidate, {
        locale: 'en',
    });
    @endif

	Vue.component("v-select", VueSelect.VueSelect);
    Vue.use(VueNumeric.default)

	var currency ={!! $currency !!};
    var homeCurrency = {!! json_encode(getHomeCurrency()) !!};
    var code = '{!! getHomeCurrency()['code'] !!}';
    var banks ={!! $banks !!};
	var Banks ={!! $banks !!};
	var one = defaultCurrency();
	

	var vm = new Vue({
		el:'#app',
		data:{
			selectedCurrency: one,
			currency:{!! json_encode(getCurrencies()) !!},
			bankes: {!! $banks !!},
            defaultAccount: 0,
			bankes: {!! $banks !!},
			amount: null,
			defaultAmount: 0,
			defaultAccount: 0,
            selected_rate: 1,
            sum_remain: 0,
            code: code,
			currency_len: 'col-md-12',
			rate_len: 'col-md-0',
            exchange_amount: null,
			number: "{{$number}}",
			memberClass:{!! $memberClass  !!},
			selected_class:null,
			member:[],
			selectedMember: null,
            currency:currency,
			summary: [],
            disabled: false,
            isError: false,
            paymentData:[
            {factor:null,
            payments:[
            ]}
            ],
            temp_items: [],

		},
		computed: {
			accountUpdate() {
				var b = _.clone(Banks)
				var test = this.accounts = b.filter((account) => {
					return (new RegExp(this.selectedCurrency.code.toLowerCase())).test(account.code.toLowerCase())
				})
                if (test.length > 0) {
				this.defaultValue = test[0].id;
				for (var x in this.bankes) {
					for (z in this.bankes[x]) {
						if (this.bankes[x][z] == this.defaultValue && z == 'id') {
							this.selectedBank = this.bankes[x];
							this.defaultAccount = this.defaultValue;
							break;
						}
					}
				}
                }else{
                    this.selectedBank = null;
                }
				return test;
			},

            // calculate subtotal
            sub_Subtotal: function() {
                var sum = 0;
                var sum_remain = 0;
                for (var i = 0; i < this.paymentData.length; i++) {
                    if (this.paymentData[i].factor && this.paymentData[i].factor != null) {
                        var rate = this.paymentData[i]['factor']['rate'];
                        var amount = this.paymentData[i]['factor']['amount'];
                        var remain_amount = this.paymentData[i]['factor']['remain_amount'];

                        if (rate > 0 && amount > 0) {
                            sum += (amount / rate) * this.selected_rate;
                        } 

                        if (rate > 0 && remain_amount > 0) {
                            sum_remain += (remain_amount / rate) * this.selected_rate;
                        } 
                    }
                }
                this.sum_remain = sum_remain;
                
                return sum;
            },
		},
		created:function(){
			
		},
		methods:{
            onFactorSelect(index=null)
            {
                if(this.paymentData[index] != undefined)
                {
                    if(this.paymentData[index].factor)
                    {   
                        this.paymentData[index].payments=[];
                        let tc={!! $currency !!}
                        let unit=this.paymentData[index].factor.currency;
                       
                        let seted_currency=_.find(tc,(c)=> c.code==unit);

                        let seted_bank=[];
                        
                        let b={!! $banks !!};
                        for(var i=0;i<b.length;i++)
                        {
                            if(b[i].code==unit)
                            {
                                seted_bank.push(b[i]);
                            }
                        }
                        
                        let selected_bank=null;
                        if(seted_bank.length)
                        {
                            selected_bank=seted_bank[0];
                        }
                      

                        this.paymentData[index].payments.push({items: seted_bank,
                            item: selected_bank,
                            currency_list:tc,
                            currency:seted_currency,
                            ref_no:null});
                    }
                }
            },
            
            memberClassChange() {
                if (vm.selected_class) {
                    vm.member = [];
                    vm.selectedMember = null;
                    let class_id = vm.selected_class.id;
                
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'SearchMember',
                            class_id: class_id
                        }
                    })
                    .then(function(response) {
                        if (response.data.length > 0) {
                            // console.log(response.data);
                            vm.member = [];
                            vm.member = response.data;
                        }
                    })
                    .catch(function(error) {
                        console.log(error);
                    })
                }
            },
            MemberSearch: _.debounce((search, loading) => {
                loading(true);
                let class_id = (vm.selected_class != undefined) ? vm.selected_class.id : null;
                
                axios.get("{{route('callMethod.search')}}", {
                    params: {
                        method_name: 'SearchMember', 
                        keyword: search,
                        class_id: class_id
                    }
                })
                .then(function(response) {
                    if (response.data.length > 0) {
                        // console.log(response.data);
                        vm.member = [];
                        vm.member = response.data;
                    }
                    loading(false);
                })
                .catch(function(error) {
                    loading(false);
                    console.log(error);
                })
            }, getDebounceTime()),
			
			setSize(selected_code) {
                    // this.paymentCurrency = this.selectedCurrency;
                    this.selected_rate = this.selectedCurrency.exchange_rate;
                    // this.selected_rate1 = this.selectedCurrency.exchange_rate;
                    if (selected_code == this.code) {
                        this.currency_len = 'col-md-12';
                        this.rate_len = 'col-md-0';
                    }
                    else {
                        this.currency_len = 'col-md-6';
                        this.rate_len = 'col-md-6';
                    }
                    this.pcurrency_len = this.currency_len;
                    this.prate_len = this.rate_len;
                },
		
			getSummary()
			{
	            if (this.selectedMember && this.selectedCurrency) {

	                this.getSummaryRecor(this.selectedMember.id, this);

                    // get member bills,factor
                    let member_id=this.selectedMember.id;
                    let code=this.selectedCurrency.code;

                    axios.get("{{route('payByFactor.getMemberFactor')}}", {
                        params: {
                            member_id:member_id,
                            code:code,
                        }
                    })
                    .then(function (response) {
                        vm.temp_items = [];
                        if (response.data.length > 0) {
                            vm.temp_items = response.data;
                            // console.log(00000,response.data);
                        }
                    })
                    .catch(function (error) {
                        console.log(error);
                        
                    })
                    // end of bill,factor

	            }

	        },
            getSummaryRecor(id, vm)
            {
                axios.get("{{route('callMethod.search')}}", {
                    params: {
                        method_name: 'memberStatment',
                        member_id: id,
                    }
                })
                .then(function (response) {

                    if (response.data.length > 0) {
                        vm.summary = response.data;
                    }
                })
                .catch(function (error) {
                    console.log(error);
                });
            },
            checkRefPaymentByFactor(e)
            {
                var ref=e.target.value;
              
                axios.get("{{route('callMethod.search')}}",
                {

                    params: {
                        ref_no: ref,
                        method_name: 'Search_ref_no',
                        table_name: 'payment_by_factors'
                    },
                })
                .then(function (response) {
                    // console.log(response.data.result);
                    if (response.data.result != null) {
                        // console.log(response.data.result);
                        // v.temp_items=response.data;
                        let msg = "@lang('layout.DuplicateData')";
                        $('#ref_msg').html(msg);
                    }
                    else {
                        vm.msg = 'no';
                        $('#ref_msg').html('');

                    }
                })
                .catch(function (error) {
                    console.log(error);
                });
            },
            // check ref
            checkRef(e,index,payment_index)
            {
                var ref=e.target.value;
              
                axios.get("{{route('callMethod.search')}}",
                {

                    params: {
                        ref_no: ref,
                        method_name: 'Search_ref_no',
                        table_name: 'payments'
                    },
                })
                .then(function (response) {
                    // console.log(response.data.result);
                    if (response.data.result != null) {
                        // console.log(response.data.result);
                        // v.temp_items=response.data;
                        let msg = "@lang('layout.DuplicateData')";
                        $('#pay_'+index).html(msg);
                    }
                    else {
                        vm.msg = 'no';
                        $('#pay_'+index).html('');

                    }
                })
                .catch(function (error) {
                    console.log(error);
                });
            },
            //  get factors
            onFactorSearch: _.debounce((search, loading) => {

                if(vm.selectedMember && vm.selectedCurrency)
                {
                    let member_id=vm.selectedMember.id;
                    let code=vm.selectedCurrency.code;
                    loading(true);

                    axios.get("{{route('payByFactor.getMemberFactor')}}", {
                        params: {
                            member_id:member_id,
                            code:code,
                            search_keyword:search
                        }
                    })
                    .then(function (response) {
                        vm.temp_items = [];
                        // console.log('test222',response.data);
                        if (response.data.length > 0) {
                            vm.temp_items = response.data;
                        }
                        loading(false);
                    })
                    .catch(function (error) {
                        console.log(error);
                        loading(false);
                    })
                }
                else
                {
                    alert("{{__('layout.SelectMember')}}");
                }
            }, getDebounceTime()),

            approperiatBank(index,payment_index)
            {
                if(this.paymentData[index].payments[payment_index].currency)
                {
                    let unit=this.paymentData[index].payments[payment_index].currency.code;
                       
                    let seted_bank=[];
                    
                    let b={!! $banks !!};
                    for(var i=0;i<b.length;i++)
                    {
                        if(b[i].code==unit)
                        {
                            seted_bank.push(b[i]);
                        }
                    }
                    
                    let selected_bank=null;
                    if(seted_bank.length)
                    {
                        selected_bank=seted_bank[0];
                    }
                  
                    this.paymentData[index].payments[payment_index].items=seted_bank;
                    this.paymentData[index].payments[payment_index].item=selected_bank; 
                }
                
            },
            get_exchange() {
                let vm = this;
                if(vm.selected_rate > 0){
                    vm.exchange_amount = myRound(vm.amount / vm.selected_rate);
                }
            },
            set_rate() {
                let vm = this;
                if(vm.exchange_amount > 0){
                    vm.selected_rate = myRound(vm.amount / vm.exchange_amount);
                }
            },
            // generic function for adding item to list
            addNew(type = null, index,payment_index=null)
            {
                //this.temp_items = [];
                if (type != null) {
                    
                    if (type == 'payment') {
                        if (this.paymentData[index].payments[payment_index + 1] == undefined) {
                            let b={!! $banks !!};
                             let tc={!! $currency !!}
                            this.paymentData[index].payments.push({
                                items: b,
                                item: null,
                                currency:null,
                                currency_list:tc,
                                ref_no:null
                            });

                        }
                    }
                    if (type == 'factor') {
                        let len=this.paymentData.length;
                        if (this.paymentData[index] == undefined) {
                            
                            this.paymentData.push({
                                factor:null,
                                payments:[
                                ]});

                        }
                    }
                } 
            },

            // delete item from list
            deleteItem(type = null, index,payment_index) {
                if (type != null) {
                  
                    if (type == 'payment') {
                        // this.paymentData[index].payments.splice(payment_index, 1);
						this.paymentData.splice(index, 1);
                    }
                }

            },

            // save or new

            saveAndNew(e,type=null) 
            {
                
                this.$validator.validate()
                    .then(valid => {
                        if (valid) {
                            vm.disabled = true;
                            var url = "{{route('payByFactor.store')}}";
                            
                            var data = $('#payByFactor-form').serialize();
                            axios.post(url, data)
                                .then(function (response) {
                                   
                                    if (response.data.result == 1) {
                                        $('#payByFactor-form').trigger('reset');
                                        toastr.success('', response.data.message);

                                        if(type==null)
                                        {
                                            window.location.href="{{route('payByFactor.index')}}"
                                        }
                                        else
                                        {
                                            vm.paymentData=[
                                            {factor:null,
                                            payments:[
                                            ]}
                                            ];
                                            vm.temp_items= [];
                                            vm.selectedMember=null;
											location.reload();
                                        }
                                       
                                    }
                                    else {
                                        vm.disabled = false;
                                        var message = "{{__('message.Warning')}}";
                                        //$('#error-sound')[0].play();
                                        toastr.warning('', message);
                                    }

                                    
                                    
                                })
                                .catch(function (error) {
                                    vm.disabled = false;
                                    console.log(error);
                                    var message = "{{__('message.Warning')}}";
                                    //$('#error-sound')[0].play();
                                    toastr.warning('', message);
                                });

                        }
                    })
            },
            test(defaultAccount) {
                for (var x in this.bankes) {
                    for (z in this.bankes[x]) {
                        if (this.bankes[x][z] == defaultAccount && z == 'id') {
                            this.selectedBank = this.bankes[x];
                            break;
                        }
                    }

                }

            },
		}

	});
</script>
@endpush
