@extends('layouts.app')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">
<link href="{{URL::asset('assets/global/plugins/bootstrap-timepicker/css/bootstrap-timepicker.min.css')}}" rel="stylesheet" type="text/css" />
@section('style')
<style type="text/css">
    .has_shadow{
        padding:2px;
        box-shadow: 0px 2px 5px grey;
        padding-bottom:1px;
    }
</style>
@stop
@section('content')
  <div class="row">
        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.PaymentByFactor') </span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools"></div>
            </div>
            <div class="portlet-body form" style="margin-bottom:50%;" id="app" v-cloak>
                <!-- BEGIN FORM-->
                {{Form::open(['route' => 'payByFactor.store','method' => 'POST','class' => 'form-horizontal','id'=>'payByFactor-form'])}}
                <div class="form-body">
                    <div class="row" style="margin-bottom: 20px; padding: 10px;">
                        <div class="col-lg-9 col-md-9 col-sm-12 col-xs-12" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px; margin-bottom: 10px; padding: 15px 50px;" >
                            <!-- second row -->
                            <div class="row" style="padding: 0px 10px;">
                                <div v-show="showWhat('member_class')=='yes'" class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="col-lg-12" style="padding: 0px !important">
                                        <label class="control-label">@lang('layout.MemberClass') </label>
                                        <v-select label="name" :options="memberClass" v-model="selected_class" @input="memberClassChange()"></v-select>
                                        <input type="hidden" name="class_id" :value="!selected_class?null:selected_class.id">
                                    </div>
                                </div>
                                <div class="col-md-5">
                                    <div class="col-lg-12" style="padding: 0px !important">
                                        <label class="control-label">@lang('layout.SelectMember')</label>
                                        <v-select @input="getSummary(),onFactorSearch()" class="vue-select2" v-model="selectedMember"
                                            @search="MemberSearch" label="name" :options="member">
                                        </v-select>
                                        <input type="hidden" name="member_id"
                                            v-model.number="(!selectedMember)?null:selectedMember.id"
                                            v-validate="'required'" data-vv-as="@lang('layout.Member')">
                                        <span class="required">@{{errors.first('member_id')}}</span>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="col-lg-12" style="padding: 0px !important;">
                                        <label class="control-label">@lang('layout.Number')</label>
                                        <input type="number" name="number" v-model="number" class="form-control" v-validate="'required'" data-vv-as="@lang('layout.Number')">
                                        <span class="required">@{{errors.first('number')}}</span>
                                    </div>
                                </div>
                            </div>
                            <!-- end second row -->
							<div class="row" style="padding: 0px 10px;">
                                <div class="col-md-4">
                                    <div class="col-lg-12" style="padding: 0px !important;">
                                        <label class="control-label">@lang('layout.ReferenceNumber')</label>
                                        <input type="text" name="ref_no" @input="checkRefPaymentByFactor($event)" class="form-control">
                                        <span id="ref_msg" class="required"></span>
                                        <span class="required">@{{errors.first('ref_no')}}</span>
                                    </div>
                                </div>
                                <div class="col-md-4" style="padding: 0px !important;">
                                    <div class="col-lg-12" style="padding: 0px !important;">
                                        <div :class="currency_len">
                                            <label class="control-label">@lang('layout.RecieveCurrency')</label>
                                            <select class="form-control" v-model="selectedCurrency" v-on:change="setSize(selectedCurrency.code), get_exchange(), getSummary()">
                                                <option v-for="curre in currency" :value="curre">@{{ curre.code }}</option>
                                            </select>
                                            <input type="hidden" name="currency" v-bind:value="selectedCurrency.code"/>
                                        </div>
                                        <div :class="rate_len" v-if="selectedCurrency.code != '{{getHomeCurrency()["code"]}}'">
                                            <label class="control-label">@lang('layout.Rate') </label>
                                            <div :class="{'has-error':selectedCurrency.rate < 0}">
                                                <div class="input-group">
                                                    <input v-model="selected_rate" class="form-control" type="number" step="any" min="0" :readonly="averageRate" @keyup="get_exchange()">
                                                    <span class="input-group-addon">@{{selectedCurrency.symbol}}</span>
                                                </div>
                                                <input type="hidden" name="currency_rate" :value="selected_rate">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div style="col-lg-12">
                                        <label class="control-label">@lang('layout.Account')</label>
                                        <div class="input-group">
                                            <select class="form-control" name="account_id" v-model="defaultAccount" v-on:change="test(defaultAccount)">
                                                <option v-for="Account in accountUpdate" :value="Account.id">@{{ Account.name }} </option>
                                            </select>
                                            <!--  <span class="input-group-addon">@{{ Number(selectedBank.balance)+(Number(amount)-Number(defaultAmount)) }}</span> -->
                                            <span class="input-group-addon">@{{ (selectedBank)?format_number( Number(selectedBank.balance)-(Number(amount)-Number(defaultAmount))):0 }}</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- third row -->
                            <!-- end third row -->
                            <div class="row" style="padding: 0px 10px;">
                                <div class="col-md-4">
                                    <div class="col-lg-12" style="padding: 0px !important;">
                                        <label class="control-label">@lang('layout.Amount')</label>
                                        <vue-numeric class="form-control" v-model="amount" :max="99999999999999" :currency="selectedCurrency.code" :precision="precision()" @input="get_exchange()">
                                        </vue-numeric>
                                        <input type="hidden" name="amount" class="form-control" v-model="amount" step="any" min="0" v-validate="'required'" data-vv-as="@lang('layout.Amount')">
                                        <span class="required">@{{ errors.first('amount') }}</span>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="col-lg-12" style="padding: 0px !important;">
                                        <label class="control-label">@lang('layout.Date')</label>
                                        <input type="text" name="date" class="form-control date" autocomplete="off"
                                        @if(getDateRequired() == 'true') v-validate='"required"' data-vv-as="@lang('layout.Date')" @endif>
                                        <span class="required">@{{errors.first('date')}}</span>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="col-lg-12" style="padding: 0px !important;">
                                        <label class="control-label">@lang('layout.Hour')</label>
                                        <div class="input-group" @click="stopDynamicTime" @mousemove="changeTime"> 
                                            @if(getHourType() == 24)
                                            <input type="text" class="form-control timepicker timepicker-24" v-model="dynamic_time" ref="time_input" name="hour" @keyup="changeTime">
                                            @else
                                            <input type="text" class="form-control timepicker timepicker-no-seconds" v-model="dynamic_time" ref="time_input" name="hour" @keyup="changeTime">
                                            @endif
                                            <span class="input-group-btn">
                                                <button class="btn default" type="button">
                                                    <i class="fa fa-clock-o"></i>
                                                </button>
                                            </span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row" style="padding: 0px 10px;">
                                <div class="col-md-4">
                                    <div class="col-lg-12" style="padding: 0px !important;">
                                        <label class="control-label">@lang('layout.Description')</label>
                                        <textarea name="description" class="form-control" rows="1"></textarea>
                                        <span class="required">@{{errors.first('description')}}</span>
                                    </div>
                                </div>
                                <div class="col-md-4" v-if="selectedCurrency.code != '{{getHomeCurrency()["code"]}}'">
                                    <div class="col-lg-12">
                                        <label class="control-label">@lang('layout.ExchangedAmount')</label>
                                        <div class="input-group">
                                            <vue-numeric class="form-control" v-model="exchange_amount" :max="99999999999999" :currency="'{{getHomeCurrency()["code"]}}'" :precision="precision()" @input="set_rate()" :readonly="averageRate">
                                            </vue-numeric>
                                            <span class="input-group-addon">{{getHomeCurrency()["symbol"]}}</span>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12" style="padding: 0px !important;">
                                    <div class="col-md-12">
                                        <label class="control-label">@lang('layout.Memo')</label>
                                        <textarea name="memo" class="form-control" rows="1"></textarea>
                                    </div>
                                </div>
                            </div>
                            <!-- begin payments -->
                            <div class="row" v-if="temp_items.length>0" style="margin: 2px">
                                <p>@lang('layout.SelectAll'): 
                                    <input type="checkbox" name="selectedItem" class="icheck" @change="selectAll(this)" v-model="selectedAll">
                                </p>
                                <div class="col-md-12 has_shadow" v-for="(item,index) in temp_items" style="margin:2px">
                                    <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                                        <thead>
                                            <tr>
                                                <th style="background-color: #6b716b;">&#10004</th>
												<th>@lang('layout.ReferenceNumber')</th>
                                                <th>@lang('layout.BillNumber')</th>
                                                @if(systemConfig()[7] != 0 )
                                                <th>@lang('layout.FactorNumber')</th>
                                                <th>@lang('layout.PaletNumber')</th>
                                                <th>@lang('layout.RentQuantity')</th>
                                                <th>@lang('layout.LoadingDate')</th>
                                                @endif
                                                <th>@lang('layout.Currency')</th>
                                                <th>@lang('layout.Rate') @lang('layout.Enterbill')</th>
                                                <th>@lang('layout.Amount')</th>
                                                <th>@lang('layout.Remain')</th>
                                                <!-- <th>@lang('layout.Rate')</th> -->
                                                <th></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr>
                                                <td class="highlight" style="background-color: rgb(174, 183, 178);">
                                                    <div class="success"></div>
                                                    <input type="checkbox" @click="toggleCheck(index)" :checked="item.selected">
                                                    <input type="hidden" :name="'selected_bill['+index+']'" :value="(!item)?null:item.selected">
                                                </td>
												<td>
													<input type="text"  :name="'payment_ref_no['+index+']'" @input="checkRef($event,index)" class="form-control">
													<span :id="`pay_${index}`"  style="color: red"></span>
												</td>
                                                <td>
                                                    <input type="number" :value="(!item)?null:item.bill_info" class="form-control" readonly style="font-size:20px;color:#005aff">
                                                    <input type="hidden" :name="'purchase_id['+index+']'" :value="(!item)?null:item.id">
                                                    <input type="hidden" :name="'types['+index+']'" :value="(!item)?null:item.types">
                                                    <span class="required">@{{ errors.first('purchase_id['+index+']') }}</span>
                                                </td>
                                                @if(systemConfig()[7] != 0 )
                                                <td>
                                                    <span> @{{(!item)?null:item.factor_number}} </span>
                                                </td>
                                                <td>
                                                    <span> @{{(!item)?null:item.other_vehicle_name}} </span>
                                                </td>
                                                <td>
                                                    <span> @{{(!item)?null:item.rent_quantity}} </span>
                                                </td>
                                                <td>
                                                    <span> @{{(!item)?null:item.loading_date}} </span>
                                                </td>
                                                @endif
                                                <td>
                                                    <input type="text" :name="'purchase_currency['+index+']'" readonly :value="(!item)?null:item.currency" class="form-control">
                                                </td>
                                                <td>
                                                    
                                                     <input type="number" :name="'purchase_rate['+index+']'" readonly :value="(!item)?null:item.rate" class="form-control">
                                                </td>
                                                <td>
                                                    
                                                     <input type="number" readonly :value="(!item)?null:item.amount" class="form-control">
                                                </td>
                                                <td>
                                                    
                                                     <input type="number" readonly :value="(!item)?null:item.remain_amount" class="form-control">
                                                </td>
                                                <!-- <td>
                                                    <input type="number" :name="'today_rate['+index+']'"  :value="(!item)?null:item.today_rate" class="form-control">
                                                </td> -->
												<td>
													<span v-if="index > 0" v-on:click="deleteItem('payment',index,index)">
													<i class="paddint-both glyphicon glyphicon-trash"></i></span>
												</td>
                                            </tr>



                                        </tbody>
                                    </table>


                                </div>
                            </div>
                            <div v-if="no_bill_msg" style="color: red;text-align:center;font-weight:bold">
                                @{{no_bill_msg}}
                            </div>
                            <!-- end payments -->
                        </div>
                        <!-- begin member summary -->
                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                            <div class="col-lg-12 col-md-12 col-sm-12" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px;margin-bottom: 1em; padding-top: 20px;">
                                <div class="panel panel-defult">
                                    <div class="panel-body">
                                        <table class="table table-bordered">
                                            <thead>
                                                <tr>
                                                    <th class="text-center">@lang('layout.Currency') </th>
                                                    <th class="text-center">@lang('layout.Payable')</th>
                                                    <th class="text-center">@lang('layout.Receivable')</th>
                                                    <th class="text-center">@lang('layout.AverageRate')</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <span v-if="selectedMember">
                                                    <tr v-for="summ in summary">
                                                        <td class="highlight text-center">
                                                            @{{ summ.currency }}
                                                        </td>
                                                        <td class="text-center"> 
                                                            @{{ format_number(Number(summ.payment)) }}
                                                        </td>
                                                        <td class="text-center">
                                                            @{{ format_number(Number(summ.invoice)) }}
                                                        </td>
                                                        <td class="text-center">
                                                            @{{format_number(Number(summ.rate))}}
                                                        </td>
                                                    </tr>
                                                </span>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                                <div class="panel panel-success" v-if="temp_items.length>0">
                                    <div class="panel-body">
                                        <table class="dashboard-tabel" width="100%">
                                            <tr>
                                                <td>
                                                    <small>@lang('layout.Total') @lang('layout.Amount') :</small>
                                                </td>
                                                <td >
                                                    <h4>@{{myRound(amount)}} @{{selectedCurrency.symbol}}</h4>
                                                </td>
                                            </tr>
                                            <tr style="color: rgb(84, 199, 211)">
                                                <td>
                                                    <small>@lang('layout.Total') @lang('layout.Factor') :</small>
                                                </td>
                                                <td class="text-right">
                                                    <h4>@{{myRound(sub_Subtotal)}} @{{selectedCurrency.symbol}}</h4>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <small>@lang('layout.Total') @lang('layout.Remain') @lang('layout.Factor') :</small>
                                                </td>
                                                <td class="text-right">
                                                    <span data-counter="counterup" data-value="7800">
                                                        @{{myRound(sum_remain)}}
                                                    </span>
                                                    <small class="font-green-sharp">
                                                        @{{selectedCurrency.symbol}}
                                                    </small>
                                                </td>
                                            </tr>
                                        </table>
                                    </div>
                                </div>
                                <div class="panel panel-success" v-if="temp_items.length>0">
                                    <div class="panel-body" style="text-align: center">
                                        <div v-if="underpayment<0" style="color: red; font-weight:bold">
                                            @lang('layout.Underpayment')<h3>@{{myRound(underpayment)}} @{{selectedCurrency.symbol}}</h3>
                                        </div>
                                        <div v-else  style="color: green; font-weight:bold">
                                            @lang('layout.Underpayment')<h3>@{{myRound(underpayment)}} @{{selectedCurrency.symbol}}</h3>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-12">
                    <div class="row">
                        <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                            {{-- <input v-if="isError ==false" type="submit" value="submit" class="btn green" > --}}
                            <button v-if="isError ==false" type="button" class="btn green"
                            :disabled="disabled" @click="saveAndNew($event)">@lang('layout.Submit')</button>
                            <button v-if="isError ==false" type="button" class="btn blue"
                            :disabled="disabled" @click="saveAndNew($event,'new')">@lang('layout.SaveAndNew')</button>
                            <a href="{{route('payByFactor.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                        </div>
                    </div>
                </div>
                {!! Form::close() !!}
            </div>
            <!-- END FORM-->
        </div>
    </div>
@endsection

@push('scripts')
<script src="{{URL::asset('assets/global/plugins/bootstrap-timepicker/js/bootstrap-timepicker.min.js')}}" type="text/javascript"></script>
<script src="{{URL::asset('assets/pages/scripts/components-date-time-pickers.min.js')}}" type="text/javascript"></script>
<script>

    @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
    Vue.use(VeeValidate, {
        locale: 'en',
    });
    @endif

	Vue.component("v-select", VueSelect.VueSelect);
    Vue.use(VueNumeric.default)

	var currency ={!! $currency !!};
    var homeCurrency = {!! json_encode(getHomeCurrency()) !!};
    var code = '{!! getHomeCurrency()['code'] !!}';
    var banks ={!! $banks !!};
	var Banks ={!! $banks !!};
	var one = defaultCurrency();
	

	var vm = new Vue({
		el:'#app',
		data:{
            dynamic_time:'',
			selectedCurrency: one,
			currency:{!! json_encode(getCurrencies()) !!},
			bankes: {!! $banks !!},
			amount: null,
			defaultAmount: 0,
			defaultAccount: 0,
            selected_rate: 1,
            sum_remain: 0,
            code: code,
			currency_len: 'col-md-12',
			rate_len: 'col-md-0',
            exchange_amount: null,
			number: "{{$number}}",
			memberClass:{!! $memberClass  !!},
			selected_class:null,
			member:[],
			selectedMember: null,
            currency:currency,
			summary: [],
            disabled: false,
            averageRate: false,
            isError: false,
            paymentData:[
            {factor:null,  payments:[]}
            ],
            temp_items: [],
            selectedAll:false,
            no_bill_msg:null,
            underpayment:0

		},
		computed: {
			accountUpdate() {
				var b = _.clone(Banks)
				var test = this.accounts = b.filter((account) => {
					return (new RegExp(this.selectedCurrency.code.toLowerCase())).test(account.code.toLowerCase())
				})
                if (test.length > 0) {
				this.defaultValue = test[0].id;
				for (var x in this.bankes) {
					for (z in this.bankes[x]) {
						if (this.bankes[x][z] == this.defaultValue && z == 'id') {
							this.selectedBank = this.bankes[x];
							this.defaultAccount = this.defaultValue;
                            this.averageRate = false;
                            @if(getAverageRate() =="true")
                            if (this.bankes[x].avg_rate) {
                                this.set_avg_rate(this.bankes[x].avg_rate);
                            }
                            @endif
							break;
						}
					}
				}
                }else{
                    this.selectedBank = null;
                }
				return test;
			},

            // calculate subtotal
            sub_Subtotal: function() {
                var sum = 0;
                var sum_remain = 0;
                for (var i = 0; i < this.temp_items.length; i++) {
                    if (this.temp_items[i] && this.temp_items[i] != null && this.temp_items[i]['selected'] ==true) {
                        var rate = this.temp_items[i]['rate'];
                        var amount = this.temp_items[i]['amount'];
                        
                        var remain_amount = this.temp_items[i]['remain_amount'];

                        if (rate > 0 && amount > 0) {
                            sum += (amount / rate) * this.selected_rate;
                        } 

                        if (rate > 0 && remain_amount > 0) {
                            sum_remain += (remain_amount / rate) * this.selected_rate;
                        } 
                    }
                }
                this.sum_remain = sum_remain;
                this.underpayment = this.amount-sum_remain;
                
                return sum;
            },
		},
        mounted: function () {

            this.dynamicTime()
            // console.log(123, selected_banks, selected_currency);
        },
		methods:{
            //BEGIN - Used for dynamic input time
            dynamicTime()
                        {
                            this.time_interval = setInterval(() => {
                                const now = new Date()
                                @if(getHourType() == 24)
                                    const hours = now.getHours().toString().padStart(2,'0')
                                    const minutes = now.getMinutes().toString().padStart(2,'0') 
                                    // const seconds = now.getSeconds().toString().padStart(2,'0')
                                    this.dynamic_time = `${hours}:${minutes}`
                                @else
                                    const timeString = now.toLocaleTimeString('en-US',{hour:'numeric',minute:'numeric',hour12:true});
                                    this.dynamic_time = `${timeString}`
                                @endif
                                
                            },1000);
                        },
                        stopDynamicTime()
                        {
                            clearInterval(vm.time_interval)
                        },
                        changeTime()
                        {
                            vm.dynamic_time = vm.$refs.time_input.value
                        },
                    //END - Used for dynamic input time
            set_avg_rate(avg_rate) {
                let vv = this;
                setTimeout(() => {
                    vv.averageRate = true;
                    vv.selected_rate = avg_rate;
                }, 300);
            },
            
            memberClassChange() {
                if (vm.selected_class) {
                    vm.member = [];
                    vm.selectedMember = null;
                    let class_id = vm.selected_class.id;
                
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'SearchMember',
                            class_id: class_id
                        }
                    })
                    .then(function(response) {
                        if (response.data.length > 0) {
                            vm.member = [];
                            vm.member = response.data;
                        }
                    })
                    .catch(function(error) {
                        console.log(error);
                    })
                }
            },
            MemberSearch: _.debounce((search, loading) => {
                loading(true);
                let class_id = (vm.selected_class != undefined) ? vm.selected_class.id : null;
                
                axios.get("{{route('callMethod.search')}}", {
                    params: {
                        method_name: 'SearchMember', 
                        keyword: search,
                        class_id: class_id
                    }
                })
                .then(function(response) {
                    if (response.data.length > 0) {
                        vm.member = [];
                        vm.member = response.data;
                    }
                    loading(false);
                })
                .catch(function(error) {
                    loading(false);
                    console.log(error);
                })
            }, getDebounceTime()),
			setSize(selected_code) {
                    // this.paymentCurrency = this.selectedCurrency;
                    this.selected_rate = this.selectedCurrency.exchange_rate;
                    // this.selected_rate1 = this.selectedCurrency.exchange_rate;
                    if (selected_code == this.code) {
                        this.currency_len = 'col-md-12';
                        this.rate_len = 'col-md-0';
                    }
                    else {
                        this.currency_len = 'col-md-6';
                        this.rate_len = 'col-md-6';
                    }
                    this.pcurrency_len = this.currency_len;
                    this.prate_len = this.rate_len;
            },
			getSummary()
			{
	            if (this.selectedMember && this.selectedCurrency) {
	                this.getSummaryRecor(this.selectedMember.id, this);
                    // get member bills,factor
                    let member_id=this.selectedMember.id;
                    let code=this.selectedCurrency.code;
                    axios.get("{{route('payByFactor.getMemberFactor')}}", {
                        params: {
                            member_id:member_id,
                            code:code,
                        }
                    })
                    .then(function (response) {
                        vm.temp_items = [];
                        if (response.data.length > 0) {
                            vm.temp_items = response.data;
                        }
                    })
                    .catch(function (error) {
                        console.log(error);
                        
                    })
                    // end of bill,factor

	            }

	        },
            getSummaryRecor(id, vm)
            {
                axios.get("{{route('callMethod.search')}}", {
                    params: {
                        method_name: 'memberStatment',
                        member_id: id,
                    }
                })
                .then(function (response) {

                    if (response.data.length > 0) {
                        vm.summary = response.data;
                    }
                })
                .catch(function (error) {
                    console.log(error);
                });
            },
            toggleCheck(index){
                this.temp_items[index].selected=!this.temp_items[index].selected;
            },
            selectAll(e){
                for(var i=0;i<this.temp_items.length;i++){ 
                    if(this.selectedAll==true){
                        this.temp_items[i].selected=true;
                    }
                    else{
                        this.temp_items[i].selected=false;
                    }
                }
            },
            checkRefPaymentByFactor(e)
            {
                var ref=e.target.value;
                axios.get("{{route('callMethod.search')}}",
                {
                    params: {
                        ref_no: ref,
                        method_name: 'Search_ref_no',
                        table_name: 'payment_by_factors'
                    },
                })
                .then(function (response) {
                    if (response.data.result != null) {
                        let msg = "@lang('layout.DuplicateData')";
                        $('#ref_msg').html(msg);
                    }
                    else {
                        vm.msg = 'no';
                        $('#ref_msg').html('');

                    }
                })
                .catch(function (error) {
                    console.log(error);
                });
            },
            // check ref
            checkRef(e,index,payment_index)
            {
                var ref=e.target.value;
                axios.get("{{route('callMethod.search')}}",
                {
                    params: {
                        ref_no: ref,
                        method_name: 'Search_ref_no',
                        table_name: 'payments'
                    },
                })
                .then(function (response) {
                    if (response.data.result != null) {
                        let msg = "@lang('layout.DuplicateData')";
                        $('#pay_'+index).html(msg);
                    }
                    else {
                        vm.msg = 'no';
                        $('#pay_'+index).html('');
                    }
                })
                .catch(function (error) {
                    console.log(error);
                });
            },
            //  get factors
            onFactorSearch: _.debounce((search, loading) => {

                if(vm.selectedMember && vm.selectedCurrency)
                {
                    let member_id=vm.selectedMember.id;
                    let code=vm.selectedCurrency.code;

                    axios.get("{{route('payByFactor.getMemberFactor')}}", {
                        params: {
                            member_id:member_id,
                            code:code,
                            search_keyword:search
                        }
                    })
                    .then(function (response) {
                        vm.temp_items = [];
                        vm.no_bill_msg = null;
                        if (response.data.length > 0) {
                            vm.temp_items = response.data;
                        }
                        else
                        {
                            vm.no_bill_msg = "{{__('message.NoBillMsg')}}";
                        }
                    })
                    .catch(function (error) {
                        console.log(error);
                    })
                }
                // else
                // {
                //     alert("{{__('layout.SelectMember')}}");
                // }
            }, getDebounceTime()),

            get_exchange() {
                let vm = this;
                if(vm.selected_rate > 0){
                    vm.exchange_amount = myRound(vm.amount / vm.selected_rate);
                }
            },
            set_rate() {
                let vm = this;
                if(vm.exchange_amount > 0){
                    vm.selected_rate = myRound(vm.amount / vm.exchange_amount);
                }
            },

            // delete item from list
            deleteItem(type = null, index,payment_index) {
                if (type != null) {
                    if (type == 'payment') {
						this.temp_items.splice(index, 1);
                    }
                }
            },

            // save or new
            saveAndNew(e,type=null) 
            {
                
                this.$validator.validate()
                    .then(valid => {
                        if (valid) {
                            vm.disabled = true;
                            var url = "{{route('payByFactor.store')}}";
                            
                            var data = $('#payByFactor-form').serialize();
                            axios.post(url, data)
                                .then(function (response) {
                                   
                                    if (response.data.result == 1) {
                                        $('#payByFactor-form').trigger('reset');
                                        toastr.success('', response.data.message);

                                        if(type==null)
                                        {
                                            window.location.href="{{route('payByFactor.index')}}"
                                        }
                                        else
                                        {
                                            vm.paymentData=[
                                            {factor:null,
                                            payments:[
                                            ]}
                                            ];
                                            vm.temp_items= [];
                                            vm.selectedMember=null;
											location.reload();
                                        }
                                       
                                    }
                                    else {
                                        vm.disabled = false;
                                        var message = "{{__('message.Warning')}}";
                                        //$('#error-sound')[0].play();
                                        toastr.warning('', message);
                                    }

                                    
                                    
                                })
                                .catch(function (error) {
                                    vm.disabled = false;
                                    console.log(error);
                                    var message = "{{__('message.Warning')}}";
                                    //$('#error-sound')[0].play();
                                    toastr.warning('', message);
                                });

                        }
                    })
            },
            test(defaultAccount) {
                for (var x in this.bankes) {
                    for (z in this.bankes[x]) {
                        if (this.bankes[x][z] == defaultAccount && z == 'id') {
                            this.selectedBank = this.bankes[x];
                            this.averageRate = false;
                            @if(getAverageRate() =="true")
                            if (this.bankes[x].avg_rate) {
                                this.set_avg_rate(this.bankes[x].avg_rate);
                            }
                            @endif
                            break;
                        }
                    }

                }

            },
		}

	});
</script>
@endpush
