@extends('layouts.app')

@section('content')


    <div class="row">
        <div class="portlet light bordered sale">
            <div class="portlet-body">
                <div class="tabbable tabbable-tabdrop">
                    <ul class="nav nav-tabs mytabs" id="mytabs">

                        <?php
                        $counter = 0;
                        ?>
                        @foreach($buildPackages AS $rec)

                            @if (($loop->index)<5)
                                <li class="my-list">
                                    <a href="#tab{{$rec->build_id}}" id="{{$rec->build_id}}"
                                       data-toggle="tab">{{$rec->name}}</a>
                                </li>

                            @endif
                            @if (($loop->index)>=5)
                                <?php
                                $counter++;
                                if($counter == 1)
                                {
                                ?>
                                <li class="dropdown">
                                    <a href="javascript:;" id="myTabDrop1" class="dropdown-toggle"
                                       data-toggle="dropdown"> @lang('layout.OtherSites')
                                        <i class="fa fa-angle-down"></i>
                                    </a>
                                    <ul class="dropdown-menu" role="menu" aria-labelledby="myTabDrop1">
                                        <?php
                                        }
                                        ?>

                                        <li>
                                            <a href="#tab{{$rec->build_id}}" id="{{$rec->build_id}}"
                                               data-toggle="tab">{{$rec->name}}</a>
                                        </li>
                                        <?php
                                        if($loop->last)
                                        {
                                        ?>
                                    </ul>
                                </li>
                                <?php
                                }
                                ?>

                            @endif


                        @endforeach
                    </ul>
                    <!-- template for the modal component -->
                    <div class="tab-content">
                        @foreach($buildPackages AS $key=>$rec)

                            <div class="tab-pane" id="tab{{$rec->build_id}}">

                                <div class="page-toolbar">
                                    <div class="pull-right">
                                    </div>
                                </div>
                                <div class="portlet-body">
                                    <div class="table-scrollable">
                                        <table class="table table-striped table-bordered table-advance table-hover">
                                            <thead>
                                            <tr>
                                                <th>
                                                    <i class="fa  fa-bars"></i> @lang('layout.BuildNumber')
                                                </th>
                                                <th class="hidden-xs">
                                                    <i class="fa fa-briefcase"></i> @lang('layout.ItemName')
                                                </th>
                                                <th class="hidden-xs">
                                                    <i class="fa  fa-user"></i> @lang('layout.CreatedBy')
                                                </th>
                                                <th>
                                                    <i class="fa fa-shopping-cart"></i> @lang('layout.Quantity')
                                                </th>
                                                <th>
                                                    <i class="fa fa-shopping-cart"></i> @lang('layout.Measure')
                                                </th>
                                                <th>
                                                    <i class="fa "></i> @lang('layout.Cost')
                                                </th>
                                                <th>
                                                    <i class="fa "></i> @lang('layout.TotalExpense')
                                                </th>
                                                <th>
                                                    <i class="fa "></i> @lang('layout.Expense')
                                                </th>
                                                <th>
                                                    <i class="fa "></i> @lang('layout.CostWithExpenses')
                                                </th>
                                                <th>
                                                    <i class="fa "></i> @lang('layout.UnitCost')
                                                </th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            <tr>
                                                <td class="hidden-xs"> {{ $rec->b_number}}  </td>
                                                <td class="hidden-xs"> {{ $rec->name}}  </td>
                                                <td class="hidden-xs"> {{ $rec->username }}  </td>
                                                <td class="hidden-xs"> {{ $rec->qty }}  </td>
                                                <td class="hidden-xs"> {{ $rec->symbol }}  </td>
                                                <td class="hidden-xs"> {{ $rec->cost*$rec->qty}}  </td>
                                                <td class="hidden-xs"> {{ $rec->expense_amount}}  </td>
                                                <td class="hidden-xs"> {{ $rec->expense_cost}}  </td>
                                                <td class="hidden-xs"> {{ ($rec->cost*$rec->qty)+$rec->expense_amount}}  </td>
                                                <td class="hidden-xs"> {{ ($rec->cost)+$rec->expense_cost}}  </td>
                                            </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                                <table id="my_table_{{$rec->build_id}}"
                                       class="table table-striped table-bordered my-generic-table" cellspacing="0"
                                       width="100%">
                                    <thead>
                                    <tr>
                                        <th>@lang('layout.ItemName')</th>
                                        <th>@lang('layout.BuildNumber')</th>
                                        <th>@lang('layout.Date')</th>
                                        <th>@lang('layout.Quantity')</th>
                                        <th>@lang('layout.MeasureName')</th>
                                        <th>@lang('layout.Total')</th>
                                    </tr>
                                    </thead>
                                </table>
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@push('scripts')
    <script>
        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            var p1 = $('.nav.nav-tabs.mytabs .my-list a');

            p1[0].click();

        });


        var my_table = 0;
        $(document).on("click", "#mytabs li", function (event) {
            var myid = event.target.id;
            if (myid != 'default') {
                if (my_table != 0) {
                    my_table.destroy();
                }
                console.log('sss', myid);
                my_table = $('#my_table_' + myid).DataTable({
                    ajax: {
                        url: '{{route("buildPackage.info")}}',
                        data: {build_id: myid}
                    },
                    scrollCollapse: false,
                    responsive:'{{responsiveDataTable()}}',
                    pagingType:'{{paginationType()}}',
                    paging: true,
                    serverSide: true,
                    autoWidth: false,
                    columns: [
                        {data: 'Name', name: 'items.name'},
                        {data: 'Build_Number', name: 'builds.number'},
                        {data: 'Date', name: 'Date', orderable: false, searchable: false},
                        {data: 'Quantity', name: 'Quantity', orderable: false, searchable: false},
                        {data: 'Measure', name: 'Measure', orderable: false, searchable: false},
                        {data: 'Cost', name: 'Cost', orderable: false, searchable: false},
                    ]
                });
            }
            else {
            }

        });

    </script>

@endpush 