@extends('layouts.factor-master')

@section('content')

<?php
$report = customeReport('build');
$_date = in_array('date', $report);
$_build_number = in_array('build_number=', $report);
$_item_name = in_array('item_name', $report);
$_measure = in_array('measure', $report);
$_quantity = in_array('quantity', $report);
$_purchase_rate = in_array('purchase_rate', $report);
$_TotalExpense = in_array('_TotalExpense', $report);

?>
<h4></h4>
<h4 class="table-caption" style="text-align: center;">@lang('layout.GeneralPackageBuild')</h4>
<table class="main-table">
  <thead>
    <tr>
      <td  class="center" >
        <div >  @lang('layout.Record') </div>
      </td>
      <td  class="center" >
        <div > @lang('layout.Number') </div>
      </td>
      @if($_date)<td  class="center" >
        <div > @lang('layout.Date')</div>
      </td>@endif
      @if($_item_name)<td  class="center" >
        <div > @lang('layout.Description')</div>
      </td>@endif
      <td class="center">@lang('layout.OutItems')</td>
      <td class="center">@lang('layout.InItems')</td>
    </tr>
  </thead>
  <?php
  $count = 0;
  $totalCost = 0;
  $allBuildDetailIn = 0;
  $allBuildDetailOut = 0;

  $BuildIn = 0;
  $BuildOut = 0;
  ?>
  <tbody>
    @foreach($data AS $record)
    <?php
    // $totalCost+=$record['Cost'];
    $allBuildDetailIn = $record['allBuildDetailIn'];
    $allBuildDetailOut = $record['allBuildDetailOut'];
    $category = [];
    ?>
    <tr>
      <td class="center">{{++$count}}</td>
      <td class="center">{{$record['number']}}</td>
      @if($_date)<td class="center">{{convertDate($record['date'])}}</td>@endif
      @if($_item_name)<td class="center">{{$record['description']}}</td>@endif
      <td width="35%">
        <table class="main-table" style="width:100%">
          <tr class="bg">
            <td width="15%">
              <div class="center"> @lang('layout.BuildNumber') </div>
            </td>
            <td width="25%">
              <div class="center"> @lang('layout.ItemName') </div>
            </td>
            <td width="30%">
              <div class="center"> @lang('layout.BaseUnit') </div>
            </td>
            <td width="30%">
              <div class="center"> @lang('layout.Quantity') </div>
            </td>
          </tr>
          <?php
          $totalOut = 0;
          ?>
          @foreach($allBuildDetailOut AS $row)
          <?php
          $totalOut += $row['quantity'];
          $BuildOut += $row['quantity'];
          ?>
          <tr>
            <td class="center">{{$row['number']}}</td>
            <td class="center">{{$row['item_name']}}</td>
            <td class="center">{{myRound($row['quantity_base'])}} ({{$row['Symbol_base']}})</td>
            <td class="center">{{myRound($row['quantity'])}} ({{$row['Symbol']}})</td>
          </tr>
          @endforeach
          <tr>
            <td class="center" colspan="2">@lang('layout.Total')</td>
            <td class="center" colspan="2">{{$totalOut}}</td>
          </tr>
        </table>
      </td>

      <td width="35%">
        <table class="main-table" style="width:100%">
          <tr class="bg">
            <td width="20%">
              <div class="center"> @lang('layout.BuildNumber') </div>
            </td>
            <td width="30%">
              <div class="center"> @lang('layout.ItemName') </div>
            </td>
            <td width="25%">
              <div class="center"> @lang('layout.BaseUnit') </div>
            </td>
            <td width="25%">
              <div class="center"> @lang('layout.Quantity') </div>
            </td>
          </tr>
          <?php
          $totalIn = 0;
          $totalInss = 0;
          $category = [];
          foreach ($allBuildDetailIn as $valuuu) {
            $totalInss += $valuuu['quantity'];
          }
          ?>
          @foreach($allBuildDetailIn AS $row)
          <?php
          if (array_key_exists($row->category_name, $category)) {
              $category[$row->category_name] = $category[$row->category_name] + $row['quantity'];
          } else {
              $category[$row->category_name] = $row['quantity'];
          }
          $totalIn += $row['quantity'];
          $BuildIn += $row['quantity'];
          ?>
          <tr>
            <td class="center">{{$row['number']}}</td>
            <td class="center">{{$row['item_name']}}</td>
            <td class="center">{{myRound($row['quantity_base'])}} ({{$row['Symbol_base']}})</td>
            <td class="center">{{myRound($row['quantity'])}} ({{$row['Symbol']}})</td>
          </tr>
          @endforeach
          <tr>
            <td class="center" colspan="2">@lang('layout.Total')</td>
            <td class="center" colspan="2">{{$totalIn}}</td>
          </tr>
        </table>
      </td>
    </tr>
    @endforeach
    <tr class="bg">
      <td colspan="4">
        <!-- <div class="center">@lang('layout.Total'): {{round($totalCost,2)}}{{getHomeCurrency()["code"]}}</div> -->
      </td>
      <td width="35%"><center>@lang('layout.OutItems'): {{$BuildOut}} </center></td>
      <td width="35%"><center>@lang('layout.InItems'): {{$BuildIn}} </center></td>
      
    </tr>
  </tbody>
</table>

<!--  signature -->
<table style="width: 100%" class="signtable">
  <tr>
    @foreach(getCompanyInfo('sign','reports') AS $info)
    <td style="text-align: left; width:40%">
      <table>

        <tr>
          <td align="right" class="signsize">{{$info['name']}}</td>
        </tr>

      </table>
    </td>
    @endforeach
  </tr>
</table>
<!-- End signature -->
@endsection