@extends('layouts.app')


@section('style')
    <link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">

@stop

@section('content')
    <div class="row">

        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.UpdateBuildPackage')</span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools">
                    <a href="" class="collapse" data-original-title="" title=""> </a>
                    <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
                    <a href="" class="reload" data-original-title="" title=""> </a>
                    <a href="" class="remove" data-original-title="" title=""> </a>
                </div>
            </div>
            <div class="portlet-body form" style="margin-bottom:50%;" id="assembaly">
                <!-- BEGIN FORM-->
                {!! Form::open(array('route' => 'buildPackage.store','method'=>'POST','class'=>'form-horizontal')) !!}
                {{ csrf_field() }}
                <div class="form-body">
                    <div class="col-md-12">


                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                            <div class="form-group">
                                <div class="col-md-12">
                                    <label class="control-label">@lang('layout.Number')</label>


                                    <input type="number" name="number" class="form-control"
                                           value="{{$package->number}}">
                                </div>
                            </div>
                        </div>

                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                            <div class="form-group">
                                <div class="col-md-12">
                                    <label class="control-label">@lang('layout.Date')</label>


                                    <input type="text" name="date" class="form-control date" value="{{$package->date}}">
                                </div>
                            </div>
                        </div>

                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                            <div class="form-group">
                                <div class="col-md-12">
                                    <label class="control-label">@lang('layout.Description')</label>


                                    <textarea class="form-control" rows="3"
                                              name="description">{{$package->description}}</textarea>
                                </div>
                            </div>
                        </div>


                    </div>

                    <div class="col-md-12 col-lg-12" v-if="package_data">
                        <!-- begin package data loop -->

                        <div v-for="(p_data,p_index) in package_data" class="row"
                             style="border:3px solid white;margin-top: 10px;margin-bottom: 15px; box-shadow: 10px 10px 5px #aaaaaa ">
                            <span style="font-size: 30px; float: <?=(session()->get("system_direction") == "rtl") ? 'right' : 'left'?>"> @{{p_index+1}}</span>
                            <span style="font-size: 30px; float: <?=(session()->get("system_direction") == "rtl") ? 'left' : 'right'?>">
                                      <span v-if="p_index > 0" v-on:click="deleteItem('package',p_index)"><i
                                                  class="paddint-both glyphicon glyphicon-trash"></i></span>
                                </span>
                            <div class="col-md-12">
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label class="control-label"> @lang('layout.ItemName')</label>
                                        <v-select label="name" v-model="p_data.item" :options="items"
                                                  @input="getItemFormula(this,p_index)"
                                                  @search="onItemSearch"></v-select>

                                        <input type="hidden" name="assembly_item[]"
                                               :value="(!p_data.item)?null:p_data.item.item_id">

                                    </div>
                                </div>

                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label class="control-label"> @lang('layout.FormulaName')</label>
                                        <select class="form-control" v-model="p_data.selected_formula">
                                            <option>@lang('layout.Select')</option>
                                            <option v-for="formula in (p_data.formula_list==null)?null:p_data.formula_list"
                                                    :value="formula">@{{formula.code+'-'+formula.name}}
                                            </option>
                                        </select>
                                        <input type="hidden" name="formula[]"
                                               :value="(!p_data.selected_formula)?null:p_data.selected_formula.id">

                                    </div>
                                </div>

                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label class="control-label ">@lang('layout.SiteName')</label>

                                        <select :name="'site[]'" v-model="p_data.site"
                                                placeholder=" @lang('layout.SelectSite')" class="form-control">
                                            <option v-for="site_data in site" :value="site_data.id">
                                                @{{site_data.name}}
                                            </option>
                                        </select>


                                    </div>
                                </div>

                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label class="control-label ">@lang('layout.EnterQuantityToBuild')</label>

                                        <input type="number" placeholder="@lang('layout.EnterQuantityToBuild')"
                                               name="build_qty[]" v-model="p_data.build_qty" class="form-control">

                                    </div>
                                </div>

                            </div>

                            <div class="col-md-12" v-if="p_data.selected_formula && p_data.selected_formula !=null">
                                <table id="table_content"
                                       class="table table-bordered table-responsive table-full-width">
                                    <thead>
                                    <tr>
                                        <th class="text-center" style="width: 25px;"> #</th>
                                        <th class="text-center" style="min-width: 160px;"> @lang('layout.Item')</th>
                                        <th class="text-center" style="min-width: 120px;"> @lang('layout.Measure')</th>
                                        <th class="text-center hidden-print"
                                            style="min-width: 80px;"> @lang('layout.Formula')</th>
                                        <th class="text-center hidden-print"
                                            style="min-width: 80px;"> @lang('layout.OnHand')</th>

                                    </tr>
                                    </thead>
                                    <tbody>
                                    <tr v-for="(item,index) in p_data.selected_formula.formula">
                                        <td class="td_one"><span class="badge badge3 badge-success badge-roundless"> @{{index+1}} </span>
                                        </td>
                                        <td class="">
                                            <input type="hidden" :name="'item_ids['+p_index+'][]'"
                                                   :value="(!item.item_id)?null:item.item_id">
                                            <span> @{{item.item_name}} </span>
                                        </td>
                                        <td>
                                            <select v-if="item" v-model="(!item)?null:item.measure"
                                                    @change="measureChange(index)" class="form-control input_style"
                                                    placeholder="Measure"

                                                    required="required" disabled>

                                                 <span v-if="item.measure_list !=null">
                                                      <option v-if="(item !=null)"
                                                              v-for="measures in item.measure_list"
                                                              :value="measures">@{{ measures.measure_name }}</option>
                                                 </span>
                                            </select>

                                            <input type="hidden" :name="'inventory_measure['+p_index+'][]'"
                                                   :value="(!item)?null:(item.measure)?item.measure.measure_id:null">
                                        </td>
                                        <td class="hidden-print">
                                            <input type="number" :name="'item_quantity['+p_index+'][]'"
                                                   v-model="(!item)?null:item.new_quantity">
                                        </td>
                                        <td class="hidden-print">
                                            <!-- <input readonly type="number"  :value="(!item)?null:item.on_hand"> -->
                                            <!-- <input readonly type="number"  :value="(!item)?null:item.on_hand">  -->
                                            <input readonly type="number"
                                                   :value="(!item)?null:buildItemQuantity(item.item_item_measure.measure_unit,item.measure.measure_unit,item.new_quantity,item.on_hand,p_data.build_qty)">
                                        </td>
                                    </tr>
                                    </tbody>
                                </table>
                            </div>
                            <hr>

                            @lang('layout.AdjastmentItems')
                            <div v-if="p_data.selected_formula && p_data.selected_formula !=null" class=""
                                 id="printarea" style="overflow-x: scroll;">
                                <table id="table_content" class="table table-bordered">
                                    <thead>
                                    <tr>
                                        <th class="text-center" style="width: 25px;"> #</th>
                                        <th class="text-center" style="min-width: 160px;"> @lang('layout.ItemName')</th>
                                        <th class="text-center" style="min-width: 120px;"> @lang('layout.Measure')</th>
                                        <th class="text-center" style="min-width: 80px;"> @lang('layout.Quantity')</th>
                                        <th class="text-center" style="min-width: 80px;"> @lang('layout.Cost')</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <tr v-for="(item,index) in p_data.selected_formula.other_build">
                                        <td class="td_one"><span class="badge badge3 badge-success badge-roundless"> @{{index+1}} </span>
                                        </td>
                                        <td class="td_one">
                                            <input type="text" name="" :value="(!item.item_id)?null:item.item_name"
                                                   class="form-control" disabled="disabled">
                                            <input type="hidden" :name="'other_build_id['+p_index+'][]'"
                                                   :value="(!item.item_id)?null:item.item_id" class="form-control">


                                        </td>
                                        <td>
                                            <select v-if="item" v-model="(!item)?null:item.measure"
                                                    @change="measureChangeOtherBuild(index)"
                                                    class="form-control input_style"
                                                    placeholder="Measure"

                                                    required="required" disabled>

                                                           <span v-if="item.measure_list !=null">
                                                                <option v-if="(item !=null)"
                                                                        v-for="measures in item.measure_list"
                                                                        :value="measures">@{{ measures.measure_name }}</option>
                                                           </span>
                                            </select>


                                            <input type="hidden" :name="'other_build_measure['+p_index+'][]'"
                                                   :value="(!item)?null:(item.measure)?item.measure.measure_id:null">
                                        </td>


                                        <td>
                                            <input type="number" v-model="(!item)?null:item.new_quantity"
                                                   :name="'other_build_qty['+p_index+'][]'">
                                        </td>
                                        <td>
                                            <div class="input-group">
                                                <input type="number" class="form-control"
                                                       placeholder="%" style="min-width: 100px" readonly
                                                       :name="'other_build_cost['+p_index+'][]'"/>
                                                <span class="input-group-addon">%</span>
                                            </div>
                                        </td>
                                    </tr>
                                    </tbody>
                                </table>

                            </div>
                        <!--  <button v-if="assemlby_items.length <= 0 " type="button" class="btn default" @click="addItems('inventory')">@lang('layout.AddItem')
                                </button> -->

                            <hr>
                            @if(getBuildExpense() == "true")
                                @lang('layout.Expense')
                                <div v-if="p_data.selected_formula && p_data.selected_formula !=null" class=""
                                     id="printarea" style="overflow-x: scroll;">
                                    <table id="table_content" class="table table-bordered">
                                        <thead>
                                        <tr>
                                            <th class="text-center" style="width: 25px;"> #</th>
                                            <th class="text-center"
                                                style="min-width: 160px;"> @lang('layout.Expense')</th>
                                            <th class="text-center"
                                                style="min-width: 160px;"> @lang('layout.Description')</th>
                                            <th class="text-center"
                                                style="min-width: 120px;"> @lang('layout.Amount')</th>

                                        </tr>
                                        </thead>
                                        <tbody>
                                        <tr v-for="(item,index) in p_data.selected_formula.expense">
                                            <td class="td_one"><span class="badge badge3 badge-success badge-roundless"> @{{index+1}} </span>
                                                <input type="hidden" :name="'assembly_expense_id['+p_index+'][]'"
                                                       :value="(!item.id)?null:item.id" class="form-control">
                                            </td>
                                            <td class="td_one">


                                                <v-select label="name"
                                                          v-model="(!item.expense_account)?null:item.expense_account"
                                                          disabled></v-select>
                                                <input type="hidden" :name="'expense_id['+p_index+'][]'"
                                                       :value="(!item.expense_account)?null:item.expense_account.id"
                                                       class="form-control">

                                            </td>

                                            <td class="td_one">
                                                <input type="text" :name="'expense_description['+p_index+'][]'"
                                                       :value="(!item.description)?null:item.description"
                                                       class="form-control">

                                            </td>

                                            <td class="td_one">
                                                <input type="text" :name="'expense_amount['+p_index+'][]'"
                                                       :value="(!item.amount)?null:item.amount" class="form-control">

                                            </td>
                                        </tr>
                                        </tbody>
                                    </table>

                                </div>

                            @endif


                        </div>

                        <!-- end package data loop -->
                        <br>
                        <button type="button" @click="addNew('package',333)" class="btn btn-success"><i
                                    class="fa fa-plus"></i></button>
                    </div>

                </div>
                <div class="col-xs-12 col-sm-12 col-md-11 text-center">
                    <button @click="handleSubmit($event)" type="button"
                            class="btn green">@lang('layout.Submit')</button>
                    <a href="{{route('inventorySite.index')}}" class="btn default"><i
                                class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>

                </div>
                {!! Form::close() !!}
            </div>
            <!-- END FORM-->
        </div>
    </div>

@endsection
@push('scripts')

    <script>

        @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
        Vue.use(VeeValidate, {
            locale: 'en',
        });
        @endif

        Vue.component('v-select', VueSelect.VueSelect);
        var site ={!! $site !!};
        var packageData = {!! $packageData !!};
        var sales = new Vue({
            el: '#assembaly',
            data: {
                site: site,
                selected_site: null,
                selected_item: null,
                buildQty: null,
                assembly_item: [],
                temp_items: [],
                items: [],
                formula_list: [],
                selected_formula: null,
                package_data: [],
                packageData: packageData,
                flag: null
            },

            computed: {
                buildQ: function () {
                    var min = null;
                    if (this.selected_formula) {
                        var rows = this.selected_formula.formula;

                        if (rows.length > 0) {
                            var temp = ((rows[0].new_quantity * rows[0].measure.measure_unit / rows[0].measure_unit));

                            //var temp_other_build=this.selected_formula.other_build;
                            min = rows[0].on_hand / temp;


                            for (var i = 1; i < rows.length; i++) {

                                var temp = ((rows[i].new_quantity * rows[i].measure.measure_unit / rows[i].measure_unit));
                                var result = (rows[i].on_hand * rows[i].item_item_measure.measure_unit) / (rows[i].measure.measure_unit);

                                if (result / temp < min) {
                                    min = result / temp;
                                }

                            }
                            min = min.toFixed(precision());

                        }

                    }
                    return min;
                },
                isError: function () {
                    var isError = false;

                    return isError;
                },
            },
            mounted: function () {
                for (var i = 0; i < this.packageData.length; i++) {
                    var item = this.packageData[i].buildSelectedItem;
                    var build_qty = this.packageData[i].build_qty;
                    var f_list = this.packageData[i].buildFormulaList;
                    var s_formula = null;
                    var s_site = this.packageData[i].selectedSite.id;
                    console.log('ddd', this.packageData[i].selectedSite.id);
                    for (var m = 0; m < f_list.length; m++) {
                        if (f_list.id == this.packageData[i].build.assembaly_id) {
                            s_formula = f_list[m];
                        }
                    }
                    this.package_data.push({
                        item: item,
                        build_qty: build_qty,
                        formula_list: f_list,
                        selected_formula: s_formula,
                        site: s_site
                    });
                }
            },
            methods: {
                handleSubmit(e) {
                    this.$validator.validate().then(valid => {
                        if (valid) {
                            // alert(e.target);
                            regForm(e.target);
                        }
                    });
                },

                // calculate item price based on measure change
                measureChange(index) {

                    if (this.selected_formula) {

                        var item = this.selected_formula.formula[index];
                        var temp = ((item.quantity * item.measure_unit / item.measure.measure_unit));
                        result = Number.parseFloat(temp).toFixed(precision());

                        this.selected_formula.formula[index].new_quantity = result;


                    }
                },
                measureChangeOtherBuild(index) {
                    if (this.selected_formula) {
                        var item = this.selected_formula.other_build[index];
                        var temp = ((item.quantity * item.measure_unit / item.measure.measure_unit));
                        result = Number.parseFloat(temp).toFixed(precision());

                        this.selected_formula.other_build[index].new_quantity = result;
                    }
                },
                getItemFormula(e, index) {
                    if (this.flag > 1) {
                        if (this.package_data[index] && this.package_data[index].item != null) {
                            this.formulaSearch(this.package_data[index].item.item_id, this, index);
                        }
                    }

                },


                //ajax call to get items
                onItemSearch: _.debounce((search, loading) => {
                    sales.formula_list = [];
                    sales.selected_formula = null;
                    loading(true);
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'assemblyList',
                            keyword: search,
                        }
                    })
                        .then(function (response) {
                            sales.items = [];
                            if (response.data.length > 0) {
                                sales.items = response.data;
                                console.log('sssss', sales.items);
                            }
                            loading(false);
                        })
                        .catch(function (error) {
                            console.log(error);
                        });
                }, getDebounceTime()),

                // end item search
                //ajax call to get formula
                formulaSearch(item_id, vm, index) {
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'item_formula',
                            item_id: item_id,
                        }
                    })
                        .then(function (response) {

                            if (response.data.length > 0) {
                                vm.package_data[index].formula_list = response.data;

                            }
                        })
                        .catch(function (error) {
                            console.log(error);
                        })
                },
                // end formula search
                // items serarch method
                onItemsSearch(search, loading) {
                    this.temp_items = [];
                    loading(true);
                    this.itemsSearch(search, loading, this);
                },
                itemsSearch(search, loading, vm) {
                    this.temp_items = [];
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'items_search_assebley',
                            'type': 'assembaly',
                            keyword: search,
                        }
                    })
                        .then(function (response) {
                            if (response.data.length > 0) {

                                vm.temp_items = response.data;
                            }
                            loading(false);
                        })
                        .catch(function (error) {
                            console.log(error);
                        });
                },

                addNew(type = null, index) {
                    if (type != null) {
                        if (type == 'package') {
                            if (this.package_data[index + 1] == undefined) {
                                this.package_data.push({
                                    item: null,
                                    build_qty: null,
                                    formula_list: [],
                                    selected_formula: null
                                },);
                            }
                        }
                        if (type == 'otherBuilds') {
                            if (this.otherBuild[index + 1] == undefined) {
                                this.otherBuild.push({item: null});
                            }
                        }

                    }

                },
                deleteItem(type = null, index) {
                    if (type != null) {
                        if (type == 'package') {
                            this.package_data.splice(index, 1);
                        }
                        if (type == 'otherBuild') {
                            this.otherBuild.splice(index, 1);
                        }
                    }

                },

                addItems(type) {
                    if (type != null) {
                        if (type == "otherBuilds") {
                            this.temp_items = [];
                            this.otherBuild.push({item: null});
                        }
                        if (type == "inventory") {
                            this.temp_items = [];
                            this.assemlby_items.push({item: null});
                        }
                    }

                },
            }
        });


    </script>


@endpush