@extends('layouts.app')
@section('style')
    <link rel="stylesheet" type="text/css" href="{{URL::asset('
ltr/assets/pages/css/profile-2.min.css')}}">
    <style type="text/css">
        .padding {
            padding: 0px;
        }
    </style>
@stop
@section('content')

    <div id="print-modal">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show"
                      :value-type="'memberTransferList'"
                      @closed="closeModal">
            <div slot="body">
                <input type="hidden" name="type" value="allDrawings"/>
                <input type="hidden" name="member_id" value="{{$owner->member_id}}"/>


                <div class="row">
                    <div class="form-group">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.Date')</label>
                                <div class="input-group">
                                    <input class="form-control date" id="range-from-example" name="from_date"
                                           autocomplete="off">

                                    <span class="input-group-addon"> @lang('layout.To') </span>
                                    <input class="form-control date" id="range-to-example" name="to_date">

                                </div>
                            </div>
                        </div>
                    </div>
                </div>    
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.Type')</label>
                                
                                <select name="report_type" v-model="report_type" class="form-control">
                                    <option value="">@lang('layout.SelectType')</option>
                                    <option value="drawing" >@lang('layout.Drawing')</option>
                                    <option value="investment">@lang('menu.Investment')</option>
                                </select>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </report-modal>
    </div>

    <div class="portlet">
        <div class="portlet-title" id="backbtn">
            <div class="caption">
                <i class=""></i>@lang('layout.OwnerInformation')
            </div>
            <div class="tools">
                <a href="javascript:;" class="collapse" data-original-title="" title=""> </a>
                <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
            </div>
        </div>
        <div class="portlet-body">
            <div class="tabbable-line tabbable-full-width">

                <div class="tab-content">
                    <div class="tab-pane active" id="tab_1_1">
                        <div class="row">
                            <div class="col-lg-12 col-md-12 col-sm-12" style="border-radius: 8px; padding: 0px 0px 0px 0px;">
                                <div style="display: flex;justify-content: start;">
                                    <div class="col-lg-6 col-md-12 col-sm-12 col-xs-12" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px;margin-left: 10px !important; padding: 10px;">
                                        <div style="display: flex;align-items: center;">
                                            <div title="{{$owner->name}}" class="twPc-avatarLink" style="margin-left: 10px; margin-right: 10px;">
                                                @if($owner->photo ==Null)
                                                    <img class="twPc-avatarImg" src="{{asset('uploads/avatar.png')}}"  style="width:150px; height:150px;border-radius: 50%;border: 5px solid rgb(80, 129, 141);">
                                                @else
                                                    <img class=" twPc-avatarImg" src="{!!url('/uploads/'.$owner->photo)!!}" style="width:150px; height:150px;border-radius: 50%;border: 5px solid rgb(80, 129, 141);">
                                                @endif
                                            </div>
                                            <table class="table table-bordered">
                                                <tr>
                                                    @if($owner->name)
                                                    <th><i class="fa fa-user"></i></th>
                                                    <td>{{$owner->name}}</td>
                                                    @endif
                                                </tr>
                                                <tr>
                                                    @if($owner->phone)
                                                    <th><i class="fa fa-mobile"></i></th>
                                                    <td>{{$owner->phone}}</td>
                                                    @endif
                                                </tr>
                                                <tr>
                                                    @if($owner->email)
                                                    <th><i class="fa fa fa-envelope"></i></th>
                                                    <td>{{$owner->email}}</td>
                                                    @endif
                                                </tr>
                                                <tr>
                                                    @if($owner->city)
                                                    <th><i class="fa fa-home"></i></th>
                                                    <td>{{$owner->city}}</td>
                                                    @endif
                                                </tr>
                                                <tr>
                                                    <th><i class="fa fa-calendar-plus-o"></i></th>
                                                    <td>{{convertDate($owner->reg_date)}}</td>
                                                </tr>
                                                <tr>
                                                    <th><i class="fa fa-money"></i></th>
                                                    <td>{{$owner->percentage}} %</td>
                                                </tr>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        {{-- <div class=""> --}}
                            {{-- <div class="col-md-2">
                                <ul class="list-unstyled profile-nav">
                                    <li>
                                        <div title="{{$owner->name}}" class="twPc-avatarLink">
                                            @if($owner->photo ==Null)
                                                <img class="twPc-avatarImg" src="{{asset('uploads/avatar.png')}}"
                                                     style="width:170px; height:170px;">
                                            @else
                                                <img class=" twPc-avatarImg" src="{!!url('/uploads/'.$owner->photo)!!}"
                                                     style="width:170px; height:170px;">
                                            @endif
                                        </div>
                                    </li>
                                </ul>
                            </div> --}}
                            {{-- <div class="col-md-10"> --}}
                                {{-- <div class="row"> --}}
                                    {{-- <div class="col-md-6 profile-info">
                                        <h1 class="font-green sbold uppercase">{{$owner->name}}</h1>
                                        <div style="margin-top: 20%;">
                                            <ul class="list-inline">
                                                <li>
                                                    <i class="fa fa-user"></i> {{$owner->name}}
                                                </li>
                                                <li>
                                                    <i class="fa fa-mobile"></i> {{$owner->phone}}
                                                </li>
                                                <li>
                                                    <i class="fa fa fa-envelope"></i> {{$owner->email}}
                                                </li>

                                                <li>
                                                    <i class="fa fa-home"></i> {{$owner->city}}
                                                </li>
                                                <li>
                                                    <i class="fa fa-calendar-plus-o"></i> {{convertDate($owner->reg_date)}}
                                                </li>
                                                <li>
                                                    <i class="fa fa-money"></i> {{$owner->percentage}} %
                                                </li>
                                            </ul>
                                        </div>
                                    </div> --}}
                                    <!--end col-md-8-->

                                    <!--end col-md-4-->
                                {{-- </div> --}}
                                <!--end row-->
                            {{-- </div> --}}
                        {{-- </div> --}}
                    </div>


                <div class="">
                  <div class="tabbable-line tabbable-custom-profile">
                    <ul class="nav nav-tabs">  
                     <li class="active">
                      <a href="#drawing" data-toggle="tab" id="drawing-tab">
                       <i class=" icon-basket-loaded"></i><b> @lang('layout.Drawing') </b></a>
                     </li>
                     <li class="">
                      <a href="#investment" data-toggle="tab" id="investment-tab">
                       <i class="icon-note"></i><b> @lang('menu.Investment')</b> </a>
                     </li>
                 
                   </ul> 
                   <div class="tab-content padding" style="padding: 0px;">
                    <div class="tab-pane active" id="drawing">
                     <div class="row">
                      <div class="col-md-12">
                        <!-- BEGIN EXAMPLE TABLE PORTLET-->
                        <div class="portlet light bordered">
                          <div class="portlet-title">
                            <div class="caption font-dark">
                              <i class="icon-settings font-dark"></i>
                              <span class="caption-subject bold uppercase">@lang('layout.DrawingDetails')</span>
                            </div>
                          <div class="actions">
                                <span id="anchore-modal">
                                   <a href="#" @click.prevent="showModal('drawing')" id="" class="btn  btn-success">
                                      <i class="fa fa-print"></i>
                                   </a>
                                </span>
                            </div>
                         </div>
                         <div class="portlet-body">
                          <table class="table table-striped table-bordered table-hover" id="drawing-table">
                            <thead>
                              <tr>  
                                 <th>@lang('layout.Account')</th>
                                <th>@lang('layout.Amount')</th>
                                <th>@lang('layout.Currency')</th>
                                <th>@lang('layout.Rate')</th>
                                <th>@lang('layout.Date')</th>
                                <th>@lang('layout.Description')</th>
                              </tr>
                            </thead>
                          </table>
                        </div>
                      </div>
                      <!-- END EXAMPLE TABLE PORTLET-->
                    </div>
                  </div>
                </div>

                <div class="tab-pane" id="investment">
                  <div class="row">
                    <div class="col-md-12">
                      <!-- BEGIN EXAMPLE TABLE PORTLET-->
                      <div class="portlet light bordered">
                        <div class="portlet-title">
                          <div class="caption font-dark">
                            <i class="icon-settings font-dark"></i>
                            <span class="caption-subject bold uppercase">@lang('layout.InvestmentDetails')</span>
                          </div>
                          <div class="actions">
                                <span id="anchore-modal1">
                                   <a href="#" @click.prevent="showModal('investment')" id="" class="btn  btn-success">
                                      <i class="fa fa-print"></i>
                                   </a>
                                </span>
                            </div>
                       </div>
                       <div class="portlet-body">
                        <table class="table table-striped table-bordered table-hover" id="investment-table">
                          <thead>
                            <tr>   
                              <th>@lang('layout.Account')</th>
                                <th>@lang('layout.Amount')</th>
                                <th>@lang('layout.Currency')</th>
                                <th>@lang('layout.Rate')</th>
                                <th>@lang('layout.Date')</th>
                                <th>@lang('layout.Description')</th>

                            </tr>
                          </thead>
                        </table>
                      </div>
                    </div>
                    <!-- END EXAMPLE TABLE PORTLET-->
                  </div>
                </div>

                
              </div> 
          </div>
      </div>
  </div>

                    <!--tab_1_2-->
                    <div class="tab-pane" id="tab_1_3">
                        <div class="row profile-account">
                            <div class="col-md-3">
                                <ul class="ver-inline-menu tabbable margin-bottom-10">
                                    <li class="active">
                                        <a data-toggle="tab" href="#tab_1-1">
                                            <i class="icon-user"></i>@lang('layout.PersonalInfo')  </a>
                                        <span class="after"> </span>
                                    </li>
                                    <li>
                                        <a data-toggle="tab" href="#tab_2-2">
                                            <i class="icon-home"></i>@lang('layout.AddressInfo') </a>
                                    </li>
                                </ul>
                            </div>
                            <div class="col-md-9">
                                <div class="tab-content">
                                    <div id="tab_1-1" class="tab-pane active">
                                        <div class="row">
                                            <div class="col-md-12">
                                                <table class="table">
                                                    <thead>
                                                    <tr>
                                                        <th>@lang('layout.Name')</th>
                                                        <th>@lang('layout.Email')</th>
                                                        <th>@lang('layout.Phone')</th>
                                                        <th>@lang('layout.Phone2')</th>
                                                        <th>@lang('layout.Code')</th>
                                                        <th>@lang('layout.Gender')</th>
                                                        <th>@lang('layout.DateOfBirth')</th>
                                                        <th>@lang('layout.Membership')</th>
                                                        <th>@lang('layout.Date')</th>
                                                    </tr>
                                                    </thead>
                                                    <tbody>
                                                    <tr class="active">
                                                        <td class="hidden-xs"> {{ $owner->name }}  </td>
                                                        <td class="hidden-xs"> {{ $owner->email }}  </td>
                                                        <td class="hidden-xs"> {{ $owner->phone }}  </td>
                                                        <td class="hidden-xs"> {{ $owner->phone2 }}  </td>
                                                        <td class="hidden-xs"> {{ $owner->code }}  </td>
                                                        <td class="hidden-xs"> {{ $owner->gender }}  </td>
                                                        <td class="hidden-xs"> {{ $owner->date_of_birth }}  </td>
                                                        <td class="hidden-xs"> {{ $owner->membership }}  </td>
                                                        <td class="hidden-xs"> {{ $owner->reg_date }}  </td>
                                                    </tr>

                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                    <div id="tab_2-2" class="tab-pane">
                                        <div class="row">
                                            <div class="col-md-12">
                                                <table class="table">
                                                    <thead>
                                                    <tr>
                                                        <th>@lang('layout.Address1')</th>
                                                        <th>@lang('layout.Address2')</th>
                                                        <th>@lang('layout.PostCode')</th>
                                                        <th>@lang('layout.City')</th>
                                                        <th>@lang('layout.Country')</th>
                                                    </tr>
                                                    </thead>
                                                    <tbody>
                                                    <tr class="active">
                                                        <td class="hidden-xs"> {{ $owner->address1 }}  </td>
                                                        <td class="hidden-xs"> {{ $owner->address2 }}  </td>
                                                        <td class="hidden-xs"> {{ $owner->post_code }}  </td>
                                                        <td class="hidden-xs"> {{ $owner->city }}  </td>
                                                        <td class="hidden-xs"> {{ $owner->country }}  </td>
                                                    </tr>
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!--end col-md-9-->
                        </div>
                    </div>
                    <!--end tab-pane-->

                    <!--end tab-pane-->
                </div>
            </div>
        </div>
    </div>

@endsection
@include('print.modal')
@push('scripts')

    <script>
    // Drawing  scripts starts 
    $('#drawing-table').DataTable({
      scrollCollapse: true,
      serverSide: true,
      responsive:'{{responsiveDataTable()}}',
        pagingType:'{{paginationType()}}',
      paging: true,
      retrieve: true, 
      ajax:{

        url:'{{route("owner.show",$owner->member_id)}}',
        data:{type:'drawing'}
      },
      columns: [ 
            {data: 'account', name: 'accounts.name'},
            {data: 'amount', name: 'transactions.amount'},
            {data: 'currency', name: 'transactions.unit'},
            {data: 'rate', name: 'rate', orderable: false, searchable: false},
            {data: 'date', name: 'date', orderable: false, searchable: false},
            {data: 'description', name: 'drawings.description'},
      ]
    }); 
    
// Investment  scripts starts 
    $(document).ready(function(){ 
        $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
      $('#investment-tab').on('shown.bs.tab', function(event){

        $('#investment-table').DataTable({
          scrollCollapse: true,
          serverSide: true,
          responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
          paging: true,
          retrieve: true, 
          ajax:{

            url:'{{route("owner.show",$owner->member_id)}}',
            data:{type:'investment'}
          },
          columns: [ 
                {data: 'account', name: 'accounts.name'},
                {data: 'amount', name: 'transactions.amount'},
                {data: 'currency', name: 'transactions.unit'},
                {data: 'rate', name: 'rate', orderable: false, searchable: false},
                {data: 'date', name: 'date', orderable: false, searchable: false},
                {data: 'description', name: 'drawings.description'},
          ]
        });

      });
    });



        var vm = new Vue({
            el: '#print-modal',
            data: {
                is_show: false,
                pdfRoute: '{!!route('export.PDFAll') !!}',
                excelRoute: '{!! route('export.ExcelAll') !!}',
                report_type:null,
            },
            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show
                },
            }
        });


        new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function (report_type) {
                    // console.log('trr', report_type)
                    vm.report_type = report_type;
                    vm.$data.is_show = true;

                }
            }
        });

        new Vue({
            el: '#anchore-modal1',
            methods: {
                showModal: function (report_type) {
                    // console.log('trr', report_type)
                    vm.report_type = report_type;
                    vm.$data.is_show = true;

                }
            }
        });
    </script>
@endpush